/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.newui.base;

import android.graphics.drawable.AnimationDrawable;
import android.support.annotation.DrawableRes;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;
import com.xdja.im.uikit.newui.base.BaseChatHolder;
import com.xdja.im.uikit.newui.presenter.ChatDetailAdapterPresenter;
import com.xdja.im.uikit.ui.dialog.BaseListDialog;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.ArrayList;
import rx.Subscriber;

public class BaseReceHolder
extends BaseChatHolder {
    protected RelativeLayout mContentLayout = (RelativeLayout)this.findViewById(R.id.layout_message_container);
    private ImageView mBombAnimImg = (ImageView)this.findViewById(R.id.img_bomb_anim);
    private TextView senderNameTextView;

    public BaseReceHolder(View itemView) {
        super(itemView);
        this.mUserName = (TextView)this.findViewById(R.id.tv_user_name);
        this.senderNameTextView = (TextView)this.findViewById(R.id.txt_chat_senderName);
        this.mContentLayout.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return BaseReceHolder.this.showPopDialog();
            }
        });
        this.mPopDialog.setOnItemClickListener(new BaseListDialog.onItemClickListener(){

            @Override
            public void onItemClick(View view, ImOption option, int itemPosition) {
                BaseReceHolder.this.dismissPopDialog();
                switch (option.getOptionType()) {
                    case 1: {
                        ((ChatDetailAdapterPresenter)BaseReceHolder.this.getPresenter()).deleteItem(itemPosition);
                        break;
                    }
                    case 2: {
                        ((ChatDetailAdapterPresenter)BaseReceHolder.this.getPresenter()).copyMessage(itemPosition);
                        break;
                    }
                    case 5: {
                        ((ChatDetailAdapterPresenter)BaseReceHolder.this.getPresenter()).forwardMessage(itemPosition);
                    }
                }
            }
        });
    }

    @Override
    public void bindData(int position, TalkMessageBean dataSource) {
        super.bindData(position, dataSource);
        if (dataSource.isGroupMsg()) {
            this.senderNameTextView.setVisibility(0);
        } else {
            this.senderNameTextView.setVisibility(8);
        }
        ((ChatDetailAdapterPresenter)this.getPresenter()).getAccount(dataSource.getFrom(), 1, new Subscriber<AccountBean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.d("BaseReceiveItem", "\u83b7\u53d6\u8054\u7cfb\u4eba\u4fe1\u606f\u51fa\u9519");
            }

            public void onNext(AccountBean accountBean) {
                BaseReceHolder.this.senderNameTextView.setText((CharSequence)accountBean.getDisplayName());
            }
        });
    }

    protected void setContentLayoutBackground(@DrawableRes int resId) {
        this.mContentLayout.setBackgroundResource(resId);
    }

    protected void startBombAnim() {
        if (this.mBombAnimImg != null) {
            AnimationDrawable boomAnim = (AnimationDrawable)this.mBombAnimImg.getBackground();
            boomAnim.stop();
            boomAnim.start();
        }
    }

    protected void setMessageDestroy(boolean isDestroy) {
        if (((TalkMessageBean)this.dataSource).getMessageType() == 3 || ((TalkMessageBean)this.dataSource).getMessageType() == 2) {
            return;
        }
        if (this.mContentLayout != null) {
            if (isDestroy) {
                this.mContentLayout.setBackgroundResource(R.drawable.im_uikit_bg_receive_shan_selector);
            } else {
                this.mContentLayout.setBackgroundResource(R.drawable.im_uikit_bg_receive_selector);
            }
        }
    }

    protected void setDestroyView(TextView destroyView, boolean isDestroy, String destroyStr) {
        if (destroyView != null) {
            if (isDestroy) {
                destroyView.setVisibility(0);
                destroyView.setTextColor(this.getLimitTextColor());
                destroyView.setText((CharSequence)destroyStr);
            } else {
                destroyView.setVisibility(8);
            }
        }
    }

    protected boolean showPopDialog() {
        ArrayList<ImOption> data = new ArrayList<ImOption>();
        if (((TalkMessageBean)this.dataSource).getMessageType() == 0 && ((TalkMessageBean)this.dataSource).getMessageState() != 5) {
            data.add((ImOption)this.mImOptions.get(0));
            data.add((ImOption)this.mImOptions.get(1));
            data.add((ImOption)this.mImOptions.get(4));
        } else {
            data.add((ImOption)this.mImOptions.get(0));
        }
        if (((TalkMessageBean)this.dataSource).getMessageType() == 14) {
            data.add((ImOption)this.mImOptions.get(1));
            data.add((ImOption)this.mImOptions.get(4));
        }
        if (((TalkMessageBean)this.dataSource).getMessageType() == 2) {
            data.add((ImOption)this.mImOptions.get(4));
        }
        if (((TalkMessageBean)this.dataSource).getMessageType() == 3) {
            data.add((ImOption)this.mImOptions.get(4));
        }
        if (((TalkMessageBean)this.dataSource).getMessageType() == 4) {
            data.add((ImOption)this.mImOptions.get(4));
        }
        if (((TalkMessageBean)this.dataSource).getMessageType() == 5) {
            data.add((ImOption)this.mImOptions.get(4));
        }
        this.mPopDialog.addData(data);
        this.mPopDialog.show(this.curPosition);
        return true;
    }

    private void dismissPopDialog() {
        if (this.mPopDialog != null) {
            this.mPopDialog.dismiss();
        }
    }
}

