/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.newui.base;

import android.view.View;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;
import com.xdja.im.uikit.newui.base.BaseChatHolder;
import com.xdja.im.uikit.newui.presenter.ChatDetailAdapterPresenter;
import com.xdja.im.uikit.ui.dialog.BaseListDialog;
import java.util.ArrayList;

public class BaseSendHolder
extends BaseChatHolder {
    protected RelativeLayout mContentLayout;
    private TextView mStateTv = (TextView)this.findViewById(R.id.tv_state);
    private Button mResendBtn = (Button)this.findViewById(R.id.btn_resend);
    private ProgressBar mSendingPBar = (ProgressBar)this.findViewById(R.id.pbar_sending);

    public BaseSendHolder(View itemView) {
        super(itemView);
        this.mContentLayout = (RelativeLayout)this.findViewById(R.id.layout_message_container);
        this.mContentLayout.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return BaseSendHolder.this.showPopDialog();
            }
        });
        this.mResendBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BaseSendHolder.this.mResendBtn.setVisibility(8);
                BaseSendHolder.this.mSendingPBar.setVisibility(0);
                ((ChatDetailAdapterPresenter)BaseSendHolder.this.getPresenter()).reSendMessage(BaseSendHolder.this.curPosition);
            }
        });
        this.mPopDialog.setOnItemClickListener(new BaseListDialog.onItemClickListener(){

            @Override
            public void onItemClick(View view, ImOption option, int itemPosition) {
                BaseSendHolder.this.dismissPopDialog();
                switch (option.getOptionType()) {
                    case 1: {
                        ((ChatDetailAdapterPresenter)BaseSendHolder.this.getPresenter()).deleteItem(itemPosition);
                        break;
                    }
                    case 2: {
                        ((ChatDetailAdapterPresenter)BaseSendHolder.this.getPresenter()).copyMessage(itemPosition);
                        break;
                    }
                    case 3: {
                        ((ChatDetailAdapterPresenter)BaseSendHolder.this.getPresenter()).recallMessage(itemPosition);
                        break;
                    }
                    case 4: {
                        ((ChatDetailAdapterPresenter)BaseSendHolder.this.getPresenter()).reSendMessage(itemPosition);
                        break;
                    }
                    case 5: {
                        ((ChatDetailAdapterPresenter)BaseSendHolder.this.getPresenter()).forwardMessage(itemPosition);
                    }
                }
            }
        });
    }

    @Override
    public void bindData(int position, TalkMessageBean dataSource) {
        super.bindData(position, dataSource);
        if (dataSource.getMessageState() == 0) {
            this.mResendBtn.setVisibility(0);
            this.mSendingPBar.setVisibility(8);
        }
        int messageState = dataSource.getMessageState();
        this.mStateTv.setText((CharSequence)ConstDef.mapMsgState(messageState));
        if (dataSource.isGroupMsg()) {
            this.mStateTv.setVisibility(8);
        }
        if (messageState == 1) {
            this.setProgressBarVisible(true);
        } else {
            this.setProgressBarVisible(false);
        }
        if (messageState == 0) {
            this.mResendBtn.setVisibility(0);
            this.mSendingPBar.setVisibility(8);
            if (dataSource.getFailCode() == -5) {
                this.mStateTv.setVisibility(0);
                this.mStateTv.setText(dataSource.isGroupMsg() ? R.string.im_uikit_not_member : R.string.im_uikit_not_friend);
            }
        } else {
            this.mResendBtn.setVisibility(8);
        }
        this.setSendLayoutBackground(dataSource.isBomb());
    }

    private void setProgressBarVisible(boolean bVisible) {
        if (bVisible) {
            this.mSendingPBar.setVisibility(0);
        } else {
            this.mSendingPBar.setVisibility(8);
        }
    }

    private void setSendLayoutBackground(boolean isLimit) {
        if (((TalkMessageBean)this.dataSource).getMessageType() == 3 || ((TalkMessageBean)this.dataSource).getMessageType() == 2) {
            return;
        }
        if (this.mContentLayout != null) {
            if (isLimit) {
                this.mContentLayout.setBackgroundResource(R.drawable.im_uikit_bg_send_shan_selector);
                this.setTxtContentColor(this.getLimitTextColor());
            } else {
                this.mContentLayout.setBackgroundResource(R.drawable.im_uikit_bg_send_selector);
                this.setTxtContentColor(this.getNormalTextColor());
            }
        }
    }

    protected void setTxtContentColor(int color2) {
    }

    @Override
    public int getNormalTextColor() {
        return this.getResources().getColor(R.color.im_uikit_view_normal_text_item_color);
    }

    @Override
    public int getLimitTextColor() {
        return this.getResources().getColor(R.color.im_uikit_view_limit_text_item_color);
    }

    protected boolean showPopDialog() {
        ArrayList<ImOption> data = new ArrayList<ImOption>();
        if (((TalkMessageBean)this.dataSource).getMessageType() == 0) {
            data.add((ImOption)this.mImOptions.get(0));
            data.add((ImOption)this.mImOptions.get(1));
            data.add((ImOption)this.mImOptions.get(4));
        } else {
            data.add((ImOption)this.mImOptions.get(0));
        }
        if (((TalkMessageBean)this.dataSource).getMessageType() == 14) {
            data.add((ImOption)this.mImOptions.get(1));
            data.add((ImOption)this.mImOptions.get(4));
        }
        if (((TalkMessageBean)this.dataSource).getMessageType() == 2) {
            data.add((ImOption)this.mImOptions.get(4));
        }
        if (((TalkMessageBean)this.dataSource).getMessageType() == 3) {
            data.add((ImOption)this.mImOptions.get(4));
        }
        if (((TalkMessageBean)this.dataSource).getMessageType() == 4) {
            data.add((ImOption)this.mImOptions.get(4));
        }
        if (((TalkMessageBean)this.dataSource).getMessageType() == 5) {
            data.add((ImOption)this.mImOptions.get(4));
        }
        if (((TalkMessageBean)this.dataSource).getMessageState() == 0) {
            data.add((ImOption)this.mImOptions.get(3));
        } else if (((TalkMessageBean)this.dataSource).getMessageState() != 1) {
            data.add((ImOption)this.mImOptions.get(2));
        }
        this.mPopDialog.addData(data);
        this.mPopDialog.show(this.curPosition);
        return true;
    }

    protected void dismissPopDialog() {
        if (this.mPopDialog != null) {
            this.mPopDialog.dismiss();
        }
    }

    protected void setMessageVisible(int visibility) {
        this.mStateTv.setVisibility(0);
    }
}

