/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.newui.holder;

import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.gson.Gson;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.custom.CustomMsgInfo;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;
import com.xdja.im.uikit.newui.base.BaseChatHolder;
import com.xdja.im.uikit.newui.presenter.ChatDetailAdapterPresenter;
import com.xdja.im.uikit.ui.dialog.BaseListDialog;
import java.util.ArrayList;
import rx.Subscriber;

public class ViewCustomReceMeetingHolder
extends BaseChatHolder {
    private ImageView imgCustomType;
    private TextView tvCustominfo;
    private LinearLayout linearLayout;
    private CustomMsgInfo customMsgInfo;
    private ImageView missedMsgIv;
    private TextView senderNameTextView;
    private Gson gson = new Gson();

    public ViewCustomReceMeetingHolder(View itemView) {
        super(itemView);
        this.senderNameTextView = (TextView)this.findViewById(R.id.txt_chat_senderName);
        this.imgCustomType = (ImageView)this.findViewById(R.id.img_custom_rec);
        this.tvCustominfo = (TextView)this.findViewById(R.id.tv_custom_info);
        this.missedMsgIv = (ImageView)this.findViewById(R.id.img_new_flag);
        this.linearLayout = (LinearLayout)this.findViewById(R.id.layout_message_container);
        this.linearLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CustomMsgInfo customMsgInfo = (CustomMsgInfo)ViewCustomReceMeetingHolder.this.gson.fromJson(((TalkMessageBean)ViewCustomReceMeetingHolder.this.dataSource).getContent(), CustomMsgInfo.class);
                int type = customMsgInfo.getType();
                if (customMsgInfo.getState() == 4 || customMsgInfo.getState() == 6) {
                    ((ChatDetailAdapterPresenter)ViewCustomReceMeetingHolder.this.getPresenter()).sendReadReceipt((TalkMessageBean)ViewCustomReceMeetingHolder.this.dataSource);
                }
                switch (type) {
                    case 3: 
                    case 5: {
                        IMUiKitProxyImpl.getInstance().startCallback(customMsgInfo.getFromAtNo());
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 1: {
                        IMUiKitProxyImpl.getInstance().startVoice(customMsgInfo.getFromAtNo(), 1);
                        if (ViewCustomReceMeetingHolder.this.missedMsgIv == null) break;
                        ViewCustomReceMeetingHolder.this.missedMsgIv.setVisibility(8);
                        break;
                    }
                    case 2: {
                        IMUiKitProxyImpl.getInstance().startVoice(customMsgInfo.getToAtNo(), 2);
                        if (ViewCustomReceMeetingHolder.this.missedMsgIv == null) break;
                        ViewCustomReceMeetingHolder.this.missedMsgIv.setVisibility(8);
                    }
                }
            }
        });
        this.linearLayout.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                ArrayList<ImOption> data = new ArrayList<ImOption>();
                data.add((ImOption)ViewCustomReceMeetingHolder.this.mImOptions.get(0));
                ViewCustomReceMeetingHolder.this.mPopDialog.addData(data);
                ViewCustomReceMeetingHolder.this.mPopDialog.show(ViewCustomReceMeetingHolder.this.curPosition);
                return true;
            }
        });
        this.mPopDialog.setOnItemClickListener(new BaseListDialog.onItemClickListener(){

            @Override
            public void onItemClick(View view, ImOption option, int itemPosition) {
                ViewCustomReceMeetingHolder.this.mPopDialog.dismiss();
                switch (option.getOptionType()) {
                    case 1: {
                        ((ChatDetailAdapterPresenter)ViewCustomReceMeetingHolder.this.getPresenter()).deleteItem(itemPosition);
                    }
                }
            }
        });
    }

    @Override
    public void bindData(int position, TalkMessageBean dataSource) {
        super.bindData(position, dataSource);
        if (dataSource.getMessageType() == 102 && dataSource.isGroupMsg()) {
            ((ChatDetailAdapterPresenter)this.getPresenter()).getAccount(dataSource.getFrom(), 1, new Subscriber<AccountBean>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                }

                public void onNext(AccountBean accountBean) {
                    ViewCustomReceMeetingHolder.this.senderNameTextView.setText((CharSequence)accountBean.getDisplayName());
                }
            });
        } else {
            this.senderNameTextView.setVisibility(8);
        }
        this.customMsgInfo = (CustomMsgInfo)this.gson.fromJson(dataSource.getContent(), CustomMsgInfo.class);
        int type = this.customMsgInfo.getType();
        int state = this.customMsgInfo.getState();
        boolean isRecalled = dataSource.getMessageState() == 4;
        long amountOfTime = this.customMsgInfo.getAmountOfTime();
        boolean isVideoCallback = type == 3 || type == 4 || type == 5;
        String content = "";
        if (state == 4) {
            content = isVideoCallback ? (type == 5 ? "\u672a\u63a5\u89c6\u9891\u901a\u8bdd" : "\u672a\u63a5\u89c6\u9891\u56de\u4f20") : "\u672a\u63a5\u8bed\u97f3\u901a\u8bdd";
        } else if (state == 6) {
            content = isVideoCallback ? (type == 5 ? "\u672a\u63a5\u89c6\u9891\u901a\u8bdd" : "\u672a\u63a5\u89c6\u9891\u56de\u4f20") : (type == 1 ? "\u672a\u63a5\u8bed\u97f3\u901a\u8bdd" : "\u672a\u63a5\u8bed\u97f3\u4f1a\u8bae");
        } else if (state == 5) {
            content = "\u5df2\u62d2\u7edd";
        } else if (state == 2) {
            content = this.buildMsgContent(type, amountOfTime);
        }
        if (isVideoCallback) {
            this.imgCustomType.setBackgroundResource(R.mipmap.im_uikit_icon_custom_callback_receiver);
        } else {
            this.imgCustomType.setBackgroundResource(R.mipmap.im_uikit_icon_custom_meeting_receiver);
        }
        this.tvCustominfo.setText((CharSequence)content);
        if (!(isRecalled || state != 4 && state != 6)) {
            this.missedMsgIv.setVisibility(0);
        } else {
            this.missedMsgIv.setVisibility(8);
        }
    }

    private String buildMsgContent(int type, long amountOfTime) {
        StringBuilder builder = new StringBuilder();
        switch (type) {
            case 3: 
            case 4: {
                builder.append("\u89c6\u9891\u56de\u4f20");
                builder.append(" " + this.getFormatTime(amountOfTime));
                break;
            }
            case 5: {
                builder.append("\u89c6\u9891\u901a\u8bdd");
                builder.append(" " + this.getFormatTime(amountOfTime));
                break;
            }
            case 1: {
                builder.append("\u8bed\u97f3\u901a\u8bdd");
                builder.append(" " + this.getFormatTime(amountOfTime));
                break;
            }
            case 2: {
                builder.append("\u8bed\u97f3\u4f1a\u8bae");
            }
        }
        return builder.toString();
    }

    private String getFormatTime(long amountOfTime) {
        String secondStr;
        long hour = amountOfTime / 3600L;
        long min = amountOfTime / 60L % 60L;
        long second = amountOfTime % 60L;
        String hourStr = "";
        String minStr = min < 10L ? "0" + min : "" + min;
        String string2 = secondStr = second < 10L ? "0" + second : "" + second;
        if (hour == 0L) {
            hourStr = "";
            return minStr + ":" + secondStr;
        }
        hourStr = hour < 10L ? "0" + hour : "" + hour;
        return hourStr + ":" + minStr + ":" + secondStr;
    }
}

