/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.newui.holder;

import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.gson.Gson;
import com.xdja.im.core.model.custom.CustomMsgInfo;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;
import com.xdja.im.uikit.newui.base.BaseChatHolder;
import com.xdja.im.uikit.newui.presenter.ChatDetailAdapterPresenter;
import com.xdja.im.uikit.ui.dialog.BaseListDialog;
import java.util.ArrayList;

public class ViewCustomSendMeetingHolder
extends BaseChatHolder {
    private ImageView imgCustomType;
    private TextView tvCustominfo;
    private LinearLayout linearLayout;
    private CustomMsgInfo customMsgInfo;
    private Gson gson = new Gson();

    public ViewCustomSendMeetingHolder(View itemView) {
        super(itemView);
        this.imgCustomType = (ImageView)this.findViewById(R.id.img_custom_send);
        this.tvCustominfo = (TextView)this.findViewById(R.id.tv_send_info);
        this.linearLayout = (LinearLayout)this.findViewById(R.id.layout_message_container);
        this.linearLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CustomMsgInfo customMsgInfo = (CustomMsgInfo)ViewCustomSendMeetingHolder.this.gson.fromJson(((TalkMessageBean)ViewCustomSendMeetingHolder.this.dataSource).getContent(), CustomMsgInfo.class);
                int type = customMsgInfo.getType();
                switch (type) {
                    case 3: 
                    case 5: {
                        IMUiKitProxyImpl.getInstance().startCallback(customMsgInfo.getToAtNo());
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 1: {
                        IMUiKitProxyImpl.getInstance().startVoice(customMsgInfo.getToAtNo(), 1);
                        break;
                    }
                    case 2: {
                        IMUiKitProxyImpl.getInstance().startVoice(customMsgInfo.getToAtNo(), 2);
                    }
                }
            }
        });
        this.linearLayout.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                ArrayList<ImOption> data = new ArrayList<ImOption>();
                data.add((ImOption)ViewCustomSendMeetingHolder.this.mImOptions.get(0));
                ViewCustomSendMeetingHolder.this.mPopDialog.addData(data);
                ViewCustomSendMeetingHolder.this.mPopDialog.show(ViewCustomSendMeetingHolder.this.curPosition);
                return true;
            }
        });
        this.mPopDialog.setOnItemClickListener(new BaseListDialog.onItemClickListener(){

            @Override
            public void onItemClick(View view, ImOption option, int itemPosition) {
                ViewCustomSendMeetingHolder.this.mPopDialog.dismiss();
                switch (option.getOptionType()) {
                    case 1: {
                        ((ChatDetailAdapterPresenter)ViewCustomSendMeetingHolder.this.getPresenter()).deleteItem(itemPosition);
                    }
                }
            }
        });
    }

    @Override
    public void bindData(int position, TalkMessageBean dataSource) {
        super.bindData(position, dataSource);
        this.customMsgInfo = (CustomMsgInfo)this.gson.fromJson(dataSource.getContent(), CustomMsgInfo.class);
        int type = this.customMsgInfo.getType();
        int state = this.customMsgInfo.getState();
        long amountOfTime = this.customMsgInfo.getAmountOfTime();
        String content = "";
        if (state == 4) {
            content = "\u5df2\u53d6\u6d88";
        } else if (state == 6) {
            content = "\u5bf9\u65b9\u65e0\u5e94\u7b54";
        } else if (state == 5) {
            content = "\u5bf9\u65b9\u5df2\u62d2\u7edd";
        } else if (state == 2) {
            content = this.buildMsgContent(type, amountOfTime);
        }
        if (type == 3 || type == 4 || type == 5) {
            this.imgCustomType.setImageResource(R.mipmap.im_uikit_icon_custom_callback_sender);
        } else {
            this.imgCustomType.setImageResource(R.mipmap.im_uikit_icon_custom_meeting_sender);
        }
        this.tvCustominfo.setText((CharSequence)content);
    }

    private String buildMsgContent(int type, long amountOfTime) {
        StringBuilder builder = new StringBuilder();
        switch (type) {
            case 3: 
            case 4: {
                builder.append("\u89c6\u9891\u56de\u4f20");
                builder.append(" " + this.getFormatTime(amountOfTime));
                break;
            }
            case 5: {
                builder.append("\u89c6\u9891\u901a\u8bdd");
                builder.append(" " + this.getFormatTime(amountOfTime));
                break;
            }
            case 1: {
                builder.append("\u8bed\u97f3\u901a\u8bdd");
                builder.append(" " + this.getFormatTime(amountOfTime));
                break;
            }
            case 2: {
                builder.append("\u8bed\u97f3\u4f1a\u8bae");
            }
        }
        return builder.toString();
    }

    private String getFormatTime(long amountOfTime) {
        String secondStr;
        long hour = amountOfTime / 3600L;
        long min = amountOfTime / 60L % 60L;
        long second = amountOfTime % 60L;
        String hourStr = "";
        String minStr = min < 10L ? "0" + min : "" + min;
        String string2 = secondStr = second < 10L ? "0" + second : "" + second;
        if (hour == 0L) {
            hourStr = "";
            return minStr + ":" + secondStr;
        }
        hourStr = hour < 10L ? "0" + hour : "" + hour;
        return hourStr + ":" + minStr + ":" + secondStr;
    }
}

