/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.newui.holder.receive;

import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.NormalFileInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.newui.base.BaseReceHolder;
import com.xdja.im.uikit.newui.presenter.ChatDetailAdapterPresenter;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.file.TranslateInfoUtil;
import com.xdja.im.uikit.utils.log.LogUtil;

public class ViewReceFileHolder
extends BaseReceHolder {
    private ImageView mFileIconImg = (ImageView)this.findViewById(R.id.img_file_flag);
    private TextView mFileNameTv = (TextView)this.findViewById(R.id.tv_file_name);
    private TextView mFileSizeTv = (TextView)this.findViewById(R.id.tv_file_size);
    private ProgressBar mLoadingPBar = (ProgressBar)this.findViewById(R.id.pbar_file_progress);
    private ImageView mDownloadStateImg = (ImageView)this.findViewById(R.id.img_download_state);

    public ViewReceFileHolder(View itemView) {
        super(itemView);
        this.mContentLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NormalFileInfo fileInfo = (NormalFileInfo)((TalkMessageBean)ViewReceFileHolder.this.dataSource).getFileInfo();
                if (fileInfo == null) {
                    LogUtil.e("ERROR: start open file, but file info is null.");
                    return;
                }
                if (fileInfo.getFileState() == 2) {
                    ((ChatDetailAdapterPresenter)ViewReceFileHolder.this.getPresenter()).openNormalFile((TalkMessageBean)ViewReceFileHolder.this.dataSource);
                } else {
                    ((ChatDetailAdapterPresenter)ViewReceFileHolder.this.getPresenter()).loadNormalFile((TalkMessageBean)ViewReceFileHolder.this.dataSource);
                }
            }
        });
    }

    @Override
    public void bindData(int position, TalkMessageBean dataSource) {
        super.bindData(position, dataSource);
        NormalFileInfo fileInfo = (NormalFileInfo)dataSource.getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: receive file info is null error.");
            return;
        }
        if (fileInfo.getFileState() != 2 && fileInfo.getFileState() != 1 && fileInfo.getFileState() != 5) {
            this.mDownloadStateImg.setImageResource(this.getStateImage(fileInfo));
            this.mLoadingPBar.setVisibility(0);
            this.mLoadingPBar.setProgress((int)((float)this.getTranslateSize(fileInfo) * 100.0f / (float)fileInfo.getFileSize()));
        } else {
            if (fileInfo.getFileState() == 5) {
                this.mDownloadStateImg.setImageResource(this.getStateImage(fileInfo));
            } else {
                this.mDownloadStateImg.setImageDrawable(null);
            }
            this.mLoadingPBar.setVisibility(8);
        }
        this.mFileIconImg.setImageResource(FileUtils.getIconWithSuffix(fileInfo.getFilePath()));
        this.mFileNameTv.setText((CharSequence)fileInfo.getFileName());
        this.mFileSizeTv.setText((CharSequence)FileSizeUtils.formatFileSize(fileInfo.getFileSize()));
    }

    private long getTranslateSize(NormalFileInfo fileInfo) {
        return Math.max(TranslateInfoUtil.getTranslateSize(fileInfo.getTalkMessageId()), fileInfo.getTranslateSize());
    }

    private int getStateImage(FileInfo fileInfo) {
        int res = 0;
        if (fileInfo.getFileState() == 3) {
            res = R.mipmap.im_uikit_ic_download_normal;
        } else if (fileInfo.getFileState() == 5) {
            res = R.mipmap.im_uikit_ic_again_normal;
        } else if (fileInfo.getFileState() == 4) {
            res = R.mipmap.im_uikit_ic_suspend_normal;
        }
        return res;
    }
}

