/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.newui.holder.receive;

import android.app.Activity;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.lib.filemanage.util.HistoryFileUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.newui.base.BaseReceHolder;
import com.xdja.im.uikit.newui.presenter.ChatDetailAdapterPresenter;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.view.ChatImageView;

public class ViewReceImageHolder
extends BaseReceHolder {
    private ChatImageView mChatImage = (ChatImageView)((Object)this.findViewById(R.id.img_receive_image));
    private ImageView mGifImageView = (ImageView)this.findViewById(R.id.img_receive_gif_image);
    private ImageView mBombFlagImg = (ImageView)this.findViewById(R.id.img_bomb_flag);
    private ProgressBar mLoadingPbar = (ProgressBar)this.findViewById(R.id.pbar_loading);
    private ImageButton mRetryBtn = (ImageButton)this.findViewById(R.id.img_retry_download);

    public ViewReceImageHolder(View itemView) {
        super(itemView);
        this.mContentLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ChatDetailAdapterPresenter)ViewReceImageHolder.this.getPresenter()).previewImage((TalkMessageBean)ViewReceImageHolder.this.dataSource);
            }
        });
        this.mRetryBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ViewReceImageHolder.this.mLoadingPbar.setVisibility(0);
                ViewReceImageHolder.this.mChatImage.setImageBitmap(null);
                ViewReceImageHolder.this.mRetryBtn.setVisibility(8);
                ((ChatDetailAdapterPresenter)ViewReceImageHolder.this.getPresenter()).downLoadFile(((TalkMessageBean)ViewReceImageHolder.this.dataSource).getFileInfo());
            }
        });
    }

    @Override
    public void bindData(int position, TalkMessageBean dataSource) {
        super.bindData(position, dataSource);
        ImageFileInfo fileInfo = (ImageFileInfo)dataSource.getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("load image, but file info is null");
            this.mChatImage.setImageResource(R.mipmap.im_uikit_pic_failed);
            return;
        }
        if (dataSource.getMessageState() == 5) {
            this.mBombFlagImg.setVisibility(8);
            this.mChatImage.setImageResource(R.mipmap.im_uikit_bg_shanxin_image);
        } else {
            this.mBombFlagImg.setVisibility(8);
            if (TextUtils.isEmpty((CharSequence)fileInfo.getFilePath())) {
                this.setReDownloadVisible();
                return;
            }
            if (fileInfo.getFileState() == 5) {
                this.setProgressBarVisible(false);
                this.setReDownloadVisible();
            } else if (fileInfo.getFileState() == 2) {
                this.setProgressBarVisible(false);
                this.loadImage(fileInfo, dataSource);
            } else {
                this.mChatImage.setImageResource(R.drawable.im_uikit_bg_pbar_loading);
                this.setProgressBarVisible(true);
                ((ChatDetailAdapterPresenter)this.getPresenter()).downLoadFile(fileInfo);
            }
            if (dataSource.getMessageState() < 4) {
                ((ChatDetailAdapterPresenter)this.getPresenter()).sendReadReceipt(dataSource);
            }
            if (dataSource.getMessageState() == 6) {
                this.startBombAnim();
                final TalkMessageBean cloneSource = new TalkMessageBean(dataSource);
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ((ChatDetailAdapterPresenter)ViewReceImageHolder.this.getPresenter()).postDestroyAnimate(cloneSource);
                        ViewReceImageHolder.this.loadImageResource(R.mipmap.im_uikit_bg_shanxin_image);
                    }
                }, 700L);
            }
        }
    }

    private void setReDownloadVisible() {
        this.loadImageResource(R.mipmap.im_uikit_pic_failed);
        if (this.mRetryBtn == null) {
            LogUtil.w("ERROR:reDownloadImageBtn is null.");
            return;
        }
        this.mRetryBtn.setVisibility(0);
    }

    private void loadImageResource(int srcId) {
        this.mChatImage.setImageResource(srcId);
        this.mLoadingPbar.setVisibility(8);
        this.mBombFlagImg.setVisibility(8);
        this.setMessageDestroy(((TalkMessageBean)this.dataSource).isBomb());
    }

    private void loadImage(ImageFileInfo fileInfo, TalkMessageBean dataSource) {
        if (FileUtils.isFileExists(fileInfo.getFilePath())) {
            this.mChatImage.setVisibility(8);
            this.mGifImageView.setVisibility(8);
            this.loadImageUrl(fileInfo, dataSource);
        } else {
            this.mChatImage.setError(R.mipmap.im_uikit_pic_default);
        }
    }

    private void setProgressBarVisible(boolean isVisible) {
        if (isVisible) {
            this.mLoadingPbar.setVisibility(0);
        } else {
            this.mLoadingPbar.setVisibility(8);
        }
    }

    private void loadImageUrl(ImageFileInfo imageFileInfo, TalkMessageBean dataSource) {
        String suffix = imageFileInfo.getSuffix();
        if (imageFileInfo != null && "gif".equalsIgnoreCase(suffix) && !TextUtils.isEmpty((CharSequence)imageFileInfo.getFilePath())) {
            String urlGif = imageFileInfo.getFilePath();
            long fileSize = imageFileInfo.getFileSize();
            this.mChatImage.setVisibility(8);
            this.mGifImageView.setVisibility(0);
            if (HistoryFileUtils.isFileExist(urlGif)) {
                Glide.with((Activity)this.getActivity()).load(urlGif).placeholder(R.mipmap.im_uikit_pic_default).diskCacheStrategy(DiskCacheStrategy.SOURCE).into(this.mGifImageView);
            }
        } else {
            this.mChatImage.setVisibility(0);
            this.mGifImageView.setVisibility(8);
            this.mChatImage.loadImage(imageFileInfo.getFilePath());
        }
    }
}

