/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.newui.holder.receive;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.newui.base.BaseReceHolder;
import com.xdja.im.uikit.newui.presenter.ChatDetailAdapterPresenter;

public class ViewReceTextHolder
extends BaseReceHolder {
    private TextView mContentTv = (TextView)this.findViewById(R.id.tv_content);

    public ViewReceTextHolder(View itemView) {
        super(itemView);
    }

    @Override
    public void bindData(int position, TalkMessageBean dataSource) {
        super.bindData(position, dataSource);
        if (dataSource.getMessageState() == 5) {
            this.setMessageDestroy(true);
            this.setRecContentTextColor(this.getLimitTextColor());
            this.setRecContentText(R.string.im_uikit_text_bomb);
        } else {
            this.setMessageDestroy(false);
            this.setRecContentTextColor(this.getNormalTextColor());
            if (!TextUtils.isEmpty((CharSequence)dataSource.getContent())) {
                this.setRecContentText((CharSequence)EmotionUtils.formatNormalSpanContent(dataSource.getContent(), (Context)((ChatDetailAdapterPresenter)this.getPresenter()).getActivity()));
            }
            if (dataSource.getMessageState() < 4) {
                ((ChatDetailAdapterPresenter)this.getPresenter()).sendReadReceipt(dataSource);
            }
            if (dataSource.getMessageState() == 6) {
                this.startBombAnim();
                final TalkMessageBean cloneObj = new TalkMessageBean(dataSource);
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ((ChatDetailAdapterPresenter)ViewReceTextHolder.this.getPresenter()).postDestroyAnimate(cloneObj);
                    }
                }, 700L);
            }
        }
    }

    private void setRecContentTextColor(int colorId) {
        if (this.mContentTv != null) {
            this.mContentTv.setTextColor(colorId);
        }
    }

    private void setRecContentText(int contentTextId) {
        if (this.mContentTv != null) {
            this.mContentTv.setText(contentTextId);
        }
    }

    private void setRecContentText(CharSequence contentText) {
        if (this.mContentTv != null) {
            this.mContentTv.setText(contentText);
        }
    }
}

