/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.newui.holder.receive;

import android.graphics.drawable.AnimationDrawable;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.VoiceFileInfo;
import com.xdja.im.core.model.screen.ScreenInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.newui.base.BaseReceHolder;
import com.xdja.im.uikit.newui.presenter.ChatDetailAdapterPresenter;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.ScreenUtil;

public class ViewReceVoiceHolder
extends BaseReceHolder {
    private static final int MIN_DP = 80;
    private static final int FIRST_STEP_DP = 140;
    private static final int SECOND_STEP_DP = 180;
    private static final int MAX_DP = 200;
    private TextView mVoiceLength = (TextView)this.findViewById(R.id.tv_hint_time);
    private ImageView mVoiceAnimImg = (ImageView)this.findViewById(R.id.img_anim_voice);
    private ImageView mNewFlagImg = (ImageView)this.findViewById(R.id.img_new_flag);
    private ScreenInfo mScreenInfo;
    private TextView mDestroyView = (TextView)this.findViewById(R.id.voice_receive_destroy);
    private RelativeLayout mVoiceLayout = (RelativeLayout)this.findViewById(R.id.layout_voice);

    public ViewReceVoiceHolder(View itemView) {
        super(itemView);
        this.mContentLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ChatDetailAdapterPresenter)ViewReceVoiceHolder.this.getPresenter()).playVoice((TalkMessageBean)ViewReceVoiceHolder.this.dataSource);
            }
        });
    }

    @Override
    public void bindData(int position, TalkMessageBean dataSource) {
        super.bindData(position, dataSource);
        this.mScreenInfo = ScreenUtil.getScreenInfo(((ChatDetailAdapterPresenter)this.getPresenter()).getActivity());
        this.initView();
    }

    private void initView() {
        if (this.dataSource == null) {
            LogUtil.e("ERROR: voice dataSource is null.");
            return;
        }
        if (((TalkMessageBean)this.dataSource).getMessageState() == 5) {
            this.setMessageDestroy(true);
            this.mVoiceLayout.setVisibility(8);
            this.mDestroyView.setVisibility(0);
            this.setDestroyView(this.mDestroyView, true, this.getStringRes(R.string.im_uikit_voice_destory_text));
            this.setClickListener(null);
            this.setNewMessageFlagVisible(false);
        } else {
            this.mVoiceLayout.setVisibility(0);
            this.mDestroyView.setVisibility(8);
            this.setMessageDestroy(false);
            this.setDestroyView(this.mDestroyView, false, "");
            VoiceFileInfo fileInfo = (VoiceFileInfo)((TalkMessageBean)this.dataSource).getFileInfo();
            if (fileInfo == null) {
                LogUtil.e("ERROR: Voice file is null.");
                return;
            }
            int recordingTime = fileInfo.getAmountOfTime();
            this.setBackground(recordingTime);
            this.setVoiceLengthText(recordingTime);
            if (((TalkMessageBean)this.dataSource).getMessageState() < 4) {
                this.setNewMessageFlagVisible(true);
            } else {
                this.setNewMessageFlagVisible(false);
            }
            if (((TalkMessageBean)this.dataSource).getMessageState() == 6) {
                this.startBombAnim();
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ((ChatDetailAdapterPresenter)ViewReceVoiceHolder.this.getPresenter()).postDestroyAnimate((TalkMessageBean)ViewReceVoiceHolder.this.dataSource);
                    }
                }, 700L);
            }
        }
        if (((ChatDetailAdapterPresenter)this.getPresenter()).getVoiceMessageIsPlaying(((TalkMessageBean)this.dataSource).getFileInfo())) {
            this.startVoiceAnim();
            this.setNewMessageFlagVisible(false);
        } else {
            this.stopVoiceAnim();
        }
    }

    private void setBackground(int recordingTime) {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mContentLayout.getLayoutParams();
        float bubbleLength = recordingTime <= 10 ? (float)(80 + 6 * recordingTime) * this.mScreenInfo.getDensity() : (recordingTime <= 20 ? (float)(140 + 4 * (recordingTime - 10)) * this.mScreenInfo.getDensity() : (recordingTime <= 30 ? (float)(180 + 2 * (recordingTime - 20)) * this.mScreenInfo.getDensity() : 200.0f * this.mScreenInfo.getDensity()));
        params.width = (int)bubbleLength;
        this.mContentLayout.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void setNewMessageFlagVisible(boolean isVisible) {
        if (this.mNewFlagImg != null) {
            if (isVisible) {
                this.mNewFlagImg.setVisibility(0);
            } else {
                this.mNewFlagImg.setVisibility(8);
            }
        }
    }

    private void setVoiceLengthText(int length) {
        this.mVoiceLength.setText((CharSequence)((length == 0 ? 1 : length) + "\""));
    }

    private void startVoiceAnim() {
        AnimationDrawable voiceAnim;
        if (this.mVoiceAnimImg != null && (voiceAnim = (AnimationDrawable)this.mVoiceAnimImg.getBackground()) != null) {
            if (voiceAnim.isRunning()) {
                voiceAnim.stop();
            }
            voiceAnim.start();
        }
    }

    private void stopVoiceAnim() {
        AnimationDrawable voiceAnim;
        if (this.mVoiceAnimImg != null && (voiceAnim = (AnimationDrawable)this.mVoiceAnimImg.getBackground()) != null) {
            voiceAnim.stop();
            voiceAnim.selectDrawable(0);
        }
    }

    private void setClickListener(View.OnClickListener listener) {
        if (this.mContentLayout != null) {
            this.mContentLayout.setOnClickListener(listener);
        }
    }
}

