/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.newui.holder.send;

import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.NormalFileInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.newui.base.BaseSendHolder;
import com.xdja.im.uikit.newui.presenter.ChatDetailAdapterPresenter;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.file.TranslateInfoUtil;
import com.xdja.im.uikit.utils.log.LogUtil;

public class ViewSendFileHolder
extends BaseSendHolder {
    private ImageView mLogoImg = (ImageView)this.findViewById(R.id.img_file_flag);
    private TextView mFileNameTv = (TextView)this.findViewById(R.id.tv_file_name);
    private TextView mFileSizeTv = (TextView)this.findViewById(R.id.tv_file_size);
    private ProgressBar mLoadingPBar = (ProgressBar)this.findViewById(R.id.pbar_file_progress);

    public ViewSendFileHolder(View itemView) {
        super(itemView);
        this.mContentLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ChatDetailAdapterPresenter)ViewSendFileHolder.this.getPresenter()).openNormalFile((TalkMessageBean)ViewSendFileHolder.this.dataSource);
            }
        });
    }

    @Override
    public void bindData(int position, TalkMessageBean dataSource) {
        super.bindData(position, dataSource);
        NormalFileInfo normalFileInfo = (NormalFileInfo)dataSource.getFileInfo();
        if (normalFileInfo == null) {
            LogUtil.e("ERROR: Send file info is null.");
            return;
        }
        this.mFileNameTv.setText((CharSequence)normalFileInfo.getFileName());
        this.mFileSizeTv.setText((CharSequence)FileSizeUtils.formatFileSize(normalFileInfo.getFileSize()));
        this.loadLogo(normalFileInfo.getFilePath());
        if (dataSource.getMessageState() == 1) {
            this.mLoadingPBar.setVisibility(0);
            this.mLoadingPBar.setProgress((int)((float)this.getTranslateSize(normalFileInfo) * 100.0f / (float)normalFileInfo.getFileSize()));
        } else {
            this.mLoadingPBar.setVisibility(8);
        }
    }

    private long getTranslateSize(NormalFileInfo fileInfo) {
        return Math.max(TranslateInfoUtil.getTranslateSize(fileInfo.getTalkMessageId()), fileInfo.getTranslateSize());
    }

    private void loadLogo(String filePath) {
        if (FileUtils.isFileExists(filePath)) {
            this.mLogoImg.setImageResource(FileUtils.getIconWithSuffix(filePath));
        } else {
            this.mLogoImg.setImageResource(R.mipmap.im_uikit_ic_others);
        }
    }
}

