/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.newui.holder.send;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.lib.filemanage.util.HistoryFileUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.newui.base.BaseSendHolder;
import com.xdja.im.uikit.newui.presenter.ChatDetailAdapterPresenter;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.view.ChatImageView;

public class ViewSendImageHolder
extends BaseSendHolder {
    private ChatImageView mChatImage = (ChatImageView)((Object)this.findViewById(R.id.img_send_image));
    private ImageView mGifImageView = (ImageView)this.findViewById(R.id.img_send_gif_image);
    private ImageView mBombFlagImg = (ImageView)this.findViewById(R.id.img_bomb_flag);

    public ViewSendImageHolder(View itemView) {
        super(itemView);
        this.mContentLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ChatDetailAdapterPresenter)ViewSendImageHolder.this.getPresenter()).previewImage((TalkMessageBean)ViewSendImageHolder.this.dataSource);
            }
        });
    }

    @Override
    public void bindData(int position, TalkMessageBean dataSource) {
        super.bindData(position, dataSource);
        ImageFileInfo fileInfo = (ImageFileInfo)dataSource.getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("load image, but file info is null");
            this.mChatImage.setError(R.mipmap.im_uikit_pic_failed);
            return;
        }
        this.loadImage(fileInfo, dataSource);
        if (dataSource.isBomb()) {
            this.mBombFlagImg.setVisibility(0);
        }
    }

    private void loadImage(ImageFileInfo imageFileInfo, TalkMessageBean dataSource) {
        if (FileUtils.isFileExists(imageFileInfo.getFilePath())) {
            this.loadImageUrl(imageFileInfo, dataSource);
        } else {
            LogUtil.w("file is not exit.");
            this.mChatImage.setError(R.mipmap.im_uikit_pic_default);
        }
    }

    private void loadImageUrl(ImageFileInfo imageFileInfo, TalkMessageBean dataSource) {
        String suffix = imageFileInfo.getSuffix();
        if (imageFileInfo != null && "gif".equalsIgnoreCase(suffix) && !TextUtils.isEmpty((CharSequence)imageFileInfo.getFilePath())) {
            String urlGif = imageFileInfo.getFilePath();
            long fileSize = imageFileInfo.getFileSize();
            this.mChatImage.setVisibility(8);
            this.mGifImageView.setVisibility(0);
            if (HistoryFileUtils.isFileExist(urlGif)) {
                Glide.with((Activity)this.getActivity()).load(urlGif).placeholder(R.mipmap.im_uikit_pic_default).diskCacheStrategy(DiskCacheStrategy.SOURCE).into(this.mGifImageView);
            }
        } else {
            this.mChatImage.setVisibility(0);
            this.mGifImageView.setVisibility(8);
            this.mChatImage.loadImage(imageFileInfo.getFilePath());
        }
    }
}

