/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.newui.holder.send;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.newui.base.BaseSendHolder;
import com.xdja.im.uikit.newui.presenter.ChatDetailAdapterPresenter;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.view.ChatImageView;
import com.xdja.im.uikit.view.CircleProgressBar;

public class ViewSendVideoHolder
extends BaseSendHolder {
    private ChatImageView mChatImage = (ChatImageView)((Object)this.findViewById(R.id.img_send_image));
    private ImageView mPlayFlagImg = (ImageView)this.findViewById(R.id.img_play_flag);
    private CircleProgressBar mLoadingPBar = (CircleProgressBar)((Object)this.findViewById(R.id.pbar_video_loading));
    private TextView mVideoTimeTv = (TextView)this.findViewById(R.id.tv_video_duration);

    public ViewSendVideoHolder(View itemView) {
        super(itemView);
        this.mContentLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ChatDetailAdapterPresenter)ViewSendVideoHolder.this.getPresenter()).previewVideo((TalkMessageBean)ViewSendVideoHolder.this.dataSource);
            }
        });
        this.mPlayFlagImg.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ChatDetailAdapterPresenter)ViewSendVideoHolder.this.getPresenter()).previewVideo((TalkMessageBean)ViewSendVideoHolder.this.dataSource);
            }
        });
        this.mPlayFlagImg.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return ViewSendVideoHolder.this.showPopDialog();
            }
        });
    }

    @Override
    public void bindData(int position, TalkMessageBean dataSource) {
        super.bindData(position, dataSource);
        VideoFileInfo videoFileInfo = (VideoFileInfo)dataSource.getFileInfo();
        if (videoFileInfo == null) {
            LogUtil.e("Video file info is null error.");
            return;
        }
        this.mPlayFlagImg.setVisibility(0);
        this.mVideoTimeTv.setVisibility(0);
        this.updateProgress(videoFileInfo.getTranslatePercent());
        this.loadImage(videoFileInfo.getFilePath());
        this.mVideoTimeTv.setText((CharSequence)String.format(this.getStringRes(R.string.im_uikit_video_duration), videoFileInfo.getAmountOfTime() / 60, videoFileInfo.getAmountOfTime() % 60));
    }

    private void loadImage(String filePath) {
        if (FileUtils.isFileExists(filePath)) {
            this.mChatImage.loadImage(filePath);
        } else {
            this.mVideoTimeTv.setVisibility(8);
            this.mPlayFlagImg.setVisibility(8);
            this.mChatImage.setError(R.mipmap.im_uikit_ic_video_failed);
        }
    }

    private void updateProgress(int percent) {
        if (((TalkMessageBean)this.dataSource).getMessageState() == 1) {
            this.mPlayFlagImg.setVisibility(8);
            this.mLoadingPBar.setVisibility(0);
            this.mLoadingPBar.setProgress(percent);
        } else {
            this.mPlayFlagImg.setVisibility(0);
            this.mLoadingPBar.setVisibility(8);
        }
    }
}

