/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.newui.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.xdja.im.common.database.dao.MeetInfoEntityDao;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.core.model.message.MeetInfo;
import com.xdja.im.lib.action.ChatActionView;
import com.xdja.im.lib.action.ChatInputView;
import com.xdja.im.lib.action.bean.OptionBean;
import com.xdja.im.lib.action.listener.IChatActionCallback;
import com.xdja.im.lib.action.listener.IChatActionItemClickListener;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImFragmentSuperView;
import com.xdja.im.uikit.newui.adapter.ChatDetailAdapter;
import com.xdja.im.uikit.newui.presenter.ChatDetailPresenter;
import com.xdja.im.uikit.newui.vu.ChatDetailVu;
import com.xdja.im.uikit.utils.FunctionUtils;
import com.xdja.im.uikit.utils.NetworkHelper;
import com.xdja.im.uikit.view.KeyboardLayout;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class ChatDetailView
extends ImFragmentSuperView<ChatDetailPresenter>
implements ChatDetailVu {
    private KeyboardLayout mRootLayout;
    private RelativeLayout mContentLayout;
    private RecyclerView mRecyclerView;
    private ChatInputView mChatInputView;
    private ChatActionView mChatActionView;
    private SwipeRefreshLayout swipeRefreshLayout;
    private InputMethodManager inputMethodManager;
    private LinearLayout networkStateLineaLayout;
    private TextView networkStateTv;
    private RelativeLayout im_uikit_meeting_tips_layout;
    private TextView im_uikit_meeting_tips_txt;
    private boolean mShouldScroll;
    private boolean isScrollView;
    private int mToPosition;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_chat_detail_layout;
    }

    @Override
    protected int getToolbarType() {
        return 0;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mRootLayout = (KeyboardLayout)this.findViewById(R.id.root_layout);
        this.mContentLayout = (RelativeLayout)this.findViewById(R.id.content_layout);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.lv_message_list);
        this.mChatInputView = (ChatInputView)this.findViewById(R.id.layout_chat_operate);
        this.mChatActionView = (ChatActionView)this.findViewById(R.id.layout_chat_action);
        this.swipeRefreshLayout = (SwipeRefreshLayout)this.findViewById(R.id.swipe_container);
        this.networkStateLineaLayout = (LinearLayout)this.findViewById(R.id.network_state_view);
        this.networkStateTv = (TextView)this.findViewById(R.id.networkstate_tv);
        this.changeNetworkViewState(NetworkHelper.getHelper().getNetState());
        this.im_uikit_meeting_tips_layout = (RelativeLayout)this.findViewById(R.id.im_uikit_meeting_tips_layout);
        this.im_uikit_meeting_tips_txt = (TextView)this.findViewById(R.id.im_uikit_meeting_tips_txt);
        this.im_uikit_meeting_tips_layout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ChatDetailPresenter)ChatDetailView.this.getPresenter()).addMeeting();
            }
        });
    }

    @Override
    public void init(LayoutInflater inflater, ViewGroup container) {
        super.init(inflater, container);
        this.inputMethodManager = (InputMethodManager)this.getActivity().getSystemService("input_method");
        this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                ((ChatDetailPresenter)ChatDetailView.this.getPresenter()).downRefreshList();
            }
        });
        this.registerInputCallback();
        this.mRootLayout.setActivity(this.getActivity());
        this.mChatActionView.setAcceptInput(this.mChatInputView.getInputEdt());
        this.initChatListListView();
        this.setNavigateCallback(new ImFragmentSuperView.onNavigateCallback(){

            @Override
            public void onBackClick() {
                ChatDetailView.this.hideSoftInputView();
            }

            @Override
            public void onAddClick() {
                ((ChatDetailPresenter)ChatDetailView.this.getPresenter()).startSetting();
            }
        });
    }

    private void initChatListListView() {
        this.mRecyclerView.setOnTouchListener(new View.OnTouchListener(){

            @SuppressLint(value={"ClickableViewAccessibility"})
            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 0) {
                    if (ChatDetailView.this.mChatActionView.isShown()) {
                        ChatDetailView.this.restoreActionState();
                        return true;
                    }
                    ChatDetailView.this.mRecyclerView.setFocusable(true);
                    ChatDetailView.this.displayInputKeyBoard(false);
                    return false;
                }
                return false;
            }
        });
        this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                if (ChatDetailView.this.mShouldScroll) {
                    ChatDetailView.this.mShouldScroll = false;
                    ChatDetailView.this.smoothMoveToPosition(ChatDetailView.this.mToPosition);
                }
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (ChatDetailView.this.isScrollView) {
                    ChatDetailView.this.isScrollView = false;
                    int lastItem = ChatDetailView.this.mRecyclerView.getAdapter().getItemCount() - 1;
                    ChatDetailView.this.smoothMoveToPosition(lastItem);
                }
            }
        });
    }

    @Override
    public void smoothMoveToPosition(int index) {
        int firstItem = ((ChatDetailPresenter)this.getPresenter()).getLinearLayoutManager().findFirstVisibleItemPosition();
        int lastItem = ((ChatDetailPresenter)this.getPresenter()).getLinearLayoutManager().findLastVisibleItemPosition();
        if (index <= firstItem) {
            this.mRecyclerView.smoothScrollToPosition(index);
        } else if (index <= lastItem) {
            int movePosition = index - firstItem;
            if (movePosition >= 0 && movePosition < this.mRecyclerView.getChildCount()) {
                int top = this.mRecyclerView.getChildAt(movePosition).getTop();
                this.mRecyclerView.smoothScrollBy(0, top);
            }
        } else {
            this.mRecyclerView.smoothScrollToPosition(index);
            this.mToPosition = index;
            this.mShouldScroll = true;
        }
    }

    @Override
    public void setToolBarVisibility(int visibility) {
        this.supportActionBar(visibility == 0);
    }

    @Override
    public void setToolBarAddVisibility(int visibility) {
        this.setToolBarAddVisible(visibility == 0);
    }

    @Override
    public void setTitle(String title) {
        if (this.isSupportActionBar()) {
            this.setToolBarTitle(title);
        }
    }

    @Override
    public void setAdapter(ChatDetailAdapter adapter) {
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)((ChatDetailPresenter)this.getPresenter()).getLinearLayoutManager());
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)adapter);
    }

    @Override
    public void setOptions(List<OptionBean> options) {
        if (this.mChatActionView != null) {
            this.mChatActionView.setOptionsData(options);
        }
    }

    @Override
    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    @Override
    public String getInputContent() {
        return this.mChatInputView.getInputText();
    }

    @Override
    public void setInputContent(String content) {
        if (!TextUtils.isEmpty((CharSequence)content)) {
            this.mChatInputView.setIsDraft(true);
        }
        this.mChatInputView.setInputText(content);
    }

    @Override
    public boolean isRefreshing() {
        return this.swipeRefreshLayout.isRefreshing();
    }

    @Override
    public void stopRefresh() {
        this.swipeRefreshLayout.setRefreshing(false);
    }

    @Override
    public void setListSelection(int selection) {
        this.smoothMoveToPosition(selection);
    }

    @Override
    public void restoreActionState() {
        this.mChatActionView.setVisibility(8);
        this.mChatInputView.setShanState(false);
        this.mChatInputView.setMoreState(false);
    }

    @Override
    public void changeViewSate(int state) {
        this.changeNetworkViewState(state);
        if (!NetworkHelper.getHelper().isFirstNotice() && FunctionUtils.isAppOnForeground((Context)this.getActivity())) {
            if (state == 2) {
                Toast.makeText((Context)this.getActivity(), (CharSequence)"Network unavailable", (int)1).show();
            } else if (state == 1) {
                Toast.makeText((Context)this.getActivity(), (CharSequence)"Unable to access the server", (int)1).show();
            }
        }
    }

    @Override
    public void setMeetState(boolean isShow, int talkType) {
        if (isShow && talkType == 2) {
            this.im_uikit_meeting_tips_layout.setVisibility(0);
        } else {
            this.im_uikit_meeting_tips_layout.setVisibility(8);
        }
    }

    @Override
    public void setChatMeet(String talkFlag) {
        Observable.just((Object)talkFlag).subscribeOn(Schedulers.newThread()).map((Func1)new Func1<String, MeetInfo>(){

            public MeetInfo call(String s) {
                MeetInfo meetInfo = MeetInfoEntityDao.getInstance().get(s);
                return meetInfo;
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<MeetInfo>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                e.printStackTrace();
                ChatDetailView.this.im_uikit_meeting_tips_layout.setVisibility(8);
            }

            public void onNext(MeetInfo meetInfo) {
                if (meetInfo != null) {
                    if (meetInfo.getIsShow() == 1 && meetInfo.getTaklFlag().equals(((ChatDetailPresenter)ChatDetailView.this.getPresenter()).getTalkFlag())) {
                        ChatDetailView.this.im_uikit_meeting_tips_layout.setVisibility(0);
                    } else {
                        ChatDetailView.this.im_uikit_meeting_tips_layout.setVisibility(8);
                    }
                    if (!TextUtils.isEmpty((CharSequence)meetInfo.getTips())) {
                        ChatDetailView.this.im_uikit_meeting_tips_txt.setText((CharSequence)meetInfo.getTips());
                    }
                } else {
                    ChatDetailView.this.im_uikit_meeting_tips_layout.setVisibility(8);
                }
            }
        });
    }

    @Override
    public void setChatMeetTips(String tips) {
        if (!TextUtils.isEmpty((CharSequence)tips) && this.im_uikit_meeting_tips_txt != null) {
            this.im_uikit_meeting_tips_txt.setText((CharSequence)tips);
        }
    }

    @Override
    public void setTalkType(int talkType) {
        if (this.mToolbarAdd != null) {
            if (talkType == 1) {
                this.mToolbarAdd.setImageResource(R.mipmap.im_uikit_ic_toolbar_add);
                this.mChatInputView.setChatType(talkType);
            } else if (talkType == 2) {
                this.mToolbarAdd.setImageResource(R.mipmap.im_uikit_ic_toolbar_add_p2g);
                this.mChatInputView.setChatType(talkType);
            }
        }
    }

    @Override
    public void setGroupId(String groupId) {
        if (!TextUtils.isEmpty((CharSequence)groupId)) {
            this.mChatInputView.setGroupId(groupId);
        }
    }

    @Override
    public void setAccount(String account) {
        if (!TextUtils.isEmpty((CharSequence)account)) {
            this.mChatInputView.setAccount(account);
        }
    }

    @Override
    public void showAtActionView() {
        if (!this.mChatActionView.isActionViewVisible()) {
            this.showActionView();
        }
        if (!this.inputMethodManager.isActive()) {
            this.displayInputKeyBoard(true);
        }
    }

    @Override
    public void setAtText(String s, int type) {
        if (this.mChatInputView.getInputEdt().length() + s.length() > 2048) {
            new XToast((Context)this.getActivity()).display(R.string.im_uikit_input_length_warnning);
            return;
        }
        if (type == 0) {
            this.showInputBoardAndHideAction();
            if (this.mChatInputView.getInputEdt().getText().toString().contains(s)) {
                return;
            }
        }
        int index = this.mChatInputView.getInputEdt().getSelectionStart();
        Editable editable = this.mChatInputView.getInputEdt().getEditableText();
        if (index < 0 || index >= editable.length()) {
            editable.append((CharSequence)s);
        } else {
            editable.insert(index, (CharSequence)s);
        }
    }

    private void showInputBoardAndHideAction() {
        this.mChatActionView.setVisibility(8);
        this.setEditTextFocus(true);
    }

    private void registerInputCallback() {
        this.mChatInputView.registerActionViewCallBack(new IChatActionCallback(){

            @Override
            public void onVirtualViewCallBack() {
            }

            @Override
            public void onMoreCheckChanged() {
                if (ChatDetailView.this.mChatActionView.isActionViewVisible()) {
                    ChatDetailView.this.hideActionView(false);
                    ChatDetailView.this.restoreActionState();
                } else {
                    ChatDetailView.this.showActionView();
                    ChatDetailView.this.mChatInputView.setMoreState(true);
                    ChatDetailView.this.mChatActionView.setActionViewVisible(true);
                }
            }

            @Override
            public void onShanCheckChanged() {
                if (ChatDetailView.this.mChatActionView.isEmojiVisible()) {
                    ChatDetailView.this.hideActionView(true);
                    ChatDetailView.this.restoreActionState();
                    ChatDetailView.this.setEditTextFocus(true);
                } else {
                    ChatDetailView.this.showActionView();
                    ChatDetailView.this.mChatInputView.setShanState(true);
                    ChatDetailView.this.mChatActionView.setEmojiVisible(true);
                }
            }

            @Override
            public void onInputCheckChanged(boolean isChecked) {
                if (isChecked) {
                    if (ChatDetailView.this.mChatActionView.isShown()) {
                        ChatDetailView.this.hideActionView(true);
                    }
                } else {
                    if (ChatDetailView.this.mRootLayout.isSoftInputShown()) {
                        ChatDetailView.this.hideSoftInputView();
                    }
                    if (ChatDetailView.this.mChatActionView.isShown()) {
                        ChatDetailView.this.hideActionView(false);
                    }
                    ChatDetailView.this.restoreActionState();
                }
            }

            @Override
            public void onSendTextCallBack() {
                String content = ChatDetailView.this.mChatInputView.getInputText();
                if (TextUtils.isEmpty((CharSequence)content.trim())) {
                    CommonTool.showToast(R.string.im_uikit_content_cannot_null);
                    return;
                }
                if (((ChatDetailPresenter)ChatDetailView.this.getPresenter()).sendTextMessage(content)) {
                    ChatDetailView.this.mChatInputView.setInputText("");
                }
            }

            @Override
            public void onInputEareTouchCallBack() {
                if (ChatDetailView.this.mChatActionView.isShown()) {
                    ChatDetailView.this.restoreActionState();
                }
                ChatDetailView.this.isScrollView = true;
            }

            @Override
            public void onRecorderFinish(int seconds, String filePath) {
                ((ChatDetailPresenter)ChatDetailView.this.getPresenter()).sendVoiceMessage(filePath, seconds);
            }
        });
        this.mChatActionView.setChatActionItemClickListener(new IChatActionItemClickListener(){

            @Override
            public void onItemClick(int position, OptionBean optionBean) {
                if (optionBean.getId() == 5 || optionBean.getId() == 6) {
                    ((ChatDetailPresenter)ChatDetailView.this.getPresenter()).startVoice(position, optionBean);
                } else if (optionBean.getId() == 8) {
                    ((ChatDetailPresenter)ChatDetailView.this.getPresenter()).startLocation(position, optionBean);
                } else if (optionBean.getId() == 7) {
                    ((ChatDetailPresenter)ChatDetailView.this.getPresenter()).startCallback(position, optionBean);
                } else {
                    ((ChatDetailPresenter)ChatDetailView.this.getPresenter()).startToOptionView(position, optionBean);
                }
            }
        });
    }

    public void showActionView() {
        if (this.mRootLayout.isSoftInputShown()) {
            this.lockContentViewHeight();
            this.hideSoftInputView();
            this.restoreActionState();
            this.unlockContentViewHeightDelayed();
        }
        this.mChatActionView.setVisibility(0);
        this.mChatInputView.switchToInputEdt(true);
        this.isScrollView = true;
    }

    public void hideActionView(boolean isShowSoftInputView) {
        if (this.mChatActionView.isShown()) {
            this.mChatActionView.setVisibility(8);
            if (isShowSoftInputView) {
                this.showSoftInputView();
            }
        }
    }

    public void lockContentViewHeight() {
        LinearLayout.LayoutParams params = this.getLayoutParamsForContent();
        params.height = this.mContentLayout.getHeight() + 200;
        params.weight = 0.0f;
    }

    public void unlockContentViewHeightDelayed() {
        this.mChatInputView.getInputEdt().postDelayed(new Runnable(){

            @Override
            public void run() {
                LinearLayout.LayoutParams params = ChatDetailView.this.getLayoutParamsForContent();
                params.weight = 1.0f;
                ChatDetailView.this.mContentLayout.invalidate();
            }
        }, 200L);
    }

    private LinearLayout.LayoutParams getLayoutParamsForContent() {
        return (LinearLayout.LayoutParams)this.mContentLayout.getLayoutParams();
    }

    private void showSoftInputView() {
        final EditText et = this.mChatInputView.getInputEdt();
        et.requestFocus();
        et.post(new Runnable(){

            @Override
            public void run() {
                ChatDetailView.this.inputMethodManager.showSoftInput((View)et, 0);
                ChatDetailView.this.isScrollView = true;
            }
        });
    }

    private void hideSoftInputView() {
        this.inputMethodManager.hideSoftInputFromWindow(this.mChatInputView.getInputEdt().getWindowToken(), 0);
    }

    public void displayInputKeyBoard(boolean isShow) {
        this.setEditTextFocus(isShow);
        if (!isShow) {
            this.inputMethodManager.hideSoftInputFromWindow(this.mChatInputView.getInputEdt().getWindowToken(), 0);
        } else {
            this.inputMethodManager.toggleSoftInput(0, 2);
        }
    }

    private void setEditTextFocus(boolean isShow) {
        if (isShow) {
            this.mChatInputView.getInputEdt().setFocusable(true);
            this.mChatInputView.getInputEdt().setFocusableInTouchMode(true);
            this.mChatInputView.getInputEdt().requestFocus();
        } else {
            this.mChatInputView.getInputEdt().setFocusable(false);
        }
    }

    private void changeNetworkViewState(int flag) {
        switch (flag) {
            case 2: {
                String tips = this.getActivity().getResources().getString(R.string.im_uikit_network_disabled);
                this.networkStateTv.setText((CharSequence)tips);
                this.networkStateLineaLayout.setVisibility(0);
                break;
            }
            case 1: {
                String tips = this.getActivity().getResources().getString(R.string.im_uikit_network_no_server);
                this.networkStateTv.setText((CharSequence)tips);
                this.networkStateLineaLayout.setVisibility(0);
                break;
            }
            case 0: {
                this.networkStateLineaLayout.setVisibility(8);
                break;
            }
        }
    }
}

