/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui;

import android.util.SparseArray;
import android.util.SparseIntArray;
import com.xdja.im.base.frame.view.AdapterBaseView;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.ui.presenter.SessionListAdapterPresenter;
import com.xdja.im.uikit.ui.view.CustomBaseChatItem;
import com.xdja.im.uikit.ui.view.ViewCustomRecItem;
import com.xdja.im.uikit.ui.view.ViewCustomSendItem;
import com.xdja.im.uikit.ui.view.ViewCustomSessionItem;
import com.xdja.im.uikit.ui.view.ViewDefaultSendItem;
import com.xdja.im.uikit.ui.view.ViewDefaultSessionItem;
import com.xdja.im.uikit.ui.view.ViewGroupItem;
import com.xdja.im.uikit.ui.view.ViewNotifyItem;
import com.xdja.im.uikit.ui.view.ViewRecvFileItem;
import com.xdja.im.uikit.ui.view.ViewRecvImageItem;
import com.xdja.im.uikit.ui.view.ViewRecvLocationItem;
import com.xdja.im.uikit.ui.view.ViewRecvTextItem;
import com.xdja.im.uikit.ui.view.ViewRecvVideoItem;
import com.xdja.im.uikit.ui.view.ViewRecvVoiceItem;
import com.xdja.im.uikit.ui.view.ViewRecvWebItem;
import com.xdja.im.uikit.ui.view.ViewSendFileItem;
import com.xdja.im.uikit.ui.view.ViewSendImageItem;
import com.xdja.im.uikit.ui.view.ViewSendLocationItem;
import com.xdja.im.uikit.ui.view.ViewSendTextItem;
import com.xdja.im.uikit.ui.view.ViewSendVideoItem;
import com.xdja.im.uikit.ui.view.ViewSendVoiceItem;
import com.xdja.im.uikit.ui.view.ViewSendWebItem;
import com.xdja.im.uikit.ui.view.ViewSingleItem;
import com.xdja.im.uikit.ui.view.ViewSystemSessionItem;

public class ListItemUtils {
    private static ListItemUtils itemUtils;
    private SparseArray<Class<? extends AdapterBaseView<ChatListAdapterPresenter, TalkMessageBean>>> chatListItemSparseArray = new SparseArray();
    private SparseArray<Class<? extends AdapterBaseView<SessionListAdapterPresenter, TalkSessionBean>>> sessionListItemSparseArray = new SparseArray();
    private SparseIntArray customTypeArray = new SparseIntArray();

    private ListItemUtils() {
        this.initSessionListItems();
        this.initChatListItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ListItemUtils getInstance() {
        if (itemUtils != null) return itemUtils;
        Class<ListItemUtils> clazz = ListItemUtils.class;
        synchronized (ListItemUtils.class) {
            if (itemUtils != null) return itemUtils;
            itemUtils = new ListItemUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return itemUtils;
        }
    }

    private void initSessionListItems() {
        this.sessionListItemSparseArray.put(0, ViewSingleItem.class);
        this.sessionListItemSparseArray.put(1, ViewGroupItem.class);
        this.sessionListItemSparseArray.put(2, ViewCustomSessionItem.class);
        this.sessionListItemSparseArray.put(3, ViewDefaultSessionItem.class);
        this.sessionListItemSparseArray.put(4, ViewSystemSessionItem.class);
    }

    public Class<? extends AdapterBaseView<SessionListAdapterPresenter, TalkSessionBean>> getSessionListItemByTypeKey(int type) {
        return (Class)this.sessionListItemSparseArray.get(type);
    }

    public int getSessionListItemTypeSize() {
        return this.sessionListItemSparseArray.size();
    }

    private void initChatListItems() {
        this.chatListItemSparseArray.put(0, ViewSendTextItem.class);
        this.chatListItemSparseArray.put(1, ViewRecvTextItem.class);
        this.chatListItemSparseArray.put(2, ViewSendVoiceItem.class);
        this.chatListItemSparseArray.put(3, ViewRecvVoiceItem.class);
        this.chatListItemSparseArray.put(4, ViewSendImageItem.class);
        this.chatListItemSparseArray.put(5, ViewRecvImageItem.class);
        this.chatListItemSparseArray.put(6, ViewSendVideoItem.class);
        this.chatListItemSparseArray.put(7, ViewRecvVideoItem.class);
        this.chatListItemSparseArray.put(8, ViewSendFileItem.class);
        this.chatListItemSparseArray.put(9, ViewRecvFileItem.class);
        this.chatListItemSparseArray.put(10, ViewSendWebItem.class);
        this.chatListItemSparseArray.put(11, ViewRecvWebItem.class);
        this.chatListItemSparseArray.put(12, ViewSendLocationItem.class);
        this.chatListItemSparseArray.put(13, ViewRecvLocationItem.class);
        this.chatListItemSparseArray.put(14, ViewNotifyItem.class);
        this.chatListItemSparseArray.put(15, ViewCustomSendItem.class);
        this.chatListItemSparseArray.put(16, ViewDefaultSendItem.class);
        this.chatListItemSparseArray.put(17, ViewCustomRecItem.class);
    }

    public Class<? extends AdapterBaseView<ChatListAdapterPresenter, TalkMessageBean>> getChatListItemByTypeKey(int type) {
        return (Class)this.chatListItemSparseArray.get(type);
    }

    public int getChatListItemTypeSize() {
        return this.chatListItemSparseArray.size();
    }

    public synchronized void addChatListItemAndPaser(int customType, Class<? extends CustomBaseChatItem> customItem) {
        this.customTypeArray.put(customType, this.chatListItemSparseArray.size());
        this.chatListItemSparseArray.put(this.chatListItemSparseArray.size(), customItem);
    }

    public int getRealCustomType(int customType) {
        return this.customTypeArray.get(customType);
    }
}

