/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.adapter;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.xdja.im.base.frame.presenter.BasePagerAdapterPresenter;
import com.xdja.im.base.frame.view.PagerAdapterView;
import com.xdja.im.common.imageloader.ImageLoader;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.repository.impl.im.IMProxyImpl;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.FilePreviewAdapterPresenter;
import com.xdja.im.uikit.ui.view.BaseFilePreview;
import com.xdja.im.uikit.ui.view.ViewPreviewFile;
import com.xdja.im.uikit.ui.view.ViewPreviewImage;
import com.xdja.im.uikit.ui.view.ViewPreviewVideo;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import rx.Subscriber;

public class FilePreviewAdapter
extends BasePagerAdapterPresenter<FilePreviewAdapterPresenter, TalkMessageBean>
implements FilePreviewAdapterPresenter {
    private Activity mActivity;
    private final List<TalkMessageBean> mDataSource;
    private IMProxyImpl mImProxyImp;
    private ImageLoader mImageLoader;
    List<Class<? extends PagerAdapterView<FilePreviewAdapterPresenter, TalkMessageBean>>> vuClasses;
    private SettingMsgIdCallback callback;

    public FilePreviewAdapter(Activity activity, List<TalkMessageBean> dataSource, IMProxyImpl imProxy, ImageLoader imageLoader, SettingMsgIdCallback callback) {
        this.mActivity = activity;
        this.mDataSource = dataSource;
        this.mImProxyImp = imProxy;
        this.mImageLoader = imageLoader;
        this.callback = callback;
    }

    @Override
    protected Activity getActivity() {
        return this.mActivity;
    }

    @Override
    public void onPageSelected(int lastPos, int curPos) {
        if (this.adapterVus != null && this.adapterVus.containsKey(lastPos)) {
            ((BaseFilePreview)this.adapterVus.get(lastPos)).onPageSelected(lastPos, curPos);
        }
    }

    @Override
    protected TalkMessageBean getDataSource(int position) {
        return this.mDataSource == null ? null : this.mDataSource.get(position);
    }

    public int getCount() {
        return this.mDataSource == null ? 0 : this.mDataSource.size();
    }

    @Override
    public int getItemViewType(int position) {
        TalkMessageBean talkMessageBean = this.getDataSource(position);
        FileInfo fileInfo = talkMessageBean.getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("get item view type, but file is null.");
            return -1;
        }
        int type = -1;
        switch (fileInfo.getFileType()) {
            case 3: {
                type = 0;
                break;
            }
            case 2: {
                type = 1;
                break;
            }
            case 11: {
                type = 2;
            }
        }
        return type;
    }

    @Override
    @NonNull
    protected Class<? extends PagerAdapterView<FilePreviewAdapterPresenter, TalkMessageBean>> getVuClassByViewType(int itemViewType) {
        Class<? extends PagerAdapterView<FilePreviewAdapterPresenter, TalkMessageBean>> vuClass = null;
        switch (itemViewType) {
            case 0: {
                vuClass = this.getVuClasses().get(0);
                break;
            }
            case 1: {
                vuClass = this.getVuClasses().get(1);
                break;
            }
            case 2: {
                vuClass = this.getVuClasses().get(2);
            }
        }
        return vuClass;
    }

    @Override
    protected List<Class<? extends PagerAdapterView<FilePreviewAdapterPresenter, TalkMessageBean>>> getVuClasses() {
        if (this.vuClasses == null) {
            this.vuClasses = new ArrayList<Class<? extends PagerAdapterView<FilePreviewAdapterPresenter, TalkMessageBean>>>();
            this.vuClasses.add(ViewPreviewImage.class);
            this.vuClasses.add(ViewPreviewVideo.class);
            this.vuClasses.add(ViewPreviewFile.class);
        }
        return this.vuClasses;
    }

    @Override
    protected FilePreviewAdapterPresenter getPresenter() {
        return this;
    }

    @Override
    public void loadImage(ImageView imageView, String filePath, ImageView.ScaleType scaleType, int width, int height) {
        this.mImageLoader.loadImage(this.getActivity(), imageView, filePath, scaleType, width, height);
    }

    @Override
    public void download(FileInfo fileInfo) {
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>();
        fileInfoList.add(fileInfo);
        this.mImProxyImp.downloadFile(fileInfoList, new Subscriber<Integer>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(Integer integer) {
            }
        });
    }

    @Override
    public void saveFile(File srsFile, String savePath, String fileName) {
        this.mImProxyImp.saveFile(srsFile, savePath, fileName, new Subscriber<String>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Save file failed.");
                CommonTool.showToast(R.string.im_uikit_hint_save_failed);
            }

            public void onNext(String savePath) {
                CommonTool.showToast(String.format(FilePreviewAdapter.this.getActivity().getString(R.string.im_uikit_hint_save_image), savePath));
                Intent intent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
                Uri uri = Uri.fromFile((File)new File(savePath));
                intent.setData(uri);
                FilePreviewAdapter.this.getActivity().sendBroadcast(intent);
            }
        });
    }

    @Override
    public void deleteMsg(TalkMessageBean bean) {
        if (this.callback == null) {
            return;
        }
        int index = 0;
        int length = this.mDataSource.size();
        for (int i = 0; i < length; ++i) {
            TalkMessageBean tempBean = this.mDataSource.get(i);
            if (bean.getId() != tempBean.getId()) continue;
            index = i;
            if (length <= 1) break;
            if (i == 0) {
                this.callback.setCurMsgId(this.mDataSource.get(1).getId());
                break;
            }
            this.callback.setCurMsgId(this.mDataSource.get(i - 1).getId());
            break;
        }
        if (this.mDataSource != null && this.mDataSource.contains(bean)) {
            this.mDataSource.remove(bean);
        }
        this.callback.updateUI();
        this.callback.selectPage(index, bean);
        if (this.mDataSource.size() == 0 && this.callback != null) {
            this.callback.showEmptyView();
        }
    }

    public void onPause(int position) {
        if (this.adapterVus != null && this.adapterVus.containsKey(position)) {
            ((BaseFilePreview)this.adapterVus.get(position)).onViewPause();
        }
    }

    public static interface SettingMsgIdCallback {
        public void setCurMsgId(long var1);

        public void updateUI();

        public void showEmptyView();

        public void selectPage(int var1, TalkMessageBean var2);
    }
}

