/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.adapter;

import android.app.Activity;
import com.xdja.im.base.frame.presenter.BaseItemAdapterPresenter;
import com.xdja.im.base.frame.view.AdapterBaseView;
import com.xdja.im.core.model.message.MeetInfo;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.uikit.ui.ListItemUtils;
import com.xdja.im.uikit.ui.presenter.SessionListAdapterPresenter;
import com.xdja.im.uikit.ui.presenter.SessionListPresenter;
import java.util.List;

public class SessionListAdapter
extends BaseItemAdapterPresenter<SessionListAdapterPresenter, TalkSessionBean>
implements SessionListAdapterPresenter {
    private Activity mActivity;
    private final List<TalkSessionBean> mDataSource;
    private List<Class<? extends AdapterBaseView<SessionListAdapterPresenter, TalkSessionBean>>> vuClasses;
    private SessionListPresenter sessionListPresenter;

    public SessionListAdapter(Activity activity, List<TalkSessionBean> mDataSource, SessionListPresenter sessionListPresenter) {
        this.mActivity = activity;
        this.mDataSource = mDataSource;
        this.sessionListPresenter = sessionListPresenter;
    }

    @Override
    protected Activity getActivity() {
        return this.mActivity;
    }

    public int getViewTypeCount() {
        return ListItemUtils.getInstance().getSessionListItemTypeSize();
    }

    public int getItemViewType(int position) {
        if (this.mDataSource != null) {
            int talkType = this.mDataSource.get(position).getTalkType();
            switch (talkType) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 999: {
                    return 2;
                }
                case 201: {
                    return 4;
                }
            }
            return 3;
        }
        return 3;
    }

    @Override
    protected Class<? extends AdapterBaseView<SessionListAdapterPresenter, TalkSessionBean>> getVuClassByViewType(int itemViewType) {
        return ListItemUtils.getInstance().getSessionListItemByTypeKey(itemViewType);
    }

    @Override
    protected SessionListAdapterPresenter getPresenter() {
        return this;
    }

    @Override
    protected TalkSessionBean getDataSource(int position) {
        return this.mDataSource == null ? null : this.mDataSource.get(position);
    }

    public int getCount() {
        return this.mDataSource == null ? 0 : this.mDataSource.size();
    }

    public Object getItem(int position) {
        return this.mDataSource.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    @Override
    public MeetInfo ifShowMeetTip() {
        return this.sessionListPresenter.ifShowMeetTip();
    }
}

