/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.dialog;

import android.app.Dialog;
import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;
import com.xdja.im.uikit.ui.adapter.BaseListAdapter;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseListDialog
extends Dialog {
    private ListView mListView;
    private BaseListAdapter mAdapter;
    private List<ImOption> mOptions = new ArrayList<ImOption>();
    private onItemClickListener onItemClickListener;
    private int mItemPosition;

    public void setOnItemClickListener(onItemClickListener listener) {
        this.onItemClickListener = listener;
    }

    public BaseListDialog(@NonNull Context context) {
        super(context, R.style.im_uikit_BaseDialogStyle);
        this.setContentView(R.layout.im_uikit_dialg_option_list);
        this.setCancelable(true);
        this.initView();
    }

    private void initView() {
        this.mListView = (ListView)this.findViewById(R.id.lv_options);
        this.mAdapter = new BaseListAdapter(this.mOptions);
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (BaseListDialog.this.onItemClickListener != null) {
                    ImOption option = (ImOption)BaseListDialog.this.mOptions.get(position);
                    BaseListDialog.this.onItemClickListener.onItemClick(view, option, BaseListDialog.this.mItemPosition);
                }
            }
        });
        this.addData(this.getOptions());
    }

    public void addData(List<ImOption> options) {
        if (options == null || options.size() == 0) {
            return;
        }
        this.mOptions.clear();
        this.mOptions.addAll(options);
    }

    public void show(int position) {
        super.show();
        this.mItemPosition = position;
    }

    public abstract List<ImOption> getOptions();

    public static interface onItemClickListener {
        public void onItemClick(View var1, ImOption var2, int var3);
    }
}

