/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.graphics.drawable.AnimationDrawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;
import com.xdja.im.uikit.ui.dialog.BaseListDialog;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.ui.view.BaseChatItem;
import java.util.ArrayList;

public class BaseReceiveItem
extends BaseChatItem {
    protected RelativeLayout mContentLayout;
    private ImageView mBombAnimImg;
    private LinearLayout newMessageRemind;

    @Override
    protected void injectView() {
        super.injectView();
        this.mContentLayout = (RelativeLayout)this.findViewById(R.id.layout_message_container);
        this.mBombAnimImg = (ImageView)this.findViewById(R.id.img_bomb_anim);
        this.mUserName = (TextView)this.findViewById(R.id.txt_chat_senderName);
        this.newMessageRemind = (LinearLayout)this.findViewById(R.id.no_read_remaind);
        this.mContentLayout.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return BaseReceiveItem.this.showPopDialog();
            }
        });
        this.mPopDialog.setOnItemClickListener(new BaseListDialog.onItemClickListener(){

            @Override
            public void onItemClick(View view, ImOption option, int itemPosition) {
                BaseReceiveItem.this.dismissPopDialog();
                switch (option.getOptionType()) {
                    case 1: {
                        ((ChatListAdapterPresenter)BaseReceiveItem.this.getPresenter()).deleteItem(itemPosition);
                        break;
                    }
                    case 2: {
                        ((ChatListAdapterPresenter)BaseReceiveItem.this.getPresenter()).copyMessage(itemPosition);
                        break;
                    }
                    case 5: {
                        ((ChatListAdapterPresenter)BaseReceiveItem.this.getPresenter()).forwardMessage(itemPosition);
                    }
                }
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        if (dataSource.isGroupMsg()) {
            this.mUserName.setVisibility(0);
        } else {
            this.mUserName.setVisibility(8);
        }
        if (dataSource.isRemind()) {
            this.newMessageRemind.setVisibility(0);
        } else {
            this.newMessageRemind.setVisibility(8);
        }
    }

    protected void setContentLayoutBackground(@DrawableRes int resId) {
        this.mContentLayout.setBackgroundResource(resId);
    }

    protected void startBombAnim() {
        if (this.mBombAnimImg != null) {
            AnimationDrawable boomAnim = (AnimationDrawable)this.mBombAnimImg.getBackground();
            boomAnim.stop();
            boomAnim.start();
        }
    }

    protected void setMessageDestroy(boolean isDestroy) {
        if (((TalkMessageBean)this.dataSource).getMessageType() == 3 || ((TalkMessageBean)this.dataSource).getMessageType() == 2) {
            return;
        }
        if (this.mContentLayout != null) {
            if (isDestroy) {
                this.mContentLayout.setBackgroundResource(R.drawable.im_uikit_bg_receive_shan_selector);
            } else {
                this.mContentLayout.setBackgroundResource(R.drawable.im_uikit_bg_receive_selector);
            }
        }
    }

    protected void setDestroyView(TextView destroyView, boolean isDestroy, String destroyStr) {
        if (destroyView != null) {
            if (isDestroy) {
                destroyView.setVisibility(0);
                destroyView.setTextColor(this.getLimitTextColor());
                destroyView.setText((CharSequence)destroyStr);
            } else {
                destroyView.setVisibility(8);
            }
        }
    }

    protected boolean showPopDialog() {
        ArrayList<ImOption> data = new ArrayList<ImOption>();
        if (((TalkMessageBean)this.dataSource).getMessageType() == 0 && ((TalkMessageBean)this.dataSource).getMessageState() != 5) {
            data.add((ImOption)this.mImOptions.get(0));
            data.add((ImOption)this.mImOptions.get(1));
            if (CommonTool.getHasForward() != 1) {
                data.add((ImOption)this.mImOptions.get(4));
            }
        } else {
            data.add((ImOption)this.mImOptions.get(0));
        }
        if (((TalkMessageBean)this.dataSource).getMessageType() == 14) {
            data.add((ImOption)this.mImOptions.get(1));
            if (CommonTool.getHasForward() != 1) {
                data.add((ImOption)this.mImOptions.get(4));
            }
        }
        if (((TalkMessageBean)this.dataSource).getMessageType() == 2 && CommonTool.getHasForward() != 1) {
            data.add((ImOption)this.mImOptions.get(4));
        }
        if (((TalkMessageBean)this.dataSource).getMessageType() == 3 && CommonTool.getHasForward() != 1) {
            data.add((ImOption)this.mImOptions.get(4));
        }
        if (((TalkMessageBean)this.dataSource).getMessageType() == 4 && CommonTool.getHasForward() != 1) {
            data.add((ImOption)this.mImOptions.get(4));
        }
        if (((TalkMessageBean)this.dataSource).getMessageType() == 5 && CommonTool.getHasForward() != 1) {
            data.add((ImOption)this.mImOptions.get(4));
        }
        this.mPopDialog.addData(data);
        this.mPopDialog.show(this.curPosition);
        return true;
    }

    private void dismissPopDialog() {
        if (this.mPopDialog != null) {
            this.mPopDialog.dismiss();
        }
    }
}

