/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xdja.im.base.frame.view.AdapterBaseView;
import com.xdja.im.base.frame.view.AdapterSuperBaseView;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.utils.sys.TimeUtil;

public class ViewCustomThirdView
extends AdapterSuperBaseView<ChatListAdapterPresenter, TalkMessageBean>
implements AdapterBaseView<ChatListAdapterPresenter, TalkMessageBean> {
    private LinearLayout linearLayout;
    private LinearLayout.LayoutParams layoutParams;
    public static final long TIME_DIFFERENCE = 300000L;
    private TextView mTimeLineTv;
    private LinearLayout newMessageRemind;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_view_custom_third_view_layout;
    }

    @Override
    @SuppressLint(value={"WrongViewCast"})
    protected void injectView() {
        super.injectView();
        this.linearLayout = (LinearLayout)this.getView().findViewById(R.id.view_custom_third_view_layout);
        this.mTimeLineTv = (TextView)this.findViewById(R.id.tv_timeLine);
        this.newMessageRemind = (LinearLayout)this.findViewById(R.id.no_read_remaind);
        this.layoutParams = new LinearLayout.LayoutParams(-1, -2);
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        try {
            if (dataSource != null) {
                this.linearLayout.removeAllViews();
                this.linearLayout.addView(((ChatListAdapterPresenter)this.getPresenter()).getThirdTypeViewItem(this.getActivity(), dataSource), (ViewGroup.LayoutParams)this.layoutParams);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (position == 0) {
            this.setTimeLineVisible(dataSource.getShowTime());
        } else {
            TalkMessageBean lastMessage = ((ChatListAdapterPresenter)this.getPresenter()).getTalkMessage(this.curPosition);
            if (lastMessage != null && dataSource.getShowTime() - lastMessage.getShowTime() > 300000L) {
                this.mTimeLineTv.setVisibility(0);
                this.mTimeLineTv.setText((CharSequence)TimeUtil.convertChatTime(dataSource.getShowTime()));
            } else {
                this.mTimeLineTv.setVisibility(8);
            }
        }
        if (dataSource.isRemind()) {
            this.newMessageRemind.setVisibility(0);
        } else {
            this.newMessageRemind.setVisibility(8);
        }
        if (dataSource.getMessageState() < 4) {
            ((ChatListAdapterPresenter)this.getPresenter()).sendReadReceipt(dataSource);
        }
    }

    private void setTimeLineVisible(long time) {
        this.mTimeLineTv.setVisibility(0);
        this.mTimeLineTv.setText((CharSequence)TimeUtil.convertChatTime(time));
    }
}

