/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.NormalFileInfo;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImActivitySuperView;
import com.xdja.im.uikit.ui.presenter.FileDownloadPresenter;
import com.xdja.im.uikit.ui.view.vu.FileDownloadVu;
import com.xdja.im.uikit.utils.file.FileUtils;

public class ViewFileDownload
extends ImActivitySuperView<FileDownloadPresenter>
implements FileDownloadVu {
    private ImageView fileLogoIv;
    private TextView fileNameTv;
    private ProgressBar progressBar;
    private TextView downloadSizeTv;
    private Button ctrlBtn;
    private TextView tipsTv;
    private NormalFileInfo fileInfo;
    private String fileSizeText;
    private TalkMessageBean talkMessageBean = null;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_activity_file_download;
    }

    @Override
    protected int getToolbarType() {
        return 0;
    }

    @Override
    protected int getToolbarTitle() {
        return R.string.im_uikit_download_file;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = this.getView();
        this.fileLogoIv = (ImageView)view.findViewById(R.id.file_logo);
        this.fileNameTv = (TextView)view.findViewById(R.id.file_name);
        this.progressBar = (ProgressBar)view.findViewById(R.id.download_rate);
        this.downloadSizeTv = (TextView)view.findViewById(R.id.download_size);
        this.ctrlBtn = (Button)view.findViewById(R.id.ctrl_btn);
        this.tipsTv = (TextView)view.findViewById(R.id.tips);
    }

    private void updateProgressBar() {
        this.progressBar.setProgress((int)(this.fileInfo.getTranslateSize() * 100L / this.fileInfo.getFileSize()));
    }

    @SuppressLint(value={"SetTextI18n"})
    private void setDownloadRateText() {
        String downloadSizeText = FileSizeUtils.formatFileSize(this.fileInfo.getTranslateSize());
        String text = downloadSizeText + "/" + this.fileSizeText;
        this.downloadSizeTv.setText((CharSequence)(this.getStringRes(R.string.im_uikit_loading) + "(" + text + ")"));
    }

    @Override
    public void updateDownloadRate() {
        this.updateProgressBar();
        this.setDownloadRateText();
    }

    @Override
    public void downloadFileFinish() {
        this.progressBar.setVisibility(4);
        this.downloadSizeTv.setVisibility(4);
        this.ctrlBtn.setText(R.string.im_uikit_open_with_other_app);
        this.tipsTv.setVisibility(0);
    }

    @Override
    @SuppressLint(value={"SetTextI18n"})
    public void setData() {
        this.fileInfo = ((FileDownloadPresenter)this.getPresenter()).getCurFileInfo();
        this.fileSizeText = FileSizeUtils.formatFileSize(this.fileInfo.getFileSize());
        this.fileLogoIv.setImageResource(this.getFileIcon(this.fileInfo));
        this.fileNameTv.setText((CharSequence)this.fileInfo.getFileName());
        this.tipsTv.setText((CharSequence)this.getResources().getString(R.string.im_uikit_cannot_open));
        if (this.fileInfo.getFileState() == 2) {
            this.progressBar.setVisibility(4);
            this.downloadSizeTv.setVisibility(4);
            this.tipsTv.setVisibility(0);
            this.ctrlBtn.setText(R.string.im_uikit_open_with_other_app);
        } else {
            this.progressBar.setVisibility(0);
            this.progressBar.setProgress((int)((float)this.fileInfo.getTranslateSize() * 100.0f / (float)this.fileInfo.getFileSize()));
            this.downloadSizeTv.setVisibility(0);
            this.tipsTv.setVisibility(8);
            if (this.fileInfo.getFileState() == 4) {
                this.ctrlBtn.setText(R.string.im_uikit_resume_download);
            } else {
                this.ctrlBtn.setText(R.string.im_uikit_pause_download);
            }
        }
        this.downloadSizeTv.setText((CharSequence)(this.getStringRes(R.string.im_uikit_loading) + "(" + FileSizeUtils.formatFileSize(this.fileInfo.getTranslateSize()) + "/" + this.fileSizeText + ")"));
        this.ctrlBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ViewFileDownload.this.talkMessageBean != null && ViewFileDownload.this.talkMessageBean.getMessageState() == 7) {
                    new XToast((Context)ViewFileDownload.this.getActivity()).display(ViewFileDownload.this.getActivity().getString(R.string.im_uikit_file_recall_not_click));
                    return;
                }
                if (ViewFileDownload.this.fileInfo.getFileState() == 2) {
                    ViewFileDownload.this.progressBar.setVisibility(4);
                    ViewFileDownload.this.downloadSizeTv.setVisibility(4);
                    ((FileDownloadPresenter)ViewFileDownload.this.getPresenter()).openFile();
                } else {
                    ViewFileDownload.this.progressBar.setVisibility(0);
                    ViewFileDownload.this.downloadSizeTv.setVisibility(0);
                    if (ViewFileDownload.this.fileInfo.getFileState() == 3) {
                        ((FileDownloadPresenter)ViewFileDownload.this.getPresenter()).pauseDownloadFile();
                        ViewFileDownload.this.ctrlBtn.setText(R.string.im_uikit_resume_download);
                    } else if (ViewFileDownload.this.fileInfo.getFileState() == 4) {
                        ((FileDownloadPresenter)ViewFileDownload.this.getPresenter()).downLoadFile(false);
                    }
                }
            }
        });
    }

    @Override
    public void changeViewSate(int state) {
        if (state != 0 && this.fileInfo != null && this.fileInfo.getFileState() == 3) {
            ((FileDownloadPresenter)this.getPresenter()).pauseDownloadFile();
            this.fileInfo.setFileState(4);
            this.ctrlBtn.setText(R.string.im_uikit_resume_download);
        }
    }

    @Override
    public void setCtrlBtnText(int res) {
        if (this.ctrlBtn != null) {
            this.ctrlBtn.setText(res);
        }
    }

    private int getFileIcon(NormalFileInfo fileInfo) {
        return FileUtils.getIconWithSuffix(fileInfo.getFilePath());
    }

    @Override
    public void setReCallBtnText(TalkMessageBean reCallMsg) {
        this.talkMessageBean = reCallMsg;
        if (this.ctrlBtn != null) {
            this.ctrlBtn.setText(R.string.im_uikit_resume_download);
        }
    }
}

