/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.core.model.screen.ScreenInfo;
import com.xdja.im.core.utils.FilePathUtils;
import com.xdja.im.lib.video.palyer.VideoPlayState;
import com.xdja.im.lib.video.widget.VideoPlayView;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;
import com.xdja.im.uikit.ui.dialog.BaseListDialog;
import com.xdja.im.uikit.ui.presenter.FilePreviewAdapterPresenter;
import com.xdja.im.uikit.ui.view.BaseFilePreview;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.ScreenUtil;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class ViewPreviewVideo
extends BaseFilePreview
implements VideoPlayView.IVideoPlayCallback {
    private RelativeLayout mLayout;
    private ImageView mPhotoView;
    private Button mPlayBtn;
    private ProgressBar mLoadingPbar;
    private VideoPlayView mVideoPlayView;
    private ScreenInfo mScreenInfo;
    private TextView mCloseTv;
    private BaseListDialog mDialog;
    private Handler handler = new myHandler(this);

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_preview_video;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    protected void injectView() {
        super.injectView();
        this.mLayout = (RelativeLayout)this.findViewById(R.id.layout_video_container);
        this.mPhotoView = (ImageView)this.findViewById(R.id.view_photo);
        this.mPlayBtn = (Button)this.findViewById(R.id.btn_play);
        this.mLoadingPbar = (ProgressBar)this.findViewById(R.id.pbar_video_loading);
        this.mVideoPlayView = (VideoPlayView)this.findViewById(R.id.view_video_player);
        this.mCloseTv = (TextView)this.findViewById(R.id.btn_close_player);
        this.mVideoPlayView.setVideoPlayCallback(this);
        this.mVideoPlayView.setVisibility(0);
        this.mDialog = new BaseListDialog(this.getContext()){

            @Override
            public List<ImOption> getOptions() {
                return ViewPreviewVideo.this.buildImOption();
            }
        };
        this.mLayout.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                VideoFileInfo videoFileInfo = (VideoFileInfo)ViewPreviewVideo.this.dataSource.getFileInfo();
                if (videoFileInfo == null) {
                    return false;
                }
                FileInfo rawFileInfo = videoFileInfo.getRawFileInfo();
                if (rawFileInfo == null || !FileUtils.isFileExists(rawFileInfo.getFilePath())) {
                    return false;
                }
                ViewPreviewVideo.this.mDialog.show();
                return false;
            }
        });
        this.mCloseTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ViewPreviewVideo.this.getActivity().finish();
            }
        });
        this.mPlayBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoFileInfo videoFileInfo = (VideoFileInfo)ViewPreviewVideo.this.dataSource.getFileInfo();
                FileInfo rawFile = videoFileInfo.getRawFileInfo();
                if (FileUtils.isFileExists(rawFile.getFilePath())) {
                    ViewPreviewVideo.this.startPlay(rawFile.getFilePath());
                } else {
                    if (ViewPreviewVideo.this.dataSource.isMine() || videoFileInfo.getFileState() == 0) {
                        ViewPreviewVideo.this.loadError();
                        CommonTool.showToast(R.string.im_uikit_video_not_exist);
                        return;
                    }
                    videoFileInfo.setType(3);
                    videoFileInfo.setFileState(3);
                    ViewPreviewVideo.this.dataSource.setFileInfo(videoFileInfo);
                    ViewPreviewVideo.this.loadVideo(videoFileInfo);
                }
            }
        });
        this.mDialog.setOnItemClickListener(new BaseListDialog.onItemClickListener(){

            @Override
            public void onItemClick(View view, ImOption option, int itemPosition) {
                switch (option.getOptionType()) {
                    case 0: {
                        ViewPreviewVideo.this.saveVideo();
                        break;
                    }
                    case 1: {
                        ViewPreviewVideo.this.deleteVideo();
                    }
                }
            }
        });
        this.getView().getViewTreeObserver().addOnWindowFocusChangeListener(new ViewTreeObserver.OnWindowFocusChangeListener(){

            public void onWindowFocusChanged(boolean hasFocus) {
                if (!hasFocus) {
                    if (ViewPreviewVideo.this.mVideoPlayView != null && ViewPreviewVideo.this.mVideoPlayView.isPlaying()) {
                        ViewPreviewVideo.this.mVideoPlayView.pause();
                    }
                } else if (ViewPreviewVideo.this.mVideoPlayView != null && ViewPreviewVideo.this.mVideoPlayView.getVideoPlayState() == VideoPlayState.PAUSE) {
                    ViewPreviewVideo.this.mVideoPlayView.resume();
                }
            }
        });
        this.mScreenInfo = ScreenUtil.getScreenInfo(this.getActivity());
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        FileInfo rawFileInfo;
        super.bindDataSource(position, dataSource);
        VideoFileInfo videoFileInfo = (VideoFileInfo)dataSource.getFileInfo();
        if (videoFileInfo == null) {
            this.loadError();
            return;
        }
        if (!this.loadImage(videoFileInfo.getFilePath())) {
            LogUtil.w("ERROR: Start preview video, but thumb is failed.");
            return;
        }
        if (!dataSource.isMine() && dataSource.getFileInfo().getFileState() == 3) {
            this.mLoadingPbar.setVisibility(0);
            return;
        }
        this.mVideoPlayView.setDuration(videoFileInfo.getAmountOfTime());
        if (this.handler != null) {
            this.handler.sendEmptyMessageDelayed(0, 500L);
        }
        if ((rawFileInfo = videoFileInfo.getRawFileInfo()) == null) {
            LogUtil.e("ERROR: Video raw file info is null.");
            return;
        }
    }

    @Override
    public void onViewDestroy() {
        super.onViewDestroy();
        this.stopPlay();
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
        }
    }

    @Override
    public void onViewPause() {
        super.onViewPause();
        this.stopPlay();
    }

    private List<ImOption> buildImOption() {
        ArrayList<ImOption> data = new ArrayList<ImOption>();
        data.add(new ImOption(0, this.getStringRes(R.string.im_uikit_video_option_save)));
        data.add(new ImOption(1, this.getStringRes(R.string.im_uikit_video_option_delete)));
        return data;
    }

    private void loadError() {
        this.mPhotoView.setImageResource(R.mipmap.im_uikit_ic_video_failed);
        this.mPhotoView.setScaleType(ImageView.ScaleType.CENTER);
        ViewGroup.LayoutParams params = this.mPhotoView.getLayoutParams();
        params.width = -2;
        params.width = -2;
        this.mPlayBtn.setVisibility(8);
        this.mVideoPlayView.setVisibility(8);
        this.mLoadingPbar.setVisibility(8);
    }

    private boolean loadImage(String filePath) {
        if (FileUtils.isFileExists(filePath)) {
            ((FilePreviewAdapterPresenter)this.getPresenter()).loadImage(this.mPhotoView, filePath, ImageView.ScaleType.FIT_XY, this.mScreenInfo.getWidth(), this.mScreenInfo.getHeight());
            return true;
        }
        this.loadError();
        return false;
    }

    private void loadVideo(VideoFileInfo rawFileInfo) {
        this.mPlayBtn.setVisibility(8);
        this.mLoadingPbar.setVisibility(0);
        ((FilePreviewAdapterPresenter)this.getPresenter()).download(rawFileInfo);
    }

    private void startPlay(String filePath) {
        this.mLoadingPbar.setVisibility(8);
        this.mPhotoView.setVisibility(8);
        this.mPlayBtn.setVisibility(8);
        this.mVideoPlayView.play(filePath);
    }

    private void stopPlay() {
        this.mPhotoView.setVisibility(0);
        this.mPlayBtn.setVisibility(0);
    }

    private void saveVideo() {
        VideoFileInfo videoFileInfo = (VideoFileInfo)this.dataSource.getFileInfo();
        if (videoFileInfo == null) {
            return;
        }
        FileInfo rawFileInfo = videoFileInfo.getRawFileInfo();
        if (rawFileInfo == null) {
            return;
        }
        File srcFile = new File(rawFileInfo.getFilePath());
        String fileName = "videoexport" + System.currentTimeMillis() + ".mp4";
        ((FilePreviewAdapterPresenter)this.getPresenter()).saveFile(srcFile, FilePathUtils.getVideoRecPath(), fileName);
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
    }

    private void deleteVideo() {
        ((FilePreviewAdapterPresenter)this.getPresenter()).deleteMsg(this.dataSource);
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
    }

    @Override
    public void prepareListener() {
    }

    @Override
    public void progressListener(int pro) {
    }

    @Override
    public void completeListener() {
        this.mPhotoView.setVisibility(0);
        this.mPlayBtn.setVisibility(0);
    }

    @Override
    public void pauseListener(int currentPos) {
    }

    @Override
    public void resumeListener(int currentPos) {
    }

    @Override
    public void surfacePrepareCallback() {
    }

    @Override
    public void surfaceDestroyListener(Bitmap currentPosBitmap) {
    }

    @Override
    public void onPageSelected(int lastPos, int curPos) {
        this.mPhotoView.setVisibility(0);
        if (this.dataSource.getFileInfo().getFileState() != 3) {
            this.mPlayBtn.setVisibility(0);
        }
        this.mVideoPlayView.stop();
    }

    @Override
    public void onFileDownloadFinish() {
        if (this.dataSource == null || this.dataSource.getFileInfo() == null) {
            LogUtil.e("Illegal video file info.");
            return;
        }
        VideoFileInfo videoFileInfo = (VideoFileInfo)this.dataSource.getFileInfo();
        FileInfo rawFileInfo = videoFileInfo.getRawFileInfo();
        if (rawFileInfo != null && FileUtils.isFileExists(rawFileInfo.getFilePath())) {
            videoFileInfo.setFileState(2);
            this.dataSource.setFileInfo(videoFileInfo);
            this.startPlay(rawFileInfo.getFilePath());
        }
    }

    private static class myHandler
    extends Handler {
        private WeakReference<ViewPreviewVideo> context;

        private myHandler(ViewPreviewVideo viewPreviewVideo) {
            this.context = new WeakReference<ViewPreviewVideo>(viewPreviewVideo);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (this.context.get() != null) {
                ((ViewPreviewVideo)this.context.get()).mPlayBtn.setVisibility(0);
                ((ViewPreviewVideo)this.context.get()).mCloseTv.setVisibility(0);
            }
        }
    }
}

