/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.CustomItemDataProvider;
import com.xdja.im.uikit.ui.view.ViewSessionItem;
import com.xdja.im.uikit.utils.log.LogUtil;

public class ViewSystemSessionItem
extends ViewSessionItem {
    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_session_system;
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkSessionBean dataSource) {
        super.bindDataSource(position, dataSource);
        this.mUserNameTv.setText((CharSequence)"\u6d88\u606f\u52a9\u624b");
    }

    @Override
    protected CharSequence getContent(String displayName) {
        SessionParam param = ((TalkSessionBean)this.dataSource).getParam();
        if (param != null && !TextUtils.isEmpty((CharSequence)param.getDraftContent()) && param.getDraftTime() > 0L) {
            CharSequence content = this.formatDraft(param.getDraftContent());
            LogUtil.d("ViewSingleItem draft:" + content);
            return EmotionUtils.formatSmallSpanContent(content, (Context)this.getActivity());
        }
        TalkMessageBean talkMessageBean = ((TalkSessionBean)this.dataSource).getLastMsg();
        if (talkMessageBean == null) {
            LogUtil.w("Last message info is null.");
            return "";
        }
        int messageType = talkMessageBean.getMessageType();
        if (!talkMessageBean.isMine() && talkMessageBean.isBomb() && talkMessageBean.getMessageState() == 5) {
            return this.getStringRes(R.string.im_uikit_bomb);
        }
        switch (messageType) {
            case 0: {
                return EmotionUtils.formatSmallSpanContent(((TalkSessionBean)this.dataSource).getContent(), (Context)this.getActivity());
            }
            case 1: {
                return this.getStringRes(R.string.im_uikit_voice);
            }
            case 2: {
                return this.getStringRes(R.string.im_uikit_video);
            }
            case 3: {
                return this.getStringRes(R.string.im_uikit_image);
            }
            case 4: {
                return this.getStringRes(R.string.im_uikit_file);
            }
            case 5: {
                return this.getStringRes(R.string.im_uikit_web_message);
            }
            case 102: {
                return this.getCustomStr(talkMessageBean);
            }
            case 201: {
                return this.getSystemStr(((TalkSessionBean)this.dataSource).getContent());
            }
        }
        return ((TalkSessionBean)this.dataSource).getContent() == null ? "" : ((TalkSessionBean)this.dataSource).getContent();
    }

    private String getSystemStr(CharSequence json) {
        CustomItemDataProvider customItemDataProvider = (CustomItemDataProvider)new Gson().fromJson(json.toString(), CustomItemDataProvider.class);
        String str = "";
        if (customItemDataProvider != null) {
            str = "[" + customItemDataProvider.getType_name() + "] " + customItemDataProvider.getTitle();
        }
        return str;
    }
}

