/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.lib.historyfile.command.ChatDetailAdapterCommand;
import com.xdja.im.uikit.R;

public class HyperLinkClickPop
extends PopupWindow {
    private final Context context;
    private final ChatDetailAdapterCommand command;
    private final LayoutInflater inflater;
    private ListView menuList;
    private final int[] type = new int[]{1, 2};
    private ActionOnItemClickCallBack onItemClick;
    private final String number;

    public HyperLinkClickPop(Context context, ChatDetailAdapterCommand command, int actionType, String number) {
        this.context = context;
        this.command = command;
        this.number = number;
        this.inflater = LayoutInflater.from((Context)this.context);
        this.initiView();
        this.initData(actionType);
        this.setAttrs();
    }

    private void initiView() {
        LinearLayout popupLayout = (LinearLayout)this.inflater.inflate(R.layout.im_uikit_activity_message_popu, null);
        popupLayout.setOnTouchListener(new View.OnTouchListener(){

            @SuppressLint(value={"ClickableViewAccessibility"})
            public boolean onTouch(View v, MotionEvent event) {
                if (HyperLinkClickPop.this.isShowing()) {
                    HyperLinkClickPop.this.dismiss();
                }
                return false;
            }
        });
        this.menuList = (ListView)popupLayout.findViewById(R.id.actionlist);
        this.setContentView((View)popupLayout);
        this.setWidth(-1);
        this.setHeight(-1);
        this.setFocusable(true);
        ColorDrawable dw = new ColorDrawable(-1342177280);
        this.setBackgroundDrawable((Drawable)dw);
    }

    private void initData(int actionType) {
        if (this.context == null) {
            return;
        }
        String[] actions = this.context.getResources().getStringArray(R.array.im_uikit_hyperlink_action);
        Object[] actionTemp = null;
        if (actionType == this.type[0]) {
            actionTemp = new String[]{actions[0], actions[1]};
        } else if (actionType == this.type[1]) {
            actionTemp = new String[]{actions[2], actions[3]};
        }
        if (actionTemp == null || actionTemp.length == 0) {
            return;
        }
        ArrayAdapter adapter = new ArrayAdapter(this.context, R.layout.im_uikit_item_action_more, actionTemp);
        this.menuList.setAdapter((ListAdapter)adapter);
        if (this.onItemClick == null) {
            this.onItemClick = new ActionOnItemClickCallBack(actions, (String[])actionTemp, this.command, this, this.number);
        }
        this.menuList.setOnItemClickListener((AdapterView.OnItemClickListener)this.onItemClick);
    }

    @SuppressLint(value={"WrongConstant"})
    private void setAttrs() {
        this.setFocusable(true);
        this.setOutsideTouchable(true);
        this.setSoftInputMode(1);
        this.setSoftInputMode(16);
    }

    private void callOut(String number) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.DIAL");
        Uri uri = Uri.parse((String)("tel:" + number));
        intent.setData(uri);
        this.context.startActivity(intent);
    }

    private void addToAccount(String number, View view) {
        new HyperLinkClickPop(this.context, null, 2, number).showAtLocation(view, 17, 0, 0);
    }

    private void insertNewContact(String number) {
        Intent addIntent = new Intent("android.intent.action.INSERT", Uri.withAppendedPath((Uri)Uri.parse((String)"content://com.android.contacts"), (String)"contacts"));
        addIntent.setType("vnd.android.cursor.dir/person");
        addIntent.setType("vnd.android.cursor.dir/contact");
        addIntent.setType("vnd.android.cursor.dir/raw_contact");
        addIntent.putExtra("phone", number);
        this.context.startActivity(addIntent);
    }

    private void addToExistAccount(String number) {
        Intent oldConstantIntent = new Intent("android.intent.action.INSERT_OR_EDIT");
        oldConstantIntent.setType("vnd.android.cursor.item/contact");
        oldConstantIntent.putExtra("phone", number);
        int contactType = 1;
        oldConstantIntent.putExtra("phone_type", contactType);
        if (oldConstantIntent.resolveActivity(this.context.getPackageManager()) != null) {
            this.context.startActivity(oldConstantIntent);
        } else {
            new XToast(this.context).display("\u6dfb\u52a0\u8054\u7cfb\u4eba\u51fa\u9519");
        }
    }

    class ActionOnItemClickCallBack
    implements AdapterView.OnItemClickListener {
        private final ChatDetailAdapterCommand handler;
        private final String[] actions;
        private final String[] actionTemp;
        private final HyperLinkClickPop hyperLinkClickPop;
        private final String number;

        public ActionOnItemClickCallBack(String[] actions, String[] actionTemp, ChatDetailAdapterCommand handler, HyperLinkClickPop hyperLinkClickPop, String number) {
            this.actions = actions;
            this.actionTemp = actionTemp;
            this.handler = handler;
            this.number = number;
            this.hyperLinkClickPop = hyperLinkClickPop;
        }

        public void onItemClick(AdapterView<?> arg0, View view, int position2, long arg3) {
            HyperLinkClickPop.this.dismiss();
            if (this.actionTemp[position2].equals(this.actions[0])) {
                HyperLinkClickPop.this.callOut(this.number);
            } else if (this.actionTemp[position2].equals(this.actions[1])) {
                HyperLinkClickPop.this.addToAccount(this.number, view);
            } else if (this.actionTemp[position2].equals(this.actions[2])) {
                HyperLinkClickPop.this.insertNewContact(this.number);
            } else if (this.actionTemp[position2].equals(this.actions[3])) {
                HyperLinkClickPop.this.addToExistAccount(this.number);
            }
        }
    }
}

