/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.utils;

import android.graphics.Bitmap;
import android.support.v4.util.LruCache;
import com.xdja.im.uikit.utils.image.BitmapUtils;

public class ImageCache {
    private LruCache<String, Bitmap> cache = new LruCache<String, Bitmap>((int)(Runtime.getRuntime().maxMemory() / 8L)){

        protected int sizeOf(String key, Bitmap value) {
            return value.getRowBytes() * value.getHeight();
        }

        protected void entryRemoved(boolean evicted, String key, Bitmap oldValue, Bitmap newValue) {
            super.entryRemoved(evicted, (Object)key, (Object)oldValue, (Object)newValue);
            if (evicted && oldValue != null) {
                BitmapUtils.recycleBmp(oldValue);
            }
        }
    };
    private LruCache<String, Bitmap> smallCache = new LruCache<String, Bitmap>((int)(Runtime.getRuntime().maxMemory() / 8L)){

        protected int sizeOf(String key, Bitmap value) {
            return value.getRowBytes() * value.getHeight();
        }
    };

    private ImageCache() {
    }

    public static ImageCache getInstance() {
        return SingletonInstance.INSTANCE;
    }

    public Bitmap put(String key, Bitmap value) {
        return (Bitmap)this.cache.put((Object)key, (Object)value);
    }

    public Bitmap get(String key) {
        return (Bitmap)this.cache.get((Object)key);
    }

    public Bitmap smallCashPut(String key, Bitmap value) {
        return (Bitmap)this.smallCache.put((Object)key, (Object)value);
    }

    public Bitmap smallCashGet(String key) {
        return (Bitmap)this.smallCache.get((Object)key);
    }

    public void clearAllCache() {
        if (this.cache != null) {
            this.cache.evictAll();
        }
    }

    public void clearAllsmallCache() {
        if (this.smallCache != null) {
            this.smallCache.evictAll();
        }
    }

    private static class SingletonInstance {
        private static final ImageCache INSTANCE = new ImageCache();

        private SingletonInstance() {
        }
    }
}

