/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.utils.gif;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.xdja.im.uikit.utils.gif.GifFrame;
import com.xdja.im.uikit.utils.gif.GifHeader;
import com.xdja.im.uikit.utils.gif.GifHeaderParser;
import com.xdja.im.uikit.utils.gif.SimpleBitmapProvider;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class GifDecoder {
    private static final String TAG = GifDecoder.class.getSimpleName();
    static final int STATUS_OK = 0;
    static final int STATUS_FORMAT_ERROR = 1;
    static final int STATUS_OPEN_ERROR = 2;
    static final int STATUS_PARTIAL_DECODE = 3;
    private static final int MAX_STACK_SIZE = 4096;
    private static final int DISPOSAL_UNSPECIFIED = 0;
    private static final int DISPOSAL_NONE = 1;
    private static final int DISPOSAL_BACKGROUND = 2;
    private static final int DISPOSAL_PREVIOUS = 3;
    private static final int NULL_CODE = -1;
    private static final int INITIAL_FRAME_POINTER = -1;
    static final int LOOP_FOREVER = -1;
    private static final int BYTES_PER_INTEGER = 4;
    private int[] act;
    private final int[] pct = new int[256];
    private ByteBuffer rawData;
    private byte[] block;
    private GifFrame currentFrame;
    private GifFrame previousFrame;
    private int previousIndex;
    private static final int WORK_BUFFER_SIZE = 16384;
    @Nullable
    private byte[] workBuffer;
    private int workBufferSize = 0;
    private int workBufferPosition = 0;
    private GifHeaderParser parser;
    private short[] prefix;
    private byte[] suffix;
    private byte[] pixelStack;
    private byte[] mainPixels;
    private int[] mainScratch;
    private int framePointer;
    private int loopIndex;
    public GifHeader header;
    private BitmapProvider bitmapProvider;
    private Bitmap previousImage;
    private boolean savePrevious;
    private int status;
    private int sampleSize;
    private int downsampledHeight;
    private int downsampledWidth;
    private Bitmap downsampledBitmap;
    private boolean isFirstFrameTransparent;
    private int available;
    private int clear;
    private int codeMask;
    private int codeSize;
    private int endOfInformation;
    private int inCode;
    private int oldCode;
    private int bits;
    private int code;
    private int count;
    private int i;
    private int datum;
    private int dataSize;
    private int first;
    private int top;
    private int bi;
    private int pi;

    GifDecoder(BitmapProvider provider, GifHeader gifHeader, ByteBuffer rawData) {
        this(provider, gifHeader, rawData, 1);
    }

    GifDecoder(BitmapProvider provider, GifHeader gifHeader, ByteBuffer rawData, int sampleSize) {
        this(provider);
        this.setData(gifHeader, rawData, sampleSize);
    }

    GifDecoder(BitmapProvider provider) {
        this.bitmapProvider = provider;
        this.header = new GifHeader();
    }

    public GifDecoder() {
        this(new SimpleBitmapProvider());
    }

    public int getWidth() {
        return this.header.width;
    }

    public int getHeight() {
        return this.header.height;
    }

    ByteBuffer getData() {
        return this.rawData;
    }

    int getStatus() {
        return this.status;
    }

    public boolean advance() {
        if (this.header.frameCount <= 0) {
            LogUtil.e("jsm", "advance::header.frameCount  ==    " + this.header.frameCount);
            return false;
        }
        if (this.framePointer == this.getFrameCount() - 1) {
            ++this.loopIndex;
        }
        this.framePointer = (this.framePointer + 1) % this.header.frameCount;
        return true;
    }

    int getDelay(int n) {
        int delay = -1;
        if (n >= 0 && n < this.header.frameCount) {
            delay = this.header.frames.get((int)n).delay;
        }
        return delay;
    }

    public int getNextDelay() {
        if (this.header == null) {
            return 0;
        }
        if (this.header.frameCount <= 0 || this.framePointer < 0) {
            return 0;
        }
        return this.getDelay(this.framePointer);
    }

    int getFrameCount() {
        return this.header.frameCount;
    }

    public int getCurrentFrameIndex() {
        return this.framePointer;
    }

    public boolean setFrameIndex(int frame) {
        if (frame < -1 || frame >= this.getFrameCount()) {
            return false;
        }
        this.framePointer = frame;
        return true;
    }

    void resetFrameIndex() {
        this.framePointer = -1;
    }

    public void resetLoopIndex() {
        this.loopIndex = 0;
    }

    int getLoopCount() {
        return this.header.loopCount;
    }

    int getLoopIndex() {
        return this.loopIndex;
    }

    int getByteSize() {
        return this.rawData.limit() + this.mainPixels.length + this.mainScratch.length * 4;
    }

    public synchronized Bitmap getNextFrame() {
        if (this.header.frameCount <= 0 || this.framePointer < 0) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("unable to decode frame, frameCount=" + this.header.frameCount + " framePointer=" + this.framePointer));
            }
            this.status = 1;
        }
        if (this.status == 1 || this.status == 2) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Unable to decode frame, status=" + this.status));
            }
            return null;
        }
        this.status = 0;
        this.currentFrame = this.header.frames.get(this.framePointer);
        this.previousFrame = null;
        this.previousIndex = this.framePointer - 1;
        if (this.previousIndex >= 0) {
            this.previousFrame = this.header.frames.get(this.previousIndex);
        }
        int[] nArray = this.act = this.currentFrame.lct != null ? this.currentFrame.lct : this.header.gct;
        if (this.act == null) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("No Valid Color Table for frame #" + this.framePointer));
            }
            this.status = 1;
            return null;
        }
        if (this.currentFrame.transparency) {
            System.arraycopy(this.act, 0, this.pct, 0, this.act.length);
            this.act = this.pct;
            this.act[this.currentFrame.transIndex] = 0;
        }
        return this.setPixels(this.currentFrame, this.previousFrame);
    }

    int read(InputStream is, int contentLength) {
        if (is != null) {
            try {
                int nRead;
                int capacity = contentLength > 0 ? contentLength + 4096 : 16384;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream(capacity);
                byte[] data = new byte[16384];
                while ((nRead = is.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                this.read(buffer.toByteArray());
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"Error reading data from stream", (Throwable)e);
            }
        } else {
            this.status = 2;
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Error closing stream", (Throwable)e);
        }
        return this.status;
    }

    public void clear() {
        this.header = null;
        if (this.mainPixels != null) {
            this.bitmapProvider.release(this.mainPixels);
        }
        if (this.mainScratch != null) {
            this.bitmapProvider.release(this.mainScratch);
        }
        if (this.previousImage != null) {
            this.bitmapProvider.release(this.previousImage);
        }
        this.previousImage = null;
        this.rawData = null;
        this.isFirstFrameTransparent = false;
        if (this.block != null) {
            this.bitmapProvider.release(this.block);
        }
        if (this.workBuffer != null) {
            this.bitmapProvider.release(this.workBuffer);
        }
    }

    synchronized void setData(GifHeader header, byte[] data) {
        this.setData(header, ByteBuffer.wrap(data));
    }

    synchronized void setData(GifHeader header, ByteBuffer buffer) {
        this.setData(header, buffer, 1);
    }

    synchronized void setData(GifHeader header, ByteBuffer buffer, int sampleSize) {
        if (sampleSize <= 0) {
            throw new IllegalArgumentException("Sample size must be >=0, not: " + sampleSize);
        }
        sampleSize = Integer.highestOneBit(sampleSize);
        this.status = 0;
        this.header = header;
        this.isFirstFrameTransparent = false;
        this.framePointer = -1;
        this.resetLoopIndex();
        this.rawData = buffer.asReadOnlyBuffer();
        this.rawData.position(0);
        this.rawData.order(ByteOrder.LITTLE_ENDIAN);
        this.savePrevious = false;
        for (GifFrame frame : header.frames) {
            if (frame.dispose != 3) continue;
            this.savePrevious = true;
            break;
        }
        this.sampleSize = sampleSize;
        this.downsampledWidth = header.width / sampleSize;
        this.downsampledHeight = header.height / sampleSize;
        this.mainPixels = this.bitmapProvider.obtainByteArray(header.width * header.height);
        this.mainScratch = this.bitmapProvider.obtainIntArray(this.downsampledWidth * this.downsampledHeight);
        this.downsampledBitmap = this.getNextBitmap();
    }

    private GifHeaderParser getHeaderParser() {
        if (this.parser == null) {
            this.parser = new GifHeaderParser();
        }
        return this.parser;
    }

    public synchronized int read(byte[] data) {
        this.header = this.getHeaderParser().setData(data).parseHeader();
        if (data != null) {
            this.setData(this.header, data);
        }
        return this.status;
    }

    private Bitmap setPixels(GifFrame currentFrame, GifFrame previousFrame) {
        int downsampledIX;
        int downsampledIW;
        int downsampledIY;
        int downsampledIH;
        if (previousFrame == null) {
            Arrays.fill(this.mainScratch, 0);
        }
        if (previousFrame != null && previousFrame.dispose > 0) {
            if (previousFrame.dispose == 2) {
                int c = 0;
                if (!currentFrame.transparency) {
                    c = this.header.bgColor;
                    if (currentFrame.lct != null && this.header.bgIndex == currentFrame.transIndex) {
                        c = 0;
                    }
                } else if (this.framePointer == 0) {
                    this.isFirstFrameTransparent = true;
                }
                this.fillRect(this.mainScratch, previousFrame, c);
            } else if (previousFrame.dispose == 3) {
                if (this.previousImage == null) {
                    this.fillRect(this.mainScratch, previousFrame, 0);
                } else {
                    downsampledIH = previousFrame.ih / this.sampleSize;
                    downsampledIY = previousFrame.iy / this.sampleSize;
                    downsampledIW = previousFrame.iw / this.sampleSize;
                    downsampledIX = previousFrame.ix / this.sampleSize;
                    int topLeft = downsampledIY * this.downsampledWidth + downsampledIX;
                    this.previousImage.getPixels(this.mainScratch, topLeft, this.downsampledWidth, downsampledIX, downsampledIY, downsampledIW, downsampledIH);
                }
            }
        }
        this.decodeBitmapData(currentFrame);
        downsampledIH = currentFrame.ih / this.sampleSize;
        downsampledIY = currentFrame.iy / this.sampleSize;
        downsampledIW = currentFrame.iw / this.sampleSize;
        downsampledIX = currentFrame.ix / this.sampleSize;
        int pass = 1;
        int inc = 8;
        int iline = 0;
        boolean isFirstFrame = this.framePointer == 0;
        for (int i = 0; i < downsampledIH; ++i) {
            int line = i;
            if (currentFrame.interlace) {
                if (iline >= downsampledIH) {
                    switch (++pass) {
                        case 2: {
                            iline = 4;
                            break;
                        }
                        case 3: {
                            iline = 2;
                            inc = 4;
                            break;
                        }
                        case 4: {
                            iline = 1;
                            inc = 2;
                            break;
                        }
                    }
                }
                line = iline;
                iline += inc;
            }
            if ((line += downsampledIY) >= this.downsampledHeight) continue;
            int k = line * this.downsampledWidth;
            int dx = k + downsampledIX;
            int dlim = dx + downsampledIW;
            if (k + this.downsampledWidth < dlim) {
                dlim = k + this.downsampledWidth;
            }
            int sx = i * this.sampleSize * currentFrame.iw;
            int maxPositionInSource = sx + (dlim - dx) * this.sampleSize;
            while (dx < dlim) {
                int averageColor;
                if (this.sampleSize == 1) {
                    int currentColorIndex = this.mainPixels[sx] & 0xFF;
                    averageColor = this.act[currentColorIndex];
                } else {
                    averageColor = this.averageColorsNear(sx, maxPositionInSource, currentFrame.iw);
                }
                if (averageColor != 0) {
                    this.mainScratch[dx] = averageColor;
                } else if (!this.isFirstFrameTransparent && isFirstFrame) {
                    this.isFirstFrameTransparent = true;
                }
                sx += this.sampleSize;
                ++dx;
            }
        }
        if (this.savePrevious && (currentFrame.dispose == 0 || currentFrame.dispose == 1)) {
            if (this.previousImage == null) {
                this.previousImage = this.downsampledBitmap;
            }
            this.previousImage.setPixels(this.mainScratch, 0, this.downsampledWidth, 0, 0, this.downsampledWidth, this.downsampledHeight);
        }
        Bitmap result = this.downsampledBitmap;
        result.setPixels(this.mainScratch, 0, this.downsampledWidth, 0, 0, this.downsampledWidth, this.downsampledHeight);
        return result;
    }

    private void fillRect(int[] dest, GifFrame frame, int bgColor) {
        int downsampledIH = frame.ih / this.sampleSize;
        int downsampledIY = frame.iy / this.sampleSize;
        int downsampledIW = frame.iw / this.sampleSize;
        int downsampledIX = frame.ix / this.sampleSize;
        int topLeft = downsampledIY * this.downsampledWidth + downsampledIX;
        int bottomLeft = topLeft + downsampledIH * this.downsampledWidth;
        for (int left = topLeft; left < bottomLeft; left += this.downsampledWidth) {
            int right = left + downsampledIW;
            for (int pointer = left; pointer < right; ++pointer) {
                dest[pointer] = bgColor;
            }
        }
    }

    private int averageColorsNear(int positionInMainPixels, int maxPositionInMainPixels, int currentFrameIw) {
        int currentColor;
        int currentColorIndex;
        int i;
        int alphaSum = 0;
        int redSum = 0;
        int greenSum = 0;
        int blueSum = 0;
        int totalAdded = 0;
        for (i = positionInMainPixels; i < positionInMainPixels + this.sampleSize && i < this.mainPixels.length && i < maxPositionInMainPixels; ++i) {
            currentColorIndex = this.mainPixels[i] & 0xFF;
            currentColor = this.act[currentColorIndex];
            if (currentColor == 0) continue;
            alphaSum += currentColor >> 24 & 0xFF;
            redSum += currentColor >> 16 & 0xFF;
            greenSum += currentColor >> 8 & 0xFF;
            blueSum += currentColor & 0xFF;
            ++totalAdded;
        }
        for (i = positionInMainPixels + currentFrameIw; i < positionInMainPixels + currentFrameIw + this.sampleSize && i < this.mainPixels.length && i < maxPositionInMainPixels; ++i) {
            currentColorIndex = this.mainPixels[i] & 0xFF;
            currentColor = this.act[currentColorIndex];
            if (currentColor == 0) continue;
            alphaSum += currentColor >> 24 & 0xFF;
            redSum += currentColor >> 16 & 0xFF;
            greenSum += currentColor >> 8 & 0xFF;
            blueSum += currentColor & 0xFF;
            ++totalAdded;
        }
        if (totalAdded == 0) {
            return 0;
        }
        return alphaSum / totalAdded << 24 | redSum / totalAdded << 16 | greenSum / totalAdded << 8 | blueSum / totalAdded;
    }

    private void decodeBitmapData(GifFrame frame) {
        int npix;
        this.workBufferSize = 0;
        this.workBufferPosition = 0;
        if (frame != null) {
            this.rawData.position(frame.bufferFrameStart);
        }
        int n = npix = frame == null ? this.header.width * this.header.height : frame.iw * frame.ih;
        if (this.mainPixels == null || this.mainPixels.length < npix) {
            this.mainPixels = this.bitmapProvider.obtainByteArray(npix);
        }
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        this.dataSize = this.readByte();
        this.clear = 1 << this.dataSize;
        this.endOfInformation = this.clear + 1;
        this.available = this.clear + 2;
        this.oldCode = -1;
        this.codeSize = this.dataSize + 1;
        this.codeMask = (1 << this.codeSize) - 1;
        this.code = 0;
        while (this.code < this.clear) {
            this.prefix[this.code] = 0;
            this.suffix[this.code] = (byte)this.code;
            ++this.code;
        }
        this.bi = 0;
        this.pi = 0;
        this.top = 0;
        this.first = 0;
        this.count = 0;
        this.bits = 0;
        this.datum = 0;
        this.i = 0;
        block1: while (this.i < npix) {
            if (this.count == 0) {
                this.count = this.readBlock();
                if (this.count <= 0) {
                    this.status = 3;
                    break;
                }
                this.bi = 0;
            }
            this.datum += (this.block[this.bi] & 0xFF) << this.bits;
            this.bits += 8;
            ++this.bi;
            --this.count;
            while (this.bits >= this.codeSize) {
                this.code = this.datum & this.codeMask;
                this.datum >>= this.codeSize;
                this.bits -= this.codeSize;
                if (this.code == this.clear) {
                    this.codeSize = this.dataSize + 1;
                    this.codeMask = (1 << this.codeSize) - 1;
                    this.available = this.clear + 2;
                    this.oldCode = -1;
                    continue;
                }
                if (this.code > this.available) {
                    this.status = 3;
                    continue block1;
                }
                if (this.code == this.endOfInformation) continue block1;
                if (this.oldCode == -1) {
                    this.pixelStack[this.top++] = this.suffix[this.code];
                    this.oldCode = this.code;
                    this.first = this.code;
                    continue;
                }
                this.inCode = this.code;
                if (this.code >= this.available) {
                    this.pixelStack[this.top++] = (byte)this.first;
                    this.code = this.oldCode;
                }
                while (this.code >= this.clear) {
                    this.pixelStack[this.top++] = this.suffix[this.code];
                    this.code = this.prefix[this.code];
                }
                this.first = this.suffix[this.code] & 0xFF;
                this.pixelStack[this.top++] = (byte)this.first;
                if (this.available < 4096) {
                    this.prefix[this.available] = (short)this.oldCode;
                    this.suffix[this.available] = (byte)this.first;
                    ++this.available;
                    if ((this.available & this.codeMask) == 0 && this.available < 4096) {
                        ++this.codeSize;
                        this.codeMask += this.available;
                    }
                }
                this.oldCode = this.inCode;
                while (this.top > 0) {
                    this.mainPixels[this.pi++] = this.pixelStack[--this.top];
                    ++this.i;
                }
            }
        }
        this.i = this.pi;
        while (this.i < npix) {
            this.mainPixels[this.i] = 0;
            ++this.i;
        }
    }

    private void readChunkIfNeeded() {
        if (this.workBufferSize > this.workBufferPosition) {
            return;
        }
        if (this.workBuffer == null) {
            this.workBuffer = this.bitmapProvider.obtainByteArray(16384);
        }
        this.workBufferPosition = 0;
        this.workBufferSize = Math.min(this.rawData.remaining(), 16384);
        this.rawData.get(this.workBuffer, 0, this.workBufferSize);
    }

    private int readByte() {
        try {
            this.readChunkIfNeeded();
            return this.workBuffer[this.workBufferPosition++] & 0xFF;
        }
        catch (Exception e) {
            this.status = 1;
            return 0;
        }
    }

    private int readBlock() {
        int blockSize = this.readByte();
        if (blockSize > 0) {
            try {
                int remaining;
                if (this.block == null) {
                    this.block = this.bitmapProvider.obtainByteArray(255);
                }
                if ((remaining = this.workBufferSize - this.workBufferPosition) >= blockSize) {
                    System.arraycopy(this.workBuffer, this.workBufferPosition, this.block, 0, blockSize);
                    this.workBufferPosition += blockSize;
                } else if (this.rawData.remaining() + remaining >= blockSize) {
                    System.arraycopy(this.workBuffer, this.workBufferPosition, this.block, 0, remaining);
                    this.workBufferPosition = this.workBufferSize;
                    this.readChunkIfNeeded();
                    int secondHalfRemaining = blockSize - remaining;
                    System.arraycopy(this.workBuffer, 0, this.block, remaining, secondHalfRemaining);
                    this.workBufferPosition += secondHalfRemaining;
                } else {
                    this.status = 1;
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"Error Reading Block", (Throwable)e);
                this.status = 1;
            }
        }
        return blockSize;
    }

    private Bitmap getNextBitmap() {
        Bitmap.Config config = this.isFirstFrameTransparent ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap result = this.bitmapProvider.obtain(this.downsampledWidth, this.downsampledHeight, config);
        GifDecoder.setAlpha(result);
        return result;
    }

    @TargetApi(value=12)
    private static void setAlpha(Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 12) {
            bitmap.setHasAlpha(true);
        }
    }

    public byte[] getByte(File file) throws Exception {
        byte[] bytes = null;
        if (file != null) {
            int offset;
            FileInputStream is = new FileInputStream(file);
            int length = (int)file.length();
            if (length > Integer.MAX_VALUE) {
                return null;
            }
            bytes = new byte[length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                return null;
            }
            ((InputStream)is).close();
        }
        return bytes;
    }

    static interface BitmapProvider {
        @NonNull
        public Bitmap obtain(int var1, int var2, Bitmap.Config var3);

        public void release(Bitmap var1);

        public byte[] obtainByteArray(int var1);

        public void release(byte[] var1);

        public int[] obtainIntArray(int var1);

        public void release(int[] var1);
    }
}

