/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.utils.sys;

import android.text.TextUtils;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.common.utils.DateUtils;
import com.xdja.im.lib.filemanage.util.ActomaController;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.timeformat.SessionTimeFormat;
import com.xdja.im.uikit.utils.timeformat.TimeFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class TimeUtil {
    private static final String FORMAT_MDYHM = "yyyy/MM/dd HH:mm";
    private static final String FORMAT_MDY = "yyyy/MM/dd";
    private static final String FORMAT_MDHM = "MM/dd HH:mm";
    private static final String FORMAT_MD = "MM/dd";
    private static final String FORMAT_HHMM = "HH:mm";
    private static final Map<String, ThreadLocal<SimpleDateFormat>> sdfMap = new HashMap<String, ThreadLocal<SimpleDateFormat>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SimpleDateFormat getFormat(final String pattern) {
        ThreadLocal<SimpleDateFormat> formatThread = sdfMap.get(pattern);
        if (formatThread != null) return formatThread.get();
        Class<DateUtils> clazz = DateUtils.class;
        synchronized (DateUtils.class) {
            formatThread = new ThreadLocal<SimpleDateFormat>(){

                @Override
                protected SimpleDateFormat initialValue() {
                    return new SimpleDateFormat(pattern);
                }
            };
            sdfMap.put(pattern, formatThread);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return formatThread.get();
        }
    }

    public static String convertSessionTime(long timestamp) {
        return TimeUtil.timeConvert(timestamp, new SessionTimeFormat());
    }

    public static String convertChatTime(long timestamp) {
        return TimeUtil.timeConvert(timestamp);
    }

    private static String timeConvert(long timestamp) {
        SimpleDateFormat yh = TimeUtil.getFormat(ActomaController.getAppConfigContext().getString(R.string.im_uikit_year_month_day));
        SimpleDateFormat mh = TimeUtil.getFormat(ActomaController.getAppConfigContext().getString(R.string.im_uikit_month_day));
        SimpleDateFormat hm = new SimpleDateFormat(FORMAT_HHMM);
        long currentSeconds = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentSeconds);
        int currentYear = cal.get(1);
        int currentMonth = cal.get(2);
        int currentDay = cal.get(5);
        cal.setTimeInMillis(timestamp);
        int lastYear = cal.get(1);
        int lastMonth = cal.get(2);
        int lastDay = cal.get(5);
        String timeStr = currentYear == lastYear ? (currentMonth == lastMonth && currentDay == lastDay ? CommonTool.getString(R.string.im_uikit_today) + "   " + hm.format(timestamp) : (currentMonth == lastMonth && currentDay - lastDay == 1 ? CommonTool.getString(R.string.im_uikit_yesterday) + "   " + hm.format(timestamp) : mh.format(timestamp) + "   " + hm.format(timestamp))) : yh.format(timestamp) + "   " + hm.format(timestamp);
        return timeStr;
    }

    private static String timeConvert(long timestamp, TimeFormat format) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        int currentYear = cal.get(1);
        int currentMonth = cal.get(2);
        int currentDay = cal.get(5);
        cal.setTimeInMillis(timestamp);
        int lastYear = cal.get(1);
        int lastMonth = cal.get(2);
        int lastDay = cal.get(5);
        String timeStr = currentYear == lastYear ? (currentMonth == lastMonth && currentDay == lastDay ? TimeUtil.getFormat(FORMAT_HHMM).format(timestamp) : (currentMonth == lastMonth && currentDay - lastDay == 1 ? (TextUtils.isEmpty((CharSequence)format.getTimePattern()) ? String.format(CommonTool.getString(R.string.im_uikit_yesterday), "") : String.format(CommonTool.getString(R.string.im_uikit_yesterday), TimeUtil.getFormat(format.getTimePattern()).format(timestamp))) : TimeUtil.getFormat(format.getMDPattern()).format(timestamp))) : TimeUtil.getFormat(format.getMDYPattern()).format(timestamp);
        return timeStr;
    }
}

