/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.utils.tbs;

import android.annotation.SuppressLint;
import android.content.ActivityNotFoundException;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.preference.PreferenceManager;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.widget.ProgressBar;
import android.widget.Toast;
import com.tencent.smtt.export.external.interfaces.IX5WebChromeClient;
import com.tencent.smtt.export.external.interfaces.JsResult;
import com.tencent.smtt.export.external.interfaces.WebResourceResponse;
import com.tencent.smtt.sdk.CookieSyncManager;
import com.tencent.smtt.sdk.DownloadListener;
import com.tencent.smtt.sdk.WebChromeClient;
import com.tencent.smtt.sdk.WebSettings;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.sdk.WebViewClient;
import com.xdja.im.lib.filemanage.util.ActomaController;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.uikit.R;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TBSBrowserActivity
extends AppCompatActivity {
    private static final String TAG = "TBSBrowserActivity";
    public static final String ACTION_VIEW = "android.intent.action.XDJA.VIEW";
    private static final int MAX = 100;
    private static final int MSG_EVENT_PROGRESS = 0;
    public static final String WEB_SHARE_TYPE = "web/";
    public static final String TEXT_SHARE_TYPE = "text/";
    public static final String TYPE = "type";
    public static final String FORWARD_ISTEXT = "isText";
    private Toolbar mToolbar;
    private WebView mWebView;
    private Uri mUri;
    private int mStyle = 0;
    private SharedPreferences mSharedPreferences = null;
    private ProgressBar mProgressBar;
    private WorkHandler mWorkHandler = new WorkHandler(this);

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(newBase);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initializeTheme();
        this.getWindow().setFormat(-3);
        this.setContentView(R.layout.im_uikit_activity_tbs_activity);
        this.initializeURL();
        this.initializeControl();
    }

    @SuppressLint(value={"NewApi"})
    private void initializeTheme() {
        this.mStyle = UniversalUtil.getThemeStyle((Context)this);
        Window window = this.getWindow();
        window.addFlags(Integer.MIN_VALUE);
        if (this.mStyle == 0) {
            window.setStatusBarColor(-16777216);
            this.setTheme(R.style.im_uikit_CommonThemeDark);
        } else {
            View decor = window.getDecorView();
            int ui = decor.getSystemUiVisibility();
            if (Build.VERSION.SDK_INT >= 23) {
                ui |= 0x2000;
                window.setStatusBarColor(this.getResources().getColor(R.color.im_uikit_toolbar_background_light));
            } else {
                ui &= 0xFFFFDFFF;
                window.setStatusBarColor(-16777216);
            }
            decor.setSystemUiVisibility(ui);
            this.setTheme(R.style.im_uikit_CommonThemeLight);
        }
        this.mSharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this);
        if (this.mSharedPreferences == null || this.mSharedPreferences.getBoolean("screenshots-" + ActomaController.getMark(), true)) {
            // empty if block
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.im_uikit_menu_browser, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    @SuppressLint(value={"NewApi"})
    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.action_refresh) {
            this.reload();
        } else {
            if (id2 == R.id.action_copy) {
                ClipData data = ClipData.newPlainText((CharSequence)" ", (CharSequence)this.mWebView.getUrl());
                ((ClipboardManager)this.getSystemService("clipboard")).setPrimaryClip(data);
                return true;
            }
            if (id2 == R.id.action_open_browser) {
                this.openBrowser(this.mWebView.getUrl());
            } else if (id2 == R.id.action_send_friend) {
                Intent intent = new Intent();
                intent.setClassName(this.getPackageName(), "com.xdja.im.lib.share.ShareSessionListActivity");
                intent.setAction("android.intent.action.FORWARD");
                if (WEB_SHARE_TYPE.equals(this.getIntent().getStringExtra(TYPE))) {
                    intent.putExtras(this.getIntent().getExtras());
                    intent.setType(WEB_SHARE_TYPE);
                } else if (this.getIntent().getBooleanExtra("isAnTongTeam", false)) {
                    String urlString = this.mWebView.getUrl();
                    if (TextUtils.isEmpty((CharSequence)urlString)) {
                        return true;
                    }
                    intent.setAction("android.intent.action.SEND");
                    intent.putExtra("web_url", urlString);
                    intent.putExtra("android.intent.extra.TEXT", urlString);
                    intent.putExtra("android.intent.extra.SUBJECT", this.mWebView.getTitle());
                    intent.putExtra("isAnTongTeam", true);
                    intent.setDataAndType(Uri.parse((String)urlString), "text/plain");
                } else {
                    ClipData beanContentClip = ClipData.newPlainText((CharSequence)" ", (CharSequence)this.mWebView.getUrl());
                    intent.setClipData(beanContentClip);
                    intent.putExtra("android.intent.extra.TEXT", this.mWebView.getUrl());
                    intent.setType(TEXT_SHARE_TYPE);
                    intent.putExtra(FORWARD_ISTEXT, true);
                }
                this.startActivity(intent);
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void openBrowser(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        try {
            Intent intent = new Intent();
            intent.setAction("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            this.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            e.printStackTrace();
            Toast.makeText((Context)this, (int)R.string.im_uikit_no_browser, (int)0).show();
        }
    }

    private void initializeURL() {
        Intent intent = this.getIntent();
        if (intent == null || intent.getData() == null) {
            this.finish();
            return;
        }
        this.mUri = intent.getData();
        if (Integer.parseInt(Build.VERSION.SDK) >= 11) {
            this.getWindow().setFlags(0x1000000, 0x1000000);
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void setConfig() {
        WebSettings webSetting = this.mWebView.getSettings();
        webSetting.setAllowFileAccess(true);
        webSetting.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        webSetting.setSupportZoom(true);
        webSetting.setBuiltInZoomControls(true);
        webSetting.setUseWideViewPort(true);
        webSetting.setSupportMultipleWindows(false);
        webSetting.setAppCacheEnabled(true);
        webSetting.setDomStorageEnabled(true);
        webSetting.setJavaScriptEnabled(true);
        webSetting.setGeolocationEnabled(true);
        webSetting.setAppCacheMaxSize(Long.MAX_VALUE);
        webSetting.setAppCachePath(this.getDir("appcache", 0).getPath());
        webSetting.setDatabasePath(this.getDir("databases", 0).getPath());
        webSetting.setGeolocationDatabasePath(this.getDir("geolocation", 0).getPath());
        webSetting.setPluginState(WebSettings.PluginState.ON_DEMAND);
    }

    private SpannableString formatAnTongSpanContent(CharSequence sourceContent, Context context, float smallScall) {
        if (TextUtils.isEmpty((CharSequence)sourceContent)) {
            return null;
        }
        SpannableString spannableString = new SpannableString(sourceContent);
        int style2 = UniversalUtil.getThemeStyle(context);
        try {
            String anTongStr = style2 == 0 ? "antong_title" : "antong_title_light";
            Pattern pattern = Pattern.compile(context.getResources().getString(R.string.app_name));
            Matcher matcher = pattern.matcher(sourceContent);
            while (matcher.find()) {
                Field field = R.drawable.class.getDeclaredField(anTongStr);
                int resouseId = Integer.parseInt(field.get(null).toString());
                Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resouseId);
                Matrix matrix = new Matrix();
                matrix.postScale(smallScall, smallScall);
                Bitmap resizeBmp = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                if (resizeBmp != bitmap) {
                    bitmap.recycle();
                }
                ImageSpan span = new ImageSpan(context, resizeBmp);
                spannableString.setSpan((Object)span, matcher.end(), matcher.end() + 1, 33);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return spannableString;
    }

    private void setWebClient() {
        this.mWebView.setWebViewClient(new WebViewClient(){

            public WebResourceResponse shouldInterceptRequest(WebView webView, String url) {
                if (!ADFilter.hasTBSADURL((Context)TBSBrowserActivity.this, url)) {
                    return super.shouldInterceptRequest(webView, url);
                }
                return new WebResourceResponse(null, null, null);
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                return false;
            }

            public void onPageStarted(WebView webView, String s, Bitmap bitmap) {
                super.onPageStarted(webView, s, bitmap);
                TBSBrowserActivity.this.removeTBSJSDiv(webView);
                TBSBrowserActivity.this.mWorkHandler.removeMessages(0);
                TBSBrowserActivity.this.mWorkHandler.sendMessage(TBSBrowserActivity.this.mWorkHandler.obtainMessage(0, true));
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                TBSBrowserActivity.this.removeTBSJSDiv(view);
                TBSBrowserActivity.this.mWorkHandler.sendMessageDelayed(TBSBrowserActivity.this.mWorkHandler.obtainMessage(0, false), 500L);
            }
        });
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public boolean onJsConfirm(WebView arg0, String arg1, String arg2, JsResult arg3) {
                return super.onJsConfirm(arg0, arg1, arg2, arg3);
            }

            public void onShowCustomView(View view, IX5WebChromeClient.CustomViewCallback customViewCallback) {
            }

            public void onProgressChanged(WebView webView, int progress) {
                super.onProgressChanged(webView, progress);
                TBSBrowserActivity.this.removeTBSJSDiv(webView);
                if (progress <= 100 && TBSBrowserActivity.this.mProgressBar != null) {
                    TBSBrowserActivity.this.mProgressBar.setProgress(progress);
                }
            }

            public void onReceivedTitle(WebView webView, String s) {
                super.onReceivedTitle(webView, s);
                boolean isAnTongTeam = TBSBrowserActivity.this.getIntent().getBooleanExtra("isAnTongTeam", false);
                TBSBrowserActivity.this.setTitle((CharSequence)(isAnTongTeam ? TBSBrowserActivity.this.formatAnTongSpanContent(TBSBrowserActivity.this.getString(R.string.app_name), (Context)TBSBrowserActivity.this, 1.0f) : s));
            }

            public void onHideCustomView() {
            }

            public boolean onJsAlert(WebView arg0, String arg1, String arg2, JsResult arg3) {
                return super.onJsAlert(null, arg1, arg2, arg3);
            }
        });
        this.mWebView.setDownloadListener(new DownloadListener(){

            public void onDownloadStart(String arg0, String arg1, String arg2, String arg3, long arg4) {
                TBSBrowserActivity.this.openBrowser(TBSBrowserActivity.this.mWebView.getUrl());
            }
        });
    }

    private void removeTBSJSDiv(WebView webView) {
        if (webView == null) {
            return;
        }
        webView.loadUrl("javascript:function setTop(){document.querySelector('.mod-download-fixer').style.display=\"none\";}setTop();");
    }

    private void initializeControl() {
        this.setTitle("");
        this.mToolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(this.mToolbar);
        this.mToolbar.setNavigationIcon(this.mStyle == 1 ? R.drawable.im_uikit_af_abs_ic_back_light : R.drawable.im_uikit_af_abs_ic_back);
        this.mToolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TBSBrowserActivity.this.finish();
            }
        });
        this.mProgressBar = (ProgressBar)this.findViewById(16908301);
        this.mProgressBar.setProgressDrawable(this.getResources().getDrawable(this.mStyle == 1 ? R.drawable.im_uikit_progress_horizontal_light : R.drawable.im_uikit_progress_horizontal));
        this.mProgressBar.setMax(100);
        this.mWebView = (WebView)this.findViewById(R.id.webview);
        this.mWebView.getView().setClickable(true);
        this.setConfig();
        this.setWebClient();
        CookieSyncManager.createInstance((Context)this);
        CookieSyncManager.getInstance().sync();
        this.loadUrl(this.mUri.toString());
    }

    private void loadUrl(String url) {
        if (this.mWebView != null) {
            this.mWebView.loadUrl(url);
        }
    }

    private void reload() {
        if (this.mWebView != null) {
            this.mWebView.reload();
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (intent == null || this.mWebView == null || intent.getData() == null) {
            return;
        }
        this.loadUrl(intent.getData().toString());
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.mWebView != null && this.mWebView.canGoBack()) {
            this.mWebView.goBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onResume() {
        super.onResume();
        if (this.mWebView != null) {
            this.mWebView.onResume();
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.mWebView != null) {
            this.mWebView.onPause();
        }
    }

    protected void onDestroy() {
        if (this.mWebView != null) {
            this.mWebView.clearCache(true);
            this.mWebView.clearFormData();
            this.mWebView.clearHistory();
            this.mWebView.destroy();
        }
        super.onDestroy();
        if (this.mWorkHandler != null) {
            this.mWorkHandler.removeCallbacksAndMessages(null);
        }
    }

    private static class WorkHandler
    extends Handler {
        private WeakReference<TBSBrowserActivity> mWeakReference;

        public WorkHandler(TBSBrowserActivity weak) {
            if (weak != null) {
                this.mWeakReference = new WeakReference<TBSBrowserActivity>(weak);
            }
        }

        public void handleMessage(Message msg) {
            if (this.mWeakReference == null || this.mWeakReference.get() == null) {
                return;
            }
            switch (msg.what) {
                case 0: {
                    if (((TBSBrowserActivity)((Object)this.mWeakReference.get())).mProgressBar == null) break;
                    ((TBSBrowserActivity)((Object)this.mWeakReference.get())).mProgressBar.setVisibility((Boolean)msg.obj != false ? 0 : 8);
                }
            }
        }
    }

    public static final class ADFilter {
        private ADFilter() {
        }

        public static boolean hasTBSADURL(Context context, String url) {
            String[] urls;
            if (TextUtils.isEmpty((CharSequence)url) || context == null) {
                return false;
            }
            url = url.toLowerCase();
            Resources res = context.getResources();
            for (String s : urls = res.getStringArray(R.array.im_uikit_AD_URL)) {
                if (!url.contains(s)) continue;
                return true;
            }
            return false;
        }
    }
}

