/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;

@SuppressLint(value={"AppCompatCustomView"})
public class AutoSplitTextView
extends TextView {
    private boolean mEnabled = true;

    public AutoSplitTextView(Context context) {
        super(context);
    }

    public AutoSplitTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AutoSplitTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setAutoSplitEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        String newText;
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) == 0x40000000 && View.MeasureSpec.getMode((int)heightMeasureSpec) == 0x40000000 && this.getWidth() > 0 && this.getHeight() > 0 && this.mEnabled && !TextUtils.isEmpty((CharSequence)(newText = this.autoSplitText(this)))) {
            this.setText(newText);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private String autoSplitText(TextView tv) {
        String rawText = tv.getText().toString();
        TextPaint tvPaint = tv.getPaint();
        float tvWidth = tv.getWidth() - tv.getPaddingLeft() - tv.getPaddingRight();
        String[] rawTextLines = rawText.replaceAll("\r", "").split("\n");
        StringBuilder sbNewText = new StringBuilder();
        for (String rawTextLine : rawTextLines) {
            if (tvPaint.measureText(rawTextLine) <= tvWidth) {
                sbNewText.append(rawTextLine);
            } else {
                float lineWidth = 0.0f;
                for (int cnt = 0; cnt != rawTextLine.length(); ++cnt) {
                    char ch = rawTextLine.charAt(cnt);
                    if ((lineWidth += tvPaint.measureText(String.valueOf(ch))) <= tvWidth) {
                        sbNewText.append(ch);
                        continue;
                    }
                    sbNewText.append("\n");
                    lineWidth = 0.0f;
                    --cnt;
                }
            }
            sbNewText.append("\n");
        }
        if (!rawText.endsWith("\n")) {
            sbNewText.deleteCharAt(sbNewText.length() - 1);
        }
        return sbNewText.toString();
    }
}

