/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ViewTreeObserver;
import android.widget.TextView;

@SuppressLint(value={"AppCompatCustomView"})
public class ElliTextView
extends TextView {
    private CharSequence text;

    public ElliTextView(Context context) {
        super(context);
        this.init();
    }

    public ElliTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)new OnGlobalLayoutListenerByEllipSize(this, 1));
    }

    public void setStrText(CharSequence text) {
        this.text = text;
        super.setText(text);
    }

    public CharSequence getStrText() {
        return this.text;
    }

    class OnGlobalLayoutListenerByEllipSize
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private ElliTextView mTextView;
        private int mMaxLines;

        public OnGlobalLayoutListenerByEllipSize(ElliTextView textView, int maxLines) {
            if (maxLines <= 0) {
                throw new IllegalArgumentException("maxLines\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
            }
            this.mTextView = textView;
            this.mMaxLines = maxLines;
            this.mTextView.setMaxLines(this.mMaxLines + 1);
            this.mTextView.setSingleLine(false);
        }

        public void onGlobalLayout() {
            if (this.mTextView.getLineCount() > this.mMaxLines) {
                int line = this.mTextView.getLayout().getLineEnd(this.mMaxLines - 1);
                String truncate = "...";
                CharSequence text = this.mTextView.getStrText();
                int length = 0;
                try {
                    length = text.length();
                    text = text.subSequence(0, line - 3);
                }
                catch (Exception e) {
                    truncate = "";
                    text = this.mTextView.getText();
                }
                TextUtils.TruncateAt at = this.mTextView.getEllipsize();
                if (at == TextUtils.TruncateAt.START) {
                    this.mTextView.setText(truncate);
                    this.mTextView.append(text);
                } else if (at == TextUtils.TruncateAt.MIDDLE) {
                    this.mTextView.setText(text.subSequence(0, text.length() / 2));
                    this.mTextView.append(truncate);
                    this.mTextView.append(text.subSequence(text.length() / 2, text.length()));
                    int newLength = this.mTextView.getText().length();
                    if (newLength < length) {
                        this.mTextView.setText(this.mTextView.getStrText().subSequence(0, (newLength -= 3) / 2));
                        this.mTextView.append(truncate);
                        this.mTextView.append(this.mTextView.getStrText().subSequence(this.mTextView.getStrText().length() - newLength / 2, this.mTextView.getStrText().length()));
                    }
                } else {
                    this.mTextView.setText(text);
                    this.mTextView.append(truncate);
                }
            }
        }
    }
}

