/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.imsdk.ImSdkService;
import com.xdja.imsdk.callback.IMFileInfoCallback;
import com.xdja.imsdk.callback.IMMessageCallback;
import com.xdja.imsdk.callback.IMSessionCallback;
import com.xdja.imsdk.constant.ImSdkFileConstant;
import com.xdja.imsdk.constant.internal.Constant;
import com.xdja.imsdk.exception.ImSdkException;
import com.xdja.imsdk.impl.ISdkClient;
import com.xdja.imsdk.logger.DebugHelper;
import com.xdja.imsdk.logger.Logger;
import com.xdja.imsdk.manager.ImSdkCallbackManager;
import com.xdja.imsdk.manager.ImSdkConfigManager;
import com.xdja.imsdk.manager.ImSdkManager;
import com.xdja.imsdk.model.IMFileInfo;
import com.xdja.imsdk.model.IMMessage;
import com.xdja.imsdk.model.IMSession;
import com.xdja.imsdk.model.InitParam;
import com.xdja.imsdk.model.body.IMFileBody;
import com.xdja.imsdk.model.body.IMImageBody;
import com.xdja.imsdk.model.body.IMMessageBody;
import com.xdja.imsdk.model.body.IMVideoBody;
import com.xdja.imsdk.model.body.IMVoiceBody;
import com.xdja.imsdk.util.ValidateUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ImClient
implements ISdkClient {
    public static final String VER_CODE = "V1.1.9_0808_D";
    private static ImClient imClient;
    private static boolean isInit;
    private Context context;

    static {
        isInit = false;
    }

    public static ImClient getInstance(Context context) {
        if (context != null) {
            if (imClient == null) {
                imClient = Factory.getInstance(context);
            }
            return imClient;
        }
        return null;
    }

    private ImClient(Context context) {
        this.context = context;
    }

    @Override
    public int Init(InitParam initParam) {
        Log.i((String)"ImSdk", (String)"ImSdk init version: [V1.1.9_0808_D]...");
        if (!this.verifyInitParam(initParam)) {
            return -1;
        }
        ImSdkCallbackManager.getInstance().registerCallbackFunction(initParam.getCallback());
        ImSdkCallbackManager.getInstance().registerSecurityCallback(initParam.getSecurityCallback());
        Logger.getLogger().d("ImSdk init param " + initParam);
        this.startService(initParam);
        isInit = true;
        return 0;
    }

    @Override
    public int Release(int flag) {
        Logger.getLogger().i("ImSdk " + (flag == 0 ? "cancel but keep receiving message..." : "cancel all..."));
        if (!isInit) {
            Logger.getLogger().d("ImSdk already released...");
            return -2;
        }
        if (flag == 0) {
            isInit = false;
            return 0;
        }
        if (flag == 1) {
            Intent intent = new Intent(this.context, ImSdkService.class);
            this.context.stopService(intent);
            isInit = false;
            return 0;
        }
        return -1;
    }

    @Override
    public int SyncMessage() {
        if (!isInit) {
            return -2;
        }
        return ImSdkManager.getInstance().syncMessage();
    }

    @Override
    public int SetConfig(Map<String, String> param) {
        Logger.getLogger().d("ImSdk set config " + param);
        if (!isInit) {
            return -2;
        }
        return ImSdkManager.getInstance().saveConfig(param);
    }

    @Override
    public String GetConfig(String key) throws ImSdkException {
        Logger.getLogger().d("ImSdk get config key " + key);
        if (!isInit) {
            throw new ImSdkException(-2);
        }
        String result = ImSdkManager.getInstance().getConfigByKey(key);
        Logger.getLogger().d("ImSdk get config result [" + key + ", " + result + "]");
        return result;
    }

    @Override
    public List<IMSession> GetIMSessionList(String begin, int size) throws ImSdkException {
        Logger.getLogger().d("ImSdk get sessions [" + begin + ", " + size + "]");
        if (!isInit) {
            throw new ImSdkException(-2);
        }
        if (!ImSdkConfigManager.getInstance().needSession()) {
            throw new ImSdkException(-4);
        }
        List<IMSession> sessions = ImSdkManager.getInstance().getIMSessionList(begin, size);
        DebugHelper.logIMSessions("ImSdk get sessions ", sessions);
        return sessions;
    }

    @Override
    public IMSession IMSessionListAddCust(IMSession session) throws ImSdkException {
        Logger.getLogger().d("ImSdk add session custom " + session);
        if (!isInit) {
            throw new ImSdkException(-2);
        }
        if (!ImSdkConfigManager.getInstance().needSession()) {
            throw new ImSdkException(-4);
        }
        if (!this.verifySession(session)) {
            throw new ImSdkException(-1);
        }
        IMSession result = ImSdkManager.getInstance().addCustomSession(session);
        Logger.getLogger().d("ImSdk add session custom result " + session);
        return result;
    }

    @Override
    public IMMessage IMMessageListAddCust(String sessionTag, IMMessage message) throws ImSdkException {
        Logger.getLogger().d("ImSdk add message custom [" + sessionTag + "], message " + message);
        if (!isInit) {
            throw new ImSdkException(-2);
        }
        if (!ImSdkConfigManager.getInstance().needSession()) {
            throw new ImSdkException(-4);
        }
        if (!this.verifyMessage(message)) {
            throw new ImSdkException(-1);
        }
        IMMessage result = ImSdkManager.getInstance().addCustomMessage(sessionTag, message);
        Logger.getLogger().d("ImSdk add message custom result " + result);
        return result;
    }

    @Override
    public List<IMMessage> GetIMMessageList(String sessionTag, long begin, int size, boolean strictly) throws ImSdkException {
        Logger.getLogger().d("ImSdk get messages [" + sessionTag + ", " + begin + ", " + size + ", " + strictly + "]");
        if (!isInit) {
            throw new ImSdkException(-2);
        }
        if (TextUtils.isEmpty((CharSequence)sessionTag)) {
            throw new ImSdkException(-1);
        }
        List<IMMessage> result = ImSdkManager.getInstance().getIMMessageList(sessionTag, begin, size, strictly);
        DebugHelper.logIMMessages("ImSdk get messages ", result);
        return result;
    }

    @Override
    public IMMessage GetFirstNewMessage(String sessionTag) throws ImSdkException {
        Logger.getLogger().d("ImSdk get first new message [" + sessionTag + "]");
        if (!isInit) {
            throw new ImSdkException(-2);
        }
        if (TextUtils.isEmpty((CharSequence)sessionTag)) {
            throw new ImSdkException(-1);
        }
        IMMessage result = ImSdkManager.getInstance().getFirstNewMessage(sessionTag);
        Logger.getLogger().d("ImSdk get first new message result " + result);
        return result;
    }

    @Override
    public List<IMMessage> GetImageList(String sessionTag, int begin, int size) throws ImSdkException {
        Logger.getLogger().d("ImSdk get images [" + sessionTag + ", " + begin + ", " + size + "]");
        if (!isInit) {
            throw new ImSdkException(-2);
        }
        if (TextUtils.isEmpty((CharSequence)sessionTag)) {
            throw new ImSdkException(-1);
        }
        List<IMMessage> result = ImSdkManager.getInstance().getImageList(sessionTag, begin, size);
        DebugHelper.logIMMessages("ImSdk get images ", result);
        return result;
    }

    @Override
    public List<IMMessage> GetFileList(String sessionTag) throws ImSdkException {
        Logger.getLogger().d("ImSdk get files [" + sessionTag + "]");
        if (!isInit) {
            throw new ImSdkException(-2);
        }
        List<IMMessage> result = ImSdkManager.getInstance().getFileList(sessionTag);
        DebugHelper.logIMMessages("ImSdk get files ", result);
        return result;
    }

    @Override
    public List<IMMessage> GetFileList(String sessionTag, ImSdkFileConstant.FileGetType getType, int begin, int size) throws ImSdkException {
        Logger.getLogger().d("ImSdk get new files [" + sessionTag + ", " + (Object)((Object)getType) + ", " + begin + ", " + size + "]");
        if (!isInit) {
            throw new ImSdkException(-2);
        }
        List<IMMessage> result = ImSdkManager.getInstance().getFileList(sessionTag, getType, begin, size);
        DebugHelper.logIMMessages("ImSdk get new files ", result);
        return result;
    }

    @Override
    public IMMessage getIMMessageById(long id) throws ImSdkException {
        Logger.getLogger().d("ImSdk get message [" + id + "]");
        if (!isInit) {
            throw new ImSdkException(-2);
        }
        IMMessage result = ImSdkManager.getInstance().getIMMessageById(id);
        Logger.getLogger().d("ImSdk get message result " + result);
        return result;
    }

    @Override
    public IMMessage SendIMMessage(IMMessage message) throws ImSdkException {
        Logger.getLogger().d("ImSdk send message " + message);
        if (!isInit) {
            throw new ImSdkException(-2);
        }
        if (!this.verifyMessage(message)) {
            throw new ImSdkException(-1);
        }
        IMMessage result = ImSdkManager.getInstance().sendIMMessage(message);
        Logger.getLogger().d("ImSdk send message result " + message);
        return result;
    }

    @Override
    public int RecallIMMessage(long id, int action) {
        Logger.getLogger().d("ImSdk recall message [" + id + ", " + action + "]");
        if (!isInit) {
            return -2;
        }
        return ImSdkManager.getInstance().recallIMMessage(id, action);
    }

    @Override
    public int DeleteIMSession(List<String> tags) {
        Logger.getLogger().d("ImSdk delete sessions " + tags);
        if (!isInit) {
            return -2;
        }
        if (!ImSdkConfigManager.getInstance().needSession()) {
            return -4;
        }
        if (tags == null || tags.isEmpty()) {
            return -1;
        }
        return ImSdkManager.getInstance().deleteIMSession(tags);
    }

    @Override
    public int DeleteIMMessage(List<Long> msgIds) {
        Logger.getLogger().d("ImSdk delete messages " + msgIds);
        if (!isInit) {
            return -2;
        }
        if (msgIds == null) {
            return -1;
        }
        if (msgIds.isEmpty()) {
            return -1;
        }
        for (Long id : msgIds) {
            if (ValidateUtils.isValidateLong(id)) continue;
            return -1;
        }
        return ImSdkManager.getInstance().deleteIMMessage(msgIds);
    }

    @Override
    public Map<String, Integer> GetRemindIMMessageCount(String sessionTag) throws ImSdkException {
        Logger.getLogger().d("ImSdk get remind count " + sessionTag);
        if (!isInit) {
            throw new ImSdkException(-2);
        }
        if (TextUtils.isEmpty((CharSequence)sessionTag)) {
            throw new ImSdkException(-3);
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        int normal = ImSdkManager.getInstance().getRemindIMMessageCount(sessionTag, false);
        int strictly = ImSdkManager.getInstance().getRemindIMMessageCount(sessionTag, true);
        int exist = ImSdkManager.getInstance().getStrictlyCount(sessionTag);
        result.put("normal_new", normal);
        result.put("strictly_new", strictly);
        result.put("strictly_exist", exist);
        Logger.getLogger().d("ImSdk [" + sessionTag + "] remind count [" + result + "]");
        return result;
    }

    @Override
    public int GetAllRemindIMMessageCount() {
        Logger.getLogger().d("ImSdk get all remind count ... ");
        if (!isInit) {
            return -2;
        }
        int result = ImSdkManager.getInstance().getAllRemindIMMessageCount();
        Logger.getLogger().d("ImSdk all remind count [" + result + "]");
        return result;
    }

    @Override
    public int SetRemind(String sessionTag, int type) {
        Logger.getLogger().d("ImSdk reset [" + sessionTag + ", " + type + "] remind count ...");
        if (!isInit) {
            return -2;
        }
        int result = ImSdkManager.getInstance().setRemind(sessionTag, type);
        Logger.getLogger().d("ImSdk reset result " + result);
        return result;
    }

    @Override
    public int ClearIMSessionAllIMMessage(String sessionTag) {
        Logger.getLogger().d("ImSdk clear [" + sessionTag + "] messages...");
        if (!isInit) {
            return -2;
        }
        if (TextUtils.isEmpty((CharSequence)sessionTag)) {
            return -1;
        }
        return ImSdkManager.getInstance().clearIMSessionAllIMMessage(sessionTag);
    }

    @Override
    public int ClearAllLocalData() {
        Logger.getLogger().d("ImSdk clear all messages...");
        if (!isInit) {
            return -2;
        }
        return ImSdkManager.getInstance().clearAllLocalData();
    }

    @Override
    public int ClearCache() {
        Logger.getLogger().d("ImSdk clear cache...");
        if (!isInit) {
            return -2;
        }
        return ImSdkManager.getInstance().clearCache();
    }

    @Override
    public long GetCacheSize() {
        Logger.getLogger().d("ImSdk get cache size...");
        if (!isInit) {
            return -2L;
        }
        return ImSdkManager.getInstance().getCacheSize();
    }

    @Override
    public int SendFilePause(IMFileInfo fileInfo) {
        Logger.getLogger().d("ImSdk send file pause..." + fileInfo);
        if (!isInit) {
            return -2;
        }
        if (!this.verifyFileInfo(fileInfo)) {
            return -1;
        }
        return ImSdkManager.getInstance().processFile(fileInfo, Constant.FileOptType.UP_PAUSE);
    }

    @Override
    public int SendFileResume(IMFileInfo fileInfo) {
        Logger.getLogger().d("ImSdk send file resume..." + fileInfo);
        if (!isInit) {
            return -2;
        }
        if (!this.verifyFileInfo(fileInfo)) {
            return -1;
        }
        return ImSdkManager.getInstance().processFile(fileInfo, Constant.FileOptType.UP_RESUME);
    }

    @Override
    public int ReceiveFileStart(List<IMFileInfo> fileInfoList) {
        Logger.getLogger().d("ImSdk receive files start..." + fileInfoList);
        if (!isInit) {
            return -2;
        }
        if (fileInfoList == null || fileInfoList.isEmpty()) {
            return -1;
        }
        for (IMFileInfo fileInfo : fileInfoList) {
            if (this.verifyFileInfo(fileInfo)) continue;
            return -1;
        }
        return ImSdkManager.getInstance().receiveFileStart(fileInfoList);
    }

    @Override
    public int ReceiveFilePause(IMFileInfo fileInfo) {
        Logger.getLogger().d("ImSdk receive file pause..." + fileInfo);
        if (!isInit) {
            return -2;
        }
        if (!this.verifyFileInfo(fileInfo)) {
            return -1;
        }
        return ImSdkManager.getInstance().processFile(fileInfo, Constant.FileOptType.DOWN_PAUSE);
    }

    @Override
    public int ReceiveFileResume(IMFileInfo fileInfo) {
        Logger.getLogger().d("ImSdk receive file resume..." + fileInfo);
        if (!isInit) {
            return -2;
        }
        if (!this.verifyFileInfo(fileInfo)) {
            return -1;
        }
        return ImSdkManager.getInstance().processFile(fileInfo, Constant.FileOptType.DOWN_RESUME);
    }

    @Override
    public int IMMessageStateChange(IMMessage message, int state) {
        Logger.getLogger().d("ImSdk change " + message + " to state = [" + state + "]");
        if (!isInit) {
            return -2;
        }
        if (!this.verifyMessage(message)) {
            return -1;
        }
        if (message.getState() == -1) {
            return -1;
        }
        if (state == message.getState() || state < message.getState()) {
            return -1;
        }
        return ImSdkManager.getInstance().changeMessageState(message, state);
    }

    @Override
    public int ResendIMMessage(long messageId) {
        Logger.getLogger().d("ImSdk resend message [" + messageId + "]");
        if (!isInit) {
            return -2;
        }
        return ImSdkManager.getInstance().resendIMMessage(messageId);
    }

    @Override
    public void RegisterIMSessionChangeListener(Context context, IMSessionCallback callback) {
        ImSdkCallbackManager.getInstance().registerSessionCallback(context, callback);
    }

    @Override
    public void UnregisterIMSessionChangeListener(Context context) {
        ImSdkCallbackManager.getInstance().unregisterSessionCallback(context);
    }

    @Override
    public void RegisterIMMessageChangeListener(Context context, IMMessageCallback callback) {
        ImSdkCallbackManager.getInstance().registerMessageCallback(context, callback);
    }

    @Override
    public void UnregisterIMMessageChangeListener(Context context) {
        ImSdkCallbackManager.getInstance().unregisterMessageCallback(context);
    }

    @Override
    public void RegisterIMFileInfoChangeListener(Context context, IMFileInfoCallback callback) {
        ImSdkCallbackManager.getInstance().registerFileCallback(context, callback);
    }

    @Override
    public void UnregisterIMFileInfoChangeListener(Context context) {
        ImSdkCallbackManager.getInstance().unregisterFileCallback(context);
    }

    @Override
    public Map<String, List<String>> GetReceiptList(long id) throws ImSdkException {
        Logger.getLogger().d("ImSdk get receipt list [" + id + "]");
        if (!isInit) {
            throw new ImSdkException(-2);
        }
        return ImSdkManager.getInstance().getReceiptList(id);
    }

    @Override
    public int SendAttentionMessage(IMMessage message) {
        Logger.getLogger().d("ImSdk send attention message [" + message + "]");
        if (!isInit) {
            return -2;
        }
        return ImSdkManager.getInstance().sendAttentionMessage(message);
    }

    @Override
    public int ChangeGroupRead(List<Long> ids) {
        Logger.getLogger().d("ImSdk change group read [" + ids + "]");
        if (!isInit) {
            return -2;
        }
        return ImSdkManager.getInstance().changeGroupRead(ids);
    }

    private boolean verifyInitParam(InitParam initParam) {
        if (initParam == null || initParam.getCallback() == null || TextUtils.isEmpty((CharSequence)initParam.getAccount()) || TextUtils.isEmpty((CharSequence)initParam.getTfcardId())) {
            return false;
        }
        if (initParam.getCallback() == null) {
            return false;
        }
        if (initParam.getProperties() != null) {
            HashMap<String, String> property = initParam.getProperties();
            Set entrySet = property.entrySet();
            for (Map.Entry entry : entrySet) {
                if (ValidateUtils.verifyCustomConfig((String)entry.getKey(), (String)entry.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean verifySession(IMSession session) {
        if (session == null) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)session.getImPartner())) {
            return false;
        }
        return session.getSessionType() == 100 || session.getSessionType() == 2 || session.getSessionType() == 1 || session.getSessionType() == 200;
    }

    private boolean verifyMessage(IMMessage message) {
        if (message == null) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)message.getTo())) {
            return false;
        }
        if (message.getType() < 0) {
            return false;
        }
        if (message.isTextIMMessage() && message.isFileIMMessage()) {
            return false;
        }
        if ((message.getType() & 1) != 1 && (message.getType() & 2) != 2 && (message.getType() & 0x40) != 64 && (message.getType() & 0x10000) != 65536) {
            return false;
        }
        if (message.isTextIMMessage() && (message.getMessageBody() == null || TextUtils.isEmpty((CharSequence)message.getMessageBody().toString()))) {
            return false;
        }
        return !message.isFileIMMessage() || this.verifyFileBody(message.getMessageBody());
    }

    private boolean verifyFileInfo(IMFileInfo fileInfo) {
        return fileInfo != null;
    }

    private boolean verifyFileBody(IMMessageBody body) {
        IMImageBody imageFile;
        IMVideoBody videoFile;
        IMVoiceBody voiceFile;
        if (body == null) {
            return false;
        }
        if (!(body instanceof IMFileBody)) {
            return false;
        }
        IMFileBody fileBody = (IMFileBody)body;
        if (TextUtils.isEmpty((CharSequence)fileBody.getLocalPath())) {
            return false;
        }
        return !(fileBody instanceof IMVoiceBody ? (voiceFile = (IMVoiceBody)fileBody).getDuration() <= 0 : (fileBody instanceof IMVideoBody ? (videoFile = (IMVideoBody)fileBody).getDuration() <= 0 : fileBody instanceof IMImageBody && TextUtils.isEmpty((CharSequence)(imageFile = (IMImageBody)fileBody).getLocalPath())));
    }

    private void startService(InitParam initParam) {
        Intent intent = new Intent(this.context, ImSdkService.class);
        Bundle bundle = new Bundle();
        bundle.putParcelable("im.init.param", (Parcelable)initParam);
        intent.putExtras(bundle);
        intent.setAction("im.action.init");
        this.context.startService(intent);
    }

    /* synthetic */ ImClient(Context context, ImClient imClient) {
        this(context);
    }

    private static class Factory {
        private Factory() {
        }

        static ImClient getInstance(Context context) {
            return new ImClient(context, null);
        }
    }
}

