/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.db.builder;

import com.xdja.imsdk.db.helper.SqlBuilder;
import com.xdja.imsdk.util.ToolUtils;
import java.util.List;

public class AttentionMsgBuilder {
    public static final String TABLE_NAME = "att_msg";
    public static final String ID = "_id";
    public static final String ATT_SERVER_ID = "ATT_SERVER_ID";
    public static final String MSG_SERVER_ID = "MSG_SERVER_ID";
    public static final String ATT_TIME = "ATT_TIME";
    public static final String ATT_FROM = "ATT_FROM";
    public static final String ATT_TO = "ATT_TO";
    public static final String RECEIVED = "RECEIVED";
    private static final String[] ALL_COLUMNS = new String[]{"_id", "ATT_SERVER_ID", "MSG_SERVER_ID", "ATT_TIME", "ATT_FROM", "ATT_TO", "RECEIVED"};
    public static final String SQL_CREATE_INDEX_ON_ATT = "CREATE INDEX attention_server_index ON att_msg(ATT_SERVER_ID)";
    public static final String SQL_CREATE_INDEX_ON_MSG = "CREATE INDEX attention_msg_index ON att_msg(MSG_SERVER_ID)";
    public static final String SQL_CREATE_TABLE_ATT_MSG = "CREATE TABLE att_msg (_id INTEGER PRIMARY KEY AUTOINCREMENT, ATT_SERVER_ID INTEGER UNIQUE, MSG_SERVER_ID INTEGER DEFAULT 0, ATT_TIME INTEGER DEFAULT 0,ATT_FROM TEXT,ATT_TO TEXT,RECEIVED INTEGER)";
    public static final String ATT_SESSION_UPDATE_ON_INSERT_TRIGGER = "CREATE TRIGGER att_session_update_on_insert_trigger  AFTER INSERT ON att_msg WHEN (new.RECEIVED = 1) BEGIN  UPDATE session_entry SET LAST_TIME = (CASE WHEN LAST_TIME < new.ATT_TIME THEN new.ATT_TIME ELSE LAST_TIME END), LAST_MSG = (CASE WHEN LAST_TIME < new.ATT_TIME THEN new._id ELSE LAST_MSG END), REMINDED = (CASE WHEN new.RECEIVED = 1 THEN REMINDED + 1 ELSE REMINDED END) WHERE SESSION_FLAG = '" + ToolUtils.getResidentTag() + "';" + " END;";
    public static final String ATT_DELETED_ON_DELETE_TRIGGER = "CREATE TRIGGER att_deleted_on_delete_trigger  BEFORE DELETE ON att_msg BEGIN  INSERT INTO deleted_msg (MSG_ID, SERVER_ID) VALUES(old._id, old.MSG_SERVER_ID); END; ";
    public static final String ATT_INSERT_ON_UPDATE_TRIGGER = "CREATE TRIGGER att_insert_on_update_trigger  AFTER INSERT ON att_msg BEGIN  UPDATE msg_entry SET EXTRA_STATE = 1  WHERE SERVER_ID =  new.MSG_SERVER_ID; END;";

    public static String insertSql() {
        return SqlBuilder.insertSql("INSERT OR REPLACE INTO  ", TABLE_NAME, ALL_COLUMNS);
    }

    public static String delSql(String tag) {
        return SqlBuilder.deleteSql(TABLE_NAME, ID, tag);
    }

    public static String delSql(List<Long> ids) {
        return SqlBuilder.deleteSql(TABLE_NAME, MSG_SERVER_ID, ids);
    }

    public static String queryIds(String where) {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(ATT_SERVER_ID).append(" FROM ").append(TABLE_NAME).append(where);
        return builder.toString();
    }

    public static String queryRemind(String where) {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append("msg_entry").append(".").append(ID);
        builder.append(" FROM ").append("msg_entry").append(" WHERE ");
        builder.append("msg_entry").append(".").append("SERVER_ID");
        builder.append(" IN (SELECT ").append(TABLE_NAME).append(".").append(MSG_SERVER_ID).append(" FROM ");
        builder.append(TABLE_NAME).append(where).append(");");
        return builder.toString();
    }

    public static String queryAllRecRemind(long begin, int size) {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(TABLE_NAME).append(".").append(MSG_SERVER_ID);
        builder.append(", ").append(TABLE_NAME).append(".").append(ATT_TIME);
        builder.append(" FROM ").append(TABLE_NAME);
        String whereAll = " WHERE att_msg.RECEIVED = 1";
        if (begin == 0L) {
            builder.append(whereAll).append(SqlBuilder.getOrder(ATT_TIME));
            if (size > 0) {
                builder.append(SqlBuilder.getLimit(Math.abs(size)));
            }
        } else {
            String beginId = " (SELECT msg_entry.SERVER_ID FROM msg_entry WHERE msg_entry._id = " + begin + ") ";
            if (size == 0) {
                builder.append(" WHERE ").append(TABLE_NAME).append(".").append(MSG_SERVER_ID).append(" = ").append(beginId);
            } else {
                String whereCompare = " AND att_msg.ATT_TIME" + (size > 0 ? " < " : " > ") + "(SELECT " + TABLE_NAME + "." + ATT_TIME + " FROM " + TABLE_NAME + " WHERE " + TABLE_NAME + "." + MSG_SERVER_ID + " = " + beginId + ")";
                builder.append(whereAll).append(whereCompare).append(SqlBuilder.getOrder(ATT_TIME)).append(SqlBuilder.getLimit(Math.abs(size)));
            }
        }
        return builder.toString();
    }

    public static String queryAllRecRemind() {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(TABLE_NAME).append(".").append(MSG_SERVER_ID);
        builder.append(", ").append(TABLE_NAME).append(".").append(ATT_TIME);
        builder.append(" FROM ").append(TABLE_NAME);
        String whereAll = " WHERE att_msg.RECEIVED = 1";
        builder.append(whereAll).append(SqlBuilder.getOrderDefault(ATT_TIME)).append(";");
        return builder.toString();
    }
}

