/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.manager;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.xdja.imsdk.callback.CallbackFunction;
import com.xdja.imsdk.callback.IMFileInfoCallback;
import com.xdja.imsdk.callback.IMMessageCallback;
import com.xdja.imsdk.callback.IMSecurityCallback;
import com.xdja.imsdk.callback.IMSessionCallback;
import com.xdja.imsdk.constant.ChangeAction;
import com.xdja.imsdk.constant.internal.Constant;
import com.xdja.imsdk.logger.DebugHelper;
import com.xdja.imsdk.logger.Logger;
import com.xdja.imsdk.manager.ImSdkConfigManager;
import com.xdja.imsdk.model.IMFileInfo;
import com.xdja.imsdk.model.IMMessage;
import com.xdja.imsdk.model.IMSession;
import com.xdja.imsdk.security.SecurityPara;
import com.xdja.imsdk.security.SecurityResult;
import com.xdja.imsdk.security.SignResult;
import com.xdja.imsdk.util.ToolUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ImSdkCallbackManager {
    private static ImSdkCallbackManager instance;
    private Map<String, IMSessionCallback> sessionCallback = new HashMap<String, IMSessionCallback>();
    private Map<String, IMMessageCallback> messageCallback = new HashMap<String, IMMessageCallback>();
    private Map<String, IMFileInfoCallback> fileInfoCallback = new HashMap<String, IMFileInfoCallback>();
    private CallbackFunction callbackFunction;
    private IMSecurityCallback securityCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImSdkCallbackManager getInstance() {
        Class<ImSdkCallbackManager> clazz = ImSdkCallbackManager.class;
        synchronized (ImSdkCallbackManager.class) {
            if (instance == null) {
                instance = Factory.getInstance();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void cancelAllCallback() {
        this.sessionCallback.clear();
        this.messageCallback.clear();
        this.fileInfoCallback.clear();
        this.callbackFunction = null;
        this.securityCallback = null;
        instance = null;
    }

    public void registerCallbackFunction(CallbackFunction callback) {
        this.callbackFunction = callback;
    }

    public void registerSecurityCallback(IMSecurityCallback callback) {
        this.securityCallback = callback;
    }

    public void registerSessionCallback(Context context, IMSessionCallback callback) {
        if (context == null || callback == null) {
            return;
        }
        this.sessionCallback.put(context.getClass().getName(), callback);
    }

    public void unregisterSessionCallback(Context context) {
        if (context == null) {
            return;
        }
        this.sessionCallback.remove(context.getClass().getName());
    }

    public void registerMessageCallback(Context context, IMMessageCallback callback) {
        if (context == null || callback == null) {
            return;
        }
        this.messageCallback.put(context.getClass().getName(), callback);
    }

    public void unregisterMessageCallback(Context context) {
        if (context == null) {
            return;
        }
        this.messageCallback.remove(context.getClass().getName());
    }

    public void registerFileCallback(Context context, IMFileInfoCallback callback) {
        if (context == null || callback == null) {
            return;
        }
        this.fileInfoCallback.put(context.getClass().getName(), callback);
    }

    public void unregisterFileCallback(Context context) {
        if (context == null) {
            return;
        }
        this.fileInfoCallback.remove(context.getClass().getName());
    }

    public void callState(int code, String message) {
        if (this.callbackFunction == null) {
            return;
        }
        Logger.getLogger().e("ImSdk callback state [" + code + "]");
        this.callbackFunction.ImSdkStateChange(code, message);
    }

    public void callNetwork(int netState) {
        if (this.callbackFunction == null) {
            return;
        }
        Logger.getLogger().d("ImSdk callback network [" + netState + "]");
        this.callbackFunction.ImSdkNetworkChange(netState);
    }

    public void callNew(IMSession session, List<IMMessage> messageList) {
        if (this.callbackFunction == null || messageList == null || messageList.isEmpty()) {
            return;
        }
        Logger.getLogger().d("ImSdk callback new message " + session);
        DebugHelper.logIMMessages("ImSdk callback new message ", messageList);
        this.callbackFunction.NewIMMessageCome(session, messageList);
    }

    public int callVersion(String account) {
        Logger.getLogger().d("ImSdk callback version [" + account + "]");
        int result = this.callbackFunction == null ? -1 : this.callbackFunction.CheckVersion(account);
        Logger.getLogger().d("ImSdk callback version [" + account + ", " + result + "]");
        return result;
    }

    public String getNoticeByAccount(String account, String groupId) {
        Logger.getLogger().d("ImSdk callback get notice [" + account + "]");
        String result = this.callbackFunction == null ? "" : this.callbackFunction.GetNoticeByAccount(account, groupId);
        Logger.getLogger().d("ImSdk callback get notice [" + account + ", " + result + "]");
        return result;
    }

    public void callCacheSize(boolean end, long size) {
        if (this.callbackFunction == null) {
            Log.e((String)"ImSdk", (String)"ImSdk have not ready... ");
            return;
        }
        Logger.getLogger().d("ImSdk cache size = " + size + ", end = " + end);
        this.callbackFunction.CacheSize(end, size);
    }

    public boolean canLog() {
        return this.callbackFunction != null;
    }

    public void callbackLog(int priority, String tag, String msg, Throwable throwable) {
        if (this.callbackFunction == null) {
            Log.e((String)tag, (String)msg);
            return;
        }
        this.callbackFunction.ImSdkLog(priority, tag, msg, throwable);
    }

    public int getSendExt() {
        int result = this.callbackFunction == null ? 0 : this.callbackFunction.GetSendExt();
        Logger.getLogger().d("ImSdk callback get send param result [" + result + "]");
        return result;
    }

    public void callChange(IMSession session, IMMessage message) {
        Logger.getLogger().d("ImSdk callback message state change refresh message list " + session + message);
        if (session == null || message == null) {
            return;
        }
        ArrayList<IMMessage> list = new ArrayList<IMMessage>();
        list.add(message);
        this.callMessage(session, list, ChangeAction.ACT_SC);
        if (ImSdkConfigManager.getInstance().needChange() && session.getLastMessage() != null && session.getLastMessage().getIMMessageId() == message.getIMMessageId()) {
            Logger.getLogger().d("ImSdk callback message state change refresh session " + session);
            this.callSession(session, ChangeAction.ACT_SC);
        }
    }

    public void callSession(IMSession session, ChangeAction action) {
        Iterator<Map.Entry<String, IMSessionCallback>> it = this.sessionCallback.entrySet().iterator();
        if (it.hasNext()) {
            IMSessionCallback callback = it.next().getValue();
            Logger.getLogger().d("ImSdk callback session change refresh session " + session);
            callback.IMSessionListChange(session, action);
        }
    }

    public void callMessage(IMSession session, List<IMMessage> messageList, ChangeAction action) {
        Iterator<Map.Entry<String, IMMessageCallback>> it = this.messageCallback.entrySet().iterator();
        if (it.hasNext()) {
            IMMessageCallback callback = it.next().getValue();
            Logger.getLogger().d("ImSdk callback message change refresh message " + session + ", " + (Object)((Object)action));
            DebugHelper.logIMMessages("ImSdk callback message change ", messageList);
            callback.IMMessageListChange(session, messageList, action);
        }
    }

    public void callRecall(IMSession session, IMMessage message, int code) {
        Iterator<Map.Entry<String, IMMessageCallback>> it = this.messageCallback.entrySet().iterator();
        if (it.hasNext()) {
            IMMessageCallback callback = it.next().getValue();
            Logger.getLogger().d("ImSdk callback message recalled " + code + ", " + session + ", " + message);
            callback.IMMessageRecall(session, message, code);
        }
    }

    public void callStrictly(IMSession session) {
        Iterator<Map.Entry<String, IMSessionCallback>> it = this.sessionCallback.entrySet().iterator();
        if (it.hasNext()) {
            IMSessionCallback callback = it.next().getValue();
            Logger.getLogger().d("ImSdk callback session strictly refresh session " + session);
            callback.IMSessionStrictlyDestroy(session);
        }
    }

    @Nullable
    public SignResult getSign(@NonNull String type, @NonNull String fileId) {
        if (this.callbackFunction == null) {
            return null;
        }
        return this.callbackFunction.requestSign(type, fileId);
    }

    public SecurityResult callEncryptText(String source, SecurityPara para) {
        SecurityResult result;
        Logger.getLogger().d("ImSdk callback encrypt text [" + Logger.getLogger().formatPositive(source) + ", " + para + "]");
        if (this.securityCallback == null) {
            result = null;
            Logger.getLogger().d("ImSdk callback encrypt text result is null, " + para + "]");
        } else {
            result = this.securityCallback.EncryptText(source, para);
            Logger.getLogger().d("ImSdk callback encrypt text result [" + Logger.getLogger().formatReverse(result.getResult()) + ", " + result.getCode() + ", " + para + "]");
        }
        return result;
    }

    public SecurityResult callEncryptFile(String source, String dest, SecurityPara para) {
        SecurityResult result;
        Logger.getLogger().d("ImSdk callback encrypt file [" + source + ", " + dest + ", " + para + "]");
        if (this.securityCallback == null) {
            result = null;
        } else {
            if (!ToolUtils.mkFile(dest)) {
                return null;
            }
            result = this.securityCallback.EncryptFile(source, dest, para);
        }
        Logger.getLogger().d("ImSdk callback encrypt file result [" + result + ", " + para + "]");
        return result;
    }

    public SecurityResult callDecryptText(String source, SecurityPara para) {
        SecurityResult result;
        Logger.getLogger().d("ImSdk callback decrypt text [" + Logger.getLogger().formatReverse(source) + ", " + para + "]");
        if (this.securityCallback == null) {
            result = null;
            Logger.getLogger().d("ImSdk callback decrypt text result is null, " + para + "]");
        } else {
            result = this.securityCallback.DecryptText(source, para);
            Logger.getLogger().d("ImSdk callback decrypt text result [" + Logger.getLogger().formatPositive(result.getResult()) + ", " + result.getCode() + ", " + para + "]");
        }
        return result;
    }

    public SecurityResult callDecryptFile(String source, String dest, SecurityPara para) {
        SecurityResult result;
        Logger.getLogger().d("ImSdk callback decrypt file [" + source + ", " + dest + ", " + para + "]");
        if (this.securityCallback == null) {
            result = null;
        } else {
            if (!ToolUtils.mkFile(dest)) {
                return null;
            }
            result = this.securityCallback.DecryptFile(source, dest, para);
        }
        Logger.getLogger().d("ImSdk callback decrypt file result [" + result + ", " + para + "]");
        return result;
    }

    public void callFile(IMFileInfo fileInfo, Constant.FileCallType type) {
        this.callFile(0, fileInfo, type);
    }

    public void callFile(int code, IMFileInfo fileInfo, Constant.FileCallType type) {
        Logger.getLogger().d("ImSdk callback file opt " + fileInfo + ", " + (Object)((Object)type));
        Iterator<Map.Entry<String, IMFileInfoCallback>> it = this.fileInfoCallback.entrySet().iterator();
        if (it.hasNext()) {
            IMFileInfoCallback callback = it.next().getValue();
            switch (type) {
                case UP_UPDATE: {
                    callback.SendFileProgressUpdate(fileInfo);
                    break;
                }
                case UP_FAIL: {
                    callback.SendFileFail(fileInfo);
                    break;
                }
                case UP_FINISH: {
                    callback.SendFileFinish(fileInfo);
                    break;
                }
                case DOWN_UPDATE: {
                    callback.ReceiveFileProgressUpdate(fileInfo);
                    break;
                }
                case DOWN_FAIL: {
                    callback.ReceiveFileFail(code, fileInfo);
                    break;
                }
                case DOWN_FINISH: {
                    callback.ReceiveFileFinish(fileInfo);
                    break;
                }
                case DOWN_PAUSE: {
                    callback.ReceiveFilePaused(fileInfo);
                    break;
                }
            }
        }
    }

    public void callReceipts(long id, Map<String, List<String>> accounts) {
        Iterator<Map.Entry<String, IMMessageCallback>> it = this.messageCallback.entrySet().iterator();
        if (it.hasNext()) {
            IMMessageCallback callback = it.next().getValue();
            Logger.getLogger().d("ImSdk callback message receipts [" + id + ", " + accounts + "]");
            callback.IMMessageReceipts(id, accounts);
        }
    }

    @NonNull
    public String getTicket() {
        if (this.callbackFunction != null) {
            return this.callbackFunction.getTicket();
        }
        return "";
    }

    private static class Factory {
        private Factory() {
        }

        static ImSdkCallbackManager getInstance() {
            return new ImSdkCallbackManager();
        }
    }
}

