/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.manager;

import android.text.TextUtils;
import com.xdja.imsdk.constant.ImSdkFileConstant;
import com.xdja.imsdk.constant.internal.Constant;
import com.xdja.imsdk.db.ImSdkDbUtils;
import com.xdja.imsdk.db.bean.FileMsgDb;
import com.xdja.imsdk.db.bean.HdThumbFileDb;
import com.xdja.imsdk.db.bean.RawFileDb;
import com.xdja.imsdk.db.helper.OptHelper;
import com.xdja.imsdk.db.helper.OptType;
import com.xdja.imsdk.db.helper.UpdateArgs;
import com.xdja.imsdk.db.wrapper.MessageWrapper;
import com.xdja.imsdk.http.file.FileEntry;
import com.xdja.imsdk.http.file.callback.IFileDownloadCallback;
import com.xdja.imsdk.http.file.callback.IFileUploadCallback;
import com.xdja.imsdk.logger.Logger;
import com.xdja.imsdk.manager.ImSdkCallbackManager;
import com.xdja.imsdk.manager.ImSdkConfigManager;
import com.xdja.imsdk.manager.ImSdkManager;
import com.xdja.imsdk.manager.ModelMapper;
import com.xdja.imsdk.manager.build.HttpManagerFactory;
import com.xdja.imsdk.manager.callback.FileCallback;
import com.xdja.imsdk.manager.callback.NetCallback;
import com.xdja.imsdk.model.IMFileInfo;
import com.xdja.imsdk.model.IMMessage;
import com.xdja.imsdk.model.IMSession;
import com.xdja.imsdk.model.body.IMFileBody;
import com.xdja.imsdk.model.body.IMImageBody;
import com.xdja.imsdk.model.body.IMMediaBody;
import com.xdja.imsdk.model.body.IMPicBody;
import com.xdja.imsdk.model.body.IMVideoBody;
import com.xdja.imsdk.util.CRC32Util;
import com.xdja.imsdk.util.FileUtils;
import com.xdja.imsdk.util.ToolUtils;
import java.io.File;
import java.util.List;

public class ImSdkFileManager {
    private static ImSdkFileManager fileManager;
    private NetCallback netCall;
    private FileCallback fileCall;
    IFileUploadCallback uploadCallback = new IFileUploadCallback(){

        @Override
        public void uploadFileProgressUpdate(int percent, FileEntry entry) {
            Logger.getLogger().d("[UPLOAD UPDATE] percent = " + percent + ", entry = " + entry);
            if (entry == null) {
                return;
            }
            int state = entry.getState();
            if (state == 14 || state == 15 || state == 17) {
                ImSdkFileManager.this.updateState(entry.getType(), 16, entry.getId());
            }
            entry.setState(16);
            ImSdkFileManager.this.networkCallback(40000);
            ImSdkFileManager.this.fileCallback(entry, percent, Constant.FileCallType.UP_UPDATE);
        }

        @Override
        public void uploadFileFinish(FileEntry entry) {
            Logger.getLogger().d("[UPLOAD FINISH] entry = " + entry);
            if (entry == null) {
                return;
            }
            long oCRC = CRC32Util.getFileCRC32(entry.getEncryptPath());
            Logger.getLogger().d("UPLOAD FILE CRC32 " + oCRC);
            Logger.getLogger().d("UPLOAD FILE CRC32 " + entry);
            entry.setState(18);
            ImSdkFileManager.this.networkCallback(40000);
            ImSdkFileManager.this.updateTSize(entry);
            ImSdkFileManager.this.uploadNext(entry);
        }

        @Override
        public void uploadFileError(int code, FileEntry entry) {
            Logger.getLogger().d("[UPLOAD ERROR] entry = " + entry);
            if (entry == null) {
                return;
            }
            entry.setState(17);
            ImSdkFileManager.this.updateTSize(entry);
            ImSdkFileManager.this.updateUpState(entry);
            ImSdkFileManager.this.fileCallback(entry, Constant.FileCallType.UP_FAIL);
            ImSdkFileManager.this.stateCallback(entry);
        }

        @Override
        public void uploadFileNetChanged(int code, FileEntry entry) {
            ImSdkFileManager.this.networkCallback(code);
        }

        @Override
        public void uploadFilePause(FileEntry entry) {
            Logger.getLogger().d("[UPLOAD PAUSE] entry = " + entry);
            if (entry == null) {
                return;
            }
            ImSdkFileManager.this.networkCallback(40000);
            entry.setState(15);
            ImSdkFileManager.this.updateTSize(entry);
            ImSdkFileManager.this.fileCallback(entry, Constant.FileCallType.UP_PAUSE);
        }

        @Override
        public void uploadFileStart(FileEntry entry) {
            Logger.getLogger().d("[UPLOAD START] entry = " + entry);
            if (entry == null) {
                return;
            }
            ImSdkFileManager.this.networkCallback(40000);
            if (TextUtils.isEmpty((CharSequence)entry.getFid())) {
                entry.setState(13);
            } else {
                entry.setState(14);
            }
            ImSdkFileManager.this.updateFid(entry);
        }
    };
    IFileDownloadCallback downloadCallback = new IFileDownloadCallback(){

        @Override
        public void downloadFileProgressUpdate(int percent, FileEntry entry) {
            Logger.getLogger().d("[DOWNLOAD UPDATE] percent = " + percent + ", entry = " + entry);
            if (entry == null) {
                return;
            }
            ImSdkFileManager.this.networkCallback(40000);
            int state = entry.getState();
            if (state != 22) {
                ImSdkFileManager.this.updateState(entry.getType(), 22, entry.getId());
            }
            entry.setState(22);
            ImSdkFileManager.this.fileCallback(entry, percent, Constant.FileCallType.DOWN_UPDATE);
        }

        @Override
        public void downloadFileFinish(FileEntry entry) {
            Logger.getLogger().d("[DOWNLOAD FINISH] entry = " + entry);
            if (entry == null) {
                return;
            }
            ImSdkFileManager.this.networkCallback(40000);
            entry.setState(24);
            ImSdkFileManager.this.updateTSize(entry);
            ImSdkFileManager.this.fileDownFinish(entry);
        }

        @Override
        public void downloadFileError(int code, FileEntry entry) {
            Logger.getLogger().d("[DOWNLOAD ERROR] code = " + code + ", entry = " + entry);
            if (entry == null) {
                return;
            }
            entry.setState(23);
            ImSdkFileManager.this.updateTSize(entry);
            ImSdkFileManager.this.fileCallback(code, entry, Constant.FileCallType.DOWN_FAIL);
            ImSdkFileManager.this.stateCallback(entry);
        }

        @Override
        public void downloadNetChanged(int code, FileEntry entry) {
            ImSdkFileManager.this.networkCallback(code);
        }

        @Override
        public void downloadFilePause(FileEntry entry) {
            Logger.getLogger().d("[DOWNLOAD PAUSE] entry = " + entry);
            if (entry == null) {
                return;
            }
            ImSdkFileManager.this.networkCallback(40000);
            entry.setState(21);
            ImSdkFileManager.this.updateTSize(entry);
            ImSdkFileManager.this.fileCallback(entry, Constant.FileCallType.DOWN_PAUSE);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImSdkFileManager getInstance() {
        Class<ImSdkFileManager> clazz = ImSdkFileManager.class;
        synchronized (ImSdkFileManager.class) {
            if (fileManager == null) {
                fileManager = Factory.getInstance();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return fileManager;
        }
    }

    public void init(FileCallback file, NetCallback net) {
        this.fileCall = file;
        this.netCall = net;
    }

    public void cancelAll() {
        if (ImSdkConfigManager.getInstance().isDecryptMode()) {
            String tmpFile = ImSdkConfigManager.getInstance().getParentPath();
            this.deleteFile(tmpFile);
            String tmpNormal = ImSdkConfigManager.getInstance().getRecPath();
            this.deleteFile(tmpNormal);
        }
    }

    public void decryptFile(MessageWrapper message, ImSdkFileConstant.FileType type) {
        this.fileCall.DecryptFile(message, type);
    }

    public void uploadFile(MessageWrapper wrapper) {
        FileMsgDb msg = wrapper.getFileMsgDb();
        if (msg == null || TextUtils.isEmpty((CharSequence)msg.getFile_path())) {
            Logger.getLogger().e("File is null!!!");
            return;
        }
        int state = msg.getFile_state();
        this.uploadExpect(state, wrapper, ImSdkFileConstant.FileType.IS_SHOW);
    }

    public void filePauseResume(IMFileInfo fileInfo, Constant.FileOptType type) {
        if (fileInfo == null || fileInfo.getMessage() == null) {
            return;
        }
        switch (type) {
            case UP_PAUSE: {
                this.uploadPause(fileInfo);
                break;
            }
            case UP_RESUME: {
                this.uploadResume(fileInfo);
                break;
            }
            case DOWN_PAUSE: {
                this.downloadPause(fileInfo);
                break;
            }
            case DOWN_RESUME: {
                this.downloadResume(fileInfo);
                break;
            }
        }
    }

    public void downloadStart(List<IMFileInfo> files) {
        if (files == null || files.isEmpty()) {
            return;
        }
        for (IMFileInfo file : files) {
            if (file == null || file.getMessage() == null) continue;
            MessageWrapper message = this.queryMessage(file.getMessage().getIMMessageId(), file.getFileType());
            FileEntry entry = this.getFileEntry(message, file.getFileType());
            this.downloadExpect(entry.getState(), entry);
        }
    }

    public void downloadPreStart(List<MessageWrapper> files) {
        if (files == null || files.isEmpty()) {
            return;
        }
        for (MessageWrapper file : files) {
            FileEntry entry = this.getFileEntry(file, ImSdkFileConstant.FileType.IS_SHOW);
            this.downloadStart(entry);
        }
    }

    public void downloadAgain(MessageWrapper message, ImSdkFileConstant.FileType type) {
        FileEntry entry = ModelMapper.getIns().getFileEntry(message, type);
        entry.setCount(1);
        this.downloadStart(entry);
    }

    public void downFinishCallback(IMFileInfo fileInfo, FileEntry entry) {
        IMImageBody imageBody;
        if (fileInfo == null) {
            return;
        }
        if (fileInfo.getMessage() == null || fileInfo.getMessage().getMessageBody() == null) {
            return;
        }
        IMFileBody body = (IMFileBody)fileInfo.getMessage().getMessageBody();
        if (body == null) {
            return;
        }
        if (fileInfo.getFileType() == ImSdkFileConstant.FileType.IS_SHOW && ToolUtils.fileExist(body.getLocalPath())) {
            this.changeStateAndCallbackFinish(fileInfo, fileInfo.getMessage(), entry.isNormal());
            return;
        }
        if (fileInfo.getFileType() == ImSdkFileConstant.FileType.IS_HD && body.isImage() && (imageBody = (IMImageBody)body).getHdTFileInfo() != null && ToolUtils.fileExist(imageBody.getHdTFileInfo().getHdTLocalPath())) {
            ImSdkCallbackManager.getInstance().callFile(fileInfo, Constant.FileCallType.DOWN_FINISH);
            return;
        }
        if (fileInfo.getFileType() == ImSdkFileConstant.FileType.IS_RAW) {
            IMMediaBody mediaBody;
            IMVideoBody videoBody;
            IMPicBody picBody;
            if (body.isImage() && (imageBody = (IMImageBody)body).getRawFileInfo() != null && ToolUtils.fileExist(imageBody.getRawFileInfo().getRawLocalPath())) {
                ImSdkCallbackManager.getInstance().callFile(fileInfo, Constant.FileCallType.DOWN_FINISH);
                return;
            }
            if (body.isPic() && (picBody = (IMPicBody)body).getRawFileInfo() != null && ToolUtils.fileExist(picBody.getRawFileInfo().getRawLocalPath())) {
                ImSdkCallbackManager.getInstance().callFile(fileInfo, Constant.FileCallType.DOWN_FINISH);
                return;
            }
            if (body.isVideo() && (videoBody = (IMVideoBody)body).getRawFileInfo() != null && ToolUtils.fileExist(videoBody.getRawFileInfo().getRawLocalPath())) {
                ImSdkCallbackManager.getInstance().callFile(fileInfo, Constant.FileCallType.DOWN_FINISH);
                return;
            }
            if (body.isMedia() && (mediaBody = (IMMediaBody)body).getRawFileInfo() != null && ToolUtils.fileExist(mediaBody.getRawFileInfo().getRawLocalPath())) {
                ImSdkCallbackManager.getInstance().callFile(fileInfo, Constant.FileCallType.DOWN_FINISH);
                return;
            }
        }
        Logger.getLogger().e("Download file -> decrypt file not exist: " + entry);
        this.fileDownFinish(entry);
    }

    public void changeStateAndCallbackFinish(IMFileInfo fileInfo, IMMessage message, boolean needChange) {
        ImSdkCallbackManager.getInstance().callFile(fileInfo, Constant.FileCallType.DOWN_FINISH);
        if (needChange) {
            ImSdkManager.getInstance().changeMessageState(message, 3);
        }
    }

    private void reDownloadFile(IMFileInfo fileInfo) {
        this.updateState(fileInfo.getFileType(), 20, fileInfo.getMessage().getIMMessageId());
        MessageWrapper message = this.queryMessage(fileInfo.getMessage().getIMMessageId(), fileInfo.getFileType());
        FileEntry entry = this.getFileEntry(message, fileInfo.getFileType());
        this.downloadExpect(entry.getState(), entry);
    }

    private void uploadExpect(int state, MessageWrapper msg, ImSdkFileConstant.FileType type) {
        switch (state) {
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                FileEntry start = this.getFileEntry(msg, type);
                start.settSize(0L);
                this.uploadStart(start);
                break;
            }
            case 15: {
                FileEntry resume = this.getFileEntry(msg, type);
                this.uploadResume(resume);
                break;
            }
            case 18: {
                this.uploadNext(msg, type);
                break;
            }
            case 10: 
            case 11: {
                Logger.getLogger().e("should encrypt file first...");
                break;
            }
            case 16: {
                Logger.getLogger().d("file already uploading...");
                break;
            }
        }
    }

    private void downloadExpect(int state, FileEntry entry) {
        switch (state) {
            case 20: 
            case 23: {
                this.downloadStart(entry);
                break;
            }
            case 21: {
                this.downloadResume(entry);
                break;
            }
            case 24: 
            case 25: {
                this.fileDownFinish(entry);
                break;
            }
            case 26: {
                IMFileInfo fileInfo = ModelMapper.getIns().mapFileInfo(entry);
                this.downFinishCallback(fileInfo, entry);
                break;
            }
            case 22: {
                Logger.getLogger().d("file already downloading...");
                break;
            }
        }
    }

    private void uploadStart(FileEntry entry) {
        HttpManagerFactory.getHttpManager().uploadStart(entry, this.uploadCallback);
    }

    private void uploadResume(FileEntry entry) {
        HttpManagerFactory.getHttpManager().uploadFileResume(entry, this.uploadCallback);
    }

    private void uploadNext(MessageWrapper msg, ImSdkFileConstant.FileType type) {
        if (type == ImSdkFileConstant.FileType.IS_SHOW) {
            FileMsgDb file = msg.getFileMsgDb();
            if (file == null) {
                return;
            }
            if (file.isImage()) {
                this.sendHd(msg);
                return;
            }
            if (file.onlyThuAndRaw()) {
                this.sendRaw(msg);
                return;
            }
            FileEntry entry = this.getFileEntry(msg, ImSdkFileConstant.FileType.IS_SHOW);
            this.uploadFinish(entry);
            return;
        }
        if (type == ImSdkFileConstant.FileType.IS_HD) {
            this.sendRaw(msg);
            return;
        }
        if (type == ImSdkFileConstant.FileType.IS_RAW) {
            FileEntry entry = this.getFileEntry(msg, ImSdkFileConstant.FileType.IS_RAW);
            if (entry == null || TextUtils.isEmpty((CharSequence)entry.getPath())) {
                return;
            }
            this.uploadFinish(entry);
        }
    }

    private void sendHd(MessageWrapper wrapper) {
        HdThumbFileDb hd = wrapper.getHdThumbFileDb();
        if (hd == null || TextUtils.isEmpty((CharSequence)hd.getHd_file_path())) {
            this.uploadErrorCallback(wrapper, ImSdkFileConstant.FileType.IS_HD);
            return;
        }
        int hdState = hd.getHd_state();
        this.uploadExpect(hdState, wrapper, ImSdkFileConstant.FileType.IS_HD);
    }

    private void sendRaw(MessageWrapper wrapper) {
        RawFileDb raw = wrapper.getRawFileDb();
        if (raw == null || TextUtils.isEmpty((CharSequence)raw.getRaw_file_path())) {
            if (wrapper.getFileMsgDb().isImage()) {
                FileEntry entry = this.getFileEntry(wrapper, ImSdkFileConstant.FileType.IS_RAW);
                this.uploadFinish(entry);
                return;
            }
            this.uploadErrorCallback(wrapper, ImSdkFileConstant.FileType.IS_RAW);
            return;
        }
        int rawState = raw.getRaw_state();
        this.uploadExpect(rawState, wrapper, ImSdkFileConstant.FileType.IS_RAW);
    }

    private void uploadFinish(FileEntry entry) {
        ImSdkCallbackManager.getInstance().callFile(ModelMapper.getIns().mapFileInfo(entry), Constant.FileCallType.UP_FINISH);
        this.fileCall.SendFileText(entry.getId());
        if (ImSdkConfigManager.getInstance().isDefaultMode()) {
            this.clearFileCache(entry.getId());
        }
    }

    private void uploadErrorCallback(MessageWrapper wrapper, ImSdkFileConstant.FileType type) {
        if (wrapper == null || wrapper.getMsgEntryDb() == null) {
            return;
        }
        UpdateArgs updateArgs = OptHelper.getIns().getMCUpdate(ToolUtils.getLong(wrapper.getMsgEntryDb().getId()), -8);
        ImSdkDbUtils.update(updateArgs);
        IMMessage message = ModelMapper.getIns().mapMessage(wrapper);
        IMFileInfo file = new IMFileInfo(message);
        file.setPercent(0);
        file.setFileType(type);
        file.setState(ImSdkFileConstant.FileState.FAIL);
        this.uploadError(file);
    }

    private void uploadPause(IMFileInfo file) {
        long id = file.getMessage().getIMMessageId();
        ImSdkFileConstant.FileType type = file.getFileType();
        this.updateState(type, 15, id);
        FileEntry entry = this.queryFileEntry(id, type);
        HttpManagerFactory.getHttpManager().uploadFilePause(entry);
    }

    private void uploadResume(IMFileInfo file) {
        long id = file.getMessage().getIMMessageId();
        ImSdkFileConstant.FileType type = file.getFileType();
        MessageWrapper message = this.queryMessage(id, type);
        if (type == ImSdkFileConstant.FileType.IS_SHOW) {
            FileMsgDb fileDb = message.getFileMsgDb();
            if (fileDb == null) {
                return;
            }
            this.uploadExpect(fileDb.getFile_state(), message, type);
        }
        if (type == ImSdkFileConstant.FileType.IS_HD) {
            HdThumbFileDb hdDb = message.getHdThumbFileDb();
            if (hdDb == null) {
                return;
            }
            this.uploadExpect(hdDb.getHd_state(), message, type);
        }
        if (type == ImSdkFileConstant.FileType.IS_RAW) {
            RawFileDb rawDb = message.getRawFileDb();
            if (rawDb == null) {
                return;
            }
            this.uploadExpect(rawDb.getRaw_state(), message, type);
        }
    }

    private void uploadError(IMFileInfo file) {
        ImSdkCallbackManager.getInstance().callFile(file, Constant.FileCallType.UP_FAIL);
    }

    private void downloadStart(FileEntry entry) {
        HttpManagerFactory.getHttpManager().downloadStart(entry, this.downloadCallback);
    }

    private void downloadResume(FileEntry entry) {
        this.updateState(entry.getType(), 22, entry.getId());
        HttpManagerFactory.getHttpManager().downloadFileResume(entry, this.downloadCallback);
    }

    private void downloadPause(IMFileInfo file) {
        long id = file.getMessage().getIMMessageId();
        ImSdkFileConstant.FileType type = file.getFileType();
        this.updateState(type, 21, id);
        FileEntry entry = this.queryFileEntry(id, type);
        HttpManagerFactory.getHttpManager().downloadFilePause(entry);
    }

    private void downloadResume(IMFileInfo file) {
        long id = file.getMessage().getIMMessageId();
        ImSdkFileConstant.FileType type = file.getFileType();
        MessageWrapper message = this.queryMessage(id, type);
        if (type == ImSdkFileConstant.FileType.IS_SHOW) {
            FileMsgDb fileDb = message.getFileMsgDb();
            if (fileDb == null) {
                return;
            }
            this.downloadExpect(fileDb.getFile_state(), this.getFileEntry(message, type));
        }
        if (type == ImSdkFileConstant.FileType.IS_HD) {
            HdThumbFileDb hdDb = message.getHdThumbFileDb();
            if (hdDb == null) {
                return;
            }
            this.downloadExpect(hdDb.getHd_state(), this.getFileEntry(message, type));
        }
        if (type == ImSdkFileConstant.FileType.IS_RAW) {
            RawFileDb rawDb = message.getRawFileDb();
            if (rawDb == null) {
                return;
            }
            this.downloadExpect(rawDb.getRaw_state(), this.getFileEntry(message, type));
        }
    }

    private void fileDownFinish(FileEntry entry) {
        if (ImSdkConfigManager.getInstance().needEncrypt()) {
            MessageWrapper message = ImSdkDbUtils.queryMessage(OptHelper.getIns().getAMQuery(entry.getId()), OptType.MQuery.ALL);
            if (message == null) {
                return;
            }
            if (ImSdkConfigManager.getInstance().noDecrypt() || message.isService()) {
                IMFileInfo fileInfo = ModelMapper.getIns().mapFileInfo(entry);
                this.updateState(entry.getType(), 26, entry.getId());
                this.changeStateAndCallbackFinish(fileInfo, fileInfo.getMessage(), entry.isNormal());
                return;
            }
            if (message.isRecalled()) {
                return;
            }
            File encryptFile = new File(entry.getEncryptPath());
            if (encryptFile.exists()) {
                this.fileCall.DecryptFile(message, entry.getType());
            } else {
                Logger.getLogger().e("Download file -> encrypt file not exist: " + entry);
                if (entry.isFinish()) {
                    IMFileInfo fileInfo = ModelMapper.getIns().mapFileInfo(entry);
                    ImSdkCallbackManager.getInstance().callFile(fileInfo, Constant.FileCallType.DOWN_FAIL);
                } else {
                    this.downloadStart(entry);
                }
            }
        } else {
            IMFileInfo fileInfo = ModelMapper.getIns().mapFileInfo(entry);
            this.updateState(entry.getType(), 26, entry.getId());
            this.changeStateAndCallbackFinish(fileInfo, fileInfo.getMessage(), entry.isNormal());
        }
    }

    private void stateCallback(FileEntry entry) {
        long id = entry.getId();
        MessageWrapper wrapper = ImSdkDbUtils.queryMessage(OptHelper.getIns().getAMQuery(id), OptType.MQuery.ALL);
        if (wrapper.getMsgEntryDb() == null) {
            return;
        }
        IMMessage message = ModelMapper.getIns().mapMessage(wrapper);
        String tag = wrapper.getMsgEntryDb().getSession_flag();
        IMSession session = ModelMapper.getIns().mapSession(ImSdkDbUtils.querySession(OptHelper.getIns().getSMQuery(tag), OptType.SQuery.HAVE));
        if (message == null || session == null) {
            return;
        }
        ImSdkCallbackManager.getInstance().callChange(session, message);
    }

    private FileEntry queryFileEntry(long id, ImSdkFileConstant.FileType type) {
        MessageWrapper message = this.queryMessage(id, type);
        return this.getFileEntry(message, type);
    }

    private MessageWrapper queryMessage(long id, ImSdkFileConstant.FileType type) {
        return ImSdkDbUtils.queryMessage(OptHelper.getIns().getFQuery(id, type), type);
    }

    private FileEntry getFileEntry(MessageWrapper message, ImSdkFileConstant.FileType type) {
        return ModelMapper.getIns().getFileEntry(message, type);
    }

    private void updateFid(FileEntry entry) {
        ImSdkDbUtils.update(OptHelper.getIns().getFFUpdate(entry.getType(), entry.getFid(), entry.getState(), entry.getId()));
    }

    private void updateTSize(FileEntry entry) {
        ImSdkDbUtils.update(OptHelper.getIns().getFTUpdate(entry.getType(), entry.gettSize(), entry.getState(), entry.getId()));
    }

    private void updateState(ImSdkFileConstant.FileType type, int state, long id) {
        ImSdkDbUtils.update(OptHelper.getIns().getFTUpdate(type, -1L, state, id));
    }

    private void updateUpState(FileEntry entry) {
        UpdateArgs file = OptHelper.getIns().getFTUpdate(entry.getType(), entry.gettSize(), entry.getState(), entry.getId());
        UpdateArgs message = OptHelper.getIns().getMSUpdate(entry.getId(), -8);
        ImSdkDbUtils.updateMF(message, file);
    }

    private void uploadNext(FileEntry entry) {
        if (entry.isShow()) {
            if (entry.isImage()) {
                ImSdkFileConstant.FileType type = ImSdkFileConstant.FileType.IS_HD;
                MessageWrapper message = this.queryMessage(entry.getId(), type);
                FileEntry hdFile = this.getFileEntry(message, type);
                hdFile.setSuffix(entry.getSuffix());
                this.uploadStart(hdFile);
                return;
            }
            if (entry.isVideo() || entry.isPic() || entry.isMedia()) {
                ImSdkFileConstant.FileType type = ImSdkFileConstant.FileType.IS_RAW;
                MessageWrapper message = this.queryMessage(entry.getId(), type);
                FileEntry hdFile = this.getFileEntry(message, type);
                hdFile.setSuffix(entry.getSuffix());
                this.uploadStart(hdFile);
                return;
            }
        }
        if (entry.getType() == ImSdkFileConstant.FileType.IS_HD && entry.isImage()) {
            ImSdkFileConstant.FileType type = ImSdkFileConstant.FileType.IS_RAW;
            MessageWrapper wrapper = this.queryMessage(entry.getId(), type);
            if (wrapper.getRawFileDb() != null) {
                FileEntry rawFile = this.getFileEntry(wrapper, type);
                rawFile.setSuffix(entry.getSuffix());
                this.uploadStart(rawFile);
                return;
            }
        }
        this.uploadFinish(entry);
    }

    private void networkCallback(int code) {
        this.netCall.NetChanged(code);
    }

    private void fileCallback(FileEntry entry, int percent, Constant.FileCallType type) {
        IMFileInfo fileInfo = ModelMapper.getIns().mapFileInfo(entry);
        fileInfo.setPercent(percent);
        ImSdkCallbackManager.getInstance().callFile(fileInfo, type);
    }

    private void fileCallback(FileEntry entry, Constant.FileCallType type) {
        this.fileCallback(0, entry, type);
    }

    private void fileCallback(int code, FileEntry entry, Constant.FileCallType type) {
        IMFileInfo fileInfo = ModelMapper.getIns().mapFileInfo(entry);
        ImSdkCallbackManager.getInstance().callFile(code, fileInfo, type);
    }

    private void clearFileCache(long id) {
        if (!ImSdkConfigManager.getInstance().needEncrypt()) {
            return;
        }
        MessageWrapper message = ImSdkDbUtils.queryMessage(OptHelper.getIns().getAMQuery(id), OptType.MQuery.ALL);
        if (message == null || message.getMsgEntryDb() == null) {
            return;
        }
        if (message.isFile() || message.isWeb()) {
            RawFileDb raw;
            HdThumbFileDb hd;
            FileMsgDb show = message.getFileMsgDb();
            if (show != null) {
                String showPath = show.getEncrypt_path();
                this.deleteFile(showPath);
            }
            if ((hd = message.getHdThumbFileDb()) != null) {
                String hdPath = hd.getHd_encrypt_path();
                this.deleteFile(hdPath);
            }
            if ((raw = message.getRawFileDb()) != null) {
                String rawPath = raw.getRaw_encrypt_path();
                this.deleteFile(rawPath);
            }
        }
    }

    private void deleteFile(String path) {
        FileUtils.deleteFile(path);
    }

    private static class Factory {
        private Factory() {
        }

        static ImSdkFileManager getInstance() {
            return new ImSdkFileManager();
        }
    }
}

