/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.manager;

import android.text.TextUtils;
import com.xdja.google.gson.reflect.TypeToken;
import com.xdja.imsdk.constant.ImSdkFileConstant;
import com.xdja.imsdk.constant.internal.Constant;
import com.xdja.imsdk.db.bean.AttentionMsgDb;
import com.xdja.imsdk.db.bean.DuplicateIdDb;
import com.xdja.imsdk.db.bean.FileMsgDb;
import com.xdja.imsdk.db.bean.HdThumbFileDb;
import com.xdja.imsdk.db.bean.LocalStateMsgDb;
import com.xdja.imsdk.db.bean.MsgEntryDb;
import com.xdja.imsdk.db.bean.OptionsDb;
import com.xdja.imsdk.db.bean.RawFileDb;
import com.xdja.imsdk.db.bean.SessionEntryDb;
import com.xdja.imsdk.db.bean.SyncIdDb;
import com.xdja.imsdk.db.wrapper.MessageWrapper;
import com.xdja.imsdk.db.wrapper.SessionWrapper;
import com.xdja.imsdk.http.bean.MsgBean;
import com.xdja.imsdk.http.bean.StateBean;
import com.xdja.imsdk.http.file.FileEntry;
import com.xdja.imsdk.logger.Logger;
import com.xdja.imsdk.manager.ImSdkCallbackManager;
import com.xdja.imsdk.manager.ImSdkConfigManager;
import com.xdja.imsdk.manager.ImSdkFileManager;
import com.xdja.imsdk.model.IMFileInfo;
import com.xdja.imsdk.model.IMMessage;
import com.xdja.imsdk.model.IMSession;
import com.xdja.imsdk.model.body.IMATBody;
import com.xdja.imsdk.model.body.IMFileBody;
import com.xdja.imsdk.model.body.IMImageBody;
import com.xdja.imsdk.model.body.IMMediaBody;
import com.xdja.imsdk.model.body.IMNormalFileBody;
import com.xdja.imsdk.model.body.IMPicBody;
import com.xdja.imsdk.model.body.IMRecallBody;
import com.xdja.imsdk.model.body.IMRichMediaBody;
import com.xdja.imsdk.model.body.IMSystemBody;
import com.xdja.imsdk.model.body.IMTextBody;
import com.xdja.imsdk.model.body.IMVideoBody;
import com.xdja.imsdk.model.body.IMVoiceBody;
import com.xdja.imsdk.model.body.IMWebBody;
import com.xdja.imsdk.model.file.IMHDThumbFileInfo;
import com.xdja.imsdk.model.file.IMRawFileInfo;
import com.xdja.imsdk.model.internal.IMContent;
import com.xdja.imsdk.model.internal.IMHd;
import com.xdja.imsdk.model.internal.IMRaw;
import com.xdja.imsdk.model.internal.IMState;
import com.xdja.imsdk.model.internal.IMWeb;
import com.xdja.imsdk.model.internal.IMWebAttached;
import com.xdja.imsdk.model.internal.content.RemindContent;
import com.xdja.imsdk.model.internal.content.WebContent;
import com.xdja.imsdk.model.internal.extra.PicExtraInfo;
import com.xdja.imsdk.model.internal.extra.VideoExtraInfo;
import com.xdja.imsdk.model.internal.extra.VoiceExtraInfo;
import com.xdja.imsdk.model.internal.old.OldExtra;
import com.xdja.imsdk.model.internal.old.OldFile;
import com.xdja.imsdk.security.SecurityPara;
import com.xdja.imsdk.security.SecurityResult;
import com.xdja.imsdk.util.Base64RFC1521Util;
import com.xdja.imsdk.util.FileUtils;
import com.xdja.imsdk.util.JsonUtils;
import com.xdja.imsdk.util.ToolUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModelMapper {
    private static ModelMapper modelMapper;
    private String account = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelMapper getIns() {
        Class<ModelMapper> clazz = ModelMapper.class;
        synchronized (ModelMapper.class) {
            if (modelMapper == null) {
                modelMapper = Factory.getInstance();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return modelMapper;
        }
    }

    public void init(String account) {
        if (!TextUtils.isEmpty((CharSequence)account)) {
            this.account = account;
        }
    }

    public SessionWrapper getSWrapper(String tag, IMMessage message) {
        SessionWrapper wrapper = new SessionWrapper();
        SessionEntryDb session = new SessionEntryDb();
        session.setSession_flag(tag);
        if (TextUtils.isEmpty((CharSequence)message.getFrom())) {
            message.setFrom(this.account);
        }
        session.setIm_partner(this.getImPartner(message));
        if (message.isGroupIMMessage()) {
            session.setSession_type(2);
        } else if (message.isServiceMessage() || message.isRichMedia()) {
            session.setSession_type(100);
        } else if (message.isAssistant()) {
            session.setSession_type(201);
        } else {
            session.setSession_type(1);
        }
        session.setSession_flag(tag);
        session.setLast_msg(0L);
        session.setStart_time(ImSdkConfigManager.getInstance().getCurrentMillis());
        session.setLast_time(0L);
        session.setReminded(0);
        session.setStrictly(0);
        wrapper.setSessionEntryDb(session);
        return wrapper;
    }

    public List<IMState> getStates(List<MessageWrapper> wrappers) {
        ArrayList<StateBean> beans = new ArrayList<StateBean>();
        for (MessageWrapper msg : wrappers) {
            StateBean bean = this.getStateBean(msg);
            if (bean == null) continue;
            beans.add(bean);
        }
        return this.subStates(beans);
    }

    private StateBean getStateBean(MessageWrapper message) {
        StateBean bean = new StateBean();
        MsgEntryDb entry = message.getMsgEntryDb();
        if (entry != null) {
            bean.setF(this.account);
            bean.setC(String.valueOf(entry.getServer_id()));
            bean.setStat(entry.getState());
            if (entry.isGroup()) {
                bean.setTo(entry.getReceiver());
                bean.setT(20);
                if (entry.getState() < 3) {
                    return bean;
                }
            } else {
                bean.setTo(entry.getSender());
                bean.setT(16);
                return bean;
            }
        }
        return null;
    }

    public SessionWrapper getSWrapper(MsgBean msgBean) {
        SessionWrapper wrapper = new SessionWrapper();
        SessionEntryDb session = new SessionEntryDb();
        session.setIm_partner(this.getImPartner(msgBean));
        if (msgBean.isSubType()) {
            session.setSession_type(201);
        } else if (msgBean.isGroupMsg() && !msgBean.isSubType()) {
            session.setSession_type(2);
        } else if (msgBean.isServiceMsg() || msgBean.isRichMedia()) {
            session.setSession_type(100);
        } else {
            session.setSession_type(1);
        }
        session.setSession_flag(ToolUtils.getSessionTag(session.getIm_partner(), session.getSession_type()));
        session.setLast_msg(0L);
        session.setStart_time(ImSdkConfigManager.getInstance().getCurrentMillis());
        session.setLast_time(0L);
        session.setReminded(0);
        session.setStrictly(0);
        wrapper.setSessionEntryDb(session);
        return wrapper;
    }

    public SecurityPara getSecurityPara(MsgEntryDb msg) {
        SecurityPara para = new SecurityPara();
        if (msg == null) {
            return null;
        }
        para.setMsgId(msg.getId());
        para.setGroup(msg.isGroup());
        if (msg.isGroup()) {
            para.setUser(msg.getSender());
            para.setPerson(msg.getReceiver());
        } else if (TextUtils.equals((CharSequence)msg.getSender(), (CharSequence)this.account)) {
            para.setUser(msg.getSender());
            para.setPerson(msg.getReceiver());
        } else {
            para.setUser(msg.getReceiver());
            para.setPerson(msg.getSender());
        }
        return para;
    }

    public SessionWrapper getSWrapper(IMSession session) {
        SessionWrapper wrapper = new SessionWrapper();
        SessionEntryDb entry = new SessionEntryDb();
        if (session.getDisplayTime() > 0L) {
            entry.setStart_time(session.getDisplayTime());
            entry.setLast_time(session.getDisplayTime());
        } else {
            entry.setStart_time(ImSdkConfigManager.getInstance().getCurrentMillis());
            entry.setLast_time(ImSdkConfigManager.getInstance().getCurrentMillis());
        }
        entry.setReminded(session.getRemindCount());
        entry.setStrictly(0);
        entry.setIm_partner(session.getImPartner());
        entry.setSession_type(session.getSessionType());
        entry.setLast_msg(0L);
        entry.setSession_flag(ToolUtils.getSessionTag(session.getImPartner(), session.getSessionType()));
        wrapper.setSessionEntryDb(entry);
        return wrapper;
    }

    public MessageWrapper getMWrapper(String tag, IMMessage message) {
        MessageWrapper wrapper = new MessageWrapper();
        MsgEntryDb msg = new MsgEntryDb();
        msg.setCard_id(message.getCardId());
        msg.setReceiver(message.getTo());
        msg.setType(message.getType());
        msg.setState(message.getState());
        msg.setSession_flag(tag);
        msg.setCreate_time(ImSdkConfigManager.getInstance().getCurrentNano());
        msg.setServer_id(-msg.getCreate_time().longValue());
        msg.setSort_time(ImSdkConfigManager.getInstance().getCurrentMillis());
        if (message.isAssistant()) {
            msg.setExtra_state(message.getExtraState());
        } else {
            msg.setExtra_state(0);
        }
        if (message.isCustom()) {
            if (!TextUtils.equals((CharSequence)this.account, (CharSequence)message.getFrom())) {
                msg.setAttr(1);
            } else {
                msg.setAttr(0);
            }
        } else {
            msg.setAttr(0);
        }
        if (message.isBombIMMessage()) {
            msg.setLife_time(ImSdkConfigManager.getInstance().getFlashTime());
        } else {
            msg.setLife_time(message.getTimeToLive());
        }
        if (TextUtils.isEmpty((CharSequence)message.getFrom())) {
            msg.setSender(this.account);
        } else {
            msg.setSender(message.getFrom());
        }
        if (message.isTextIMMessage()) {
            if (message.isATMessage()) {
                IMATBody imatBody = (IMATBody)message.getMessageBody();
                msg.setContent(imatBody.getContent());
                msg.setMsg_extra(JsonUtils.getGson().toJson(imatBody.getAccounts()));
                wrapper.setMsgEntryDb(msg);
                return wrapper;
            }
            IMTextBody textBody = (IMTextBody)message.getMessageBody();
            msg.setContent(textBody.getContent());
            wrapper.setMsgEntryDb(msg);
            return wrapper;
        }
        if (message.isFileIMMessage()) {
            IMFileBody fileBody = (IMFileBody)message.getMessageBody();
            msg.setContent(String.valueOf(fileBody.getType()));
            FileMsgDb file = new FileMsgDb();
            file.setFile_path(fileBody.getLocalPath());
            file.setFile_name(fileBody.getDisplayName());
            file.setFile_size(fileBody.getFileSize());
            file.setType(fileBody.getType());
            file.setFile_state(10);
            file.setSuffix(fileBody.getSuffix());
            file.setEncrypt_size(fileBody.getFileSize());
            file.setTranslate_size(fileBody.getTranslateSize());
            switch (fileBody.getType()) {
                case 0: {
                    break;
                }
                case 1: {
                    IMVoiceBody voiceBody = (IMVoiceBody)message.getMessageBody();
                    VoiceExtraInfo voiceExt = new VoiceExtraInfo(voiceBody.getDuration());
                    file.setExtra_info(JsonUtils.getGson().toJson((Object)voiceExt));
                    break;
                }
                case 3: {
                    IMRawFileInfo iRawInfo;
                    IMImageBody imageBody = (IMImageBody)message.getMessageBody();
                    IMHDThumbFileInfo hdInfo = imageBody.getHdTFileInfo();
                    if (hdInfo != null) {
                        wrapper.setHdThumbFileDb(this.mapHd(hdInfo));
                    }
                    if ((iRawInfo = imageBody.getRawFileInfo()) == null) break;
                    wrapper.setRawFileDb(this.mapRaw(iRawInfo));
                    break;
                }
                case 2: {
                    IMVideoBody videoBody = (IMVideoBody)message.getMessageBody();
                    VideoExtraInfo videoExt = new VideoExtraInfo(videoBody.getDuration(), videoBody.getSize());
                    file.setExtra_info(JsonUtils.getGson().toJson((Object)videoExt));
                    IMRawFileInfo vRawInfo = videoBody.getRawFileInfo();
                    if (vRawInfo == null) break;
                    wrapper.setRawFileDb(this.mapRaw(vRawInfo));
                    break;
                }
                case 5: {
                    IMPicBody picBody = (IMPicBody)message.getMessageBody();
                    PicExtraInfo picExt = new PicExtraInfo(picBody.getSize());
                    file.setExtra_info(JsonUtils.getGson().toJson((Object)picExt));
                    IMRawFileInfo pRawInfo = picBody.getRawFileInfo();
                    if (pRawInfo == null) break;
                    wrapper.setRawFileDb(this.mapRaw(pRawInfo));
                    break;
                }
                case 6: {
                    IMMediaBody mediaBody = (IMMediaBody)message.getMessageBody();
                    VideoExtraInfo mediaExt = new VideoExtraInfo(mediaBody.getDuration(), mediaBody.getSize());
                    file.setExtra_info(JsonUtils.getGson().toJson((Object)mediaExt));
                    IMRawFileInfo mRawInfo = mediaBody.getRawFileInfo();
                    if (mRawInfo == null) break;
                    wrapper.setRawFileDb(this.mapRaw(mRawInfo));
                    break;
                }
                case 100: {
                    break;
                }
            }
            wrapper.setMsgEntryDb(msg);
            wrapper.setFileMsgDb(file);
            return wrapper;
        }
        if (message.isWebIMMessage()) {
            IMWebBody imWebBody = (IMWebBody)message.getMessageBody();
            WebContent content = new WebContent();
            content.setTitle(imWebBody.getTitle());
            content.setDescription(imWebBody.getDescription());
            content.setSource(imWebBody.getSource());
            content.setUrl(imWebBody.getUrl());
            msg.setContent(JsonUtils.getGson().toJson((Object)content));
            FileMsgDb file = new FileMsgDb();
            if (!TextUtils.isEmpty((CharSequence)imWebBody.getLocalPath())) {
                file.setFile_path(imWebBody.getLocalPath());
                file.setFile_name(imWebBody.getDisplayName());
                file.setFile_size(imWebBody.getFileSize());
                file.setType(4);
                file.setFile_state(10);
                file.setSuffix(imWebBody.getSuffix());
                file.setEncrypt_size(imWebBody.getFileSize());
                file.setTranslate_size(imWebBody.getTranslateSize());
                wrapper.setFileMsgDb(file);
            }
            wrapper.setMsgEntryDb(msg);
            return wrapper;
        }
        return wrapper;
    }

    public SyncIdDb getSync(long id, String key) {
        SyncIdDb sync = new SyncIdDb();
        sync.setId_value(String.valueOf(id));
        sync.setId_type(key);
        return sync;
    }

    public IMSession mapSession(SessionWrapper sWrapper) {
        IMSession session = new IMSession();
        if (sWrapper == null || sWrapper.getSessionEntryDb() == null) {
            return session;
        }
        SessionEntryDb entry = sWrapper.getSessionEntryDb();
        session.setId(ToolUtils.getLong(entry.getId()));
        session.setImPartner(entry.getIm_partner());
        session.setRemindCount(entry.getReminded());
        session.setStrictlyCount(entry.getStrictly());
        session.setSessionTag(entry.getSession_flag());
        session.setSessionType(entry.getSession_type());
        if (sWrapper.getMsgEntryDb() == null) {
            session.setDisplayTime(ToolUtils.getLong(entry.getLast_time()));
            session.setLastMessage(null);
        } else {
            session.setDisplayTime(ToolUtils.getLong(entry.getLast_time()));
            IMMessage message = this.mapMessage(sWrapper.getMsgEntryDb(), true);
            FileMsgDb file = sWrapper.getFileMsgDb();
            if (file != null && message.isFileIMMessage() && !message.isRecalled()) {
                this.mapFileMessage(message, file);
            }
            if (file != null && message.isWebIMMessage()) {
                this.mapWebFileMessage(message, file);
            }
            session.setLastMessage(message);
        }
        return session;
    }

    public List<IMSession> mapSessions(List<SessionWrapper> sWrappers) {
        ArrayList<IMSession> sessions = new ArrayList<IMSession>();
        if (sWrappers == null || sWrappers.isEmpty()) {
            return sessions;
        }
        for (SessionWrapper wrapper : sWrappers) {
            sessions.add(this.mapSession(wrapper));
        }
        return sessions;
    }

    public IMMessage mapMessageNoDecrypt(MessageWrapper mWrapper) {
        IMMessage message = new IMMessage();
        MsgEntryDb msg = mWrapper.getMsgEntryDb();
        if (msg == null) {
            Logger.getLogger().e("wrong message!!!");
            return message;
        }
        message = this.mapMessage(msg, false);
        if (mWrapper.isFile() && !message.isRecalled()) {
            this.mapFileMessage(mWrapper, message, msg.getContent(), true);
        } else if (mWrapper.isWeb()) {
            this.mapWebFileMessage(mWrapper, message, true);
        }
        return message;
    }

    public IMMessage mapMessage(MessageWrapper mWrapper) {
        IMMessage message = new IMMessage();
        MsgEntryDb msg = mWrapper.getMsgEntryDb();
        if (msg == null) {
            Logger.getLogger().e("wrong message!!!");
            return message;
        }
        message = this.mapMessage(msg, true);
        if (mWrapper.isFile() && !message.isRecalled()) {
            this.mapFileMessage(mWrapper, message, msg.getContent(), true);
            return message;
        }
        if (mWrapper.isWeb() && !message.isRecalled()) {
            this.mapWebFileMessage(mWrapper, message, true);
            return message;
        }
        return message;
    }

    public IMMessage mapIMMessageDecryptDone(MessageWrapper mWrapper) {
        IMMessage message = new IMMessage();
        MsgEntryDb msg = mWrapper.getMsgEntryDb();
        if (msg == null) {
            Logger.getLogger().e("wrong message!!!");
            return message;
        }
        message = this.mapMessage(msg, true);
        if (mWrapper.isFile() && !message.isRecalled()) {
            this.mapFileMessage(mWrapper, message, msg.getContent(), false);
            return message;
        }
        if (mWrapper.isWeb() && !message.isRecalled()) {
            this.mapWebFileMessage(mWrapper, message, false);
            return message;
        }
        return message;
    }

    public List<IMMessage> mapMessages(List<MessageWrapper> mWrappers) {
        ArrayList<IMMessage> messages = new ArrayList<IMMessage>();
        if (mWrappers == null || mWrappers.isEmpty()) {
            return messages;
        }
        for (MessageWrapper wrapper : mWrappers) {
            messages.add(this.mapMessage(wrapper));
        }
        return messages;
    }

    private IMMessage mapMessage(MsgEntryDb entry, boolean decrypt) {
        IMMessage message = new IMMessage();
        message.setIMMessageId(ToolUtils.getLong(entry.getId()));
        message.setCardId(entry.getCard_id());
        message.setFrom(entry.getSender());
        message.setTo(entry.getReceiver());
        message.setType(entry.getType());
        message.setTimeToLive(entry.getLife_time());
        message.setIMMessageTime(entry.getSort_time());
        message.setExtraState(entry.getExtra_state());
        int state = entry.getState();
        if (state < 0) {
            message.setFailCode(this.mapFailState(state));
        } else {
            message.setFailCode(0);
        }
        message.setState(this.mapState(state));
        if (entry.isSystem()) {
            message.setMessageBody(new IMSystemBody(entry.getContent()));
            return message;
        }
        if (entry.isRecalled()) {
            message.setMessageBody(new IMRecallBody(entry.getContent()));
            return message;
        }
        if (entry.isAT()) {
            String ext = entry.getMsg_extra();
            ArrayList<String> accounts = new ArrayList();
            try {
                accounts = (List)JsonUtils.getGson().fromJson(ext, new TypeToken<List<String>>(){}.getType());
            }
            catch (Exception e) {
                Logger.getLogger().e("at message error !!!" + ext);
            }
            if (decrypt) {
                if (!ImSdkConfigManager.getInstance().needEncrypt()) {
                    message.setMessageBody(new IMATBody(entry.getContent(), accounts));
                } else if (ImSdkConfigManager.getInstance().noDecrypt()) {
                    message.setMessageBody(new IMATBody(entry.getContent(), accounts));
                } else {
                    message.setMessageBody(new IMATBody(this.decryptText(entry), accounts));
                }
            } else {
                message.setMessageBody(new IMATBody(entry.getContent(), accounts));
            }
            return message;
        }
        if (entry.isText()) {
            if (decrypt) {
                if (!ImSdkConfigManager.getInstance().needEncrypt()) {
                    message.setMessageBody(new IMTextBody(entry.getContent()));
                } else if (ImSdkConfigManager.getInstance().noDecrypt()) {
                    message.setMessageBody(new IMTextBody(entry.getContent()));
                } else {
                    if (entry.isService()) {
                        message.setMessageBody(new IMTextBody(ToolUtils.decode(entry.getContent())));
                        return message;
                    }
                    message.setMessageBody(new IMTextBody(this.decryptText(entry)));
                }
            } else {
                message.setMessageBody(new IMTextBody(entry.getContent()));
            }
            return message;
        }
        if (entry.isRichMedia()) {
            String decodeResult = Base64RFC1521Util.decode(entry.getContent());
            if (TextUtils.isEmpty((CharSequence)decodeResult)) {
                message.setMessageBody(new IMTextBody(entry.getContent()));
                message.setType(0);
                return message;
            }
            message.setMessageBody(new IMRichMediaBody(decodeResult));
            return message;
        }
        if (entry.isWeb()) {
            WebContent webContent = decrypt ? JsonUtils.mapGson(this.decryptText(entry), WebContent.class) : JsonUtils.mapGson(entry.getContent(), WebContent.class);
            if (webContent != null) {
                IMWebBody webBody = new IMWebBody(4);
                if (ImSdkConfigManager.getInstance().noDecrypt()) {
                    webBody.setTitle(ToolUtils.encode(webContent.getTitle()));
                    webBody.setDescription(ToolUtils.encode(webContent.getDescription()));
                    webBody.setUrl(ToolUtils.encode(webContent.getUrl()));
                    webBody.setSource(ToolUtils.encode(webContent.getSource()));
                    message.setMessageBody(webBody);
                } else {
                    webBody.setTitle(webContent.getTitle());
                    webBody.setDescription(webContent.getDescription());
                    webBody.setUrl(webContent.getUrl());
                    webBody.setSource(webContent.getSource());
                    message.setMessageBody(webBody);
                }
            }
            return message;
        }
        if (entry.isFile()) {
            int fileType = ToolUtils.getInt(entry.getContent());
            switch (fileType) {
                case 0: {
                    message.setMessageBody(new IMNormalFileBody(0));
                    break;
                }
                case 1: {
                    message.setMessageBody(new IMVoiceBody(1));
                    break;
                }
                case 2: {
                    message.setMessageBody(new IMVideoBody(2));
                    break;
                }
                case 3: {
                    message.setMessageBody(new IMImageBody(3));
                    break;
                }
                case 5: {
                    message.setMessageBody(new IMPicBody(5));
                    break;
                }
                case 6: {
                    message.setMessageBody(new IMMediaBody(6));
                    break;
                }
                case 100: {
                    message.setMessageBody(new IMFileBody(100));
                    break;
                }
                default: {
                    message.setMessageBody(new IMFileBody(100));
                }
            }
        }
        return message;
    }

    private void mapFileMessage(IMMessage message, FileMsgDb file) {
        if (file != null && !TextUtils.isEmpty((CharSequence)file.getFile_name())) {
            IMFileBody fileBody = (IMFileBody)message.getMessageBody();
            fileBody.setDisplayName(file.getFile_name());
        }
    }

    private void mapWebFileMessage(IMMessage message, FileMsgDb file) {
        IMWebBody fileBody;
        if (file != null && !TextUtils.isEmpty((CharSequence)file.getFile_name()) && (fileBody = (IMWebBody)message.getMessageBody()) != null) {
            fileBody.setDisplayName(file.getFile_name());
        }
    }

    private void mapWebFileMessage(MessageWrapper mWrapper, IMMessage message, boolean needDecrypt) {
        IMWebBody fileBody;
        if (!mWrapper.isWeb()) {
            return;
        }
        FileMsgDb file = mWrapper.getFileMsgDb();
        if (file != null && !TextUtils.isEmpty((CharSequence)file.getFile_path()) && (fileBody = (IMWebBody)message.getMessageBody()) != null) {
            fileBody.setDisplayName(file.getFile_name());
            fileBody.setSuffix(file.getSuffix());
            fileBody.setTranslateSize(file.getTranslate_size());
            fileBody.setFileSize(file.getFile_size());
            fileBody.setState(this.mapFileState(file.getFile_state()));
            if (ImSdkConfigManager.getInstance().noDecrypt()) {
                fileBody.setLocalPath(file.getEncrypt_path());
            } else if (ImSdkConfigManager.getInstance().needDecrypt() && needDecrypt) {
                if (this.fileNeedDecrypt(file.getFile_state())) {
                    ImSdkFileManager.getInstance().decryptFile(mWrapper, ImSdkFileConstant.FileType.IS_SHOW);
                }
                fileBody.setLocalPath(file.getFile_path());
            } else {
                fileBody.setLocalPath(file.getFile_path());
            }
            message.setMessageBody(fileBody);
        }
    }

    private void mapFileMessage(MessageWrapper mWrapper, IMMessage message, String content, boolean needDecrypt) {
        if (!mWrapper.isFile()) {
            return;
        }
        FileMsgDb file = mWrapper.getFileMsgDb();
        if (file != null && !TextUtils.isEmpty((CharSequence)file.getFile_path())) {
            IMFileBody fileBody = (IMFileBody)message.getMessageBody();
            fileBody = this.mapNormalBody(mWrapper, file, fileBody, needDecrypt);
            int fileType = ToolUtils.getInt(content);
            String extraInfo = file.getExtra_info();
            switch (fileType) {
                case 0: {
                    IMNormalFileBody normalFileBody = (IMNormalFileBody)fileBody;
                    message.setMessageBody(normalFileBody);
                    break;
                }
                case 1: {
                    VoiceExtraInfo voiceExtra;
                    if (TextUtils.isEmpty((CharSequence)extraInfo) || (voiceExtra = JsonUtils.mapGson(extraInfo, VoiceExtraInfo.class)) == null) break;
                    IMVoiceBody voiceBody = (IMVoiceBody)fileBody;
                    voiceBody.setDuration(voiceExtra.getDuration());
                    message.setMessageBody(voiceBody);
                    break;
                }
                case 2: {
                    VideoExtraInfo videoExtra;
                    if (TextUtils.isEmpty((CharSequence)extraInfo) || (videoExtra = JsonUtils.mapGson(extraInfo, VideoExtraInfo.class)) == null) break;
                    IMVideoBody videoBody = (IMVideoBody)fileBody;
                    videoBody.setDuration(videoExtra.getDuration());
                    videoBody.setSize(videoExtra.getSize());
                    RawFileDb rawFile = mWrapper.getRawFileDb();
                    if (rawFile != null) {
                        videoBody.setRawFileInfo(this.mapRaw(mWrapper, rawFile, needDecrypt));
                    }
                    message.setMessageBody(videoBody);
                    break;
                }
                case 3: {
                    RawFileDb rawFile;
                    IMImageBody imageBody = (IMImageBody)fileBody;
                    HdThumbFileDb hdFile = mWrapper.getHdThumbFileDb();
                    if (hdFile != null) {
                        imageBody.setHdTFileInfo(this.mapHd(mWrapper, hdFile, needDecrypt));
                        message.setMessageBody(imageBody);
                    }
                    if ((rawFile = mWrapper.getRawFileDb()) == null) break;
                    imageBody.setRawFileInfo(this.mapRaw(mWrapper, rawFile, needDecrypt));
                    message.setMessageBody(imageBody);
                    break;
                }
                case 5: {
                    RawFileDb rawPic;
                    PicExtraInfo picExtra;
                    IMPicBody picBody = (IMPicBody)fileBody;
                    if (!TextUtils.isEmpty((CharSequence)extraInfo) && (picExtra = JsonUtils.mapGson(extraInfo, PicExtraInfo.class)) != null) {
                        picBody.setSize(picExtra.getSize());
                    }
                    if ((rawPic = mWrapper.getRawFileDb()) != null) {
                        picBody.setRawFileInfo(this.mapRaw(mWrapper, rawPic, needDecrypt));
                    }
                    message.setMessageBody(picBody);
                    break;
                }
                case 6: {
                    RawFileDb rawMedia;
                    VideoExtraInfo mediaExtra;
                    IMMediaBody mediaBody = (IMMediaBody)fileBody;
                    if (!TextUtils.isEmpty((CharSequence)extraInfo) && (mediaExtra = JsonUtils.mapGson(extraInfo, VideoExtraInfo.class)) != null) {
                        mediaBody.setDuration(mediaExtra.getDuration());
                        mediaBody.setSize(mediaExtra.getSize());
                    }
                    if ((rawMedia = mWrapper.getRawFileDb()) != null) {
                        mediaBody.setRawFileInfo(this.mapRaw(mWrapper, rawMedia, needDecrypt));
                    }
                    message.setMessageBody(mediaBody);
                    break;
                }
                case 100: {
                    break;
                }
            }
        }
    }

    private IMFileBody mapNormalBody(MessageWrapper mWrapper, FileMsgDb file, IMFileBody fileBody, boolean needDecrypt) {
        fileBody.setSuffix(file.getSuffix());
        fileBody.setTranslateSize(file.getTranslate_size());
        fileBody.setFileSize(file.getFile_size());
        fileBody.setState(this.mapFileState(file.getFile_state()));
        fileBody.setType(file.getType());
        if (ImSdkConfigManager.getInstance().noDecrypt()) {
            fileBody.setLocalPath(file.getEncrypt_path());
            fileBody.setDisplayName(ToolUtils.encode(file.getFile_name()));
        } else if (ImSdkConfigManager.getInstance().needDecrypt() && needDecrypt) {
            if (this.fileNeedDecrypt(file.getFile_state())) {
                ImSdkFileManager.getInstance().decryptFile(mWrapper, ImSdkFileConstant.FileType.IS_SHOW);
            }
            fileBody.setLocalPath(file.getFile_path());
            fileBody.setDisplayName(file.getFile_name());
        } else {
            fileBody.setLocalPath(file.getFile_path());
            fileBody.setDisplayName(file.getFile_name());
        }
        return fileBody;
    }

    private RawFileDb mapRaw(IMRawFileInfo rawInfo) {
        RawFileDb raw = new RawFileDb();
        raw.setRaw_file_name(rawInfo.getRawDisplayName());
        raw.setRaw_file_size(rawInfo.getRawFileSize());
        raw.setRaw_encrypt_size(rawInfo.getRawFileSize());
        raw.setRaw_translate_size(rawInfo.getRawFileTranslateSize());
        raw.setRaw_state(10);
        raw.setRaw_file_path(rawInfo.getRawLocalPath());
        return raw;
    }

    private IMRawFileInfo mapRaw(MessageWrapper mWrapper, RawFileDb raw, boolean needDecrypt) {
        IMRawFileInfo rawFile = new IMRawFileInfo();
        rawFile.setRawDisplayName(raw.getRaw_file_name());
        rawFile.setRawFileSize(raw.getRaw_file_size());
        rawFile.setRawFileTranslateSize(raw.getRaw_translate_size());
        rawFile.setRawState(this.mapFileState(raw.getRaw_state()));
        if (ImSdkConfigManager.getInstance().noDecrypt()) {
            rawFile.setRawLocalPath(raw.getRaw_encrypt_path());
        } else if (ImSdkConfigManager.getInstance().needDecrypt() && needDecrypt) {
            if (this.fileNeedDecrypt(raw.getRaw_state())) {
                ImSdkFileManager.getInstance().decryptFile(mWrapper, ImSdkFileConstant.FileType.IS_RAW);
            }
            rawFile.setRawLocalPath(raw.getRaw_file_path());
        } else {
            rawFile.setRawLocalPath(raw.getRaw_file_path());
        }
        return rawFile;
    }

    private HdThumbFileDb mapHd(IMHDThumbFileInfo hdInfo) {
        HdThumbFileDb hd = new HdThumbFileDb();
        hd.setHd_file_name(hdInfo.getHdTDisplayName());
        hd.setHd_file_path(hdInfo.getHdTLocalPath());
        hd.setHd_file_size(hdInfo.getHdTFileSize());
        hd.setHd_encrypt_size(hdInfo.getHdTFileSize());
        hd.setHd_translate_size(hdInfo.getHdTFileTranslateSize());
        hd.setHd_state(10);
        return hd;
    }

    private IMHDThumbFileInfo mapHd(MessageWrapper mWrapper, HdThumbFileDb hd, boolean needDecrypt) {
        IMHDThumbFileInfo hdFile = new IMHDThumbFileInfo();
        hdFile.setHdTDisplayName(hd.getHd_file_name());
        hdFile.setHdTFileSize(hd.getHd_file_size());
        hdFile.setHdTFileTranslateSize(hd.getHd_translate_size());
        hdFile.setHdState(this.mapFileState(hd.getHd_state()));
        if (ImSdkConfigManager.getInstance().noDecrypt()) {
            hdFile.setHdTLocalPath(hd.getHd_encrypt_path());
        } else if (ImSdkConfigManager.getInstance().needDecrypt() && needDecrypt) {
            if (this.fileNeedDecrypt(hd.getHd_state())) {
                ImSdkFileManager.getInstance().decryptFile(mWrapper, ImSdkFileConstant.FileType.IS_HD);
            }
            hdFile.setHdTLocalPath(hd.getHd_file_path());
        } else {
            hdFile.setHdTLocalPath(hd.getHd_file_path());
        }
        return hdFile;
    }

    public MessageWrapper mapMWrapper(MsgBean msgBean) {
        MessageWrapper wrapper = new MessageWrapper();
        MsgEntryDb msg = new MsgEntryDb();
        msg.setServer_id(msgBean.getI());
        msg.setCard_id(msgBean.getFi());
        msg.setSession_flag(this.getSessionFlag(msgBean));
        msg.setAttr(this.getAttr(msgBean));
        msg.setSort_time(this.getSortTime(msgBean));
        msg.setState(msgBean.getStat());
        msg.setReceiver(msgBean.getTo());
        msg.setSender(msgBean.getF());
        msg.setCreate_time(msgBean.getFst());
        msg.setSent_time(msgBean.getSst());
        msg.setLife_time(msgBean.getLc());
        msg.setType(msgBean.getT());
        msg.setExtra_state(0);
        if (!msgBean.isSupportMsg()) {
            msg.setContent(msgBean.getC());
            msg.setType(0);
            wrapper.setMsgEntryDb(msg);
            return wrapper;
        }
        if (msgBean.isSystemMsg()) {
            msg.setContent(msgBean.getC());
            wrapper.setMsgEntryDb(msg);
            return wrapper;
        }
        if (msgBean.isServiceMsg()) {
            if (msgBean.isTextMsg()) {
                msg.setContent(msgBean.getC());
                wrapper.setMsgEntryDb(msg);
                return wrapper;
            }
            if (msgBean.isFileMsg()) {
                wrapper = this.mapFileContent(wrapper, msg, msgBean.getC());
                return wrapper;
            }
        }
        if (msgBean.isATType()) {
            msg.setMsg_extra(ToolUtils.decode(msgBean.getAt()));
        }
        if (msgBean.getStat() == 5) {
            msg.setContent(msgBean.getC());
            wrapper.setMsgEntryDb(msg);
            return wrapper;
        }
        if (msgBean.isRichMedia()) {
            msg.setState(1);
            msg.setContent(msgBean.getC());
            wrapper.setMsgEntryDb(msg);
            return wrapper;
        }
        if (msgBean.isTextMsg()) {
            msg.setContent(msgBean.getC());
            wrapper.setMsgEntryDb(msg);
            return wrapper;
        }
        if (msgBean.isWebMsg()) {
            wrapper = this.mapWebContent(wrapper, msg, msgBean.getC());
            return wrapper;
        }
        if (msgBean.isFileMsg()) {
            wrapper = this.mapFileContent(wrapper, msg, msgBean.getC());
            return wrapper;
        }
        return wrapper;
    }

    public MsgBean mapTextBean(MessageWrapper wrapper) {
        MsgEntryDb msg = wrapper.getMsgEntryDb();
        if (msg == null) {
            return null;
        }
        MsgBean msgBean = new MsgBean();
        msgBean.setFi(msg.getCard_id());
        msgBean.setF(msg.getSender());
        msgBean.setTo(msg.getReceiver());
        msgBean.setI(-1L);
        msgBean.setFst(msg.getCreate_time());
        msgBean.setStat(0);
        msgBean.setT(msg.getType());
        msgBean.setLc(msg.getLife_time());
        if (msg.isWeb()) {
            msgBean.setC(ToolUtils.encode(msg.getContent()));
            return msgBean;
        }
        msgBean.setC(msg.getContent());
        if (msg.isAT()) {
            msgBean.setAt(ToolUtils.encode(msg.getMsg_extra()));
        } else if (msg.isAssistant()) {
            msgBean.setAt(String.valueOf(msg.getExtra_state()));
        }
        return msgBean;
    }

    public MsgBean mapFileBean(MessageWrapper wrapper) {
        MsgEntryDb msg = wrapper.getMsgEntryDb();
        if (msg == null) {
            return null;
        }
        MsgBean msgBean = new MsgBean();
        msgBean.setFi(msg.getCard_id());
        msgBean.setF(msg.getSender());
        msgBean.setTo(msg.getReceiver());
        msgBean.setI(-1L);
        msgBean.setFst(msg.getCreate_time());
        msgBean.setStat(0);
        msgBean.setT(msg.getType());
        msgBean.setLc(msg.getLife_time());
        if (msg.isAssistant()) {
            msgBean.setAt(String.valueOf(msg.getExtra_state()));
        }
        if (wrapper.isFile()) {
            msgBean.setC(this.mapIMContent(wrapper));
        } else if (wrapper.isWeb()) {
            msgBean.setC(this.mapIMWeb(wrapper));
        }
        return msgBean;
    }

    public FileEntry getFileEntry(MessageWrapper wrapper, ImSdkFileConstant.FileType type) {
        FileEntry entry = new FileEntry();
        if (wrapper.getMsgEntryDb() == null || !wrapper.isFile() && !wrapper.isWeb()) {
            return entry;
        }
        entry.setId(ToolUtils.getLong(wrapper.getMsgEntryDb().getId()));
        entry.setType(type);
        entry.setTag(wrapper.getMsgEntryDb().getSession_flag());
        entry.setCount(0);
        FileMsgDb file = wrapper.getFileMsgDb();
        if (file != null) {
            entry.setMsgType(file.getType());
            entry.setSuffix(file.getSuffix());
        }
        switch (type) {
            case IS_SHOW: {
                if (file == null) break;
                entry.setSize(file.getFile_size());
                entry.settSize(file.getTranslate_size());
                entry.setFid(file.getFid());
                entry.setPath(file.getFile_path());
                entry.setEncryptPath(file.getEncrypt_path());
                entry.setEncryptSize(file.getEncrypt_size());
                entry.setName(file.getFile_name());
                entry.setState(file.getFile_state());
                entry.setMd5(file.getFile_md5());
                break;
            }
            case IS_HD: {
                HdThumbFileDb hd = wrapper.getHdThumbFileDb();
                if (hd == null) break;
                entry.setSize(hd.getHd_file_size());
                entry.settSize(hd.getHd_translate_size());
                entry.setFid(hd.getHd_fid());
                entry.setName(hd.getHd_file_name());
                entry.setPath(hd.getHd_file_path());
                entry.setEncryptPath(hd.getHd_encrypt_path());
                entry.setEncryptSize(hd.getHd_encrypt_size());
                entry.setState(hd.getHd_state());
                entry.setMd5(hd.getHd_md5());
                break;
            }
            case IS_RAW: {
                RawFileDb raw = wrapper.getRawFileDb();
                if (raw == null) break;
                entry.setSize(raw.getRaw_file_size());
                entry.settSize(raw.getRaw_translate_size());
                entry.setFid(raw.getRaw_fid());
                entry.setName(raw.getRaw_file_name());
                entry.setPath(raw.getRaw_file_path());
                entry.setEncryptPath(raw.getRaw_encrypt_path());
                entry.setEncryptSize(raw.getRaw_encrypt_size());
                entry.setState(raw.getRaw_state());
                entry.setMd5(raw.getRaw_md5());
                break;
            }
        }
        return entry;
    }

    public IMFileInfo mapFileInfo(FileEntry entry) {
        IMRawFileInfo raw;
        IMFileInfo info = new IMFileInfo();
        info.setFileType(entry.getType());
        info.setState(this.mapFileState(entry.getState()));
        info.setTag(entry.getTag());
        info.setPercent(entry.getPercent());
        info.settSize(entry.gettSize());
        IMMessage message = new IMMessage();
        message.setIMMessageId(entry.getId());
        if (entry.isNormal()) {
            IMNormalFileBody normal = new IMNormalFileBody(entry.getMsgType());
            normal.setState(this.mapFileState(entry.getState()));
            normal.setLocalPath(entry.getPath());
            normal.setDisplayName(entry.getName());
            normal.setFileSize(entry.getSize());
            normal.setTranslateSize(entry.gettSize());
            normal.setType(entry.getMsgType());
            message.setMessageBody(normal);
        }
        if (entry.isImage()) {
            IMImageBody image = new IMImageBody(entry.getMsgType());
            image.setType(entry.getMsgType());
            if (entry.isShow()) {
                image.setState(this.mapFileState(entry.getState()));
                image.setLocalPath(entry.getPath());
                image.setDisplayName(entry.getName());
                image.setFileSize(entry.getSize());
                image.setTranslateSize(entry.gettSize());
            }
            if (entry.isHd()) {
                IMHDThumbFileInfo hd = new IMHDThumbFileInfo();
                hd.setHdState(this.mapFileState(entry.getState()));
                hd.setHdTFileTranslateSize(entry.gettSize());
                hd.setHdTFileSize(entry.getSize());
                hd.setHdTDisplayName(entry.getName());
                hd.setHdTLocalPath(entry.getPath());
                image.setHdTFileInfo(hd);
            }
            if (entry.isRaw()) {
                raw = new IMRawFileInfo();
                raw.setRawState(this.mapFileState(entry.getState()));
                raw.setRawFileSize(entry.getSize());
                raw.setRawFileTranslateSize(entry.gettSize());
                raw.setRawDisplayName(entry.getName());
                raw.setRawLocalPath(entry.getPath());
                image.setRawFileInfo(raw);
            }
            message.setMessageBody(image);
        }
        if (entry.isVideo()) {
            IMVideoBody video = new IMVideoBody(entry.getMsgType());
            video.setType(entry.getMsgType());
            if (entry.isShow()) {
                video.setState(this.mapFileState(entry.getState()));
                video.setLocalPath(entry.getPath());
                video.setDisplayName(entry.getName());
                video.setFileSize(entry.getSize());
                video.setTranslateSize(entry.gettSize());
            }
            if (entry.isRaw()) {
                raw = new IMRawFileInfo();
                raw.setRawState(this.mapFileState(entry.getState()));
                raw.setRawFileSize(entry.getSize());
                raw.setRawFileTranslateSize(entry.gettSize());
                raw.setRawDisplayName(entry.getName());
                raw.setRawLocalPath(entry.getPath());
                video.setRawFileInfo(raw);
            }
            message.setMessageBody(video);
        }
        if (entry.isVoice()) {
            IMVoiceBody voice = new IMVoiceBody(entry.getMsgType());
            voice.setType(entry.getMsgType());
            if (entry.isShow()) {
                voice.setState(this.mapFileState(entry.getState()));
                voice.setLocalPath(entry.getPath());
                voice.setDisplayName(entry.getName());
                voice.setFileSize(entry.getSize());
                voice.setTranslateSize(entry.gettSize());
            }
            message.setMessageBody(voice);
        }
        if (entry.isWeb()) {
            IMWebBody webBody = new IMWebBody(entry.getMsgType());
            if (entry.isShow()) {
                webBody.setState(this.mapFileState(entry.getState()));
                webBody.setLocalPath(entry.getPath());
                webBody.setDisplayName(entry.getName());
                webBody.setFileSize(entry.getSize());
                webBody.setTranslateSize(entry.gettSize());
            }
            message.setMessageBody(webBody);
        }
        if (entry.isPic()) {
            IMPicBody picBody = new IMPicBody(entry.getMsgType());
            picBody.setType(entry.getMsgType());
            if (entry.isShow()) {
                picBody.setState(this.mapFileState(entry.getState()));
                picBody.setLocalPath(entry.getPath());
                picBody.setDisplayName(entry.getName());
                picBody.setFileSize(entry.getSize());
                picBody.setTranslateSize(entry.gettSize());
            }
            if (entry.isRaw()) {
                raw = new IMRawFileInfo();
                raw.setRawState(this.mapFileState(entry.getState()));
                raw.setRawFileSize(entry.getSize());
                raw.setRawFileTranslateSize(entry.gettSize());
                raw.setRawDisplayName(entry.getName());
                raw.setRawLocalPath(entry.getPath());
                picBody.setRawFileInfo(raw);
            }
            message.setMessageBody(picBody);
        }
        if (entry.isMedia()) {
            IMMediaBody mediaBody = new IMMediaBody(entry.getMsgType());
            mediaBody.setType(entry.getMsgType());
            if (entry.isShow()) {
                mediaBody.setState(this.mapFileState(entry.getState()));
                mediaBody.setLocalPath(entry.getPath());
                mediaBody.setDisplayName(entry.getName());
                mediaBody.setFileSize(entry.getSize());
                mediaBody.setTranslateSize(entry.gettSize());
            }
            if (entry.isRaw()) {
                raw = new IMRawFileInfo();
                raw.setRawState(this.mapFileState(entry.getState()));
                raw.setRawFileSize(entry.getSize());
                raw.setRawFileTranslateSize(entry.gettSize());
                raw.setRawDisplayName(entry.getName());
                raw.setRawLocalPath(entry.getPath());
                mediaBody.setRawFileInfo(raw);
            }
            message.setMessageBody(mediaBody);
        }
        info.setMessage(message);
        return info;
    }

    public Constant.BodyType mapBodyType(MessageWrapper wrapper) {
        if (wrapper.isText()) {
            return Constant.BodyType.TEXT;
        }
        Constant.BodyType bodyType = Constant.BodyType.UNKNOWN;
        FileMsgDb file = wrapper.getFileMsgDb();
        if (wrapper.isFile() && file != null) {
            int type = file.getType();
            return this.mapBodyType(type);
        }
        return bodyType;
    }

    public Constant.BodyType mapBodyType(IMMessage message) {
        if (message.isTextIMMessage()) {
            return Constant.BodyType.TEXT;
        }
        Constant.BodyType bodyType = Constant.BodyType.UNKNOWN;
        if (message.isFileIMMessage()) {
            IMFileBody fileBody = (IMFileBody)message.getMessageBody();
            int type = fileBody.getType();
            return this.mapBodyType(type);
        }
        return bodyType;
    }

    private Constant.BodyType mapBodyType(int type) {
        Constant.BodyType bodyType = Constant.BodyType.UNKNOWN;
        switch (type) {
            case 0: {
                bodyType = Constant.BodyType.NORMAL;
                break;
            }
            case 1: {
                bodyType = Constant.BodyType.VOICE;
                break;
            }
            case 3: {
                bodyType = Constant.BodyType.IMAGE;
                break;
            }
            case 2: {
                bodyType = Constant.BodyType.VIDEO;
                break;
            }
            case 100: {
                bodyType = Constant.BodyType.UNKNOWN;
                break;
            }
        }
        return bodyType;
    }

    public List<SessionEntryDb> mapSession(List<SessionWrapper> wrappers) {
        ArrayList<SessionEntryDb> dbs = new ArrayList<SessionEntryDb>();
        for (SessionWrapper wrapper : wrappers) {
            dbs.add(wrapper.getSessionEntryDb());
        }
        return dbs;
    }

    public List<SessionWrapper> mapSessions(Map<String, SessionWrapper> map) {
        ArrayList<SessionWrapper> wrappers = new ArrayList<SessionWrapper>();
        Set<Map.Entry<String, SessionWrapper>> entrySet = map.entrySet();
        for (Map.Entry<String, SessionWrapper> entry : entrySet) {
            wrappers.add(entry.getValue());
        }
        return wrappers;
    }

    public List<Long> getIds(List<MessageWrapper> wrappers) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (MessageWrapper wrapper : wrappers) {
            if (wrapper.getMsgEntryDb() == null) continue;
            ids.add(ToolUtils.getLong(wrapper.getMsgEntryDb().getId()));
        }
        return ids;
    }

    public List<Long> getServerIds(List<MessageWrapper> wrappers) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (MessageWrapper wrapper : wrappers) {
            if (wrapper.getMsgEntryDb() == null) continue;
            ids.add(wrapper.getMsgEntryDb().getServer_id());
        }
        return ids;
    }

    public List<OptionsDb> mapOption(Map<String, String> options) {
        ArrayList<OptionsDb> dbList = new ArrayList<OptionsDb>();
        if (options != null && !options.isEmpty()) {
            Set<Map.Entry<String, String>> entrySet = options.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                OptionsDb db = new OptionsDb(null, entry.getKey(), entry.getValue());
                dbList.add(db);
            }
        }
        return dbList;
    }

    public Map<String, String> mapOption(List<OptionsDb> list) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (OptionsDb db : list) {
            map.put(db.getProperty(), db.getValue());
        }
        return map;
    }

    public LocalStateMsgDb mapState(IMState state) {
        LocalStateMsgDb stateDb = new LocalStateMsgDb();
        stateDb.setContent(state.getContent());
        stateDb.setSendTime(state.getSendTime());
        return stateDb;
    }

    public List<IMState> mapStates(List<LocalStateMsgDb> list) {
        ArrayList<IMState> states = new ArrayList<IMState>();
        for (LocalStateMsgDb msg : list) {
            IMState state = new IMState();
            state.setContent(msg.getContent());
            state.setSendTime(msg.getSendTime());
            state.setId(msg.getId());
            states.add(state);
        }
        return states;
    }

    public MsgBean mapRecall(MessageWrapper message) {
        MsgEntryDb msg = message.getMsgEntryDb();
        if (msg == null) {
            return null;
        }
        MsgBean msgBean = new MsgBean();
        msgBean.setFi(msg.getCard_id());
        msgBean.setF(msg.getSender());
        msgBean.setTo(msg.getReceiver());
        msgBean.setI(-1L);
        msgBean.setFst(msg.getCreate_time());
        msgBean.setStat(0);
        msgBean.setC(String.valueOf(msg.getServer_id()));
        msgBean.setLc(0);
        if (msg.isGroup()) {
            msgBean.setT(132);
            return msgBean;
        }
        msgBean.setT(128);
        return msgBean;
    }

    public MsgBean mapRemind(MessageWrapper message, String receive) {
        MsgEntryDb msg = message.getMsgEntryDb();
        if (msg == null) {
            return null;
        }
        MsgBean msgBean = new MsgBean();
        msgBean.setFi(msg.getCard_id());
        msgBean.setF(this.account);
        msgBean.setTo(receive);
        msgBean.setI(-1L);
        msgBean.setFst(msg.getCreate_time());
        msgBean.setStat(0);
        msgBean.setLc(0);
        msgBean.setT(2048);
        RemindContent remindContent = new RemindContent(msg.getServer_id(), ImSdkConfigManager.getInstance().getCurrentMillis());
        msgBean.setC(JsonUtils.getGson().toJson((Object)remindContent));
        return msgBean;
    }

    public AttentionMsgDb getAttention(MessageWrapper message, String to) {
        MsgEntryDb msg = message.getMsgEntryDb();
        if (msg == null) {
            return null;
        }
        AttentionMsgDb db = new AttentionMsgDb();
        db.setAtt_server_id(-ImSdkConfigManager.getInstance().getCurrentNano());
        db.setAtt_time(ImSdkConfigManager.getInstance().getCurrentMillis());
        db.setMsg_server_id(msg.getServer_id());
        db.setAtt_from(this.account);
        db.setAtt_to(to);
        db.setReceived(2);
        return db;
    }

    public List<LocalStateMsgDb> mapLStates(List<IMState> list) {
        ArrayList<LocalStateMsgDb> states = new ArrayList<LocalStateMsgDb>();
        for (IMState entry : list) {
            LocalStateMsgDb state = new LocalStateMsgDb();
            state.setContent(entry.getContent());
            state.setSendTime(entry.getSendTime());
            states.add(state);
        }
        return states;
    }

    public List<DuplicateIdDb> mapDup(List<MsgBean> list) {
        ArrayList<DuplicateIdDb> ids = new ArrayList<DuplicateIdDb>();
        for (MsgBean msg : list) {
            DuplicateIdDb id = new DuplicateIdDb();
            id.setSend_time(String.valueOf(msg.getFst()));
            id.setServer_id(String.valueOf(msg.getI()));
            ids.add(id);
        }
        return ids;
    }

    private List<IMState> subStates(List<StateBean> beans) {
        ArrayList<IMState> states = new ArrayList<IMState>();
        int size = beans.size();
        int subSize = size % 50 == 0 ? size / 50 : size / 50 + 1;
        int i = 0;
        while (i < subSize) {
            ArrayList<StateBean> sub = new ArrayList<StateBean>();
            int j = i * 50;
            while (j < 50 * (i + 1)) {
                if (j < size) {
                    sub.add(beans.get(j));
                }
                ++j;
            }
            states.add(this.getState(sub));
            ++i;
        }
        return states;
    }

    private IMState getState(List<StateBean> beans) {
        IMState state = new IMState();
        state.setContent(JsonUtils.getGson().toJson(beans));
        state.setSendTime(ImSdkConfigManager.getInstance().getCurrentMillis());
        return state;
    }

    private MessageWrapper mapFileContent(MessageWrapper message, MsgEntryDb msg, String c) {
        IMContent content = JsonUtils.mapGson(ToolUtils.decode(c), IMContent.class);
        if (content != null && !TextUtils.isEmpty((CharSequence)content.getFid())) {
            return this.mapIMContent(message, msg, content);
        }
        OldFile oldFile = JsonUtils.mapGson(c, OldFile.class);
        if (oldFile != null) {
            return this.mapOldFile(message, msg, oldFile);
        }
        return message;
    }

    private MessageWrapper mapWebContent(MessageWrapper message, MsgEntryDb msg, String c) {
        IMWeb imWeb = JsonUtils.mapGson(ToolUtils.decode(c), IMWeb.class);
        if (imWeb == null) {
            Logger.getLogger().e("decrypt web error !!!");
            message.setMsgEntryDb(msg);
            return message;
        }
        WebContent content = new WebContent();
        content.setTitle(imWeb.getTitle());
        content.setDescription(imWeb.getDescription());
        content.setSource(imWeb.getSource());
        content.setUrl(imWeb.getUrl());
        msg.setContent(JsonUtils.getGson().toJson((Object)content));
        if (!TextUtils.isEmpty((CharSequence)imWeb.getAttached())) {
            IMWebAttached attached = JsonUtils.mapGson(imWeb.getAttached(), IMWebAttached.class);
            if (attached == null) {
                Logger.getLogger().e("decrypt web error !!!");
                msg.setContent(c);
                message.setMsgEntryDb(msg);
                return message;
            }
            FileMsgDb file = new FileMsgDb();
            file.setFid(attached.getFid());
            file.setFile_size(attached.getSize());
            file.setEncrypt_size(attached.getEncryptSize());
            file.setType(4);
            file.setSuffix(attached.getSuffix());
            file.setFile_state(20);
            String name = FileUtils.getName(attached.getName());
            String encryptPath = this.getDownloadPath(4, name, false);
            String filePath = this.getOuPutPath(4, name, encryptPath, false);
            file.setFile_name(name);
            file.setFile_path(filePath);
            file.setEncrypt_path(encryptPath);
            message.setFileMsgDb(file);
        }
        message.setMsgEntryDb(msg);
        return message;
    }

    public MessageWrapper mapOldFile(MessageWrapper message, MsgEntryDb msg, OldFile oldFile) {
        FileMsgDb file = new FileMsgDb();
        file.setFid(oldFile.getFileUrl());
        file.setFile_size(oldFile.getSize());
        file.setEncrypt_size(oldFile.getSize());
        file.setType(oldFile.getType());
        file.setSuffix(oldFile.getSuffix());
        file.setFile_state(20);
        msg.setContent(String.valueOf(oldFile.getType()));
        message.setMsgEntryDb(msg);
        if (oldFile.isImage()) {
            String name = FileUtils.subDat(oldFile.getName());
            String encryptFilePath = this.getDownloadPath(3, name, false);
            String filePath = this.getOuPutPath(3, name, encryptFilePath, false);
            file.setFile_name(name);
            file.setFile_path(filePath);
            file.setEncrypt_path(encryptFilePath);
            String extraInfo = oldFile.getExtraInfo();
            message.setHdThumbFileDb(this.mapHdExtraInfo(extraInfo));
            message.setRawFileDb(this.mapRawExtraInfo(extraInfo));
        } else if (oldFile.isVoice()) {
            String name = FileUtils.subDat(oldFile.getName());
            String encryptVoicePath = this.getDownloadPath(1, name, false);
            String filePath = this.getOuPutPath(1, name, encryptVoicePath, false);
            file.setFile_name(name);
            file.setFile_path(filePath);
            file.setEncrypt_path(encryptVoicePath);
            file.setExtra_info(oldFile.getExtraInfo());
        } else {
            file.setExtra_info(oldFile.getExtraInfo());
        }
        message.setFileMsgDb(file);
        return message;
    }

    public HdThumbFileDb mapHdExtraInfo(String oldExtra) {
        OldExtra image = JsonUtils.mapGson(oldExtra, OldExtra.class);
        if (image != null && !TextUtils.isEmpty((CharSequence)image.getThumbFid())) {
            HdThumbFileDb hd = new HdThumbFileDb();
            hd.setHd_fid(image.getThumbFid());
            hd.setHd_file_size(image.getThumbFileSize());
            hd.setHd_encrypt_size(image.getThumbFileSize());
            hd.setHd_translate_size(image.getThumbFileTranslateSize());
            hd.setHd_state(20);
            String thuName = FileUtils.subDat(image.getThumbFileName());
            String encryptThuPath = this.getDownloadPath(3, thuName, false);
            String thuPath = this.getOuPutPath(3, thuName, encryptThuPath, false);
            hd.setHd_file_name(thuName);
            hd.setHd_encrypt_path(encryptThuPath);
            hd.setHd_file_path(thuPath);
            return hd;
        }
        return null;
    }

    public RawFileDb mapRawExtraInfo(String oldExtra) {
        OldExtra image = JsonUtils.mapGson(oldExtra, OldExtra.class);
        if (image != null && !TextUtils.isEmpty((CharSequence)image.getRawFid())) {
            RawFileDb raw = new RawFileDb();
            raw.setRaw_fid(image.getRawFid());
            raw.setRaw_file_size(image.getRawFileSize());
            raw.setRaw_encrypt_size(image.getRawFileSize());
            raw.setRaw_translate_size(image.getRawFileTranslateSize());
            raw.setRaw_state(20);
            String rawName = FileUtils.subDat(image.getRawFileName());
            String encryptRawPath = this.getDownloadPath(3, rawName, false);
            String rawPath = this.getOuPutPath(3, rawName, encryptRawPath, false);
            raw.setRaw_file_name(rawName);
            raw.setRaw_file_path(rawPath);
            raw.setRaw_encrypt_path(encryptRawPath);
            return raw;
        }
        return null;
    }

    private MessageWrapper mapIMContent(MessageWrapper message, MsgEntryDb msg, IMContent content) {
        FileMsgDb file = new FileMsgDb();
        if (!content.isSupportFile()) {
            msg.setContent(String.valueOf(100));
            msg.setType(0);
            message.setMsgEntryDb(msg);
            return message;
        }
        file.setFid(content.getFid());
        file.setFile_size(content.getSize());
        file.setEncrypt_size(content.getEncryptSize());
        file.setType(content.getType());
        file.setSuffix(content.getSuffix());
        file.setFile_state(20);
        file.setExtra_info(content.getExtraInfo());
        file.setTranslate_size(0L);
        file.setFile_md5(content.getMd5());
        msg.setContent(String.valueOf(content.getType()));
        message.setMsgEntryDb(msg);
        String name = FileUtils.getName(content.getName());
        String encryptPath = this.getDownloadPath(content.getType(), name, msg.isService());
        String filePath = this.getOuPutPath(content.getType(), name, encryptPath, msg.isService());
        file.setEncrypt_path(encryptPath);
        file.setFile_path(filePath);
        file.setFile_name(name);
        message.setFileMsgDb(file);
        if (content.isVoice() || content.isNormal()) {
            return message;
        }
        if (content.isImage()) {
            RawFileDb rawFile;
            HdThumbFileDb hdFileDb = this.getHdFileDb(content, msg.isService());
            if (hdFileDb != null) {
                message.setHdThumbFileDb(hdFileDb);
            }
            if ((rawFile = this.getRawFileDb(content, msg.isService())) != null) {
                message.setRawFileDb(rawFile);
            }
            return message;
        }
        if (content.isVideo() || content.isPic() || content.isMedia()) {
            RawFileDb rawFile = this.getRawFileDb(content, msg.isService());
            if (rawFile != null) {
                message.setRawFileDb(rawFile);
            }
            return message;
        }
        return message;
    }

    private HdThumbFileDb getHdFileDb(IMContent content, boolean noEncryptMode) {
        IMHd hd = JsonUtils.mapGson(content.getHd(), IMHd.class);
        if (hd == null || TextUtils.isEmpty((CharSequence)hd.getFid())) {
            return null;
        }
        HdThumbFileDb hdFile = new HdThumbFileDb();
        hdFile.setHd_fid(hd.getFid());
        hdFile.setHd_file_size(hd.getSize());
        hdFile.setHd_encrypt_size(hd.getEncryptSize());
        hdFile.setHd_state(20);
        hdFile.setHd_translate_size(0L);
        hdFile.setHd_md5(hd.getHdMd5());
        String hdName = FileUtils.getName(hd.getName());
        String encryptHdPath = this.getDownloadPath(content.getType(), hdName, noEncryptMode);
        String hdPath = this.getOuPutPath(content.getType(), hdName, encryptHdPath, noEncryptMode);
        hdFile.setHd_file_name(hdName);
        hdFile.setHd_encrypt_path(encryptHdPath);
        hdFile.setHd_file_path(hdPath);
        return hdFile;
    }

    private RawFileDb getRawFileDb(IMContent content, boolean noEncryptMode) {
        IMRaw raw = JsonUtils.mapGson(content.getRaw(), IMRaw.class);
        if (raw == null || TextUtils.isEmpty((CharSequence)raw.getFid())) {
            return null;
        }
        RawFileDb rawFile = new RawFileDb();
        rawFile.setRaw_fid(raw.getFid());
        rawFile.setRaw_file_size(raw.getSize());
        rawFile.setRaw_encrypt_size(raw.getEncryptSize());
        rawFile.setRaw_state(20);
        rawFile.setRaw_translate_size(0L);
        rawFile.setRaw_md5(raw.getRawMd5());
        String rawName = FileUtils.getName(raw.getName());
        String encryptRawPath = this.getDownloadPath(content.getType(), rawName, noEncryptMode);
        String rawPath = this.getOuPutPath(content.getType(), rawName, encryptRawPath, noEncryptMode);
        rawFile.setRaw_file_name(rawName);
        rawFile.setRaw_encrypt_path(encryptRawPath);
        rawFile.setRaw_file_path(rawPath);
        return rawFile;
    }

    private String getDownloadPath(int type, String name, boolean noEncryptMode) {
        if (noEncryptMode) {
            if (type == 0) {
                return FileUtils.getFileRecPath(name);
            }
            return FileUtils.getRanPath(type, name);
        }
        if (ImSdkConfigManager.getInstance().needEncrypt()) {
            return FileUtils.getEncryptPath(type, name);
        }
        if (type == 0) {
            return FileUtils.getFileRecPath(name);
        }
        return FileUtils.getRanPath(type, name);
    }

    private String getOuPutPath(int type, String name, String encryptPath, boolean noEncryptMode) {
        if (noEncryptMode) {
            return encryptPath;
        }
        if (ImSdkConfigManager.getInstance().needEncrypt()) {
            if (type == 0) {
                return FileUtils.getFileRecPath(name);
            }
            return FileUtils.getRanPath(type, name);
        }
        return encryptPath;
    }

    private String mapIMContent(MessageWrapper wrapper) {
        IMContent content = new IMContent();
        FileMsgDb file = wrapper.getFileMsgDb();
        if (file == null) {
            return "";
        }
        content.setFid(file.getFid());
        content.setType(file.getType());
        content.setName(file.getFile_name());
        content.setSize(file.getFile_size());
        content.setEncryptSize(file.getEncrypt_size());
        content.setSuffix(file.getSuffix());
        content.setMd5(file.getFile_md5());
        file.isNormal();
        if (file.isVoice()) {
            content.setExtraInfo(file.getExtra_info());
        }
        if (file.isImage()) {
            RawFileDb raw;
            HdThumbFileDb hd = wrapper.getHdThumbFileDb();
            if (hd != null) {
                IMHd imHd = new IMHd();
                imHd.setEncryptSize(hd.getHd_encrypt_size());
                imHd.setFid(hd.getHd_fid());
                imHd.setName(hd.getHd_file_name());
                imHd.setSize(hd.getHd_file_size());
                imHd.setHdMd5(hd.getHd_md5());
                content.setHd(JsonUtils.getGson().toJson((Object)imHd));
            }
            if ((raw = wrapper.getRawFileDb()) != null) {
                IMRaw imRaw = new IMRaw();
                imRaw.setEncryptSize(raw.getRaw_encrypt_size());
                imRaw.setFid(raw.getRaw_fid());
                imRaw.setName(raw.getRaw_file_name());
                imRaw.setSize(raw.getRaw_file_size());
                imRaw.setRawMd5(raw.getRaw_md5());
                content.setRaw(JsonUtils.getGson().toJson((Object)imRaw));
            }
        }
        if (file.onlyThuAndRaw()) {
            content.setExtraInfo(file.getExtra_info());
            RawFileDb raw = wrapper.getRawFileDb();
            if (raw != null) {
                IMRaw imRaw = new IMRaw();
                imRaw.setEncryptSize(raw.getRaw_encrypt_size());
                imRaw.setFid(raw.getRaw_fid());
                imRaw.setName(raw.getRaw_file_name());
                imRaw.setSize(raw.getRaw_file_size());
                imRaw.setRawMd5(raw.getRaw_md5());
                content.setRaw(JsonUtils.getGson().toJson((Object)imRaw));
            }
        }
        return ToolUtils.encode(JsonUtils.getGson().toJson((Object)content));
    }

    private String mapIMWeb(MessageWrapper wrapper) {
        if (wrapper == null || wrapper.getMsgEntryDb() == null || TextUtils.isEmpty((CharSequence)wrapper.getMsgEntryDb().getContent()) || wrapper.getFileMsgDb() == null || TextUtils.isEmpty((CharSequence)wrapper.getFileMsgDb().getFile_path())) {
            Logger.getLogger().e("Web error!!!");
            return "";
        }
        WebContent webContent = JsonUtils.mapGson(wrapper.getMsgEntryDb().getContent(), WebContent.class);
        if (webContent == null) {
            Logger.getLogger().e("Web error!!!");
            return "";
        }
        IMWeb imWeb = new IMWeb();
        imWeb.setTitle(webContent.getTitle());
        imWeb.setDescription(webContent.getDescription());
        imWeb.setSource(webContent.getSource());
        imWeb.setUrl(webContent.getUrl());
        FileMsgDb fileMsgDb = wrapper.getFileMsgDb();
        IMWebAttached attached = new IMWebAttached();
        attached.setEncryptSize(fileMsgDb.getEncrypt_size());
        attached.setFid(fileMsgDb.getFid());
        attached.setName(fileMsgDb.getFile_name());
        attached.setSize(fileMsgDb.getFile_size());
        attached.setSuffix(fileMsgDb.getSuffix());
        imWeb.setAttached(JsonUtils.getGson().toJson((Object)attached));
        return ToolUtils.encode(JsonUtils.getGson().toJson((Object)imWeb));
    }

    private String getImPartner(MsgBean msgBean) {
        if (this.account.equals(msgBean.getF())) {
            return msgBean.getTo();
        }
        if (msgBean.isGroupMsg()) {
            return msgBean.getTo();
        }
        return msgBean.getF();
    }

    private String getSessionFlag(MsgBean msgBean) {
        String im = this.getImPartner(msgBean);
        if (msgBean.isSubType()) {
            return ToolUtils.getSessionTag(im, 201);
        }
        if (msgBean.isGroupMsg() && !msgBean.isSystemMsg()) {
            return ToolUtils.getSessionTag(im, 2);
        }
        if (msgBean.isServiceMsg() || msgBean.isRichMedia()) {
            return ToolUtils.getSessionTag(im, 100);
        }
        return ToolUtils.getSessionTag(im, 1);
    }

    private int getAttr(MsgBean msgBean) {
        if (this.account.equals(msgBean.getF())) {
            return 2;
        }
        if (msgBean.getStat() == 1) {
            return 1;
        }
        return 3;
    }

    private long getSortTime(MsgBean msgBean) {
        if (this.account.equals(msgBean.getF())) {
            return ToolUtils.getMTime(msgBean.getFst());
        }
        return ToolUtils.getMTime(msgBean.getSst());
    }

    private String getImPartner(IMMessage message) {
        if (this.account.equals(message.getFrom())) {
            return message.getTo();
        }
        if (message.isGroupIMMessage()) {
            return message.getTo();
        }
        return message.getFrom();
    }

    private String decryptText(MsgEntryDb msg) {
        if (!ImSdkConfigManager.getInstance().needEncrypt()) {
            return msg.getContent();
        }
        String content = msg.getContent();
        SecurityPara para = this.getSecurityPara(msg);
        SecurityResult result = ImSdkCallbackManager.getInstance().callDecryptText(content, para);
        if (result == null) {
            return msg.getContent();
        }
        return result.getResult();
    }

    private ImSdkFileConstant.FileState mapFileState(int state) {
        ImSdkFileConstant.FileState file = ImSdkFileConstant.FileState.FAIL;
        switch (state) {
            case 10: 
            case 20: {
                file = ImSdkFileConstant.FileState.INACTIVE;
                break;
            }
            case 24: {
                if (ImSdkConfigManager.getInstance().isDecryptMode()) {
                    file = ImSdkFileConstant.FileState.DONE;
                    break;
                }
                if (!ImSdkConfigManager.getInstance().needEncrypt()) {
                    file = ImSdkFileConstant.FileState.DONE;
                    break;
                }
            }
            case 12: 
            case 14: 
            case 16: 
            case 22: {
                file = ImSdkFileConstant.FileState.LOADING;
                break;
            }
            case 18: 
            case 26: {
                file = ImSdkFileConstant.FileState.DONE;
                break;
            }
            case 15: 
            case 21: {
                file = ImSdkFileConstant.FileState.PAUSE;
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 23: 
            case 25: {
                file = ImSdkFileConstant.FileState.FAIL;
                break;
            }
        }
        return file;
    }

    private int mapState(int state) {
        if (state > 0) {
            return state;
        }
        if (state == 0 || state == -4) {
            return 0;
        }
        return -1;
    }

    public MessageWrapper getNewStateWrapper(MessageWrapper wrapper, int type) {
        MessageWrapper stateWrapper = new MessageWrapper();
        MsgEntryDb stateEntry = new MsgEntryDb(wrapper.getMsgEntryDb());
        stateEntry.setType(type);
        stateWrapper.setMsgEntryDb(stateEntry);
        stateWrapper.setFileMsgDb(wrapper.getFileMsgDb());
        stateWrapper.setHdThumbFileDb(wrapper.getHdThumbFileDb());
        stateWrapper.setRawFileDb(wrapper.getRawFileDb());
        return stateWrapper;
    }

    private int mapFailState(int state) {
        int fail = -1;
        switch (state) {
            case -1: {
                fail = -2;
                break;
            }
            case -3: {
                fail = -3;
                break;
            }
            case -5: 
            case -4: {
                fail = -4;
                break;
            }
            case -6: {
                fail = -5;
                break;
            }
            case -8: 
            case -7: {
                fail = -6;
                break;
            }
            case -9: {
                fail = -7;
                break;
            }
        }
        return fail;
    }

    private boolean fileNeedDecrypt(int state) {
        return state == 24 || state == 26;
    }

    private static class Factory {
        private Factory() {
        }

        static ModelMapper getInstance() {
            return new ModelMapper();
        }
    }
}

