/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.org.eclipse.paho.client.mqttv3;

import com.xdja.org.eclipse.paho.client.mqttv3.IMqttActionListener;
import com.xdja.org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import com.xdja.org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import com.xdja.org.eclipse.paho.client.mqttv3.IMqttToken;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttCallback;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttException;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttMessage;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttPingSender;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttSecurityException;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttToken;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttTopic;
import com.xdja.org.eclipse.paho.client.mqttv3.TimerPingSender;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.ClientComms;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.ConnectActionListener;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.LocalNetworkModule;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.SSLNetworkModule;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.TCPNetworkModule;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.security.SSLSocketFactoryFactory;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.wire.MqttSubscribe;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.wire.MqttUnsubscribe;
import com.xdja.org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import com.xdja.org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import com.xdja.org.eclipse.paho.client.mqttv3.util.Debug;
import com.xdja.pushsdk.utils.LogHelper;
import java.util.Hashtable;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class MqttAsyncClient
implements IMqttAsyncClient {
    private static final String CLASS_NAME = MqttAsyncClient.class.getName();
    private static final String CLIENT_ID_PREFIX = "paho";
    private static final long QUIESCE_TIMEOUT = 30000L;
    private static final long DISCONNECT_TIMEOUT = 10000L;
    private static final char MIN_HIGH_SURROGATE = '\ud800';
    private static final char MAX_HIGH_SURROGATE = '\udbff';
    private String clientId;
    private String serverURI;
    protected ClientComms comms;
    private Hashtable topics;
    private MqttClientPersistence persistence;

    public MqttAsyncClient(String serverURI, String clientId) throws MqttException {
        this(serverURI, clientId, new MqttDefaultFilePersistence());
    }

    public MqttAsyncClient(String serverURI, String clientId, MqttClientPersistence persistence) throws MqttException {
        this(serverURI, clientId, persistence, new TimerPingSender());
    }

    public MqttAsyncClient(String serverURI, String clientId, MqttClientPersistence persistence, MqttPingSender pingSender) throws MqttException {
        String methodName = "MqttAsyncClient";
        if (clientId == null) {
            throw new IllegalArgumentException("Null clientId");
        }
        int clientIdLength = 0;
        for (int i = 0; i < clientId.length() - 1; ++i) {
            if (MqttAsyncClient.Character_isHighSurrogate(clientId.charAt(i))) {
                ++i;
            }
            ++clientIdLength;
        }
        if (clientIdLength > 65535) {
            throw new IllegalArgumentException("ClientId longer than 65535 characters");
        }
        MqttConnectOptions.validateURI(serverURI);
        this.serverURI = serverURI;
        this.clientId = clientId;
        this.persistence = persistence;
        if (this.persistence == null) {
            this.persistence = new MemoryPersistence();
        }
        this.persistence.open(clientId, serverURI);
        this.comms = new ClientComms(this, this.persistence, pingSender);
        this.persistence.close();
        this.topics = new Hashtable();
    }

    protected static boolean Character_isHighSurrogate(char ch) {
        return ch >= '\ud800' && ch <= '\udbff';
    }

    protected NetworkModule[] createNetworkModules(String address, MqttConnectOptions options) throws MqttException, MqttSecurityException {
        String methodName = "createNetworkModules";
        NetworkModule[] networkModules = null;
        String[] serverURIs = options.getServerURIs();
        String[] array = null;
        array = serverURIs == null ? new String[]{address} : (serverURIs.length == 0 ? new String[]{address} : serverURIs);
        networkModules = new NetworkModule[array.length];
        for (int i = 0; i < array.length; ++i) {
            networkModules[i] = this.createNetworkModule(array[i], options);
        }
        return networkModules;
    }

    private NetworkModule createNetworkModule(String address, MqttConnectOptions options) throws MqttException, MqttSecurityException {
        NetworkModule netModule;
        String methodName = "createNetworkModule";
        SocketFactory factory = options.getSocketFactory();
        int serverURIType = MqttConnectOptions.validateURI(address);
        switch (serverURIType) {
            case 0: {
                String shortAddress = address.substring(6);
                String host = this.getHostName(shortAddress);
                int port = this.getPort(shortAddress, 1883);
                if (factory == null) {
                    factory = SocketFactory.getDefault();
                } else if (factory instanceof SSLSocketFactory) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                netModule = new TCPNetworkModule(factory, host, port, this.clientId);
                ((TCPNetworkModule)netModule).setConnectTimeout(options.getConnectionTimeout());
                break;
            }
            case 1: {
                String[] enabledCiphers;
                String shortAddress = address.substring(6);
                String host = this.getHostName(shortAddress);
                int port = this.getPort(shortAddress, 8883);
                SSLSocketFactoryFactory factoryFactory = null;
                if (factory == null) {
                    factoryFactory = new SSLSocketFactoryFactory();
                    Properties sslClientProps = options.getSSLProperties();
                    if (null != sslClientProps) {
                        factoryFactory.initialize(sslClientProps, null);
                    }
                    factory = factoryFactory.createSocketFactory(null);
                } else if (!(factory instanceof SSLSocketFactory)) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                netModule = new SSLNetworkModule((SSLSocketFactory)factory, host, port, this.clientId);
                ((SSLNetworkModule)netModule).setSSLhandshakeTimeout(options.getConnectionTimeout());
                if (factoryFactory == null || (enabledCiphers = factoryFactory.getEnabledCipherSuites(null)) == null) break;
                ((SSLNetworkModule)netModule).setEnabledCiphers(enabledCiphers);
                break;
            }
            case 2: {
                netModule = new LocalNetworkModule(address.substring(8));
                break;
            }
            default: {
                netModule = null;
            }
        }
        return netModule;
    }

    private int getPort(String uri, int defaultPort) {
        int portIndex = uri.lastIndexOf(58);
        int port = portIndex == -1 ? defaultPort : Integer.parseInt(uri.substring(portIndex + 1));
        return port;
    }

    private String getHostName(String uri) {
        int schemeIndex = uri.lastIndexOf(47);
        int portIndex = uri.lastIndexOf(58);
        if (portIndex == -1) {
            portIndex = uri.length();
        }
        return uri.substring(schemeIndex + 1, portIndex);
    }

    @Override
    public IMqttToken connect(Object userContext, IMqttActionListener callback) throws MqttException, MqttSecurityException {
        return this.connect(new MqttConnectOptions(), userContext, callback);
    }

    @Override
    public IMqttToken connect() throws MqttException, MqttSecurityException {
        return this.connect(null, null);
    }

    @Override
    public IMqttToken connect(MqttConnectOptions options) throws MqttException, MqttSecurityException {
        return this.connect(options, null, null);
    }

    @Override
    public IMqttToken connect(MqttConnectOptions options, Object userContext, IMqttActionListener callback) throws MqttException, MqttSecurityException {
        String methodName = "connect";
        if (this.comms.isConnected()) {
            throw ExceptionHelper.createMqttException(32100);
        }
        if (this.comms.isConnecting()) {
            throw new MqttException(32110);
        }
        if (this.comms.isDisconnecting()) {
            throw new MqttException(32102);
        }
        if (this.comms.isClosed()) {
            throw new MqttException(32111);
        }
        this.comms.setNetworkModules(this.createNetworkModules(this.serverURI, options));
        MqttToken userToken = new MqttToken(this.getClientId());
        ConnectActionListener connectActionListener = new ConnectActionListener(this, this.persistence, this.comms, options, userToken, userContext, callback);
        userToken.setActionCallback(connectActionListener);
        userToken.setUserContext(this);
        this.comms.setNetworkModuleIndex(0);
        connectActionListener.connect();
        return userToken;
    }

    @Override
    public IMqttToken disconnect(Object userContext, IMqttActionListener callback) throws MqttException {
        LogHelper.getHelper(CLASS_NAME).i("Mqtt client disconnect, 2 params");
        return this.disconnect(30000L, userContext, callback);
    }

    @Override
    public IMqttToken disconnect() throws MqttException {
        LogHelper.getHelper(CLASS_NAME).i("Mqtt client disconnect, 0 params");
        return this.disconnect(null, null);
    }

    @Override
    public IMqttToken disconnect(long quiesceTimeout) throws MqttException {
        LogHelper.getHelper(CLASS_NAME).i("Mqtt client disconnect, 1 params");
        return this.disconnect(quiesceTimeout, null, null);
    }

    @Override
    public IMqttToken disconnect(long quiesceTimeout, Object userContext, IMqttActionListener callback) throws MqttException {
        String methodName = "disconnect";
        LogHelper.getHelper(CLASS_NAME).i("Mqtt client disconnect, 3 params");
        MqttToken token = new MqttToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        MqttDisconnect disconnect = new MqttDisconnect();
        this.comms.disconnect(disconnect, quiesceTimeout, token);
        return token;
    }

    @Override
    public void disconnectForcibly() throws MqttException {
        this.disconnectForcibly(30000L, 10000L);
    }

    @Override
    public void disconnectForcibly(long disconnectTimeout) throws MqttException {
        this.disconnectForcibly(30000L, disconnectTimeout);
    }

    @Override
    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout) throws MqttException {
        this.comms.disconnectForcibly(quiesceTimeout, disconnectTimeout);
    }

    @Override
    public boolean isConnected() {
        return this.comms.isConnected();
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getServerURI() {
        return this.serverURI;
    }

    protected MqttTopic getTopic(String topic) {
        MqttTopic.validate(topic, false);
        MqttTopic result = (MqttTopic)this.topics.get(topic);
        if (result == null) {
            result = new MqttTopic(topic, this.comms);
            this.topics.put(topic, result);
        }
        return result;
    }

    public IMqttToken checkPing(Object userContext, IMqttActionListener callback) throws MqttException {
        String methodName = "ping";
        MqttToken token = this.comms.checkForActivity();
        return token;
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos, Object userContext, IMqttActionListener callback) throws MqttException {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos}, userContext, callback);
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos) throws MqttException {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos}, null, null);
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qos) throws MqttException {
        return this.subscribe(topicFilters, qos, null, null);
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qos, Object userContext, IMqttActionListener callback) throws MqttException {
        String methodName = "subscribe";
        if (topicFilters.length != qos.length) {
            throw new IllegalArgumentException();
        }
        String subs = "";
        for (int i = 0; i < topicFilters.length; ++i) {
            if (i > 0) {
                subs = subs + ", ";
            }
            subs = subs + "topic=" + topicFilters[i] + " qos=" + qos[i];
            MqttTopic.validate(topicFilters[i], true);
        }
        MqttToken token = new MqttToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.internalTok.setTopics(topicFilters);
        MqttSubscribe register = new MqttSubscribe(topicFilters, qos);
        this.comms.sendNoWait(register, token);
        return token;
    }

    @Override
    public IMqttToken unsubscribe(String topicFilter, Object userContext, IMqttActionListener callback) throws MqttException {
        return this.unsubscribe(new String[]{topicFilter}, userContext, callback);
    }

    @Override
    public IMqttToken unsubscribe(String topicFilter) throws MqttException {
        return this.unsubscribe(new String[]{topicFilter}, null, null);
    }

    @Override
    public IMqttToken unsubscribe(String[] topicFilters) throws MqttException {
        return this.unsubscribe(topicFilters, null, null);
    }

    @Override
    public IMqttToken unsubscribe(String[] topicFilters, Object userContext, IMqttActionListener callback) throws MqttException {
        String methodName = "unsubscribe";
        String subs = "";
        for (int i = 0; i < topicFilters.length; ++i) {
            if (i > 0) {
                subs = subs + ", ";
            }
            subs = subs + topicFilters[i];
            MqttTopic.validate(topicFilters[i], true);
        }
        MqttToken token = new MqttToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.internalTok.setTopics(topicFilters);
        MqttUnsubscribe unregister = new MqttUnsubscribe(topicFilters);
        this.comms.sendNoWait(unregister, token);
        return token;
    }

    @Override
    public void setCallback(MqttCallback callback) {
        this.comms.setCallback(callback);
    }

    public static String generateClientId() {
        return CLIENT_ID_PREFIX + System.nanoTime();
    }

    @Override
    public IMqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.comms.getPendingDeliveryTokens();
    }

    @Override
    public IMqttDeliveryToken publish(String topic, byte[] payload, int qos, boolean retained, Object userContext, IMqttActionListener callback) throws MqttException, MqttPersistenceException {
        MqttMessage message = new MqttMessage(payload);
        message.setQos(qos);
        message.setRetained(retained);
        return this.publish(topic, message, userContext, callback);
    }

    @Override
    public IMqttDeliveryToken publish(String topic, byte[] payload, int qos, boolean retained) throws MqttException, MqttPersistenceException {
        return this.publish(topic, payload, qos, retained, null, null);
    }

    @Override
    public IMqttDeliveryToken publish(String topic, MqttMessage message) throws MqttException, MqttPersistenceException {
        return this.publish(topic, message, null, null);
    }

    @Override
    public IMqttDeliveryToken publish(String topic, MqttMessage message, Object userContext, IMqttActionListener callback) throws MqttException, MqttPersistenceException {
        String methodName = "publish";
        MqttTopic.validate(topic, false);
        MqttDeliveryToken token = new MqttDeliveryToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.setMessage(message);
        token.internalTok.setTopics(new String[]{topic});
        MqttPublish pubMsg = new MqttPublish(topic, message);
        this.comms.sendNoWait(pubMsg, token);
        return token;
    }

    @Override
    public void close() throws MqttException {
        String methodName = "close";
        this.comms.close();
    }

    public Debug getDebug() {
        return new Debug(this.clientId, this.comms);
    }
}

