/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.org.eclipse.paho.client.mqttv3;

import com.xdja.org.eclipse.paho.client.mqttv3.MqttPingSender;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.ClientComms;
import java.util.Timer;
import java.util.TimerTask;

public class TimerPingSender
implements MqttPingSender {
    private static final String CLASS_NAME = TimerPingSender.class.getName();
    private ClientComms comms;
    private Timer timer;

    @Override
    public void init(ClientComms comms) {
        if (comms == null) {
            throw new IllegalArgumentException("ClientComms cannot be null.");
        }
        this.comms = comms;
    }

    @Override
    public void start() {
        String methodName = "start";
        String clientid = this.comms.getClient().getClientId();
        this.timer = new Timer("MQTT Ping: " + clientid);
        this.timer.schedule((TimerTask)new PingTask(), this.comms.getKeepAlive());
    }

    @Override
    public void stop() {
        String methodName = "stop";
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Override
    public void schedule(long delayInMilliseconds) {
        this.timer.schedule((TimerTask)new PingTask(), delayInMilliseconds);
    }

    private class PingTask
    extends TimerTask {
        private static final String methodName = "PingTask.run";

        private PingTask() {
        }

        @Override
        public void run() {
            TimerPingSender.this.comms.checkForActivity();
        }
    }
}

