/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.org.eclipse.paho.client.mqttv3.internal;

import com.xdja.org.eclipse.paho.client.mqttv3.IMqttActionListener;
import com.xdja.org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttCallback;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttException;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttPingSender;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttToken;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttTopic;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.ClientState;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.CommsCallback;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.CommsReceiver;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.CommsSendToutHandler;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.CommsSender;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.wire.MqttConnack;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.wire.MqttConnect;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import com.xdja.pushsdk.utils.LogHelper;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class ClientComms {
    public static String VERSION = "${project.version}";
    public static String BUILD_LEVEL = "L${build.level}";
    private static final String CLASS_NAME = ClientComms.class.getName();
    private static final byte CONNECTED = 0;
    private static final byte CONNECTING = 1;
    private static final byte DISCONNECTING = 2;
    private static final byte DISCONNECTED = 3;
    private static final byte CLOSED = 4;
    private IMqttAsyncClient client;
    private int networkModuleIndex;
    private NetworkModule[] networkModules;
    private CommsReceiver receiver;
    private CommsSender sender;
    private CommsCallback callback;
    private ClientState clientState;
    private MqttConnectOptions conOptions;
    private MqttClientPersistence persistence;
    private MqttPingSender pingSender;
    private CommsTokenStore tokenStore;
    private CommsSendToutHandler commsSendToutHandler;
    private boolean stoppingComms = false;
    private byte conState = (byte)3;
    private Object conLock = new Object();
    private boolean closePending = false;

    public ClientComms(IMqttAsyncClient client, MqttClientPersistence persistence, MqttPingSender pingSender) throws MqttException {
        this.conState = (byte)3;
        this.client = client;
        this.persistence = persistence;
        this.pingSender = pingSender;
        this.pingSender.init(this);
        this.tokenStore = new CommsTokenStore(this.getClient().getClientId());
        this.callback = new CommsCallback(this);
        this.clientState = new ClientState(persistence, this.tokenStore, this.callback, this, pingSender);
        this.commsSendToutHandler = new CommsSendToutHandler(this.tokenStore, this);
        this.callback.setClientState(this.clientState);
    }

    CommsReceiver getReceiver() {
        return this.receiver;
    }

    void internalSend(MqttWireMessage message, MqttToken token) throws MqttException {
        String methodName = "internalSend";
        if (token.getClient() != null) {
            throw new MqttException(32201);
        }
        token.internalTok.setClient(this.getClient());
        try {
            this.clientState.send(message, token);
        }
        catch (MqttException e) {
            if (message instanceof MqttPublish) {
                this.clientState.undo((MqttPublish)message);
            }
            throw e;
        }
    }

    public void sendNoWait(MqttWireMessage message, MqttToken token) throws MqttException {
        String methodName = "sendNoWait";
        if (!(this.isConnected() || !this.isConnected() && message instanceof MqttConnect || this.isDisconnecting() && message instanceof MqttDisconnect)) {
            throw ExceptionHelper.createMqttException(32104);
        }
        this.internalSend(message, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws MqttException {
        String methodName = "close";
        Object object = this.conLock;
        synchronized (object) {
            if (!this.isClosed()) {
                if (!this.isDisconnected()) {
                    if (this.isConnecting()) {
                        throw new MqttException(32110);
                    }
                    if (this.isConnected()) {
                        throw ExceptionHelper.createMqttException(32100);
                    }
                    if (this.isDisconnecting()) {
                        this.closePending = true;
                        return;
                    }
                }
                this.conState = (byte)4;
                this.clientState.close();
                this.clientState = null;
                this.callback = null;
                this.persistence = null;
                this.sender = null;
                this.pingSender = null;
                this.receiver = null;
                this.networkModules = null;
                this.conOptions = null;
                this.tokenStore = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(MqttConnectOptions options, MqttToken token) throws MqttException {
        String methodName = "connect";
        Object object = this.conLock;
        synchronized (object) {
            if (!this.isDisconnected() || this.closePending) {
                if (this.isClosed() || this.closePending) {
                    throw new MqttException(32111);
                }
                if (this.isConnecting()) {
                    throw new MqttException(32110);
                }
                if (this.isDisconnecting()) {
                    throw new MqttException(32102);
                }
                throw ExceptionHelper.createMqttException(32100);
            }
            this.conState = 1;
            this.conOptions = options;
            MqttConnect connect = new MqttConnect(this.client.getClientId(), options.getMqttVersion(), options.isCleanSession(), options.getKeepAliveInterval(), options.getUserName(), options.getPassword(), options.getWillMessage(), options.getWillDestination());
            this.clientState.setKeepAliveSecs(options.getKeepAliveInterval());
            this.clientState.setCleanSession(options.isCleanSession());
            this.tokenStore.open();
            ConnectBG conbg = new ConnectBG(this, token, connect);
            conbg.start();
        }
    }

    public void setKeepAliveSecs(long time) {
        this.clientState.setKeepAliveSecs(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectComplete(MqttConnack cack, MqttException mex) throws MqttException {
        String methodName = "connectComplete";
        int rc = cack.getReturnCode();
        Object object = this.conLock;
        synchronized (object) {
            if (rc == 0) {
                this.conState = 0;
                return;
            }
        }
        throw mex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownConnection(MqttToken token, MqttException reason) {
        boolean wasConnected;
        String methodName = "shutdownConnection";
        MqttToken endToken = null;
        LogHelper.getHelper(CLASS_NAME).i("Mqtt client shutdownConnection");
        Object object = this.conLock;
        synchronized (object) {
            if (this.stoppingComms || this.closePending) {
                return;
            }
            this.stoppingComms = true;
            wasConnected = this.isConnected() || this.isDisconnecting();
            this.conState = (byte)2;
        }
        if (this.commsSendToutHandler != null) {
            this.commsSendToutHandler.clearQueue();
        }
        if (token != null && !token.isComplete()) {
            token.internalTok.setException(reason);
        }
        if (this.callback != null) {
            this.callback.stop();
        }
        try {
            NetworkModule networkModule;
            if (this.networkModules != null && (networkModule = this.networkModules[this.networkModuleIndex]) != null) {
                networkModule.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.receiver != null) {
            this.receiver.stop();
        }
        this.tokenStore.quiesce(new MqttException(32102));
        endToken = this.handleOldTokens(token, reason);
        try {
            this.clientState.disconnected(reason);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.sender != null) {
            this.sender.stop();
        }
        if (this.pingSender != null) {
            this.pingSender.stop();
        }
        try {
            if (this.persistence != null) {
                this.persistence.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = this.conLock;
        synchronized (object) {
            this.conState = (byte)3;
            this.stoppingComms = false;
        }
        if (endToken != null & this.callback != null) {
            this.callback.asyncOperationComplete(endToken);
        }
        if (wasConnected && this.callback != null) {
            this.callback.connectionLost(reason);
        }
        object = this.conLock;
        synchronized (object) {
            if (this.closePending) {
                try {
                    this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private MqttToken handleOldTokens(MqttToken token, MqttException reason) {
        String methodName = "handleOldTokens";
        MqttToken tokToNotifyLater = null;
        try {
            if (token != null && this.tokenStore.getToken(token.internalTok.getKey()) == null) {
                this.tokenStore.saveToken(token, token.internalTok.getKey());
            }
            Vector toksToNot = this.clientState.resolveOldTokens(reason);
            Enumeration toksToNotE = toksToNot.elements();
            while (toksToNotE.hasMoreElements()) {
                MqttToken tok = (MqttToken)toksToNotE.nextElement();
                if (tok.internalTok.getKey().equals("Disc") || tok.internalTok.getKey().equals("Con")) {
                    tokToNotifyLater = tok;
                    continue;
                }
                this.callback.asyncOperationComplete(tok);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tokToNotifyLater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(MqttDisconnect disconnect, long quiesceTimeout, MqttToken token) throws MqttException {
        String methodName = "disconnect";
        Object object = this.conLock;
        synchronized (object) {
            if (this.isClosed()) {
                throw ExceptionHelper.createMqttException(32111);
            }
            if (this.isDisconnected()) {
                throw ExceptionHelper.createMqttException(32101);
            }
            if (this.isDisconnecting()) {
                throw ExceptionHelper.createMqttException(32102);
            }
            if (Thread.currentThread() == this.callback.getThread()) {
                throw ExceptionHelper.createMqttException(32107);
            }
            this.conState = (byte)2;
            DisconnectBG discbg = new DisconnectBG(disconnect, quiesceTimeout, token);
            discbg.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout) throws MqttException {
        this.clientState.quiesce(quiesceTimeout);
        MqttToken token = new MqttToken(this.client.getClientId());
        try {
            this.internalSend(new MqttDisconnect(), token);
            token.waitForCompletion(disconnectTimeout);
        }
        catch (Exception exception) {
        }
        finally {
            token.internalTok.markComplete(null, null);
            this.shutdownConnection(token, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisconnected() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisconnecting() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 4;
        }
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.callback.setCallback(mqttCallback);
    }

    protected MqttTopic getTopic(String topic) {
        return new MqttTopic(topic, this);
    }

    public void setNetworkModuleIndex(int index) {
        this.networkModuleIndex = index;
    }

    public int getNetworkModuleIndex() {
        return this.networkModuleIndex;
    }

    public NetworkModule[] getNetworkModules() {
        return this.networkModules;
    }

    public void setNetworkModules(NetworkModule[] networkModules) {
        this.networkModules = networkModules;
    }

    public MqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.tokenStore.getOutstandingDelTokens();
    }

    protected void deliveryComplete(MqttPublish msg) throws MqttPersistenceException {
        this.clientState.deliveryComplete(msg);
    }

    public IMqttAsyncClient getClient() {
        return this.client;
    }

    public long getKeepAlive() {
        return this.clientState.getKeepAlive();
    }

    public ClientState getClientState() {
        return this.clientState;
    }

    public MqttConnectOptions getConOptions() {
        return this.conOptions;
    }

    public Properties getDebug() {
        Properties props = new Properties();
        props.put("conState", new Integer(this.conState));
        props.put("serverURI", this.getClient().getServerURI());
        props.put("callback", this.callback);
        props.put("stoppingComms", new Boolean(this.stoppingComms));
        return props;
    }

    public MqttToken checkForActivity() {
        return this.checkForActivity(null);
    }

    public MqttToken checkForActivity(IMqttActionListener listener) {
        MqttToken token = null;
        try {
            token = this.clientState.checkForActivity(listener);
        }
        catch (MqttException e) {
            this.handleRunException(e);
        }
        catch (Exception e) {
            this.handleRunException(e);
        }
        return token;
    }

    private void handleRunException(Exception ex) {
        String methodName = "handleRunException";
        MqttException mex = !(ex instanceof MqttException) ? new MqttException(32109, (Throwable)ex) : (MqttException)ex;
        LogHelper.getHelper(CLASS_NAME).i("Mqtt client shutdownConnection  handleRunException");
        this.shutdownConnection(null, mex);
    }

    private class DisconnectBG
    implements Runnable {
        Thread dBg = null;
        MqttDisconnect disconnect;
        long quiesceTimeout;
        MqttToken token;

        DisconnectBG(MqttDisconnect disconnect, long quiesceTimeout, MqttToken token) {
            this.disconnect = disconnect;
            this.quiesceTimeout = quiesceTimeout;
            this.token = token;
        }

        void start() {
            this.dBg = new Thread((Runnable)this, "MQTT Disc: " + ClientComms.this.getClient().getClientId());
            this.dBg.start();
        }

        @Override
        public void run() {
            String methodName = "disconnectBG:run";
            ClientComms.this.clientState.quiesce(this.quiesceTimeout);
            try {
                ClientComms.this.internalSend(this.disconnect, this.token);
                this.token.internalTok.waitUntilSent();
            }
            catch (MqttException mqttException) {
            }
            finally {
                this.token.internalTok.markComplete(null, null);
                LogHelper.getHelper(CLASS_NAME).i("Mqtt client shutdownConnection  DisconnectBG");
                ClientComms.this.shutdownConnection(this.token, null);
            }
        }
    }

    private class ConnectBG
    implements Runnable {
        ClientComms clientComms = null;
        Thread cBg = null;
        MqttToken conToken;
        MqttConnect conPacket;

        ConnectBG(ClientComms cc, MqttToken cToken, MqttConnect cPacket) {
            this.clientComms = cc;
            this.conToken = cToken;
            this.conPacket = cPacket;
            this.cBg = new Thread((Runnable)this, "MQTT Con: ");
        }

        void start() {
            this.cBg.start();
        }

        @Override
        public void run() {
            String methodName = "connectBG:run";
            MqttException mqttEx = null;
            try {
                MqttDeliveryToken[] toks = ClientComms.this.tokenStore.getOutstandingDelTokens();
                for (int i = 0; i < toks.length; ++i) {
                    toks[i].internalTok.setException(null);
                }
                ClientComms.this.tokenStore.saveToken(this.conToken, this.conPacket);
                NetworkModule networkModule = ClientComms.this.networkModules[ClientComms.this.networkModuleIndex];
                networkModule.start();
                ClientComms.this.receiver = new CommsReceiver(this.clientComms, ClientComms.this.clientState, ClientComms.this.tokenStore, networkModule.getInputStream());
                ClientComms.this.receiver.start("MQTT Rec: ");
                ClientComms.this.sender = new CommsSender(this.clientComms, ClientComms.this.clientState, ClientComms.this.tokenStore, networkModule.getOutputStream(), ClientComms.this.commsSendToutHandler);
                ClientComms.this.sender.start("MQTT Snd: ");
                ClientComms.this.callback.start("MQTT Call: ");
                ClientComms.this.internalSend(this.conPacket, this.conToken);
            }
            catch (MqttException ex) {
                mqttEx = ex;
            }
            catch (Exception ex) {
                mqttEx = ExceptionHelper.createMqttException(ex);
            }
            if (mqttEx != null) {
                LogHelper.getHelper(CLASS_NAME).i("Mqtt client shutdownConnection  ConnectBG");
                ClientComms.this.shutdownConnection(this.conToken, mqttEx);
            }
        }
    }
}

