/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.org.eclipse.paho.client.mqttv3.internal;

import com.xdja.org.eclipse.paho.client.mqttv3.MqttException;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;

public class LocalNetworkModule
implements NetworkModule {
    private Class localListener;
    private String brokerName;
    private Object localAdapter;

    public LocalNetworkModule(String brokerName) {
        this.brokerName = brokerName;
    }

    @Override
    public void start() throws IOException, MqttException {
        if (!ExceptionHelper.isClassAvailable("com.ibm.mqttdirect.modules.local.bindings.localListener")) {
            throw ExceptionHelper.createMqttException(32103);
        }
        try {
            this.localListener = Class.forName("com.ibm.mqttdirect.modules.local.bindings.localListener");
            Method connect_m = this.localListener.getMethod("connect", String.class);
            this.localAdapter = connect_m.invoke(null, this.brokerName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.localAdapter == null) {
            throw ExceptionHelper.createMqttException(32103);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream stream = null;
        try {
            Method m = this.localListener.getMethod("getClientInputStream", new Class[0]);
            stream = (InputStream)m.invoke(this.localAdapter, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        OutputStream stream = null;
        try {
            Method m = this.localListener.getMethod("getClientOutputStream", new Class[0]);
            stream = (OutputStream)m.invoke(this.localAdapter, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stream;
    }

    @Override
    public void stop() throws IOException {
        if (this.localAdapter != null) {
            try {
                Method m = this.localListener.getMethod("close", new Class[0]);
                m.invoke(this.localAdapter, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

