/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.org.eclipse.paho.client.mqttv3.internal;

import com.xdja.org.eclipse.paho.client.mqttv3.MqttException;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.TCPNetworkModule;
import java.io.IOException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SSLNetworkModule
extends TCPNetworkModule {
    private static final String CLASS_NAME = SSLNetworkModule.class.getName();
    private String[] enabledCiphers;
    private int handshakeTimeoutSecs;

    public SSLNetworkModule(SSLSocketFactory factory, String host, int port, String resourceContext) {
        super(factory, host, port, resourceContext);
    }

    public String[] getEnabledCiphers() {
        return this.enabledCiphers;
    }

    public void setEnabledCiphers(String[] enabledCiphers) {
        String methodName = "setEnabledCiphers";
        this.enabledCiphers = enabledCiphers;
        if (this.socket != null && enabledCiphers != null) {
            ((SSLSocket)this.socket).setEnabledCipherSuites(enabledCiphers);
        }
    }

    public void setSSLhandshakeTimeout(int timeout) {
        super.setConnectTimeout(timeout);
        this.handshakeTimeoutSecs = timeout;
    }

    @Override
    public void start() throws IOException, MqttException {
        super.start();
        this.setEnabledCiphers(this.enabledCiphers);
        int soTimeout = this.socket.getSoTimeout();
        if (soTimeout == 0) {
            this.socket.setSoTimeout(this.handshakeTimeoutSecs * 1000);
        }
        ((SSLSocket)this.socket).startHandshake();
        this.socket.setSoTimeout(soTimeout);
    }
}

