/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.org.eclipse.paho.client.mqttv3.internal;

import com.xdja.org.eclipse.paho.client.mqttv3.MqttException;
import com.xdja.org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.SocketFactory;

public class TCPNetworkModule
implements NetworkModule {
    private static final String CLASS_NAME = TCPNetworkModule.class.getName();
    protected Socket socket;
    private SocketFactory factory;
    private String host;
    private int port;
    private int conTimeout;

    public TCPNetworkModule(SocketFactory factory, String host, int port, String resourceContext) {
        this.factory = factory;
        this.host = host;
        this.port = port;
    }

    @Override
    public void start() throws IOException, MqttException {
        String methodName = "start";
        try {
            InetSocketAddress sockaddr = new InetSocketAddress(this.host, this.port);
            this.socket = this.factory.createSocket();
            this.socket.connect(sockaddr, this.conTimeout * 1000);
        }
        catch (ConnectException ex) {
            throw new MqttException(32103, (Throwable)ex);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public void stop() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public void setConnectTimeout(int timeout) {
        this.conTimeout = timeout;
    }
}

