/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.org.eclipse.paho.client.mqttv3.util;

import com.xdja.org.eclipse.paho.client.mqttv3.internal.ClientComms;
import java.util.Enumeration;
import java.util.Properties;

public class Debug {
    private static final String CLASS_NAME = ClientComms.class.getName();
    private static final String separator = "==============";
    private static final String lineSep = System.getProperty("line.separator", "\n");
    private String clientID;
    private ClientComms comms;

    public Debug(String clientID, ClientComms comms) {
        this.clientID = clientID;
        this.comms = comms;
    }

    public void dumpClientDebug() {
        this.dumpClientComms();
        this.dumpConOptions();
        this.dumpClientState();
        this.dumpBaseDebug();
    }

    public void dumpBaseDebug() {
        this.dumpVersion();
        this.dumpSystemProperties();
        this.dumpMemoryTrace();
    }

    protected void dumpMemoryTrace() {
    }

    protected void dumpVersion() {
        StringBuffer vInfo = new StringBuffer();
        vInfo.append(lineSep + separator + " Version Info " + separator + lineSep);
        vInfo.append(Debug.left("Version", 20, ' ') + ":  " + ClientComms.VERSION + lineSep);
        vInfo.append(Debug.left("Build Level", 20, ' ') + ":  " + ClientComms.BUILD_LEVEL + lineSep);
        vInfo.append("==========================================" + lineSep);
    }

    public void dumpSystemProperties() {
    }

    public void dumpClientState() {
        Properties props = null;
        if (this.comms != null && this.comms.getClientState() != null) {
            props = this.comms.getClientState().getDebug();
        }
    }

    public void dumpClientComms() {
        Properties props = null;
        if (this.comms != null) {
            props = this.comms.getDebug();
        }
    }

    public void dumpConOptions() {
        Properties props = null;
        if (this.comms != null) {
            props = this.comms.getConOptions().getDebug();
        }
    }

    public static String dumpProperties(Properties props, String name) {
        StringBuffer propStr = new StringBuffer();
        Enumeration<?> propsE = props.propertyNames();
        propStr.append(lineSep + separator + " " + name + " " + separator + lineSep);
        while (propsE.hasMoreElements()) {
            String key = (String)propsE.nextElement();
            propStr.append(Debug.left(key, 28, ' ') + ":  " + props.get(key) + lineSep);
        }
        propStr.append("==========================================" + lineSep);
        return propStr.toString();
    }

    public static String left(String s, int width, char fillChar) {
        if (s.length() >= width) {
            return s;
        }
        StringBuffer sb = new StringBuffer(width);
        sb.append(s);
        int i = width - s.length();
        while (--i >= 0) {
            sb.append(fillChar);
        }
        return sb.toString();
    }
}

