/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.xdja.pushsdk.PushClient;
import com.xdja.pushsdk.http.HttpManager;
import com.xdja.pushsdk.http.bean.BindSerResult;
import com.xdja.pushsdk.http.bean.RequestBean;
import com.xdja.pushsdk.npc.manager.ProcessNotifyManager;
import com.xdja.pushsdk.npc.manager.PushRequestManager;
import com.xdja.pushsdk.utils.LogHelper;
import com.xdja.pushsdk.utils.ProviderUtil;
import com.xdja.pushsdk.utils.Result;
import com.xdja.pushsdk.utils.SharedPreUtils;
import com.xdja.pushsdk.utils.XDJAExecutorService;
import java.util.ArrayList;
import java.util.List;

public class NPCManager {
    public static boolean isNPCService(Context context) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!service.service.getClassName().endsWith("MqttService") || !service.service.getPackageName().equals(context.getPackageName())) continue;
            LogHelper.getHelper().d("NPCS IS EXISTED::  PROCESS::" + service.process);
            return true;
        }
        LogHelper.getHelper().d("NPCS IS INEXISTED");
        return false;
    }

    protected static int initNPC(Context context, String appId, String userId, String key) {
        LogHelper.getHelper().d("InitNPC");
        boolean isValid = NPCManager.verifyInitParams(context, appId, userId);
        if (!isValid) {
            LogHelper.getHelper().w("\u521d\u59cb\u5316\u5931\u8d25\uff0c\u53c2\u6570\u65e0\u6548");
            return 30012;
        }
        SharedPreUtils.savePushBindState(context, 0);
        if (NPCManager.isNPCService(context)) {
            NPCManager.bindNpc(context);
            return 30013;
        }
        if (TextUtils.isEmpty((CharSequence)key)) {
            key = appId;
        }
        SharedPreUtils.savePushClientId(context, appId, userId, key);
        Intent intent = new Intent();
        intent.setAction("com.xdja.PushService");
        intent.setPackage(context.getPackageName());
        ComponentName component = null;
        try {
            component = context.startService(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (component != null) {
            LogHelper.getHelper().d("START NPCS");
            return 30010;
        }
        return 30011;
    }

    protected static int subscribeTopic(List<String> topics, Context context) {
        LogHelper.getHelper().d("subscribeTopic");
        if (!NPCManager.verifyTopicsParams(context, topics)) {
            LogHelper.getHelper().w("\u8ba2\u9605\u5931\u8d25\uff0c\u53c2\u6570\u65e0\u6548");
            return 30022;
        }
        if (!NPCManager.getPushState(context)) {
            LogHelper.getHelper().i("This push is closed by you ");
            return 30023;
        }
        SharedPreUtils.saveTopics(context, topics);
        if (!NPCManager.isNPCService(context)) {
            return 500;
        }
        if (!PushClient.getPushBindState(context)) {
            return 501;
        }
        for (String topic : topics) {
            ProcessNotifyManager.lastGetMsgTimeMillis.put(topic, 0L);
        }
        try {
            ProviderUtil.getPushWorkBinder(context, context.getPackageName()).subTopic(topics, context.getPackageName());
        }
        catch (Exception e) {
            return 30021;
        }
        return 30020;
    }

    protected static int unsubscribeTopic(List<String> topics, Context context) {
        LogHelper.getHelper().d("unsubscribeTopic");
        if (!NPCManager.verifyTopicsParams(context, topics)) {
            return 30032;
        }
        if (!NPCManager.isNPCService(context)) {
            return 500;
        }
        SharedPreUtils.deleteTopics(context, topics);
        try {
            ProviderUtil.getPushWorkBinder(context, context.getPackageName()).unsubTopic(topics, context.getPackageName());
        }
        catch (Exception e) {
            return 30031;
        }
        return 30030;
    }

    protected static boolean getPushState(Context context) {
        if (context == null) {
            return false;
        }
        int state = SharedPreUtils.getPushState(context);
        return state == 0;
    }

    protected static int unRegisterPush(Context context) {
        boolean isValid = NPCManager.verifyReleaseParams(context);
        if (!isValid) {
            LogHelper.getHelper().w("\u91ca\u653e\u8ba2\u9605\u5931\u8d25\uff0c\u53c2\u6570\u65e0\u6548");
            return 30100;
        }
        SharedPreUtils.clearSharedPre(context, "INIT_DEVID");
        SharedPreUtils.clearSharedPre(context, "TOPIC_HIS_2.0");
        SharedPreUtils.clearSharedPre(context, "PUSH_BIND_STATE");
        try {
            ProviderUtil.getPushWorkBinder(context, context.getPackageName()).stopPush();
        }
        catch (Exception e) {
            return 30041;
        }
        return 30040;
    }

    protected static List<String> getPushTopic(Context context) {
        if (context == null) {
            return null;
        }
        return SharedPreUtils.getPushTopics(context);
    }

    private static boolean verifyInitParams(Context context, String appId, String userId) {
        return context != null && !TextUtils.isEmpty((CharSequence)appId) && !TextUtils.isEmpty((CharSequence)userId);
    }

    private static boolean verifyTopicsParams(Context context, List<String> topics) {
        if (context == null) {
            return false;
        }
        if (topics == null) {
            return false;
        }
        if (topics.size() == 0) {
            return false;
        }
        for (String str : topics) {
            if (!TextUtils.isEmpty((CharSequence)str)) continue;
            return false;
        }
        return true;
    }

    public static void bindNpc(Context context) {
        LogHelper.getHelper().d("\u63a8\u9001\u7ed1\u5b9a start");
        XDJAExecutorService.BUSINESS_LIMITED_TASK_EXECUTOR.execute(new BindNpcRunnable(context));
    }

    private static boolean bindRequest(Context context) {
        try {
            boolean isConnected = ProviderUtil.getPushWorkBinder(context, context.getPackageName()).getConnState();
            if (!isConnected) {
                LogHelper.getHelper().d("BindRequest fail by client is not connected");
                return false;
            }
        }
        catch (Exception e) {
            LogHelper.getHelper().e("BindRequest fail by client is not connected");
            return false;
        }
        RequestBean requestBindBean = HttpManager.getRequestBindBean(context);
        if (requestBindBean == null) {
            return false;
        }
        Result<BindSerResult> resultResult = PushRequestManager.getInstance().bindNps(context, requestBindBean);
        BindSerResult bindSerResult = resultResult.getData();
        if (bindSerResult != null && bindSerResult.getValue() == 1) {
            LogHelper.getHelper().i("BindSerResult is 1");
            int pushState = SharedPreUtils.getPushState(context);
            if (pushState != 0) {
                LogHelper.getHelper().d("This push is closed by you   pushState--->>" + pushState);
                return false;
            }
            ArrayList topics = (ArrayList)SharedPreUtils.getPushTopics(context);
            if (topics.size() != 0) {
                try {
                    ProviderUtil.getPushWorkBinder(context, context.getPackageName()).subTopic(topics, context.getPackageName());
                }
                catch (Exception e) {
                    LogHelper.getHelper().e("subscribeTopic fail");
                    return false;
                }
                LogHelper.getHelper().d("subscribeTopic");
            }
            return true;
        }
        return false;
    }

    protected static void checkNpcOnline(Context context) {
        try {
            ProviderUtil.getPushWorkBinder(context, context.getPackageName()).checkPing();
        }
        catch (Exception e) {
            LogHelper.getHelper().e("checkPing fail");
        }
    }

    private static boolean verifyReleaseParams(Context context) {
        return context != null;
    }

    public static class BindNpcRunnable
    implements Runnable {
        Context context;
        int reTimes = 0;

        public BindNpcRunnable(Context context) {
            this.context = context;
        }

        @Override
        public void run() {
            do {
                if (!NPCManager.bindRequest(this.context)) continue;
                this.reTimes = 0;
                SharedPreUtils.savePushBindState(this.context, 0);
                return;
            } while (++this.reTimes <= 5);
            try {
                ProviderUtil.getPushWorkBinder(this.context, this.context.getPackageName()).bindNpcFail();
            }
            catch (Exception e) {
                LogHelper.getHelper().e("bindNpcFail fail");
            }
        }
    }
}

