/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk;

import android.content.Context;
import com.xdja.pushsdk.NPCManager;
import com.xdja.pushsdk.utils.LogHelper;
import com.xdja.pushsdk.utils.SharedPreUtils;
import java.util.ArrayList;
import java.util.List;

public class PushClient {
    public static final String VERSION_CODE = "v3.0.5";

    @Deprecated
    public static int init(Context context, String clientId) {
        return PushClient.init(context, clientId, null, null, null);
    }

    @Deprecated
    public static int init(Context context, String clientId, String webApiIp, String webApiPort, String type) {
        return 30011;
    }

    public static int init(Context context, String appId, String userId, String key) {
        LogHelper.getHelper().i("XdjaPushSdk_Version::v3.0.5");
        return NPCManager.initNPC(context, appId, userId, key);
    }

    public static int subTopic(Context context, String topic) {
        ArrayList<String> topics = new ArrayList<String>();
        topics.add(topic);
        return PushClient.subTopic(context, topics);
    }

    public static int subTopic(Context context, List<String> topics) {
        return NPCManager.subscribeTopic(topics, context);
    }

    public static int unsubscribe(Context context, String topic) {
        ArrayList<String> topics = new ArrayList<String>();
        topics.add(topic);
        return PushClient.unsubscribe(context, topics);
    }

    public static int unsubscribe(Context context, List<String> topics) {
        return NPCManager.unsubscribeTopic(topics, context);
    }

    @Deprecated
    public static int subTopic(Context context, String topic, int type) {
        return PushClient.subTopic(context, topic);
    }

    @Deprecated
    public static int subTopic(Context context, String topic, Object cb, int type) {
        return PushClient.subTopic(context, topic);
    }

    @Deprecated
    public static int subTopic(Context context, List<String> topics, Object cb, int type) {
        return PushClient.subTopic(context, topics);
    }

    @Deprecated
    public static int subTopic(Context context, List<String> topics, int type) {
        return PushClient.subTopic(context, topics);
    }

    @Deprecated
    public static int unsubscribe(Context context, String topic, String category) {
        return PushClient.unsubscribe(context, topic);
    }

    @Deprecated
    public static int unsubscribe(Context context, List<String> topics, String category) {
        return PushClient.unsubscribe(context, topics);
    }

    public static int release(Context ctx) {
        return NPCManager.unRegisterPush(ctx);
    }

    public static void checkPushOnline(Context context) {
        if (context == null) {
            return;
        }
        NPCManager.checkNpcOnline(context);
    }

    public static int startPush(Context context) {
        if (context == null) {
            return 30100;
        }
        SharedPreUtils.savePushState(context, 0);
        List<String> topics = SharedPreUtils.getPushTopics(context);
        if (topics.size() != 0) {
            NPCManager.subscribeTopic(topics, context);
            return 30050;
        }
        return 30052;
    }

    public static int stopPush(Context context) {
        if (context == null) {
            return 30100;
        }
        SharedPreUtils.savePushState(context, -1);
        ArrayList<String> topics = new ArrayList<String>();
        topics.add("UNREGISTER_PUSH");
        NPCManager.unsubscribeTopic(topics, context);
        return 30060;
    }

    public static boolean getPushState(Context context) {
        if (context == null) {
            return false;
        }
        int state = SharedPreUtils.getPushState(context);
        return state == 0;
    }

    public static boolean getPushBindState(Context context) {
        if (context == null) {
            return false;
        }
        int state = SharedPreUtils.getPushBindState(context);
        return state == 0;
    }
}

