/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.aidl;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IPushWork
extends IInterface {
    public void sendMessage(String var1, String var2) throws RemoteException;

    public void subTopic(List<String> var1, String var2) throws RemoteException;

    public void unsubTopic(List<String> var1, String var2) throws RemoteException;

    public void stopPush() throws RemoteException;

    public void checkPing() throws RemoteException;

    public boolean getConnState() throws RemoteException;

    public void bindNpcFail() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPushWork {
        private static final String DESCRIPTOR = "com.xdja.pushsdk.aidl.IPushWork";
        static final int TRANSACTION_sendMessage = 1;
        static final int TRANSACTION_subTopic = 2;
        static final int TRANSACTION_unsubTopic = 3;
        static final int TRANSACTION_stopPush = 4;
        static final int TRANSACTION_checkPing = 5;
        static final int TRANSACTION_getConnState = 6;
        static final int TRANSACTION_bindNpcFail = 7;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPushWork asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IPushWork) {
                return (IPushWork)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.sendMessage(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    ArrayList _arg0 = data.createStringArrayList();
                    String _arg1 = data.readString();
                    this.subTopic(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringList((List)_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    ArrayList _arg0 = data.createStringArrayList();
                    String _arg1 = data.readString();
                    this.unsubTopic(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringList((List)_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    this.stopPush();
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    this.checkPing();
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.getConnState();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(DESCRIPTOR);
                    this.bindNpcFail();
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IPushWork {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendMessage(String topic, String msg) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(topic);
                    _data.writeString(msg);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void subTopic(List<String> topics, String pg) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringList(topics);
                    _data.writeString(pg);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _reply.readStringList(topics);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unsubTopic(List<String> topics, String pg) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringList(topics);
                    _data.writeString(pg);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _reply.readStringList(topics);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void stopPush() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void checkPing() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getConnState() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public void bindNpcFail() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }
}

