/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.http;

import android.text.TextUtils;
import com.xdja.google.gson.Gson;
import com.xdja.google.gson.JsonIOException;
import com.xdja.google.gson.JsonSyntaxException;
import com.xdja.pushsdk.http.HttpManager;
import com.xdja.pushsdk.http.bean.ErrorBean;
import com.xdja.pushsdk.http.bean.RequestBean;
import com.xdja.pushsdk.http.bean.ResponseBean;
import com.xdja.pushsdk.http.bean.ServiceException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class HttpHelper {
    private static final int TIME_OUT = 10000;
    private String url = null;
    private Gson gson;
    private ResponseBean responseBean;

    public HttpHelper(String url) throws ServiceException {
        if (TextUtils.isEmpty((CharSequence)url)) {
            throw ServiceException.create(33566824, "http\u670d\u52a1\u5730\u5740\u4e3a\u7a7a", null);
        }
        this.url = url;
        this.gson = new Gson();
    }

    public ResponseBean request(RequestBean requestBean) throws ServiceException {
        return this.request(requestBean, null);
    }

    public ResponseBean request(RequestBean requestBean, String authorization) throws ServiceException {
        Request request = HttpManager.getRequest(requestBean, this.url);
        OkHttpClient okHttpClient = new OkHttpClient();
        okHttpClient.newBuilder().connectTimeout(10000L, TimeUnit.MILLISECONDS);
        try {
            String jsonStr;
            ErrorBean errorBean;
            Response response = okHttpClient.newCall(request).execute();
            if (null != response && response.isSuccessful()) {
                String jsonStr2 = response.body().string();
                this.responseBean = this.gson.fromJson(jsonStr2, ResponseBean.class);
            } else if (null != response && (errorBean = this.gson.fromJson(jsonStr = response.body().string(), ErrorBean.class)) != null) {
                this.responseBean = new ResponseBean();
                this.responseBean.setError(errorBean);
            }
        }
        catch (JsonIOException e) {
            throw ServiceException.create(33566820, e.getMessage(), e);
        }
        catch (IOException e) {
            throw ServiceException.create(33566822, e.getMessage(), e);
        }
        catch (IllegalStateException e) {
            throw ServiceException.create(33566820, e.getMessage(), e);
        }
        catch (JsonSyntaxException e) {
            throw ServiceException.create(33566820, e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw ServiceException.create(33566823, e.getMessage(), e);
        }
        return this.responseBean;
    }
}

