/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.http;

import android.content.Context;
import android.text.TextUtils;
import com.xdja.google.gson.Gson;
import com.xdja.pushsdk.http.bean.NotifyBean;
import com.xdja.pushsdk.http.bean.RequestBean;
import com.xdja.pushsdk.http.bean.RequestBindBean;
import com.xdja.pushsdk.http.bean.RequestDelMsgBean;
import com.xdja.pushsdk.http.bean.RequestMosBean;
import com.xdja.pushsdk.http.bean.RequestMsgBean;
import com.xdja.pushsdk.http.bean.RequestUnbindBean;
import com.xdja.pushsdk.utils.ConfigurationUtils;
import com.xdja.pushsdk.utils.LogHelper;
import com.xdja.pushsdk.utils.SharedPreUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class HttpManager {
    public static final String URLPARAM_GETMOSQUITTOSERVLET = "/webrelay/api";
    public static final String URLPARAM_HEAD = "http://";
    public static final String URLPARAM_GETMOSCONNID = "/xpush/connections/coninfo";
    public static final String URLPARAM_BINDNPC = "/xpush/connections/binding/enforcement";
    public static final String URLPARAM_GETMSG = "/xpush/msg";
    public static final String URLPARAM_DELMSG = "/xpush/msg";
    public static final String URLPARAM_UNINDNPC = "/xpush/connections/unbinding";
    private static final String GET_MESSAGE_TYPE = "ad";
    public static final String BIND_FAIL = "0";
    private static final String GET_MESSAGE_SIZE = "50";
    private static String servIPString;
    private static String servPortString;
    private static String servTypeString;
    private static final String KEY_SWITCH = "1";

    public static String getRequestMosquittoRequestUrl(Context context) {
        String servIPString = HttpManager.getRequestRequestIp(context);
        String servPortString = HttpManager.getRequestRequestPort(context);
        StringBuilder getAccountUrl = new StringBuilder();
        getAccountUrl.append(URLPARAM_HEAD);
        getAccountUrl.append(servIPString);
        getAccountUrl.append(":");
        getAccountUrl.append(servPortString);
        getAccountUrl.append(URLPARAM_GETMOSQUITTOSERVLET);
        getAccountUrl.append(URLPARAM_GETMOSCONNID);
        return getAccountUrl.toString();
    }

    public static String getRequestRequestIp(Context context) {
        if (TextUtils.isEmpty((CharSequence)servIPString)) {
            servIPString = ConfigurationUtils.getIpPortType(context, "NPSWebApiServiceIp");
        }
        return servIPString;
    }

    public static String getRequestRequestPort(Context context) {
        if (TextUtils.isEmpty((CharSequence)servPortString)) {
            servPortString = ConfigurationUtils.getIpPortType(context, "NPSWebApiServicePort");
        }
        return servPortString;
    }

    public static String getRequestBindRequestUrl(Context context) {
        String servIPString = HttpManager.getRequestRequestIp(context);
        String servPortString = HttpManager.getRequestRequestPort(context);
        StringBuilder getAccountUrl = new StringBuilder();
        getAccountUrl.append(URLPARAM_HEAD);
        getAccountUrl.append(servIPString);
        getAccountUrl.append(":");
        getAccountUrl.append(servPortString);
        getAccountUrl.append(URLPARAM_GETMOSQUITTOSERVLET);
        getAccountUrl.append(URLPARAM_BINDNPC);
        return getAccountUrl.toString();
    }

    public static String getRequestUnbindRequestUrl(Context context) {
        String servIPString = HttpManager.getRequestRequestIp(context);
        String servPortString = HttpManager.getRequestRequestPort(context);
        StringBuilder getAccountUrl = new StringBuilder();
        getAccountUrl.append(URLPARAM_HEAD);
        getAccountUrl.append(servIPString);
        getAccountUrl.append(":");
        getAccountUrl.append(servPortString);
        getAccountUrl.append(URLPARAM_GETMOSQUITTOSERVLET);
        getAccountUrl.append(URLPARAM_UNINDNPC);
        return getAccountUrl.toString();
    }

    public static String getRequestMsgUrl(Context context) {
        String servIPString = HttpManager.getRequestRequestIp(context);
        String servPortString = HttpManager.getRequestRequestPort(context);
        StringBuilder getAccountUrl = new StringBuilder();
        getAccountUrl.append(URLPARAM_HEAD);
        getAccountUrl.append(servIPString);
        getAccountUrl.append(":");
        getAccountUrl.append(servPortString);
        getAccountUrl.append(URLPARAM_GETMOSQUITTOSERVLET);
        getAccountUrl.append("/xpush/msg");
        return getAccountUrl.toString();
    }

    public static String getRequestDelMsgUrl(Context context) {
        String servIPString = HttpManager.getRequestRequestIp(context);
        String servPortString = HttpManager.getRequestRequestPort(context);
        StringBuilder getAccountUrl = new StringBuilder();
        getAccountUrl.append(URLPARAM_HEAD);
        getAccountUrl.append(servIPString);
        getAccountUrl.append(":");
        getAccountUrl.append(servPortString);
        getAccountUrl.append(URLPARAM_GETMOSQUITTOSERVLET);
        getAccountUrl.append("/xpush/msg");
        return getAccountUrl.toString();
    }

    public static RequestBean getRequestMosBean(String appId, String type) {
        RequestMosBean requestBean = new RequestMosBean();
        requestBean.setAppId(appId);
        requestBean.setExt(KEY_SWITCH);
        return requestBean;
    }

    public static RequestBean getRequestBindBean(Context context) {
        String appId = SharedPreUtils.getAppid(context);
        String userId = SharedPreUtils.getUserid(context);
        String connId = SharedPreUtils.getConnid(context);
        LogHelper.getHelper().i("bind ::" + connId);
        if (BIND_FAIL.equalsIgnoreCase(connId)) {
            return null;
        }
        RequestBindBean requestBindBean = new RequestBindBean();
        requestBindBean.setAppId(appId);
        requestBindBean.setConnId(connId);
        requestBindBean.setUserId(userId);
        requestBindBean.setDevType(GET_MESSAGE_TYPE);
        return requestBindBean;
    }

    public static RequestMsgBean getRequestGetMsgBean(NotifyBean bean) {
        RequestMsgBean requestMsgBean = new RequestMsgBean();
        if (bean != null) {
            requestMsgBean.setAppId(bean.getAppId());
            requestMsgBean.setTopic(bean.getTopic());
            requestMsgBean.setQuantity(GET_MESSAGE_SIZE);
            requestMsgBean.setDevType(GET_MESSAGE_TYPE);
            return requestMsgBean;
        }
        return null;
    }

    public static RequestDelMsgBean getRequestDelMsgBean(String topic, String startId, String appId) {
        RequestDelMsgBean requestBean = new RequestDelMsgBean();
        requestBean.setAppId(appId);
        requestBean.setTopic(topic);
        requestBean.setQuantity(GET_MESSAGE_SIZE);
        requestBean.setDevType(GET_MESSAGE_TYPE);
        requestBean.setStartId(startId);
        return requestBean;
    }

    public static Request getRequest(RequestBean requestBean, String url) {
        Gson gson = new Gson();
        String json = gson.toJson(requestBean);
        MediaType jsonMediaType = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((MediaType)jsonMediaType, (String)json);
        Request request = null;
        if (requestBean instanceof RequestMosBean) {
            LogHelper.getHelper().d("\u83b7\u53d6mos\u548cconnid::" + json);
            request = new Request.Builder().url(url).post(body).build();
        } else if (requestBean instanceof RequestBindBean) {
            LogHelper.getHelper().d("\u7ed1\u5b9a\u63a8\u9001::clientId" + json);
            request = new Request.Builder().url(url).post(body).build();
        } else if (requestBean instanceof RequestUnbindBean) {
            LogHelper.getHelper().d("\u89e3\u7ed1\u63a8\u9001::" + json);
            request = new Request.Builder().url(url).post(body).build();
        } else if (requestBean instanceof RequestMsgBean) {
            LogHelper.getHelper().d("\u83b7\u53d6\u95f4\u63a8\u6d88\u606f::" + json);
            StringBuilder getAccountUrl = new StringBuilder();
            getAccountUrl.append(url);
            getAccountUrl.append("?");
            getAccountUrl.append("appId=");
            getAccountUrl.append(((RequestMsgBean)requestBean).getAppId());
            getAccountUrl.append("&topic=");
            getAccountUrl.append(((RequestMsgBean)requestBean).getTopic());
            if (!TextUtils.isEmpty((CharSequence)((RequestMsgBean)requestBean).getStartId())) {
                getAccountUrl.append("&startId=");
                getAccountUrl.append(((RequestMsgBean)requestBean).getStartId());
            }
            getAccountUrl.append("&devType=");
            getAccountUrl.append(((RequestMsgBean)requestBean).getDevType());
            getAccountUrl.append("&quantity=");
            getAccountUrl.append(((RequestMsgBean)requestBean).getQuantity());
            try {
                getAccountUrl.append("&ext=").append(URLEncoder.encode("{\"version\":1}", "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            request = new Request.Builder().url(getAccountUrl.toString()).build();
        } else if (requestBean instanceof RequestDelMsgBean) {
            request = new Request.Builder().url(url).delete(body).build();
        }
        return request;
    }
}

