/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.npc.manager;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import com.xdja.google.gson.Gson;
import com.xdja.google.gson.JsonSyntaxException;
import com.xdja.google.gson.reflect.TypeToken;
import com.xdja.pushsdk.http.bean.MsgBean;
import com.xdja.pushsdk.http.bean.NotifyBean;
import com.xdja.pushsdk.npc.manager.ProcessNotifyManager;
import com.xdja.pushsdk.utils.LogHelper;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;

public class MessageManager {
    private static final int HIS_MSG_ID = 10000000;
    private static final String HANDLER_THREAD_NAME = "xdja_push_sdk";
    private static ProcessNotifyManager processNotifyManager;
    public static LinkedBlockingQueue<NotifyBean> notifyLinkedBlockingQueue;
    private static MessageManager clientManager;
    private static HandlerThread handlerThread;
    private static Handler taskhandler;
    private Context context;

    private MessageManager(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageManager getInstance(Context ctx) {
        Class<MessageManager> clazz = MessageManager.class;
        synchronized (MessageManager.class) {
            if (clientManager == null) {
                clientManager = new MessageManager(ctx);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return clientManager;
        }
    }

    public int getNotifyStr(String topic, NotifyBean notifyBean, String pg) throws JsonSyntaxException {
        if (processNotifyManager == null) {
            processNotifyManager = new ProcessNotifyManager(this.context.getApplicationContext());
        }
        processNotifyManager.startProcessNotifyTask();
        processNotifyManager.startProcessMsgTask();
        if (notifyBean != null) {
            try {
                if ("PULL_HISTORY_MSG".equals(notifyBean.getContext())) {
                    notifyBean.setType(2);
                    LogHelper.getHelper().d("PULL_HISTORY_MSG");
                    notifyBean.setId(10000000L);
                } else {
                    String msg = notifyBean.getContext();
                    MsgBean bean = null;
                    if (!TextUtils.isEmpty((CharSequence)msg)) {
                        Gson gsonMsg = new Gson();
                        bean = (MsgBean)gsonMsg.fromJson(msg, new TypeToken<MsgBean>(){}.getType());
                        notifyBean.setContext(bean.getCon());
                        notifyBean.setId(bean.getId());
                    }
                }
                notifyBean.setPg(pg);
                notifyBean.setTopic(topic);
                notifyBean.setAppId(this.getAppIdFromTopic(topic));
                this.addNotifyBean2Quene(notifyBean);
            }
            catch (Exception e) {
                return 602;
            }
            return 601;
        }
        return 602;
    }

    private void addNotifyBean2Quene(final NotifyBean notifyBean) {
        if (notifyBean.getType() == 2) {
            Iterator<NotifyBean> iter = notifyLinkedBlockingQueue.iterator();
            String toipc = notifyBean.getTopic();
            while (iter.hasNext()) {
                NotifyBean next = iter.next();
                if (!toipc.equalsIgnoreCase(next.getTopic())) continue;
                iter.remove();
                LogHelper.getHelper().d("addNotifyBean2Quene--->>remove");
            }
        }
        if (!notifyLinkedBlockingQueue.offer(notifyBean)) {
            taskhandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        notifyLinkedBlockingQueue.put(notifyBean);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private String getAppIdFromTopic(String topic) {
        String appId;
        if (TextUtils.isEmpty((CharSequence)topic) || !topic.contains("/")) {
            return null;
        }
        try {
            appId = topic.substring(0, topic.indexOf("/"));
        }
        catch (Exception e) {
            return null;
        }
        return appId;
    }

    static {
        notifyLinkedBlockingQueue = new LinkedBlockingQueue();
        handlerThread = new HandlerThread(HANDLER_THREAD_NAME);
        handlerThread.start();
        taskhandler = new Handler(handlerThread.getLooper());
    }
}

