/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.npc.manager;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import com.xdja.pushsdk.http.HttpManager;
import com.xdja.pushsdk.http.bean.DelMsgBean;
import com.xdja.pushsdk.http.bean.DelMsgResult;
import com.xdja.pushsdk.http.bean.MsgBean;
import com.xdja.pushsdk.http.bean.NotifyBean;
import com.xdja.pushsdk.http.bean.RequestDelMsgBean;
import com.xdja.pushsdk.http.bean.RequestMsgBean;
import com.xdja.pushsdk.http.bean.RequestMsgResult;
import com.xdja.pushsdk.manager.BroadcastManager;
import com.xdja.pushsdk.npc.manager.MessageManager;
import com.xdja.pushsdk.npc.manager.PushRequestManager;
import com.xdja.pushsdk.utils.LogHelper;
import com.xdja.pushsdk.utils.Result;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ProcessNotifyManager {
    public static final Map<String, Long> lastGetMsgTimeMillis = new HashMap<String, Long>();
    private final int wait_notify_timeout = 100;
    private final int Notify_Type_Msg = 1;
    private final int Notify_Type_Signal = 2;
    private final int Notify_Type_Msg_Uncached = 4;
    private boolean isStopProcessNotifyTask = false;
    private static boolean isHaveNotHandleNotify = false;
    private static final String MESSAGE_HANDLE_THREAD = "message_handle_thread";
    private static final String HTTP_TASK_HANDLE_THREAD = "http_task_handle_thread";
    private static final String GET_MESSAGE_SIZE = "50";
    private static final int GET_MESSAGE_SIZE_INT = 50;
    private static final String DEL_MESSAGE_SIZE = "-1";
    private static final int DEFAULT_TYPE = -1;
    private static LinkedBlockingQueue<NotifyBean> messageLinkedBlockingQueue = new LinkedBlockingQueue();
    private HandlerThread messageHandlerThread;
    private HandlerThread httpTaskHandlerThread;
    private Handler messageHandler;
    private Handler httpTaskHandler;
    private ExecutorService executorService = Executors.newFixedThreadPool(3);
    private PushRequestManager pushRequestManager;
    private Context mContext;

    public ProcessNotifyManager(Context context) {
        this.mContext = context;
        this.pushRequestManager = PushRequestManager.getInstance();
    }

    public void stopProcessNotifyTask() {
        this.isStopProcessNotifyTask = true;
    }

    public void startProcessNotifyTask() {
        ExecutorService executorService = Executors.newFixedThreadPool(3);
        executorService.execute(new ProcessNotifyRunnable());
    }

    public void startProcessMsgTask() {
        if (this.messageHandlerThread == null) {
            this.messageHandlerThread = new HandlerThread(MESSAGE_HANDLE_THREAD);
            this.messageHandlerThread.start();
        } else if (!this.messageHandlerThread.isAlive()) {
            this.messageHandlerThread.start();
        }
        if (this.httpTaskHandlerThread == null) {
            this.httpTaskHandlerThread = new HandlerThread(HTTP_TASK_HANDLE_THREAD);
            this.httpTaskHandlerThread.start();
        } else if (!this.messageHandlerThread.isAlive()) {
            this.messageHandlerThread.start();
        }
        this.messageHandler = new Handler(this.messageHandlerThread.getLooper());
        this.httpTaskHandler = new Handler(this.httpTaskHandlerThread.getLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAllowGetMsgByTime(String topic) {
        long currentTime = System.currentTimeMillis();
        Map<String, Long> map = lastGetMsgTimeMillis;
        synchronized (map) {
            Long lastGetMsgTime;
            if (lastGetMsgTimeMillis.containsKey(topic) && (lastGetMsgTime = lastGetMsgTimeMillis.get(topic)) != null) {
                return currentTime - lastGetMsgTime >= 100L;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSignalNotify(final NotifyBean notifyBean) {
        if (notifyBean != null) {
            Map<String, Long> map = lastGetMsgTimeMillis;
            synchronized (map) {
                lastGetMsgTimeMillis.put(notifyBean.getTopic(), System.currentTimeMillis());
            }
        }
        this.httpTaskHandler.post(new Runnable(){

            @Override
            public void run() {
                ProcessNotifyManager.this.pullMsgFromServ(notifyBean);
            }
        });
        isHaveNotHandleNotify = false;
    }

    private void pullMsgFromServ(NotifyBean notifyBean) {
        RequestMsgBean requestMsgBean = HttpManager.getRequestGetMsgBean(notifyBean);
        if (requestMsgBean != null) {
            boolean isHasMsg = true;
            long firstId = 0L;
            long lastId = 0L;
            ArrayList<NotifyBean> notifyBeans = new ArrayList<NotifyBean>();
            int pullMsgNum = 0;
            while (isHasMsg) {
                LogHelper.getHelper().d("pullMsgFromServ--->>begain  " + System.currentTimeMillis());
                Result<RequestMsgResult> msgBean = this.pushRequestManager.getMsg(this.mContext, requestMsgBean);
                if (msgBean != null && !msgBean.isError()) {
                    NotifyBean bean;
                    List<NotifyBean> notifys = this.convertMsgResult2NotifyBean(msgBean, notifyBean.getTopic(), notifyBean.getPg());
                    notifyBeans.addAll(notifys);
                    pullMsgNum = notifys.size();
                    if (notifys.size() > 1 && (bean = notifys.get(notifys.size() - 1)) != null) {
                        lastId = bean.getId();
                    }
                    LogHelper.getHelper().d("pullMsgFromServ--->>end   size::" + notifys.size());
                    LogHelper.getHelper().d("pullMsgFromServ--->>end   " + System.currentTimeMillis());
                } else if (msgBean != null && msgBean.isError()) {
                    LogHelper.getHelper().e("Error message:" + msgBean.getMessage() + "Error code:" + msgBean.getResultCode());
                }
                if (pullMsgNum < 50) {
                    isHasMsg = false;
                }
                requestMsgBean.setStartId(lastId + "");
            }
            if (notifyBeans.size() > 0) {
                firstId = ((NotifyBean)notifyBeans.get(0)).getId();
                RequestDelMsgBean delMsgBean = HttpManager.getRequestDelMsgBean(notifyBean.getTopic(), firstId + "", notifyBean.getAppId());
                if (delMsgBean != null) {
                    Result<DelMsgResult> result = this.pushRequestManager.delMsg(this.mContext, delMsgBean);
                    if (!result.isError() && result.getData().getValue() > 0) {
                        this.handleMessageNotify(notifyBeans);
                        LogHelper.getHelper().i("PMCS::" + notifyBeans.size() + " T::" + System.currentTimeMillis());
                        notifyBeans.clear();
                    } else if (result.isError()) {
                        LogHelper.getHelper().e("delMsgBean message: fail::" + result.getMessage());
                    }
                }
            }
            notifyBeans.clear();
        }
    }

    private void handleMessageNotify(NotifyBean notifyBean) {
        this.addNotifyBean2Quene(notifyBean);
        this.startHandleMsgThread();
    }

    private void handleMessageNotify(List<NotifyBean> notifyBeans) {
        for (NotifyBean bean : notifyBeans) {
            this.addNotifyBean2Quene(bean);
        }
        this.startHandleMsgThread();
    }

    private RequestMsgBean getRequestMsgBean(NotifyBean bean) {
        RequestMsgBean requestMsgBean = new RequestMsgBean();
        if (bean != null) {
            return requestMsgBean;
        }
        return null;
    }

    private DelMsgBean getDelMsgBean(String id2, String topic) {
        DelMsgBean delMsgBean = null;
        delMsgBean = new DelMsgBean();
        delMsgBean.setUser(topic);
        delMsgBean.setMsgStartId(id2);
        delMsgBean.setDelMsgSize(DEL_MESSAGE_SIZE);
        return delMsgBean;
    }

    private List<NotifyBean> convertMsgResult2NotifyBean(Result<RequestMsgResult> result, String topic, String pg) {
        MsgBean[] beans;
        ArrayList<NotifyBean> notifyBeans = new ArrayList<NotifyBean>();
        NotifyBean notifyBean = null;
        MsgBean bean = null;
        if (result.getData() != null && (beans = result.getData().getData()) != null) {
            for (int i = 0; i < beans.length; ++i) {
                notifyBean = new NotifyBean();
                bean = beans[i];
                notifyBean.setContext(bean.getCon());
                notifyBean.setId(bean.getId());
                notifyBean.setExp(bean.getExp());
                notifyBean.setType(-1);
                notifyBean.setTopic(topic);
                notifyBean.setPg(pg);
                notifyBeans.add(notifyBean);
            }
        }
        return notifyBeans;
    }

    private void addNotifyBean2Quene(final NotifyBean notifyBean) {
        if (!messageLinkedBlockingQueue.offer(notifyBean)) {
            this.messageHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        messageLinkedBlockingQueue.put(notifyBean);
                        ProcessNotifyManager.this.startHandleMsgThread();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private void startHandleMsgThread() {
        if (this.executorService != null) {
            this.executorService.execute(new HandleMsgRunnable());
        }
    }

    private class HandleMsgRunnable
    implements Runnable {
        private HandleMsgRunnable() {
        }

        @Override
        public void run() {
            NotifyBean bean;
            while ((bean = (NotifyBean)messageLinkedBlockingQueue.poll()) != null) {
                BroadcastManager.getInstance().sendPushMsgIntent(ProcessNotifyManager.this.mContext, bean.getContext(), bean.getTopic(), bean.getPg(), bean.getId());
                LogHelper.getHelper().i("Msg Broadcast to APP");
                LogHelper.getHelper().d("\u5e7f\u64ad\u5c06\u6d88\u606f\u4f20\u9012\u7ed9\u4e0a\u5c42APP");
            }
        }
    }

    public class ProcessNotifyRunnable
    implements Runnable {
        @Override
        public void run() {
            do {
                NotifyBean notifyBean;
                if ((notifyBean = this.getNotifyBeanFromMsgQueue()) == null) {
                    if (!isHaveNotHandleNotify) continue;
                    ProcessNotifyManager.this.handleSignalNotify(notifyBean);
                    continue;
                }
                if (notifyBean.getType() == 1 || notifyBean.getType() == 4 || notifyBean.getType() == 6 || notifyBean.getType() == 5) {
                    RequestDelMsgBean delMsgBean;
                    ProcessNotifyManager.this.handleMessageNotify(notifyBean);
                    LogHelper.getHelper().i("PMCS::1 T::" + System.currentTimeMillis());
                    if (notifyBean.getType() == 1 && (delMsgBean = HttpManager.getRequestDelMsgBean(notifyBean.getTopic(), notifyBean.getId() + "", notifyBean.getAppId())) != null) {
                        ProcessNotifyManager.this.pushRequestManager.delMsg(ProcessNotifyManager.this.mContext, delMsgBean);
                    }
                    if (!isHaveNotHandleNotify || !ProcessNotifyManager.this.isAllowGetMsgByTime(notifyBean.getTopic())) continue;
                    ProcessNotifyManager.this.handleSignalNotify(notifyBean);
                    continue;
                }
                if (notifyBean.getType() != 2) continue;
                if (notifyBean.getContext().equals("PULL_HISTORY_MSG")) {
                    ProcessNotifyManager.this.handleSignalNotify(notifyBean);
                }
                if (ProcessNotifyManager.this.isAllowGetMsgByTime(notifyBean.getTopic())) {
                    ProcessNotifyManager.this.handleSignalNotify(notifyBean);
                    continue;
                }
                isHaveNotHandleNotify = true;
            } while (!ProcessNotifyManager.this.isStopProcessNotifyTask);
        }

        private NotifyBean getNotifyBeanFromMsgQueue() {
            NotifyBean notifyBean = null;
            try {
                notifyBean = isHaveNotHandleNotify ? MessageManager.notifyLinkedBlockingQueue.poll(this.getBlockTimeout(), TimeUnit.MILLISECONDS) : MessageManager.notifyLinkedBlockingQueue.take();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return notifyBean;
        }

        private int getBlockTimeout() {
            return 100;
        }
    }
}

