/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.npc.manager;

import android.content.Context;
import com.xdja.google.gson.Gson;
import com.xdja.google.gson.JsonArray;
import com.xdja.google.gson.JsonElement;
import com.xdja.google.gson.JsonIOException;
import com.xdja.google.gson.JsonParser;
import com.xdja.google.gson.JsonSyntaxException;
import com.xdja.pushsdk.http.HttpHelper;
import com.xdja.pushsdk.http.HttpManager;
import com.xdja.pushsdk.http.bean.BindSerResult;
import com.xdja.pushsdk.http.bean.DelMsgResult;
import com.xdja.pushsdk.http.bean.ErrorBean;
import com.xdja.pushsdk.http.bean.Mosquito;
import com.xdja.pushsdk.http.bean.MsgBean;
import com.xdja.pushsdk.http.bean.RequestBean;
import com.xdja.pushsdk.http.bean.RequestMsgResult;
import com.xdja.pushsdk.http.bean.ResponseBean;
import com.xdja.pushsdk.http.bean.ServiceException;
import com.xdja.pushsdk.http.bean.UnbindSerResult;
import com.xdja.pushsdk.npc.impl.IPushManager;
import com.xdja.pushsdk.utils.ErrCode;
import com.xdja.pushsdk.utils.LogHelper;
import com.xdja.pushsdk.utils.Result;
import java.util.ArrayList;

public class PushRequestManager
implements IPushManager {
    private static PushRequestManager mInstance;

    private PushRequestManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PushRequestManager getInstance() {
        Class<PushRequestManager> clazz = PushRequestManager.class;
        synchronized (PushRequestManager.class) {
            if (mInstance == null) {
                mInstance = new PushRequestManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    @Override
    public Result<Mosquito> getConnid(Context context, RequestBean requestBean) {
        Result<Mosquito> result = new Result();
        String url = HttpManager.getRequestMosquittoRequestUrl(context);
        HttpHelper httpHelper = new HttpHelper(url);
        try {
            ResponseBean reponse = httpHelper.request(requestBean);
            result = this.parseMosquitto(reponse);
        }
        catch (ServiceException e) {
            result.setResultCode(e.getErrCode());
            result.setMessage(e.getMessage());
        }
        catch (JsonIOException e) {
            e.printStackTrace();
            result.setResultCode(33566733);
            result.setMessage(ErrCode.getErrMsg(33566733));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            result.setResultCode(33566823);
            result.setMessage(ErrCode.getErrMsg(33566733));
        }
        return result;
    }

    @Override
    public Result<BindSerResult> bindNps(Context context, RequestBean requestBean) {
        Result<BindSerResult> result = new Result();
        String url = HttpManager.getRequestBindRequestUrl(context);
        HttpHelper httpHelper = new HttpHelper(url);
        try {
            ResponseBean reponse = httpHelper.request(requestBean);
            result = this.parseBind(reponse);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            result.setResultCode(e.getErrCode());
            result.setMessage(e.getMessage());
        }
        catch (JsonIOException e) {
            e.printStackTrace();
            result.setResultCode(33566733);
            result.setMessage(ErrCode.getErrMsg(33566733));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            result.setResultCode(33566823);
            result.setMessage(ErrCode.getErrMsg(33566733));
        }
        return result;
    }

    @Override
    public Result<UnbindSerResult> unbindNps(Context context, RequestBean requestBean) {
        Result<UnbindSerResult> result = new Result();
        String url = HttpManager.getRequestUnbindRequestUrl(context);
        HttpHelper httpHelper = new HttpHelper(url);
        try {
            ResponseBean reponse = httpHelper.request(requestBean);
            result = this.parseUnbind(reponse);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            result.setResultCode(e.getErrCode());
            result.setMessage(e.getMessage());
        }
        catch (JsonIOException e) {
            e.printStackTrace();
            result.setResultCode(33566733);
            result.setMessage(ErrCode.getErrMsg(33566733));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            result.setResultCode(33566823);
            result.setMessage(ErrCode.getErrMsg(33566733));
        }
        return result;
    }

    @Override
    public Result<RequestMsgResult> getMsg(Context context, RequestBean requestBean) {
        Result<RequestMsgResult> result = new Result();
        String url = HttpManager.getRequestMsgUrl(context);
        HttpHelper httpHelper = new HttpHelper(url);
        try {
            ResponseBean reponse = httpHelper.request(requestBean);
            result = this.parseGetMsg(reponse);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            result.setResultCode(e.getErrCode());
            result.setMessage(e.getMessage());
        }
        catch (JsonIOException e) {
            e.printStackTrace();
            result.setResultCode(33566736);
            result.setMessage(ErrCode.getErrMsg(33566736));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            result.setResultCode(33566823);
            result.setMessage(ErrCode.getErrMsg(33566736));
        }
        return result;
    }

    @Override
    public Result<DelMsgResult> delMsg(Context context, RequestBean requestBean) {
        Result<DelMsgResult> result = new Result();
        String url = HttpManager.getRequestDelMsgUrl(context);
        HttpHelper httpHelper = new HttpHelper(url);
        try {
            ResponseBean reponse = httpHelper.request(requestBean);
            result = this.parseDelMsg(reponse);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            result.setResultCode(e.getErrCode());
            result.setMessage(e.getMessage());
        }
        catch (JsonIOException e) {
            e.printStackTrace();
            result.setResultCode(33566737);
            result.setMessage(ErrCode.getErrMsg(33566737));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            result.setResultCode(33566823);
            result.setMessage(ErrCode.getErrMsg(33566737));
        }
        return result;
    }

    private Result<Mosquito> parseMosquitto(ResponseBean reponse) throws JsonSyntaxException {
        Result<Mosquito> result = new Result<Mosquito>();
        if (reponse == null || reponse.getResult() == null && reponse.getError() == null) {
            result.setResultCode(33566731);
            result.setMessage(ErrCode.getErrMsg(33566731));
            return result;
        }
        Object resultObject = reponse.getResult();
        if (resultObject != null) {
            Gson gson = new Gson();
            String json = gson.toJson(resultObject);
            Mosquito mosquitoInfo = new Gson().fromJson(json, Mosquito.class);
            LogHelper.getHelper().d("Get mos callback json : " + json);
            if (mosquitoInfo == null) {
                result.setResultCode(33566732);
                result.setMessage(ErrCode.getErrMsg(33566732));
            } else {
                result.setData(mosquitoInfo);
            }
        } else if (reponse.getError() != null) {
            ErrorBean errorBean = reponse.getError();
            result.setResultCode(errorBean.getCode());
            result.setMessage(errorBean.getMessage());
        }
        return result;
    }

    private Result<RequestMsgResult> parseGetMsg(ResponseBean reponse) throws JsonSyntaxException {
        Result<RequestMsgResult> result = new Result<RequestMsgResult>();
        if (reponse == null || reponse.getResult() == null && reponse.getError() == null) {
            return result;
        }
        Object resultObject = reponse.getResult();
        if (resultObject != null) {
            Gson gson = new Gson();
            ArrayList<MsgBean> msgBeans = new ArrayList<MsgBean>();
            String json = gson.toJson(resultObject);
            JsonParser parser = new JsonParser();
            JsonElement jsonElement = parser.parse(json);
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            for (JsonElement bean : jsonArray) {
                String x = bean.getAsString();
                LogHelper.getHelper().d(x);
                MsgBean msgBean = gson.fromJson(x, MsgBean.class);
                msgBeans.add(msgBean);
            }
            RequestMsgResult requestMsgResult = new RequestMsgResult();
            MsgBean[] msgs = new MsgBean[msgBeans.size()];
            msgBeans.toArray(msgs);
            requestMsgResult.setData(msgs);
            if (requestMsgResult == null) {
                result.setResultCode(33566734);
                result.setMessage(ErrCode.getErrMsg(33566734));
            } else {
                result.setData(requestMsgResult);
            }
        } else if (reponse.getError() != null) {
            ErrorBean errorBean = reponse.getError();
            result.setResultCode(errorBean.getCode());
            result.setMessage(errorBean.getMessage());
        }
        return result;
    }

    private Result<DelMsgResult> parseDelMsg(ResponseBean reponse) throws JsonSyntaxException {
        Result<DelMsgResult> result = new Result<DelMsgResult>();
        if (reponse == null || reponse.getResult() == null && reponse.getError() == null) {
            result.setResultCode(33566731);
            result.setMessage(ErrCode.getErrMsg(33566731));
            return result;
        }
        Object resultObject = reponse.getResult();
        if (resultObject != null) {
            Float res = Float.valueOf(reponse.getResult().toString());
            DelMsgResult delMsgResult = new DelMsgResult();
            delMsgResult.setValue(res.intValue());
            result.setData(delMsgResult);
        } else if (reponse.getError() != null) {
            ErrorBean errorBean = reponse.getError();
            result.setResultCode(errorBean.getCode());
            result.setMessage(errorBean.getMessage());
        }
        return result;
    }

    private Result<BindSerResult> parseBind(ResponseBean reponse) throws JsonSyntaxException {
        Result<BindSerResult> result = new Result<BindSerResult>();
        if (reponse == null || reponse.getResult() == null && reponse.getError() == null) {
            result.setResultCode(33566731);
            result.setMessage(ErrCode.getErrMsg(33566731));
            return result;
        }
        if (reponse.getError() != null) {
            ErrorBean errorBean = reponse.getError();
            result.setResultCode(errorBean.getCode());
            result.setMessage(errorBean.getMessage());
            return result;
        }
        Float resultObject = Float.valueOf(reponse.getResult().toString());
        BindSerResult bindSerResult = new BindSerResult();
        bindSerResult.setValue(resultObject.intValue());
        result.setData(bindSerResult);
        return result;
    }

    private Result<UnbindSerResult> parseUnbind(ResponseBean reponse) throws JsonSyntaxException {
        Result<UnbindSerResult> result = new Result<UnbindSerResult>();
        if (reponse == null || reponse.getResult() == null && reponse.getError() == null) {
            result.setResultCode(33566731);
            result.setMessage(ErrCode.getErrMsg(33566731));
            return result;
        }
        if (reponse.getError() != null) {
            ErrorBean errorBean = reponse.getError();
            result.setResultCode(errorBean.getCode());
            result.setMessage(errorBean.getMessage());
            return result;
        }
        boolean value = Boolean.valueOf(reponse.getResult().toString());
        UnbindSerResult bindSerResult = new UnbindSerResult();
        bindSerResult.setValue(value);
        result.setData(bindSerResult);
        return result;
    }
}

