/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.npc.service;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteException;
import com.xdja.pushsdk.NPCManager;
import com.xdja.pushsdk.aidl.IGuardService;
import com.xdja.pushsdk.utils.LogHelper;
import com.xdja.pushsdk.utils.ProviderUtil;

public class GuardService
extends Service {
    private final String tag = "aidl";
    private MyBinder mBinder;
    private String pg = "";

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    @SuppressLint(value={"NewApi"})
    public void onCreate() {
        super.onCreate();
        this.mBinder = new MyBinder();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return 2;
    }

    public boolean onUnbind(Intent intent) {
        this.reStartNPCS();
        return super.onUnbind(intent);
    }

    public void onDestroy() {
        super.onDestroy();
    }

    private void reStartNPCS() {
        if (NPCManager.isNPCService((Context)this)) {
            LogHelper.getHelper().i("GuardService:npcs exist, don't restart npcs");
            return;
        }
        String appId = null;
        try {
            appId = ProviderUtil.getPushNotifyBinder((Context)this, this.getPackageName()).getAppId();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if ("0".equalsIgnoreCase(appId)) {
            return;
        }
        LogHelper.getHelper().i("GuardService:npcs not exist , restart npcs");
        Intent intent = new Intent();
        intent.setPackage(this.getPackageName());
        intent.setAction("com.xdja.PushService");
        this.startService(intent);
        this.stopSelf();
    }

    private class MyBinder
    extends IGuardService.Stub {
        private MyBinder() {
        }

        @Override
        public void isRunningNPCPackage(String packageName) throws RemoteException {
            LogHelper.getHelper().d("npcs exist in packageName::" + packageName);
            GuardService.this.pg = packageName;
        }

        @Override
        public void unBindCon() throws RemoteException {
            GuardService.this.stopSelf();
        }
    }
}

