/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushsdk.npc.service;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.google.gson.Gson;
import com.xdja.org.eclipse.paho.client.mqttv3.IMqttActionListener;
import com.xdja.org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import com.xdja.org.eclipse.paho.client.mqttv3.IMqttToken;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttCallback;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttException;
import com.xdja.org.eclipse.paho.client.mqttv3.MqttMessage;
import com.xdja.pushsdk.http.HttpManager;
import com.xdja.pushsdk.http.bean.Mosquito;
import com.xdja.pushsdk.http.bean.NotifyBean;
import com.xdja.pushsdk.http.bean.RequestBean;
import com.xdja.pushsdk.npc.impl.IObtainMosquittoCb;
import com.xdja.pushsdk.npc.manager.ProcessNotifyManager;
import com.xdja.pushsdk.npc.manager.PushRequestManager;
import com.xdja.pushsdk.npc.service.AlarmPingSender;
import com.xdja.pushsdk.npc.service.MqttConnectCallback;
import com.xdja.pushsdk.npc.service.MqttService;
import com.xdja.pushsdk.utils.LogHelper;
import com.xdja.pushsdk.utils.ProviderUtil;
import com.xdja.pushsdk.utils.Result;
import com.xdja.pushsdk.utils.XDJAExecutorService;
import java.io.Serializable;
import java.net.URLDecoder;

class MqttConnection
implements MqttCallback,
MqttConnectCallback,
IObtainMosquittoCb {
    private static final String THREAD_CONNECT_TASK = "ThreadConnectTask";
    private static final String NOT_CONNECTED = "not connected";
    private static final int DEFAULT_REGETMSQ = 6000;
    private static final int KEEPALIVE = 240;
    private static final int CONTIMEOUT = 20;
    private static final int OBMOS_TIME = 60000;
    private static boolean disconnected = true;
    private static boolean isConnecting = false;
    private static boolean isObtaining = false;
    private static boolean isObtained = false;
    private static Mosquito mosquitto;
    private static String serverURI;
    private static String clientId;
    private static String appId;
    private MqttService service;
    private MqttClientPersistence persistence = null;
    private String key = "-1";
    private MqttConnectOptions connectOptions;
    private MqttAsyncClient myClient = null;
    private boolean cleanSession = true;
    private PowerManager.WakeLock wakelock = null;
    private String wakeLockTag = "MqttConnection";
    private AlarmPingSender alarmPingSender = null;
    private int reTimes = 0;
    private int reconnectTime = 0;
    private int reTimesMos = 0;
    private int reconnectTimeMos = 0;

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        MqttConnection.appId = appId;
    }

    public String getServerURI() {
        return serverURI;
    }

    public void setServerURI(String serverURI) {
        MqttConnection.serverURI = serverURI;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        MqttConnection.clientId = clientId;
    }

    public MqttConnectOptions getConnectOptions() {
        return this.connectOptions;
    }

    public void setConnectOptions(MqttConnectOptions connectOptions) {
        this.connectOptions = connectOptions;
    }

    public MqttService getService() {
        return this.service;
    }

    public void setService(MqttService service) {
        this.service = service;
    }

    public MqttClientPersistence getPersistence() {
        return this.persistence;
    }

    public void setPersistence(MqttClientPersistence persistence) {
        this.persistence = persistence;
    }

    private MqttConnection(MqttService service, String serverURI, String clientId, MqttClientPersistence persistence) {
        MqttConnection.serverURI = serverURI;
        this.service = service;
        MqttConnection.clientId = clientId;
        this.persistence = persistence;
        StringBuffer buff = new StringBuffer(this.getClass().getCanonicalName());
        buff.append(" ");
        buff.append(clientId);
        buff.append(" ");
        buff.append("on host ");
        buff.append(serverURI);
        this.wakeLockTag = buff.toString();
    }

    public MqttConnection(MqttService service) {
        this.service = service;
    }

    public synchronized void initConnect(MqttService service) {
        if (this.isOnline((Context)service)) {
            service.sendPushCode("10002");
            if (mosquitto != null) {
                isObtained = true;
                isObtaining = false;
                LogHelper.getHelper().d("NPCUtil.mosquitto  is existed");
                this.clientConnect(mosquitto);
            } else {
                isObtained = false;
            }
            if (!isObtaining && !isObtained) {
                isObtaining = true;
                LogHelper.getHelper().d("NPCUtil.mosquitto  is inexistent and obtain this ");
                LogHelper.getHelper().d("CurrentPg::" + service.getPackageName());
                this.getMosquitto(this);
            }
        } else {
            service.sendPushCode("10003");
        }
    }

    private void clientConnect(final Mosquito mosquitto) {
        XDJAExecutorService.BUSINESS_LIMITED_TASK_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                if (MqttConnection.this.connectOptions == null) {
                    MqttConnection.this.connectOptions = new MqttConnectOptions();
                }
                MqttConnection.this.connectOptions.setCleanSession(mosquitto.isCleanSession());
                MqttConnection.this.connectOptions.setKeepAliveInterval(mosquitto.getKeepalive());
                MqttConnection.this.connectOptions.setConnectionTimeout(mosquitto.getConnectionTimeout());
                MqttConnection.this.connectOptions.setMqttVersion(3);
                MqttConnection.this.connect(MqttConnection.this.connectOptions, null, null);
            }
        });
    }

    public synchronized void connect(MqttConnectOptions options, String invocationContext, String activityToken) {
        LogHelper.getHelper().i("Push coninect to server mos cid::" + clientId);
        this.connectOptions = options;
        try {
            if (this.alarmPingSender == null) {
                this.alarmPingSender = new AlarmPingSender(this.service);
            }
            int keepAliveInterval = (int)this.alarmPingSender.getLastPingTime();
            this.connectOptions.setKeepAliveInterval(keepAliveInterval);
            if (this.myClient != null) {
                if (isConnecting) {
                    LogHelper.getHelper().d("Push connecting");
                    return;
                }
                if (this.myClient.isConnected()) {
                    if (!TextUtils.isEmpty((CharSequence)this.myClient.getClientId()) && this.myClient.getClientId().equalsIgnoreCase(clientId)) {
                        LogHelper.getHelper().i("Connect to server myClient isConnected cid::" + this.myClient.getClientId());
                        this.doAfterConnectSuccess();
                        return;
                    }
                    LogHelper.getHelper().i("Old myClient close cid::" + this.myClient.getClientId());
                    this.myClient.disconnect();
                }
                LogHelper.getHelper().i("Push connect to server old myClient cid::" + this.myClient.getClientId());
            }
            this.myClient = new MqttAsyncClient(serverURI, clientId, this.persistence, this.alarmPingSender);
            this.myClient.setCallback(this);
            this.myClient.connect(this.connectOptions, invocationContext, new IMqttActionListener(){

                @Override
                public void onSuccess(IMqttToken asyncActionToken) {
                    LogHelper.getHelper().i("Push connect success");
                    LogHelper.getHelper().d("Push connect success::" + MqttConnection.this.myClient.getClientId());
                    MqttConnection.this.doAfterConnectSuccess();
                }

                @Override
                public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                    LogHelper.getHelper().i("Push connect failure");
                    LogHelper.getHelper().d("Push connect failure::" + MqttConnection.this.myClient.getClientId());
                    MqttConnection.this.doAfterConnectFail();
                    MqttConnection.this.reconnect();
                }
            });
        }
        catch (MqttException e) {
            e.printStackTrace();
            LogHelper.getHelper().d("reasonCode: " + e.getReasonCode());
        }
    }

    private void doAfterConnectSuccess() {
        this.setConnectingState(false);
        disconnected = false;
        this.service.mqttConnectSuccess();
        LogHelper.getHelper().d("Subscribe default topic::" + this.getClientId());
        if ("0".equalsIgnoreCase(appId)) {
            try {
                appId = ProviderUtil.getPushNotifyBinder((Context)this.service, this.service.getPackageName()).getAppId();
            }
            catch (Exception e) {
                LogHelper.getHelper().e("getAppId fail");
            }
        }
        if (!"0".equalsIgnoreCase(appId)) {
            this.subscribe(new String[]{"@SYS/notice/" + this.getClientId(), appId + "/broadcast"}, new int[]{0, 0}, null, null);
        } else {
            LogHelper.getHelper().e("GetAppId fail and sub gt fail");
            this.subscribe(new String[]{"@SYS/notice/" + this.getClientId()}, new int[]{0}, null, null);
        }
    }

    private void doAfterConnectFail() {
        this.service.disconnect();
        disconnected = true;
        this.setConnectingState(false);
        this.service.sendPushCode("10004");
    }

    void close() {
        try {
            if (this.myClient != null) {
                this.myClient.close();
            }
        }
        catch (MqttException mqttException) {
            // empty catch block
        }
    }

    void disconnect(long quiesceTimeout, String invocationContext, String activityToken) {
        disconnected = true;
        Bundle resultBundle = new Bundle();
        resultBundle.putString("MqttService.activityToken", activityToken);
        resultBundle.putString("MqttService.invocationContext", invocationContext);
        resultBundle.putString("MqttService.callbackAction", "disconnect");
        if (this.myClient != null && this.myClient.isConnected()) {
            MqttConnectionListener listener = new MqttConnectionListener(resultBundle);
            try {
                this.myClient.disconnect(quiesceTimeout, invocationContext, listener);
            }
            catch (Exception exception) {}
        } else {
            resultBundle.putString("MqttService.errorMessage", NOT_CONNECTED);
        }
        this.releaseWakeLock();
    }

    void disconnect(String invocationContext, String activityToken) {
        this.disconnect(invocationContext, activityToken, null);
    }

    void disconnect(String invocationContext, String activityToken, IMqttActionListener listener) {
        if (this.alarmPingSender != null) {
            this.alarmPingSender.stop();
        }
        disconnected = true;
        Bundle resultBundle = new Bundle();
        resultBundle.putString("MqttService.activityToken", activityToken);
        resultBundle.putString("MqttService.invocationContext", invocationContext);
        resultBundle.putString("MqttService.callbackAction", "disconnect");
        if (this.myClient != null && this.myClient.isConnected()) {
            if (listener == null) {
                listener = new MqttConnectionListener(resultBundle);
            }
            try {
                this.myClient.disconnect(invocationContext, listener);
            }
            catch (Exception exception) {}
        } else {
            resultBundle.putString("MqttService.errorMessage", NOT_CONNECTED);
        }
        this.releaseWakeLock();
    }

    @Override
    public boolean isConnected() {
        return this.myClient != null && this.myClient.isConnected();
    }

    @Override
    public void bindNpcFail() {
        LogHelper.getHelper().i("Bind npc fail");
        if (this.isConnected()) {
            LogHelper.getHelper().i("is not Connected and init connection");
            mosquitto = null;
            isObtained = false;
            if (this.service != null) {
                this.initConnect(this.service);
            }
        }
    }

    public IMqttDeliveryToken publish(String topic, byte[] payload, int qos, boolean retained, String invocationContext, String activityToken) {
        Bundle resultBundle = new Bundle();
        resultBundle.putString("MqttService.callbackAction", "send");
        resultBundle.putString("MqttService.activityToken", activityToken);
        resultBundle.putString("MqttService.invocationContext", invocationContext);
        IMqttDeliveryToken sendToken = null;
        if (this.myClient != null && this.myClient.isConnected()) {
            MqttConnectionListener listener = new MqttConnectionListener(resultBundle);
            try {
                MqttMessage message = new MqttMessage(payload);
                message.setQos(qos);
                message.setRetained(retained);
                sendToken = this.myClient.publish(topic, payload, qos, retained, invocationContext, listener);
                this.storeSendDetails(topic, message, sendToken, invocationContext, activityToken);
            }
            catch (Exception exception) {}
        } else {
            resultBundle.putString("MqttService.errorMessage", NOT_CONNECTED);
        }
        return sendToken;
    }

    public IMqttDeliveryToken publish(String topic, MqttMessage message, String invocationContext, String activityToken) {
        Bundle resultBundle = new Bundle();
        resultBundle.putString("MqttService.callbackAction", "send");
        resultBundle.putString("MqttService.activityToken", activityToken);
        resultBundle.putString("MqttService.invocationContext", invocationContext);
        IMqttDeliveryToken sendToken = null;
        if (this.myClient != null && this.myClient.isConnected()) {
            MqttConnectionListener listener = new MqttConnectionListener(resultBundle);
            try {
                sendToken = this.myClient.publish(topic, message, invocationContext, listener);
                this.storeSendDetails(topic, message, sendToken, invocationContext, activityToken);
            }
            catch (Exception exception) {}
        } else {
            resultBundle.putString("MqttService.errorMessage", NOT_CONNECTED);
        }
        return sendToken;
    }

    public IMqttToken subscribe(final String[] topics, final int[] qos, String invocationContext, String activityToken) {
        Bundle resultBundle = new Bundle();
        resultBundle.putString("MqttService.callbackAction", "subscribe");
        resultBundle.putString("MqttService.activityToken", activityToken);
        resultBundle.putString("MqttService.invocationContext", invocationContext);
        IMqttToken token = null;
        if (this.myClient != null && this.myClient.isConnected()) {
            try {
                token = this.myClient.subscribe(topics, qos, (Object)invocationContext, new IMqttActionListener(){

                    @Override
                    public void onSuccess(IMqttToken arg0) {
                        for (String topic : topics) {
                            ProcessNotifyManager.lastGetMsgTimeMillis.put(topic, 0L);
                            MqttConnection.this.service.pullHisMsg(topic);
                            LogHelper.getHelper().i("subscribe success");
                            LogHelper.getHelper().d("subscribe success:" + topic);
                        }
                    }

                    @Override
                    public void onFailure(IMqttToken arg0, Throwable arg1) {
                        MqttConnection.this.subscribe(topics, qos, null, null);
                        LogHelper.getHelper().i("subscribe failure");
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            this.service.disSubscribe(topics);
            resultBundle.putString("MqttService.errorMessage", NOT_CONNECTED);
        }
        return token;
    }

    void unsubscribe(String topic, String invocationContext, String activityToken) {
        Bundle resultBundle = new Bundle();
        resultBundle.putString("MqttService.callbackAction", "unsubscribe");
        resultBundle.putString("MqttService.activityToken", activityToken);
        resultBundle.putString("MqttService.invocationContext", invocationContext);
        if (this.myClient != null && this.myClient.isConnected()) {
            MqttConnectionListener listener = new MqttConnectionListener(resultBundle);
            try {
                this.myClient.unsubscribe(topic, (Object)invocationContext, (IMqttActionListener)listener);
            }
            catch (Exception exception) {}
        } else {
            resultBundle.putString("MqttService.errorMessage", NOT_CONNECTED);
        }
    }

    void unsubscribe(String[] topic, String invocationContext, String activityToken) {
        Bundle resultBundle = new Bundle();
        resultBundle.putString("MqttService.callbackAction", "unsubscribe");
        resultBundle.putString("MqttService.activityToken", activityToken);
        resultBundle.putString("MqttService.invocationContext", invocationContext);
        if (this.myClient != null && this.myClient.isConnected()) {
            MqttConnectionListener listener = new MqttConnectionListener(resultBundle);
            try {
                this.myClient.unsubscribe(topic, (Object)invocationContext, (IMqttActionListener)listener);
            }
            catch (Exception exception) {}
        } else {
            resultBundle.putString("MqttService.errorMessage", NOT_CONNECTED);
        }
    }

    @Override
    public void connectionLost(Throwable why) {
        if (why != null) {
            LogHelper.getHelper().i("connectionLost" + why.getMessage());
        }
        this.service.sendPushCode("10001");
        disconnected = true;
        this.service.disconnect();
        this.reconnect();
        Bundle resultBundle = new Bundle();
        resultBundle.putString("MqttService.callbackAction", "onConnectionLost");
        if (why != null) {
            resultBundle.putString("MqttService.errorMessage", why.getMessage());
            if (why instanceof MqttException) {
                resultBundle.putSerializable("MqttService.exception", (Serializable)why);
            }
            resultBundle.putString("MqttService.exceptionStack", Log.getStackTraceString((Throwable)why));
        }
        this.releaseWakeLock();
    }

    @Override
    public void messageArrived(String topic, MqttMessage message) throws Exception {
        NotifyBean notifyBean = null;
        Gson gson = new Gson();
        try {
            notifyBean = gson.fromJson(message.toString(), NotifyBean.class);
        }
        catch (Exception e) {
            LogHelper.getHelper().e("npc json msg fail");
        }
        LogHelper.getHelper().d("key--->>" + this.key + "    message--->>" + message.toString());
        if (notifyBean != null) {
            if (notifyBean.getType() != 5 && notifyBean.getType() != 6) {
                String msg = notifyBean.getContext();
                if (!"-1".equals(this.key)) {
                    msg = this.encrypt(msg, this.key);
                    notifyBean.setContext(msg);
                }
            }
            this.service.messageArrivedSender(topic, notifyBean);
        }
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken arg0) {
    }

    private void storeSendDetails(String topic, MqttMessage msg, IMqttDeliveryToken messageToken, String invocationContext, String activityToken) {
    }

    private void acquireWakeLock() {
        if (this.wakelock == null) {
            PowerManager pm = (PowerManager)this.service.getSystemService("power");
            this.wakelock = pm.newWakeLock(1, this.wakeLockTag);
            this.wakelock.setReferenceCounted(false);
        }
        this.wakelock.acquire();
    }

    private void releaseWakeLock() {
        if (this.wakelock != null && this.wakelock.isHeld()) {
            this.wakelock.release();
        }
    }

    void offline() {
        if (!disconnected && !this.cleanSession) {
            Exception e = new Exception("Android offline");
            this.connectionLost(e);
        }
    }

    synchronized void reconnect() {
        if (isObtaining) {
            LogHelper.getHelper().d("isObtaining mosquitto");
            return;
        }
        if (isConnecting) {
            LogHelper.getHelper().d("isConnecting");
            return;
        }
        if (!this.isOnline((Context)this.service)) {
            this.service.sendPushCode("10003");
            LogHelper.getHelper().d("isOnline is not");
            this.reTimes = 0;
            this.reconnectTime = 0;
            return;
        }
        this.service.sendPushCode("10002");
        if (disconnected && isObtained) {
            LogHelper.getHelper().d("mqtt reconnect reTimes::" + this.reTimes + "  reconnectTime::" + this.reconnectTime);
            this.setConnectingState(true);
            this.acquireWakeLock();
            try {
                int keepAliveInterval = (int)this.alarmPingSender.getLastPingTime();
                this.connectOptions.setKeepAliveInterval(keepAliveInterval);
                this.myClient.connect(this.connectOptions, null, new IMqttActionListener(){

                    @Override
                    public void onSuccess(IMqttToken asyncActionToken) {
                        LogHelper.getHelper().i("mqtt reconnect onSuccess");
                        MqttConnection.this.reTimes = 0;
                        MqttConnection.this.reconnectTime = 0;
                        MqttConnection.this.doAfterConnectSuccess();
                        MqttConnection.this.releaseWakeLock();
                    }

                    @Override
                    public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                        LogHelper.getHelper().i("mqtt reconnect onFailure");
                        MqttConnection.this.doAfterConnectFail();
                        if (MqttConnection.this.reconnectTime > 6000) {
                            isObtained = false;
                            mosquitto = null;
                            MqttConnection.this.reTimes = 0;
                            MqttConnection.this.reconnectTime = 0;
                            MqttConnection.this.initConnect(MqttConnection.this.service);
                            LogHelper.getHelper().d("reobtained mosquitto");
                            MqttConnection.this.releaseWakeLock();
                            return;
                        }
                        try {
                            MqttConnection.this.reconnectTime = MqttConnection.this.reconnectTime + (int)(Math.pow(2.0, MqttConnection.this.reTimes) * 1000.0);
                            MqttConnection.this.reTimes++;
                            Thread.sleep(MqttConnection.this.reconnectTime);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        LogHelper.getHelper().d("use last mosquitto to reconnect");
                        MqttConnection.this.releaseWakeLock();
                        MqttConnection.this.reconnect();
                    }
                });
            }
            catch (MqttException e) {
                this.setConnectingState(false);
            }
        } else if (disconnected && !isObtained && this.service != null) {
            this.initConnect(this.service);
        }
    }

    public boolean isOnline(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo info = cm.getActiveNetworkInfo();
        if (info != null && info.isAvailable() && info.isConnected()) {
            LogHelper.getHelper().i("NetWork is ok");
            return true;
        }
        LogHelper.getHelper().i("NetWork is fail");
        return false;
    }

    synchronized void setConnectingState(boolean isConnecting) {
        MqttConnection.isConnecting = isConnecting;
    }

    public String encrypt(String strSrc, String strKey) {
        LogHelper.getHelper().d("Encrypt before:" + strSrc);
        byte[] data = strSrc.getBytes();
        byte[] keyData = strKey.getBytes();
        int keyIndex = 0;
        for (int i = 0; i < strSrc.length(); ++i) {
            data[i] = (byte)(data[i] ^ keyData[keyIndex]);
            if (++keyIndex != keyData.length) continue;
            keyIndex = 0;
        }
        LogHelper.getHelper().d("Encrypt after:" + strSrc);
        try {
            strSrc = URLDecoder.decode(new String(data), "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LogHelper.getHelper().d("Decode after:" + strSrc);
        return strSrc;
    }

    @Override
    public void checkPing() {
        if (null != this.myClient) {
            if (this.myClient.isConnected()) {
                try {
                    IMqttToken token = this.myClient.checkPing(null, null);
                    if (token == null) {
                        LogHelper.getHelper("AlarmPingSender").d("No ping while quiescing\uff0c did not send ping");
                    }
                }
                catch (MqttException e) {
                    e.printStackTrace();
                }
            } else {
                this.reconnect();
            }
        } else if (this.service != null) {
            this.initConnect(this.service);
        }
    }

    public void getMosquitto(final IObtainMosquittoCb cb) {
        try {
            appId = ProviderUtil.getPushNotifyBinder((Context)this.service, this.service.getPackageName()).getAppId();
        }
        catch (Exception e) {
            LogHelper.getHelper().e("getAppId fail");
        }
        if (appId.equals("0")) {
            cb.onResulFail("-1");
            return;
        }
        XDJAExecutorService.BUSINESS_LIMITED_TASK_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                PushRequestManager mosManager = PushRequestManager.getInstance();
                RequestBean requestMosBean = HttpManager.getRequestMosBean(appId, null);
                Result<Mosquito> result = mosManager.getConnid((Context)MqttConnection.this.service, requestMosBean);
                if (result != null && !result.isError()) {
                    Mosquito mosquitto = result.getData();
                    LogHelper.getHelper().d("GetMosquitto : " + mosquitto.toString());
                    cb.onResultGet(mosquitto);
                } else {
                    cb.onResulFail(result.getMessage());
                    LogHelper.getHelper().e("GetMosquitto  fail  by msg " + result.getMessage() + "  and code " + result.getResultCode());
                }
            }
        });
    }

    @Override
    public void onResultGet(Mosquito mos) {
        this.reTimesMos = 0;
        this.reconnectTimeMos = 0;
        isObtained = true;
        isObtaining = false;
        mosquitto = mos;
        mosquitto.setCleanSession(this.cleanSession);
        mosquitto.setKeepalive(240);
        mosquitto.setConnectionTimeout(20);
        if (mosquitto.getK() != null) {
            this.key = mosquitto.getK();
        }
        serverURI = "tcp://" + mosquitto.getHo() + ":" + mosquitto.getPo();
        clientId = mosquitto.getCid();
        StringBuffer buff = new StringBuffer(this.service.getClass().getCanonicalName());
        buff.append(" ");
        buff.append(clientId);
        buff.append(" ");
        buff.append("on host ");
        buff.append(serverURI);
        this.wakeLockTag = buff.toString();
        this.clientConnect(mosquitto);
    }

    @Override
    public void onResulFail(String code) {
        isObtaining = false;
        isObtained = false;
        this.service.sendPushCode("10004");
        LogHelper.getHelper().d(code);
        LogHelper.getHelper().d("reTimesMos::" + this.reTimesMos);
        LogHelper.getHelper().d("reconnectTimeMos::" + this.reconnectTimeMos);
        if (code.equals("-1")) {
            this.reTimesMos = 0;
            this.reconnectTimeMos = 0;
            this.service.stopSelf();
            return;
        }
        if (this.reconnectTimeMos > 60000) {
            this.reTimesMos = 0;
            this.reconnectTimeMos = 0;
            return;
        }
        try {
            this.reconnectTimeMos += (int)(Math.pow(2.0, this.reTimesMos) * 1000.0);
            ++this.reTimesMos;
            Thread.sleep(this.reconnectTimeMos);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.initConnect(this.service);
    }

    static {
        appId = "0";
    }

    private class MqttConnectionListener
    implements IMqttActionListener {
        private final Bundle resultBundle;

        private MqttConnectionListener(Bundle resultBundle) {
            this.resultBundle = resultBundle;
        }

        @Override
        public void onSuccess(IMqttToken asyncActionToken) {
            LogHelper.getHelper().d("unsub is success");
        }

        @Override
        public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
            this.resultBundle.putString("MqttService.errorMessage", exception.getLocalizedMessage());
            this.resultBundle.putSerializable("MqttService.exception", (Serializable)exception);
        }
    }
}

